/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

public class Bezier {
    public static float bezierF(float t, float x0) {
        return x0;
    }

    public static float bezierF(float t, float x0, float x1) {
        return (1.0f - t) * x0 + t * x1;
    }

    public static float bezierF(float t, float x0, float x1, float x2) {
        return (1.0f - t) * Bezier.bezierF(t, x0, x1) + t * Bezier.bezierF(t, x1, x2);
    }

    public static float bezierF(float t, float x0, float x1, float x2, float x3) {
        return (1.0f - t) * Bezier.bezierF(t, x0, x1, x2) + t * Bezier.bezierF(t, x1, x2, x3);
    }

    public static float bezierF(float t, float[] array, int a, int b) {
        if (array == null) {
            return 0.0f;
        }
        int N = array.length;
        if (a < 0 || b < a || N <= b) {
            return 0.0f;
        }
        if (a == b) {
            return array[a];
        }
        float x0 = Bezier.bezierF(t, array, a, b - 1);
        float x1 = Bezier.bezierF(t, array, a + 1, b);
        return Bezier.bezierF(t, x0, x1);
    }

    public static float[] mapBezierF(float t, float[] array) {
        if (array == null) {
            return null;
        }
        int N = array.length;
        if (N <= 1) {
            return new float[0];
        }
        int M = N - 1;
        float[] result = new float[M];
        int i = 0;
        while (i < M) {
            result[i] = Bezier.bezierF(t, array[i], array[i + 1]);
            ++i;
        }
        return result;
    }

    public static float[] newBezierPointsF(float a, float b, float[] controls) {
        if (controls == null) {
            return null;
        }
        int N = controls.length;
        if (N == 0) {
            return new float[0];
        }
        if (N == 1) {
            return new float[]{controls[0]};
        }
        Object current = new float[][]{controls};
        float[][] next = null;
        int k = 2;
        while (k <= N) {
            next = new float[k][];
            int m = k - 1;
            int i = 0;
            while (i < m) {
                next[i] = Bezier.mapBezierF(a, current[i]);
                ++i;
            }
            next[m] = Bezier.mapBezierF(b, current[m - 1]);
            current = next;
            ++k;
        }
        float[] result = new float[N];
        int i = 0;
        while (i < N) {
            result[i] = current[i][0];
            ++i;
        }
        return result;
    }

    public static double bezierD(double t, double x0) {
        return x0;
    }

    public static double bezierD(double t, double x0, double x1) {
        return (1.0 - t) * x0 + t * x1;
    }

    public static double bezierD(double t, double x0, double x1, double x2) {
        return (1.0 - t) * Bezier.bezierD(t, x0, x1) + t * Bezier.bezierD(t, x1, x2);
    }

    public static double bezierD(double t, double x0, double x1, double x2, double x3) {
        return (1.0 - t) * Bezier.bezierD(t, x0, x1, x2) + t * Bezier.bezierD(t, x1, x2, x3);
    }

    public static double bezierD(double t, double[] array, int a, int b) {
        if (array == null) {
            return 0.0;
        }
        int N = array.length;
        if (a < 0 || b < a || N <= b) {
            return 0.0;
        }
        if (a == b) {
            return array[a];
        }
        double x0 = Bezier.bezierD(t, array, a, b - 1);
        double x1 = Bezier.bezierD(t, array, a + 1, b);
        return Bezier.bezierD(t, x0, x1);
    }

    public static double[] mapBezierD(double t, double[] array) {
        if (array == null) {
            return null;
        }
        int N = array.length;
        if (N <= 1) {
            return new double[0];
        }
        int M = N - 1;
        double[] result = new double[M];
        int i = 0;
        while (i < M) {
            result[i] = Bezier.bezierD(t, array[i], array[i + 1]);
            ++i;
        }
        return result;
    }

    public static double[] newBezierPointsD(double a, double b, double[] controls) {
        if (controls == null) {
            return null;
        }
        int N = controls.length;
        if (N == 0) {
            return new double[0];
        }
        if (N == 1) {
            return new double[]{controls[0]};
        }
        Object current = new double[][]{controls};
        double[][] next = null;
        int k = 2;
        while (k <= N) {
            next = new double[k][];
            int m = k - 1;
            int i = 0;
            while (i < m) {
                next[i] = Bezier.mapBezierD(a, current[i]);
                ++i;
            }
            next[m] = Bezier.mapBezierD(b, current[m - 1]);
            current = next;
            ++k;
        }
        double[] result = new double[N];
        int i = 0;
        while (i < N) {
            result[i] = current[i][0];
            ++i;
        }
        return result;
    }
}

