/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.quick;

public final class StringObjectPair {
    private String string = null;
    private Object object = null;

    public StringObjectPair(String string, Object object) {
        if (string == null || object == null) {
            throw new NullPointerException("null data item in StringObjectPair(String, Object) constructor");
        }
        this.string = string;
        this.object = object;
    }

    public StringObjectPair(Object[] data) {
        if (data == null) {
            throw new NullPointerException("null data array in StringObjectPair(Object[]) constructor");
        }
        if (data.length != 2) {
            throw new IllegalArgumentException("data length != 2 in StringObjectPair(Object[]) constructor");
        }
        if (data[0] == null || data[1] == null) {
            throw new NullPointerException("null data item in StringObjectPair(Object[]) constructor");
        }
        if (!(data[0] instanceof String)) {
            throw new IllegalArgumentException("data[0] is not String in StringObjectPair(Object[]) constructor");
        }
        this.string = (String)data[0];
        this.object = data[1];
    }

    public String getString() {
        return this.string;
    }

    public Object getObject() {
        return this.object;
    }

    public boolean equals(Object entity) {
        if (!(entity instanceof StringObjectPair)) {
            return false;
        }
        StringObjectPair pair = (StringObjectPair)entity;
        return this.string.equals(pair.getString()) && this.object.equals(pair.getObject());
    }

    public int hashCode() {
        return this.string.hashCode() ^ this.object.hashCode();
    }

    public String toString() {
        return "(" + this.string + ", " + this.object.toString() + ")";
    }

    public Object[] toArray() {
        return new Object[]{this.string, this.object};
    }

    public static StringObjectPair makeStringObjectPair(Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        if (!(a instanceof String)) {
            return null;
        }
        return new StringObjectPair((String)a, b);
    }

    public static StringObjectPair makeStringObjectPair(Object[] data) {
        try {
            return new StringObjectPair(data);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Object[][] toArray(StringObjectPair[] pairs) {
        if (pairs == null) {
            return null;
        }
        int length = pairs.length;
        Object[][] array = new Object[length][];
        int i = 0;
        while (i < length) {
            array[i] = pairs[i] == null ? null : pairs[i].toArray();
            ++i;
        }
        return array;
    }

    public static StringObjectPair[] toArray(Object[][] array) {
        if (array == null) {
            return null;
        }
        int length = array.length;
        StringObjectPair[] pairs = new StringObjectPair[length];
        int i = 0;
        while (i < length) {
            pairs[i] = StringObjectPair.makeStringObjectPair(array[i]);
            ++i;
        }
        return pairs;
    }

    public static String[] getStrings(StringObjectPair[] pairs) {
        if (pairs == null) {
            return null;
        }
        int length = pairs.length;
        String[] array = new String[length];
        int i = 0;
        while (i < length) {
            array[i] = pairs[i] == null ? null : pairs[i].getString();
            ++i;
        }
        return array;
    }

    public static Object[] getObjects(StringObjectPair[] pairs) {
        if (pairs == null) {
            return null;
        }
        int length = pairs.length;
        Object[] array = new Object[length];
        int i = 0;
        while (i < length) {
            array[i] = pairs[i] == null ? null : pairs[i].getObject();
            ++i;
        }
        return array;
    }
}

