/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.quick;

import edu.neu.ccs.Strings;
import java.util.Comparator;

public class StringIntPair {
    private String string;
    private int number;
    public static final Comparator stringFirst = new Comparator(){

        public int compare(Object p, Object q) {
            if (!(p instanceof StringIntPair)) {
                throw new ClassCastException("StringIntPair required for compare operation");
            }
            if (!(q instanceof StringIntPair)) {
                throw new ClassCastException("StringIntPair required for compare operation");
            }
            StringIntPair a = (StringIntPair)p;
            StringIntPair b = (StringIntPair)q;
            int x = a.string.compareTo(b.string);
            if (x != 0) {
                return x;
            }
            return a.number - b.number;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    };
    public static final Comparator numberFirst = new Comparator(){

        public int compare(Object p, Object q) {
            if (!(p instanceof StringIntPair)) {
                throw new ClassCastException("StringIntPair required for compare operation");
            }
            if (!(q instanceof StringIntPair)) {
                throw new ClassCastException("StringIntPair required for compare operation");
            }
            StringIntPair a = (StringIntPair)p;
            StringIntPair b = (StringIntPair)q;
            int x = a.number - b.number;
            if (x != 0) {
                return x;
            }
            return a.string.compareTo(b.string);
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    };

    public StringIntPair(String string, int number) {
        if (string == null) {
            throw new NullPointerException("Null String in StringIntPair constructor");
        }
        this.string = string;
        this.number = number;
    }

    public String getString() {
        return this.string;
    }

    public int getInt() {
        return this.number;
    }

    public int getNumber() {
        return this.number;
    }

    public String toString() {
        String n = Integer.toString(this.number);
        return Strings.joinWithSpace(this.string, n);
    }

    public String toString(int widthS) {
        String s = Strings.padOnRight(this.string, widthS);
        String n = Integer.toString(this.number);
        return Strings.joinWithSpace(s, n);
    }

    public String toString(int widthS, int widthN) {
        String s = Strings.padOnRight(this.string, widthS);
        String n = Strings.padOnLeft(Integer.toString(this.number), widthN);
        return Strings.joinWithSpace(s, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof StringIntPair)) {
            return false;
        }
        StringIntPair x = (StringIntPair)object;
        return x.string.equals(this.string) && x.number == this.number;
    }

    public int hashCode() {
        return this.string.hashCode() + this.number;
    }
}

