/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.quick;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class QuickTreeMap
extends TreeMap {
    public QuickTreeMap() {
    }

    public QuickTreeMap(Comparator c) {
        super(c);
    }

    public QuickTreeMap(Map m) {
        super(m);
    }

    public QuickTreeMap(SortedMap m) {
        super(m);
    }

    public QuickTreeMap(Object[][] pairs) {
        this.putPairs(pairs);
    }

    public QuickTreeMap(Comparator c, Object[][] pairs) {
        super(c);
        this.putPairs(pairs);
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            return null;
        }
        return super.put(key, value);
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return super.get(key);
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        return super.remove(key);
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return super.containsKey(key);
    }

    public SortedMap headMap(Object key) {
        if (key == null) {
            return null;
        }
        return super.headMap(key);
    }

    public SortedMap tailMap(Object key) {
        if (key == null) {
            return null;
        }
        return super.tailMap(key);
    }

    public SortedMap subMap(Object lower, Object upper) {
        if (lower == null || upper == null) {
            return null;
        }
        return super.subMap(lower, upper);
    }

    public void putPairs(Object[][] pairs) {
        if (pairs == null) {
            return;
        }
        int length = pairs.length;
        int i = 0;
        while (i < length) {
            if (pairs[i] != null && pairs[i].length == 2) {
                this.put(pairs[i][0], pairs[i][1]);
            }
            ++i;
        }
    }

    public void setPairs(Object[][] pairs) {
        this.clear();
        this.putPairs(pairs);
    }

    public void removeKeys(Object[] keys) {
        if (keys == null) {
            return;
        }
        int length = keys.length;
        int i = 0;
        while (i < length) {
            if (keys[i] != null) {
                this.remove(keys[i]);
            }
            ++i;
        }
    }

    public void putSymmetric(Object key, Object value) {
        if (key == null || value == null) {
            return;
        }
        this.put(key, value);
        this.put(value, key);
    }

    public void putPairsSymmetric(Object[][] pairs) {
        if (pairs == null) {
            return;
        }
        int length = pairs.length;
        int i = 0;
        while (i < length) {
            if (pairs[i] != null && pairs[i].length == 2) {
                this.putSymmetric(pairs[i][0], pairs[i][1]);
            }
            ++i;
        }
    }

    public void setPairsSymmetric(Object[][] pairs) {
        this.clear();
        this.putPairsSymmetric(pairs);
    }
}

