/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.quick;

public final class Pair {
    private Object a = null;
    private Object b = null;

    public Pair(Object a, Object b) {
        if (a == null || b == null) {
            throw new NullPointerException("null data item in Pair(Object, Object) constructor");
        }
        this.a = a;
        this.b = b;
    }

    public Pair(Object[] data) {
        if (data == null) {
            throw new NullPointerException("null data array in Pair(Object[]) constructor");
        }
        if (data.length != 2) {
            throw new IllegalArgumentException("data length != 2 in Pair(Object[]) constructor");
        }
        if (data[0] == null || data[1] == null) {
            throw new NullPointerException("null data item in Pair(Object[]) constructor");
        }
        this.a = data[0];
        this.b = data[1];
    }

    public Object getA() {
        return this.a;
    }

    public Object getB() {
        return this.b;
    }

    public boolean equals(Object entity) {
        if (!(entity instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)entity;
        return this.a.equals(pair.getA()) && this.b.equals(pair.getB());
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode();
    }

    public String toString() {
        return "(" + this.a.toString() + ", " + this.b.toString() + ")";
    }

    public Object[] toArray() {
        return new Object[]{this.a, this.b};
    }

    public static Pair makePair(Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        return new Pair(a, b);
    }

    public static Pair makePair(Object[] data) {
        try {
            return new Pair(data);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Object[][] toArray(Pair[] pairs) {
        if (pairs == null) {
            return null;
        }
        int length = pairs.length;
        Object[][] array = new Object[length][];
        int i = 0;
        while (i < length) {
            array[i] = pairs[i] == null ? null : pairs[i].toArray();
            ++i;
        }
        return array;
    }

    public static Pair[] toArray(Object[][] array) {
        if (array == null) {
            return null;
        }
        int length = array.length;
        Pair[] pairs = new Pair[length];
        int i = 0;
        while (i < length) {
            pairs[i] = Pair.makePair(array[i]);
            ++i;
        }
        return pairs;
    }

    public static Object[] getAObjects(Pair[] pairs) {
        if (pairs == null) {
            return null;
        }
        int length = pairs.length;
        Object[] array = new Object[length];
        int i = 0;
        while (i < length) {
            array[i] = pairs[i] == null ? null : pairs[i].getA();
            ++i;
        }
        return array;
    }

    public static Object[] getBObjects(Pair[] pairs) {
        if (pairs == null) {
            return null;
        }
        int length = pairs.length;
        Object[] array = new Object[length];
        int i = 0;
        while (i < length) {
            array[i] = pairs[i] == null ? null : pairs[i].getB();
            ++i;
        }
        return array;
    }
}

