/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.quick;

import java.util.Arrays;

public class BooleanStateArray {
    private int[] keys = null;
    private boolean[] states = null;

    public BooleanStateArray(int[] list) {
        int N = 0;
        if (list == null) {
            this.keys = new int[0];
        } else {
            N = list.length;
            this.keys = new int[N];
            int i = 0;
            while (i < N) {
                this.keys[i] = list[i];
                ++i;
            }
        }
        Arrays.sort(this.keys);
        int duplicates = 0;
        int i = 1;
        while (i < N) {
            if (this.keys[i] == this.keys[i - 1]) {
                ++duplicates;
            }
            ++i;
        }
        if (duplicates > 0) {
            int M = N - duplicates;
            int[] copy = new int[M];
            copy[0] = this.keys[0];
            int k = 1;
            int i2 = 1;
            while (i2 < N) {
                if (this.keys[i2] != this.keys[i2 - 1]) {
                    copy[k] = this.keys[i2];
                    ++k;
                }
                ++i2;
            }
            N = M;
            this.keys = copy;
        }
        this.states = new boolean[N];
    }

    public boolean getState(int key) {
        int index = Arrays.binarySearch(this.keys, key);
        if (index >= 0) {
            return this.states[index];
        }
        return false;
    }

    public void setState(int key, boolean state) {
        int index = Arrays.binarySearch(this.keys, key);
        if (index >= 0) {
            this.states[index] = state;
        }
    }

    public void setState(int[] list, boolean state) {
        if (list == null) {
            return;
        }
        int N = list.length;
        int i = 0;
        while (i < N) {
            this.setState(list[i], state);
            ++i;
        }
    }

    public void setAllStates(boolean state) {
        int N = this.states.length;
        int i = 0;
        while (i < N) {
            this.states[i] = state;
            ++i;
        }
    }
}

