/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pedagogy;

import edu.neu.ccs.gui.BufferedPanel;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.PlotTool;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class Turtle {
    public static final int MINIMUM_SIZE = 201;
    public static final int PREFERRED_SIZE = 401;
    public static final Paint DEFAULT_PAINT = Color.black;
    public static final int PEN_UP = 0;
    public static final int PEN_DOWN = 1;
    private static final double DEGREES_TO_RADIANS = Math.PI / 180;
    protected static BufferedPanel turtleBufferPanel = null;
    protected static int turtleBufferPanelSize = 401;
    protected static AffineTransform transform = null;
    protected static Vector turtleList = new Vector();
    protected double xPosition = 0.0;
    protected double yPosition = 0.0;
    protected double direction = 0.0;
    protected Paint penPaint = DEFAULT_PAINT;
    protected int penState = 1;
    protected boolean showTurtle = true;
    protected boolean autoRepaint = true;
    private Line2D line = new Line2D.Double();
    private Point2D point1 = new Point2D.Double();
    private Point2D point2 = new Point2D.Double();
    GeneralPath path = new GeneralPath(1, 4);

    public static void setTurtleBufferPanelSize(int size) {
        if (turtleBufferPanel == null) {
            if (size < 201) {
                size = 201;
            }
            turtleBufferPanelSize = size;
        }
    }

    public static int getTurtleBufferPanelSize() {
        return turtleBufferPanelSize;
    }

    public static BufferedPanel getTurtleBufferPanel() {
        if (turtleBufferPanel == null) {
            turtleBufferPanel = new BufferedPanel(turtleBufferPanelSize, turtleBufferPanelSize){

                public void paintOver(Graphics2D g2) {
                    Turtle[] list = Turtle.getTurtles();
                    int size = list.length;
                    if (size == 0) {
                        return;
                    }
                    int i = 0;
                    while (i < size) {
                        if (list[i].showTurtle) {
                            list[i].drawTurtle(g2);
                        }
                        ++i;
                    }
                }
            };
            Turtle.useCenterCoordinates();
        }
        return turtleBufferPanel;
    }

    public static void useCenterCoordinates() {
        if (turtleBufferPanel != null) {
            int center = (turtleBufferPanelSize + 1) / 2;
            transform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, center, center);
        }
    }

    public static void useCornerCoordinates() {
        if (turtleBufferPanel != null) {
            boolean xCorner = false;
            int yCorner = turtleBufferPanelSize - 1;
            transform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, (float)xCorner, yCorner);
        }
    }

    public static void setCoordinatesViaBounds(Rectangle2D world) {
        Turtle.setCoordinatesViaBounds(world, 0);
    }

    public static void setCoordinatesViaBounds(Rectangle2D world, int inset) {
        if (turtleBufferPanel != null && world != null) {
            Rectangle2D.Double image = new Rectangle2D.Double(0.0, 0.0, turtleBufferPanelSize, turtleBufferPanelSize);
            PlotTool plottool = new PlotTool(world, image, true, inset);
            transform = plottool.getTransform();
        }
    }

    public static Graphics2D getTurtleBufferGraphics() {
        return Turtle.getTurtleBufferPanel().getBufferGraphics();
    }

    public static BufferedImage getTurtleBuffer() {
        return Turtle.getTurtleBufferPanel().getBuffer();
    }

    public static void clear() {
        Turtle.getTurtleBufferPanel().clearPanel();
        Turtle.repaint();
    }

    public static void repaint() {
        Turtle.getTurtleBufferPanel().repaint();
    }

    public static Turtle[] getTurtles() {
        int size = turtleList.size();
        Turtle[] list = new Turtle[size];
        int i = 0;
        while (i < size) {
            list[i] = (Turtle)turtleList.get(i);
            ++i;
        }
        return list;
    }

    public static void showAllTurtles() {
        Turtle[] list = Turtle.getTurtles();
        int size = list.length;
        if (size == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            list[i].showTurtle = true;
            ++i;
        }
        Turtle.repaint();
    }

    public static void hideAllTurtles() {
        Turtle[] list = Turtle.getTurtles();
        int size = list.length;
        if (size == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            list[i].showTurtle = false;
            ++i;
        }
        Turtle.repaint();
    }

    public Turtle() {
        Turtle.getTurtleBufferPanel();
        turtleList.add(this);
    }

    public void step(double distance) {
        double cos = Math.cos(this.direction * (Math.PI / 180));
        double sin = Math.sin(this.direction * (Math.PI / 180));
        double dx = distance * cos;
        double dy = distance * sin;
        if (this.penState == 1) {
            this.point1.setLocation(this.xPosition, this.yPosition);
            this.xPosition += dx;
            this.yPosition += dy;
            this.point2.setLocation(this.xPosition, this.yPosition);
            transform.transform(this.point1, this.point1);
            transform.transform(this.point2, this.point2);
            this.line.setLine(this.point1, this.point2);
            Graphics2D g2 = Turtle.getTurtleBufferGraphics();
            g2.setPaint(this.penPaint != null ? this.penPaint : DEFAULT_PAINT);
            g2.draw(this.line);
        } else {
            this.xPosition += dx;
            this.yPosition += dy;
        }
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public void turn(double angle) {
        this.setDirection(this.direction + angle);
    }

    public void showTurtle() {
        this.showTurtle = true;
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public void hideTurtle() {
        this.showTurtle = false;
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public void setVisible(boolean visible) {
        this.showTurtle = visible;
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public boolean isVisible() {
        return this.showTurtle;
    }

    public void setPosition(double x, double y) {
        this.xPosition = x;
        this.yPosition = y;
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public void setPosition(Point2D position) {
        if (position != null) {
            this.setPosition(position.getX(), position.getY());
        }
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.xPosition, this.yPosition);
    }

    public double getX() {
        return this.xPosition;
    }

    public double getY() {
        return this.yPosition;
    }

    public void setDirection(double direction) {
        if ((direction %= 360.0) < 0.0) {
            direction += 360.0;
        }
        this.direction = direction;
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public double getDirection() {
        return this.direction;
    }

    public void setPaint(Paint paint) {
        this.penPaint = paint;
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public void setPaint(int r, int g, int b) {
        this.setPaint(new Color(r, g, b));
    }

    public void setPaint(int r, int g, int b, int alpha) {
        this.setPaint(new Color(r, g, b, alpha));
    }

    public Paint getPaint() {
        return this.penPaint;
    }

    public void setPenState(int penState) {
        switch (penState) {
            case 0: 
            case 1: {
                this.penState = penState;
                break;
            }
        }
    }

    public int getPenState() {
        return this.penState;
    }

    public void setAutoRepaint(boolean enabled) {
        this.autoRepaint = enabled;
    }

    public boolean getAutoRepaint() {
        return this.autoRepaint;
    }

    public void reset() {
        this.xPosition = 0.0;
        this.yPosition = 0.0;
        this.direction = 0.0;
        this.penPaint = DEFAULT_PAINT;
        this.penState = 1;
        this.autoRepaint = true;
        this.showTurtle = true;
        Turtle.repaint();
    }

    protected void drawTurtle(Graphics2D g2) {
        this.point1.setLocation(this.xPosition, this.yPosition);
        transform.transform(this.point1, this.point1);
        float x = (float)this.point1.getX();
        float y = (float)this.point1.getY();
        float cos = (float)Math.cos(this.direction * (Math.PI / 180));
        float sin = (float)Math.sin(this.direction * (Math.PI / 180));
        float size1 = 6.0f;
        float size2 = 4.0f;
        this.path.reset();
        this.path.moveTo(x + size1 * cos, y - size1 * sin);
        this.path.lineTo(x - size1 * cos - size2 * sin, y + size1 * sin - size2 * cos);
        this.path.lineTo(x - size1 * cos + size2 * sin, y + size1 * sin + size2 * cos);
        this.path.closePath();
        g2.setPaint(this.penPaint != null ? this.penPaint : DEFAULT_PAINT);
        g2.fill(this.path);
    }

    public static void selfTest() {
        Turtle.setTurtleBufferPanelSize(501);
        JPTFrame.createQuickJPTFrame("Turtle Self Test", Turtle.getTurtleBufferPanel());
        int steps = 96;
        int offset = Turtle.getTurtleBufferPanelSize() / 4;
        Turtle turtle1 = new Turtle();
        int i = 1;
        while (i <= steps) {
            turtle1.step(i);
            turtle1.turn(90.0);
            ++i;
        }
        Turtle turtle2 = new Turtle();
        turtle2.setPosition(offset, offset);
        turtle2.setPaint(Color.blue);
        int i2 = 1;
        while (i2 <= steps) {
            turtle2.step(i2);
            turtle2.turn(60.0);
            ++i2;
        }
        Turtle.useCornerCoordinates();
        Turtle turtle3 = new Turtle();
        turtle3.setPosition(offset, offset);
        turtle3.setAutoRepaint(false);
        Color[] colors = new Color[]{Color.black, Color.red, Color.green, Color.blue, Color.magenta, Color.yellow};
        int i3 = 1;
        while (i3 <= steps) {
            turtle3.setPaint(colors[i3 % 6]);
            turtle3.step(i3);
            turtle3.turn(60.0);
            ++i3;
        }
        Turtle.repaint();
        Rectangle2D.Double world = new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0);
        Turtle.setCoordinatesViaBounds(world);
        Turtle turtle4 = new Turtle();
        turtle4.setPosition(0.5, -0.5);
        turtle4.setPaint(153, 51, 0);
        double denominator = Turtle.getTurtleBufferPanelSize() / 2;
        int i4 = 1;
        while (i4 <= steps) {
            turtle4.step((double)i4 / denominator);
            turtle4.turn(90.0);
            ++i4;
        }
        Turtle.useCenterCoordinates();
        Turtle[] list = Turtle.getTurtles();
        int size = list.length;
        int i5 = 0;
        while (i5 < size) {
            list[i5].setAutoRepaint(true);
            list[i5].setPosition(-offset, offset);
            list[i5].setDirection(90 * i5 + 15);
            list[i5].setPaint(colors[i5]);
            list[i5].step(offset / 2);
            ++i5;
        }
    }
}

