/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.parser;

import edu.neu.ccs.Strings;
import edu.neu.ccs.parser.AbstractFunction;
import edu.neu.ccs.parser.BaseParser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;
import java.util.Hashtable;

public class SimpleFunction
extends AbstractFunction {
    private BaseParser parser;
    private String[] parameters = null;
    private String body = null;

    public SimpleFunction(String name, String[] parameters, String body) {
        this(null, name, parameters, body);
    }

    public SimpleFunction(String name, String parameters, String body) {
        this(null, name, Strings.splitCommaList(parameters), body);
    }

    public SimpleFunction(BaseParser parser, String name, String[] parameters, String body) {
        super(name == null ? null : (name = name.trim()), parameters == null ? 0 : parameters.length);
        String message;
        if (parser == null) {
            parser = ParserUtilities.getDefaultParser();
        }
        this.parser = parser;
        if (parameters == null) {
            parameters = new String[]{};
        } else {
            Strings.trim(parameters);
        }
        if (body != null) {
            body = body.trim();
        }
        if ((message = SimpleFunction.testFunctionName(parser, name)) == null) {
            message = SimpleFunction.testParameterArrayNames(parser, parameters, name);
        }
        if (message == null) {
            message = SimpleFunction.testFunctionBody(body);
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        this.parameters = parameters;
        this.body = Strings.flatten(body);
        parser.addFunction(this);
    }

    public SimpleFunction(BaseParser parser, String name, String parameters, String body) {
        this(parser, name, Strings.splitCommaList(parameters), body);
    }

    public final Object functionCall(Object[] values) throws ParseException {
        this.checkValuesAsXObject(values);
        return this.parser.parseWithArgumentList(this.body, this.parameters, values);
    }

    public final String[] parameters() {
        int length = this.parameters.length;
        String[] copy = new String[length];
        int i = 0;
        while (i < length) {
            copy[i] = this.parameters[i];
            ++i;
        }
        return copy;
    }

    public final String parametersAsString() {
        String result = Strings.makeCommaList(this.parameters);
        if (result.length() == 0) {
            return " ";
        }
        return result;
    }

    public final String body() {
        return this.body;
    }

    public final BaseParser parser() {
        return this.parser;
    }

    public static String testFunctionName(String fcnName) {
        return SimpleFunction.testFunctionName(null, fcnName);
    }

    public static String testFunctionName(BaseParser parser, String fcnName) {
        if (parser == null) {
            parser = ParserUtilities.getDefaultParser();
        }
        String message = null;
        if (fcnName == null) {
            message = "A function name must not be null";
        } else if ((fcnName = fcnName.trim()).length() == 0) {
            message = "A function name must not be empty";
        } else if (!BaseParser.isPossibleIdentifier(fcnName)) {
            message = String.valueOf(fcnName) + " is not a valid identifier\n" + "and therefore may not be a function name";
        } else if (parser.isReservedID(fcnName)) {
            message = String.valueOf(fcnName) + " may not define a function name\n" + "since it is the reserved ID of a special form";
        } else if (parser.isConstantID(fcnName)) {
            message = String.valueOf(fcnName) + " may not define a function name\n" + "since it already defines a constant ID";
        } else if (parser.isOrdinaryFunctionName(fcnName)) {
            message = String.valueOf(fcnName) + " is already installed as a built-in function\n" + " and may not be replaced by a simple function";
        }
        return message;
    }

    public static String testParameterName(String paramName, String fcnName) {
        return SimpleFunction.testParameterName(null, paramName, fcnName);
    }

    public static String testParameterName(BaseParser parser, String paramName, String fcnName) {
        if (parser == null) {
            parser = ParserUtilities.getDefaultParser();
        }
        String message = null;
        if (paramName == null) {
            message = "A parameter name must not be null";
        } else if (fcnName == null) {
            message = "A function name must not be null";
        } else {
            paramName = paramName.trim();
            fcnName = fcnName.trim();
            if (paramName.length() == 0) {
                message = "A parameter name must not be empty";
            } else if (fcnName.length() == 0) {
                message = "A function name must not be empty";
            } else if (!BaseParser.isPossibleIdentifier(paramName)) {
                message = String.valueOf(paramName) + " is not a valid identifier\n" + "and therefore may not be a parameter name";
            } else if (paramName.equals(fcnName)) {
                message = "A parameter name " + paramName + " must not equal its function name";
            } else if (parser.isReservedID(paramName)) {
                message = String.valueOf(paramName) + " may not define a parameter name\n" + "since it already defines a reserved ID";
            } else if (parser.isConstantID(paramName)) {
                message = String.valueOf(paramName) + " may not define a parameter name\n" + "since it already defines a constant ID";
            } else if (parser.isFunctionName(paramName)) {
                message = String.valueOf(paramName) + " may not define a parameter name\n" + "since it already defines a function name";
            }
        }
        return message;
    }

    public static String testParameterArrayNames(String[] parameters, String fcnName) {
        return SimpleFunction.testParameterArrayNames(null, parameters, fcnName);
    }

    public static String testParameterArrayNames(BaseParser parser, String[] parameters, String fcnName) {
        if (parser == null) {
            parser = ParserUtilities.getDefaultParser();
        }
        String message = null;
        if (parameters == null) {
            message = "An array of parameter names must not be null";
        } else {
            parameters = Strings.trim(parameters);
            int length = parameters.length;
            Hashtable<String, String> args = new Hashtable<String, String>();
            int i = 0;
            while (i < length) {
                String arg = parameters[i];
                message = SimpleFunction.testParameterName(parser, arg, fcnName);
                if (message != null) break;
                args.put(arg, arg);
                ++i;
            }
            if (message == null && args.size() < length) {
                message = "An array of parameter names has a parameter name that is repeated";
            }
        }
        return message;
    }

    public static String testFunctionBody(String body) {
        String message = null;
        if (body == null) {
            message = "A function body must not be null";
        } else if ((body = body.trim()).length() == 0) {
            message = "A function body must not be empty";
        }
        return message;
    }

    public String toString() {
        String fcnName = this.name();
        String fcnParams = this.parametersAsString();
        String fcnBody = this.body();
        int length = 3 + fcnName.length() + fcnParams.length() + fcnBody.length();
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(fcnName);
        buffer.append("\n");
        buffer.append(fcnParams);
        buffer.append("\n");
        buffer.append(fcnBody);
        buffer.append("\n");
        return buffer.toString();
    }
}

