/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.parser;

import edu.neu.ccs.XBigDecimal;
import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XByte;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XFloat;
import edu.neu.ccs.XInt;
import edu.neu.ccs.XLong;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.XShort;
import edu.neu.ccs.parser.BaseParser;
import edu.neu.ccs.parser.JPTParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.FieldPosition;

public class ParserUtilities {
    private static BaseParser parser = new JPTParser();

    private ParserUtilities() {
    }

    public static BaseParser getDefaultParser() {
        return parser;
    }

    public static void setDefaultParser(BaseParser p) {
        if (p == null) {
            p = new JPTParser();
        }
        parser = p;
    }

    public static boolean isXNumber(Object x) {
        return x instanceof XNumber;
    }

    public static boolean isXIntegral(Object x) {
        return x instanceof XBigInteger || x instanceof XLong || x instanceof XInt || x instanceof XShort || x instanceof XByte;
    }

    public static boolean isXFloating(Object x) {
        return x instanceof XBigDecimal || x instanceof XDouble || x instanceof XFloat;
    }

    public static boolean isXBoolean(Object x) {
        return x instanceof XBoolean;
    }

    public static XLong toXLong(XNumber value) {
        if (value instanceof XLong) {
            return (XLong)value;
        }
        return new XLong(value.longValue());
    }

    public static XDouble toXDouble(XNumber value) {
        if (value instanceof XDouble) {
            return (XDouble)value;
        }
        return new XDouble(value.doubleValue());
    }

    public static XBigInteger toXBigInteger(XNumber value) {
        if (value instanceof XBigInteger) {
            return (XBigInteger)value;
        }
        if (value instanceof XBigDecimal) {
            XBigDecimal v = (XBigDecimal)value;
            BigDecimal x = v.getValue();
            return new XBigInteger(x.toBigInteger());
        }
        String s = "0";
        if (ParserUtilities.isXIntegral(value)) {
            s = String.valueOf(value.longValue());
        } else {
            double x = value.doubleValue();
            x = Math.rint(x);
            DecimalFormat f = new DecimalFormat("#0");
            StringBuffer b = new StringBuffer(1024);
            FieldPosition p = new FieldPosition(0);
            b = f.format(x, b, p);
            s = b.toString();
        }
        return new XBigInteger(new BigInteger(s));
    }

    public static XBigDecimal toXBigDecimal(XNumber value) {
        if (value instanceof XBigDecimal) {
            return (XBigDecimal)value;
        }
        if (value instanceof XBigInteger) {
            XBigInteger v = (XBigInteger)value;
            BigInteger x = v.getValue();
            return new XBigDecimal(new BigDecimal(x));
        }
        if (ParserUtilities.isXIntegral(value)) {
            String s = String.valueOf(value.longValue());
            return new XBigDecimal(new BigDecimal(s));
        }
        double z = value.doubleValue();
        return new XBigDecimal(new BigDecimal(z));
    }
}

