/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.parser;

import edu.neu.ccs.parser.BaseParser;
import java.text.ParseException;

public abstract class Operation {
    public static final Operation IDENTITY = new Operation(""){

        public Object performOperation(Object left, Object right) {
            return right;
        }
    };
    public static final Operation OPERATION_PREFIX = new Operation("\u0000"){

        public Object performOperation(Object left, Object right) {
            return null;
        }
    };
    private String symbol = "";
    private boolean isUnary = true;
    private boolean isBinary = true;

    public Operation(String id) {
        if (id == null) {
            String message = "null id passed when defining an operation";
            throw new IllegalArgumentException(message);
        }
        if (!BaseParser.isPossibleOperation(id)) {
            String message = "\"" + id + "\" is not a valid symbol" + " for defining an operation";
            throw new IllegalArgumentException(message);
        }
        this.symbol = id;
    }

    public Operation(String id, boolean unary, boolean binary) {
        this(id);
        this.isUnary = unary;
        this.isBinary = binary;
    }

    public abstract Object performOperation(Object var1, Object var2) throws ParseException;

    public final String symbol() {
        return this.symbol;
    }

    public final boolean isUnary() {
        return this.isUnary;
    }

    public final boolean isBinary() {
        return this.isBinary;
    }

    public final void checkUnary() throws ParseException {
        if (!this.isUnary) {
            throw new ParseException("Operation " + this.symbol + " expects 2 arguments.", 0);
        }
    }

    public final void checkBinary() throws ParseException {
        if (!this.isBinary) {
            throw new ParseException("Operation " + this.symbol + " expects 1 argument.", 0);
        }
    }
}

