/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.parser;

import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.parser.Operation;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class NumericOperation
extends Operation {
    public NumericOperation(String s) {
        super(s);
    }

    public NumericOperation(String s, boolean unary, boolean binary) {
        super(s, unary, binary);
    }

    public final Object performOperation(Object left, Object right) throws ParseException {
        if (left == null) {
            this.checkUnary();
            if (ParserUtilities.isXIntegral(right)) {
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)right);
                return this.unaryForXIntegral(a);
            }
            if (ParserUtilities.isXNumber(right)) {
                XDouble x = ParserUtilities.toXDouble((XNumber)right);
                return this.unaryForXFloating(x);
            }
            throw new ParseException("Numeric operation " + this.symbol() + " expects 1 numeric argument", 0);
        }
        this.checkBinary();
        if (ParserUtilities.isXIntegral(left) && ParserUtilities.isXIntegral(right)) {
            XBigInteger a = ParserUtilities.toXBigInteger((XNumber)left);
            XBigInteger b = ParserUtilities.toXBigInteger((XNumber)right);
            return this.binaryForXIntegral(a, b);
        }
        if (ParserUtilities.isXNumber(left) && ParserUtilities.isXNumber(right)) {
            XDouble x = ParserUtilities.toXDouble((XNumber)left);
            XDouble y = ParserUtilities.toXDouble((XNumber)right);
            return this.binaryForXFloating(x, y);
        }
        throw new ParseException("Numeric operation " + this.symbol() + " expects 2 numeric arguments", 0);
    }

    public Object unaryForXIntegral(XBigInteger a) {
        return null;
    }

    public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
        return null;
    }

    public Object unaryForXFloating(XDouble x) {
        return null;
    }

    public Object binaryForXFloating(XDouble x, XDouble y) {
        return null;
    }
}

