/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.parser;

import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XInt;
import edu.neu.ccs.XLong;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.parser.AbstractFunction;
import edu.neu.ccs.parser.BaseParser;
import edu.neu.ccs.parser.BooleanOperation;
import edu.neu.ccs.parser.NumericOperation;
import edu.neu.ccs.parser.ParserUtilities;
import edu.neu.ccs.util.MathUtilities;
import java.math.BigInteger;
import java.text.ParseException;

public class JPTParser
extends BaseParser {
    public static final AbstractFunction functionAbs = new AbstractFunction("abs", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            if (ParserUtilities.isXIntegral(values[0])) {
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)values[0]);
                BigInteger va = a.getValue();
                int test = va.compareTo(BigInteger.ZERO);
                if (test >= 0) {
                    return a;
                }
                va = va.negate();
                return new XBigInteger(va);
            }
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            if (vx >= 0.0) {
                return x;
            }
            return new XDouble(-vx);
        }
    };
    public static final AbstractFunction functionCeiling = new AbstractFunction("ceiling", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            if (ParserUtilities.isXIntegral(values[0])) {
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)values[0]);
                return a;
            }
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            vx = Math.ceil(vx);
            return new XDouble(vx);
        }
    };
    public static final AbstractFunction functionFloor = new AbstractFunction("floor", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            if (ParserUtilities.isXIntegral(values[0])) {
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)values[0]);
                return a;
            }
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            vx = Math.floor(vx);
            return new XDouble(vx);
        }
    };
    public static final AbstractFunction functionRound = new AbstractFunction("round", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            if (ParserUtilities.isXIntegral(values[0])) {
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)values[0]);
                return a;
            }
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            vx = Math.rint(vx);
            return new XDouble(vx);
        }
    };
    public static final AbstractFunction functionMax = new AbstractFunction("max", 2){

        public Object functionCall(Object[] values) throws ParseException {
            double vy;
            this.checkValuesAsNumeric(values);
            if (ParserUtilities.isXIntegral(values[0]) && ParserUtilities.isXIntegral(values[1])) {
                BigInteger vb;
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)values[0]);
                XBigInteger b = ParserUtilities.toXBigInteger((XNumber)values[1]);
                BigInteger va = a.getValue();
                int test = va.compareTo(vb = b.getValue());
                if (test >= 0) {
                    return a;
                }
                return b;
            }
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            XDouble y = ParserUtilities.toXDouble((XNumber)values[1]);
            double vx = x.getValue();
            if (vx >= (vy = y.getValue())) {
                return x;
            }
            return y;
        }
    };
    public static final AbstractFunction functionMin = new AbstractFunction("min", 2){

        public Object functionCall(Object[] values) throws ParseException {
            double vy;
            this.checkValuesAsNumeric(values);
            if (ParserUtilities.isXIntegral(values[0]) && ParserUtilities.isXIntegral(values[1])) {
                BigInteger vb;
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)values[0]);
                XBigInteger b = ParserUtilities.toXBigInteger((XNumber)values[1]);
                BigInteger va = a.getValue();
                int test = va.compareTo(vb = b.getValue());
                if (test >= 0) {
                    return b;
                }
                return a;
            }
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            XDouble y = ParserUtilities.toXDouble((XNumber)values[1]);
            double vx = x.getValue();
            if (vx >= (vy = y.getValue())) {
                return y;
            }
            return x;
        }
    };
    public static final AbstractFunction functionSqrt = new AbstractFunction("sqrt", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.sqrt(vx));
        }
    };
    public static final AbstractFunction functionPower = new AbstractFunction("power", 2){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            XDouble y = ParserUtilities.toXDouble((XNumber)values[1]);
            double vx = x.getValue();
            double vy = y.getValue();
            return new XDouble(Math.pow(vx, vy));
        }
    };
    public static final AbstractFunction functionRoot = new AbstractFunction("root", 2){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            XDouble y = ParserUtilities.toXDouble((XNumber)values[1]);
            double vx = x.getValue();
            double vy = y.getValue();
            return new XDouble(MathUtilities.root(vx, vy));
        }
    };
    public static final AbstractFunction functionToDegrees = new AbstractFunction("todegrees", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.toDegrees(vx));
        }
    };
    public static final AbstractFunction functionToRadians = new AbstractFunction("toradians", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.toRadians(vx));
        }
    };
    public static final AbstractFunction functionSin = new AbstractFunction("sin", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.sin(vx));
        }
    };
    public static final AbstractFunction functionSinDeg = new AbstractFunction("sindeg", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.sin(Math.toRadians(vx)));
        }
    };
    public static final AbstractFunction functionCos = new AbstractFunction("cos", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.cos(vx));
        }
    };
    public static final AbstractFunction functionCosDeg = new AbstractFunction("cosdeg", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.cos(Math.toRadians(vx)));
        }
    };
    public static final AbstractFunction functionTan = new AbstractFunction("tan", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.tan(vx));
        }
    };
    public static final AbstractFunction functionTanDeg = new AbstractFunction("tandeg", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.tan(Math.toRadians(vx)));
        }
    };
    public static final AbstractFunction functionASin = new AbstractFunction("asin", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.asin(vx));
        }
    };
    public static final AbstractFunction functionASinDeg = new AbstractFunction("asindeg", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.toDegrees(Math.asin(vx)));
        }
    };
    public static final AbstractFunction functionACos = new AbstractFunction("acos", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.acos(vx));
        }
    };
    public static final AbstractFunction functionACosDeg = new AbstractFunction("acosdeg", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.toDegrees(Math.acos(vx)));
        }
    };
    public static final AbstractFunction functionATan = new AbstractFunction("atan", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.atan(vx));
        }
    };
    public static final AbstractFunction functionATanDeg = new AbstractFunction("atandeg", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.toDegrees(Math.atan(vx)));
        }
    };
    public static final AbstractFunction functionATan2 = new AbstractFunction("atan2", 2){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble y = ParserUtilities.toXDouble((XNumber)values[0]);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[1]);
            double vy = y.getValue();
            double vx = x.getValue();
            return new XDouble(Math.atan2(vy, vx));
        }
    };
    public static final AbstractFunction functionATan2Deg = new AbstractFunction("atan2deg", 2){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble y = ParserUtilities.toXDouble((XNumber)values[0]);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[1]);
            double vy = y.getValue();
            double vx = x.getValue();
            return new XDouble(Math.toDegrees(Math.atan2(vy, vx)));
        }
    };
    public static final AbstractFunction functionExp = new AbstractFunction("exp", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.exp(vx));
        }
    };
    public static final AbstractFunction functionLog = new AbstractFunction("log", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.log(vx));
        }
    };
    public static final AbstractFunction functionLn = new AbstractFunction("ln", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.log(vx));
        }
    };
    public static final AbstractFunction functionLog2 = new AbstractFunction("log2", 1){
        private final double log2 = Math.log(2.0);

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.log(vx) / this.log2);
        }
    };
    public static final AbstractFunction functionLog10 = new AbstractFunction("log10", 1){
        private final double log10 = Math.log(10.0);

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(Math.log(vx) / this.log10);
        }
    };
    public static final AbstractFunction functionLogToBase = new AbstractFunction("logtobase", 2){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            XDouble b = ParserUtilities.toXDouble((XNumber)values[1]);
            double vx = x.getValue();
            double vb = b.getValue();
            return new XDouble(Math.log(vx) / Math.log(vb));
        }
    };
    public static final AbstractFunction functionSinh = new AbstractFunction("sinh", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(MathUtilities.sinh(vx));
        }
    };
    public static final AbstractFunction functionCosh = new AbstractFunction("cosh", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(MathUtilities.cosh(vx));
        }
    };
    public static final AbstractFunction functionTanh = new AbstractFunction("tanh", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(MathUtilities.tanh(vx));
        }
    };
    public static final AbstractFunction functionASinh = new AbstractFunction("asinh", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(MathUtilities.asinh(vx));
        }
    };
    public static final AbstractFunction functionACosh = new AbstractFunction("acosh", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(MathUtilities.acosh(vx));
        }
    };
    public static final AbstractFunction functionATanh = new AbstractFunction("atanh", 1){

        public Object functionCall(Object[] values) throws ParseException {
            this.checkValuesAsNumeric(values);
            XDouble x = ParserUtilities.toXDouble((XNumber)values[0]);
            double vx = x.getValue();
            return new XDouble(MathUtilities.atanh(vx));
        }
    };
    public static final NumericOperation operationPlus = new NumericOperation("+", true, true){

        public Object unaryForXIntegral(XBigInteger a) {
            return a;
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger va = a.getValue();
            BigInteger vb = b.getValue();
            return new XBigInteger(va.add(vb));
        }

        public Object unaryForXFloating(XDouble x) {
            return x;
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vx = x.getValue();
            double vy = y.getValue();
            return new XDouble(vx + vy);
        }
    };
    public static final NumericOperation operationMinus = new NumericOperation("-", true, true){

        public Object unaryForXIntegral(XBigInteger a) {
            BigInteger va = a.getValue();
            return new XBigInteger(va.negate());
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger va = a.getValue();
            BigInteger vb = b.getValue();
            return new XBigInteger(va.subtract(vb));
        }

        public Object unaryForXFloating(XDouble x) {
            double vx = x.getValue();
            return new XDouble(-vx);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vx = x.getValue();
            double vy = y.getValue();
            return new XDouble(vx - vy);
        }
    };
    public static final NumericOperation operationTimes = new NumericOperation("*", false, true){

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger va = a.getValue();
            BigInteger vb = b.getValue();
            return new XBigInteger(va.multiply(vb));
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vx = x.getValue();
            double vy = y.getValue();
            return new XDouble(vx * vy);
        }
    };
    public static final NumericOperation operationSlash = new NumericOperation("/", false, true){

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger va = a.getValue();
            BigInteger vb = b.getValue();
            if (vb.equals(BigInteger.ZERO)) {
                int test = va.compareTo(BigInteger.ZERO);
                if (test > 0) {
                    return new XDouble(Double.POSITIVE_INFINITY);
                }
                if (test < 0) {
                    return new XDouble(Double.NEGATIVE_INFINITY);
                }
                return new XDouble(Double.NaN);
            }
            return new XBigInteger(va.divide(vb));
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vx = x.getValue();
            double vy = y.getValue();
            return new XDouble(vx / vy);
        }
    };
    public static final NumericOperation operationPercent = new NumericOperation("%", false, true){

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger va = a.getValue();
            BigInteger vb = b.getValue();
            if (vb.equals(BigInteger.ZERO)) {
                return new XDouble(Double.NaN);
            }
            return new XBigInteger(va.remainder(vb));
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vx = x.getValue();
            double vy = y.getValue();
            return new XDouble(vx % vy);
        }
    };
    public static final NumericOperation operationCaret = new NumericOperation("^", false, true){
        private final BigInteger ZERO = BigInteger.ZERO;
        private final BigInteger ONE = BigInteger.ONE;
        private final BigInteger MINUSONE = this.ONE.negate();

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            int exponent;
            String bits;
            BigInteger vc;
            BigInteger va = a.getValue();
            BigInteger vb = b.getValue();
            if (vb.equals(this.ZERO)) {
                return new XBigInteger(this.ONE);
            }
            int test = vb.compareTo(this.ZERO);
            if (va.equals(this.ZERO)) {
                if (test > 0) {
                    return new XBigInteger(this.ZERO);
                }
                return new XDouble(Double.NaN);
            }
            if (va.equals(this.ONE)) {
                return new XBigInteger(this.ONE);
            }
            if (va.equals(this.MINUSONE)) {
                int lowbit = vb.getLowestSetBit();
                if (lowbit == 0) {
                    return new XBigInteger(this.MINUSONE);
                }
                return new XBigInteger(this.ONE);
            }
            if (test > 0 && vb.equals(vc = new BigInteger(bits = Integer.toBinaryString(exponent = vb.intValue()), 2))) {
                return new XBigInteger(va.pow(exponent));
            }
            double vx = va.doubleValue();
            double vy = vb.doubleValue();
            return new XDouble(Math.pow(vx, vy));
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vx = x.getValue();
            double vy = y.getValue();
            return new XDouble(Math.pow(vx, vy));
        }
    };
    public static final BooleanOperation operationEQ = new BooleanOperation("==", false, true, true){

        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vq;
            boolean vp = p.getValue();
            return new XBoolean(vp == (vq = q.getValue()));
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger vb;
            BigInteger va = a.getValue();
            int test = va.compareTo(vb = b.getValue());
            return new XBoolean(test == 0);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vy;
            double vx = x.getValue();
            return new XBoolean(vx == (vy = y.getValue()));
        }
    };
    public static final BooleanOperation operationNE = new BooleanOperation("!=", false, true, true){

        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vp = p.getValue();
            boolean vq = q.getValue();
            return new XBoolean(vp ^ vq);
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger vb;
            BigInteger va = a.getValue();
            int test = va.compareTo(vb = b.getValue());
            return new XBoolean(test != 0);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vy;
            double vx = x.getValue();
            return new XBoolean(vx != (vy = y.getValue()));
        }
    };
    public static final BooleanOperation operationLT = new BooleanOperation("<", false, true, true){

        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vp = p.getValue();
            boolean vq = q.getValue();
            return new XBoolean(!vp && vq);
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger vb;
            BigInteger va = a.getValue();
            int test = va.compareTo(vb = b.getValue());
            return new XBoolean(test < 0);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vy;
            double vx = x.getValue();
            return new XBoolean(vx < (vy = y.getValue()));
        }
    };
    public static final BooleanOperation operationGT = new BooleanOperation(">", false, true, true){

        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vp = p.getValue();
            boolean vq = q.getValue();
            return new XBoolean(vp && !vq);
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger vb;
            BigInteger va = a.getValue();
            int test = va.compareTo(vb = b.getValue());
            return new XBoolean(test > 0);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vy;
            double vx = x.getValue();
            return new XBoolean(vx > (vy = y.getValue()));
        }
    };
    public static final BooleanOperation operationLE = new BooleanOperation("<=", false, true, true){

        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vp = p.getValue();
            boolean vq = q.getValue();
            return new XBoolean(!vp || vq);
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger vb;
            BigInteger va = a.getValue();
            int test = va.compareTo(vb = b.getValue());
            return new XBoolean(test <= 0);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vy;
            double vx = x.getValue();
            return new XBoolean(vx <= (vy = y.getValue()));
        }
    };
    public static final BooleanOperation operationGE = new BooleanOperation(">=", false, true, true){

        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vp = p.getValue();
            boolean vq = q.getValue();
            return new XBoolean(vp || !vq);
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger vb;
            BigInteger va = a.getValue();
            int test = va.compareTo(vb = b.getValue());
            return new XBoolean(test >= 0);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vy;
            double vx = x.getValue();
            return new XBoolean(vx >= (vy = y.getValue()));
        }
    };
    public static final BooleanOperation operationAND = new BooleanOperation("&&", false, true, false){

        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vp = p.getValue();
            boolean vq = q.getValue();
            return new XBoolean(vp && vq);
        }
    };
    public static final BooleanOperation operationOR = new BooleanOperation("||", false, true, false){

        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vp = p.getValue();
            boolean vq = q.getValue();
            return new XBoolean(vp || vq);
        }
    };
    public static final BooleanOperation operationNOT = new BooleanOperation("!", true, false, false){

        public Object unaryForXBoolean(XBoolean p) {
            boolean vp = p.getValue();
            return new XBoolean(!vp);
        }
    };

    protected void addConstants() {
        this.addConstant("true", new XBoolean(true));
        this.addConstant("false", new XBoolean(false));
        this.addConstant("pi", new XDouble(Math.PI));
        this.addConstant("e", new XDouble(Math.E));
        this.addConstant("MaxInt", new XInt(Integer.MAX_VALUE));
        this.addConstant("maxint", new XInt(Integer.MAX_VALUE));
        this.addConstant("MinInt", new XInt(Integer.MIN_VALUE));
        this.addConstant("minint", new XInt(Integer.MIN_VALUE));
        this.addConstant("MaxLong", new XLong(Long.MAX_VALUE));
        this.addConstant("maxlong", new XLong(Long.MAX_VALUE));
        this.addConstant("MinLong", new XLong(Long.MIN_VALUE));
        this.addConstant("minlong", new XLong(Long.MIN_VALUE));
        this.addConstant("MaxDouble", new XDouble(Double.MAX_VALUE));
        this.addConstant("maxdouble", new XDouble(Double.MAX_VALUE));
        this.addConstant("MinDouble", new XDouble(Double.MIN_VALUE));
        this.addConstant("mindouble", new XDouble(Double.MIN_VALUE));
        this.addConstant("Infinity", new XDouble(Double.POSITIVE_INFINITY));
        this.addConstant("infinity", new XDouble(Double.POSITIVE_INFINITY));
        this.addConstant("NaN", new XDouble(Double.NaN));
        this.addConstant("nan", new XDouble(Double.NaN));
    }

    protected void addFunctions() {
        this.addFunction(functionAbs);
        this.addFunction(functionCeiling);
        this.addFunction(functionFloor);
        this.addFunction(functionRound);
        this.addFunction(functionMax);
        this.addFunction(functionMin);
        this.addFunction(functionSqrt);
        this.addFunction(functionPower);
        this.addFunction(functionRoot);
        this.addFunction(functionToDegrees);
        this.addFunction(functionToRadians);
        this.addFunction(functionSin);
        this.addFunction(functionSinDeg);
        this.addFunction(functionCos);
        this.addFunction(functionCosDeg);
        this.addFunction(functionTan);
        this.addFunction(functionTanDeg);
        this.addFunction(functionASin);
        this.addFunction(functionASinDeg);
        this.addFunction(functionACos);
        this.addFunction(functionACosDeg);
        this.addFunction(functionATan);
        this.addFunction(functionATanDeg);
        this.addFunction(functionATan2);
        this.addFunction(functionATan2Deg);
        this.addFunction(functionExp);
        this.addFunction(functionLog);
        this.addFunction(functionLn);
        this.addFunction(functionLog2);
        this.addFunction(functionLog10);
        this.addFunction(functionLogToBase);
        this.addFunction(functionSinh);
        this.addFunction(functionCosh);
        this.addFunction(functionTanh);
        this.addFunction(functionASinh);
        this.addFunction(functionACosh);
        this.addFunction(functionATanh);
    }

    protected void addOperations() {
        this.addOperationAfterPrecedenceOf(IDENTITY, operationOR);
        this.addOperationAfterPrecedenceOf(operationOR, operationAND);
        this.addOperationAfterPrecedenceOf(operationAND, operationEQ);
        this.addOperationAtPrecedenceOf(operationEQ, operationNE);
        this.addOperationAfterPrecedenceOf(operationEQ, operationLT);
        this.addOperationAtPrecedenceOf(operationLT, operationGT);
        this.addOperationAtPrecedenceOf(operationLT, operationLE);
        this.addOperationAtPrecedenceOf(operationLT, operationGE);
        this.addOperationAfterPrecedenceOf(operationLT, operationPlus);
        this.addOperationAtPrecedenceOf(operationPlus, operationMinus);
        this.addOperationAfterPrecedenceOf(operationPlus, operationTimes);
        this.addOperationAtPrecedenceOf(operationTimes, operationSlash);
        this.addOperationAtPrecedenceOf(operationTimes, operationPercent);
        this.addOperationAfterPrecedenceOf(operationTimes, operationCaret);
        this.addOperationAfterPrecedenceOf(operationCaret, operationNOT);
    }
}

