/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.parser;

import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.parser.Operation;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class BooleanOperation
extends Operation {
    protected boolean booleanOrNumeric = true;

    public BooleanOperation(String s) {
        super(s);
    }

    public BooleanOperation(String s, boolean unary, boolean binary) {
        super(s, unary, binary);
    }

    public BooleanOperation(String s, boolean unary, boolean binary, boolean b_or_n) {
        super(s, unary, binary);
        this.booleanOrNumeric = b_or_n;
    }

    public final Object performOperation(Object left, Object right) throws ParseException {
        if (left == null) {
            this.checkUnary();
            if (ParserUtilities.isXBoolean(right)) {
                XBoolean p = (XBoolean)right;
                return this.unaryForXBoolean(p);
            }
            if (!this.booleanOrNumeric) {
                throw new ParseException("Boolean operation " + this.symbol() + " expects 1 boolean argument", 0);
            }
            if (ParserUtilities.isXIntegral(right)) {
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)right);
                return this.unaryForXIntegral(a);
            }
            if (ParserUtilities.isXNumber(right)) {
                XDouble x = ParserUtilities.toXDouble((XNumber)right);
                return this.unaryForXFloating(x);
            }
            throw new ParseException("Boolean operation " + this.symbol() + " expects 1 boolean or 1 numeric argument", 0);
        }
        this.checkBinary();
        if (ParserUtilities.isXBoolean(left) && ParserUtilities.isXBoolean(right)) {
            XBoolean p = (XBoolean)left;
            XBoolean q = (XBoolean)right;
            return this.binaryForXBoolean(p, q);
        }
        if (!this.booleanOrNumeric) {
            throw new ParseException("Boolean operation " + this.symbol() + " expects 2 boolean arguments", 0);
        }
        if (ParserUtilities.isXIntegral(left) && ParserUtilities.isXIntegral(right)) {
            XBigInteger a = ParserUtilities.toXBigInteger((XNumber)left);
            XBigInteger b = ParserUtilities.toXBigInteger((XNumber)right);
            return this.binaryForXIntegral(a, b);
        }
        if (ParserUtilities.isXNumber(left) && ParserUtilities.isXNumber(right)) {
            XDouble x = ParserUtilities.toXDouble((XNumber)left);
            XDouble y = ParserUtilities.toXDouble((XNumber)right);
            return this.binaryForXFloating(x, y);
        }
        throw new ParseException("Boolean operation " + this.symbol() + " expects 2 boolean or 2 numeric arguments", 0);
    }

    public final boolean handlesBooleanOrNumeric() {
        return this.booleanOrNumeric;
    }

    public Object unaryForXBoolean(XBoolean p) {
        return null;
    }

    public Object binaryForXBoolean(XBoolean p, XBoolean q) {
        return null;
    }

    public Object unaryForXIntegral(XBigInteger a) {
        return null;
    }

    public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
        return null;
    }

    public Object unaryForXFloating(XDouble x) {
        return null;
    }

    public Object binaryForXFloating(XDouble x, XDouble y) {
        return null;
    }
}

