/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.parser;

import edu.neu.ccs.Strings;
import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XInterval;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.parser.AbstractFunction;
import edu.neu.ccs.parser.ObjectOperationPair;
import edu.neu.ccs.parser.Operation;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserContext;
import edu.neu.ccs.parser.ParserUtilities;
import edu.neu.ccs.parser.SimpleFunction;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BaseParser
implements Parser {
    public static final Operation IDENTITY = Operation.IDENTITY;
    public static final Operation OPERATION_PREFIX = Operation.OPERATION_PREFIX;
    protected static final int INTEGRAL = 100;
    protected static final int FLOATING = 101;
    protected String NESTED_EXPRESSION_START = "(";
    protected String NESTED_EXPRESSION_END = ")";
    protected String ARGUMENT_LIST_START = "(";
    protected String ARGUMENT_LIST_END = ")";
    protected String RADIX_POINT = ".";
    protected String ARGUMENT_SEPARATOR = ",";
    protected char UNDERSCORE = (char)95;
    protected final String ASSIGNMENT_BY_SET = "set";
    protected final String ASSIGNMENT_BY_LET = "let";
    protected final String IF_THEN_ELSE = "if";
    protected final String EVAL = "eval";
    protected final String RANDOM = "random";
    private Hashtable reserved = new Hashtable();
    private Hashtable constants = new Hashtable();
    private Hashtable set_variables = new Hashtable();
    private Hashtable let_variables = new Hashtable();
    private Hashtable functions = new Hashtable();
    private Hashtable operations = new Hashtable();
    private Hashtable prefixes = new Hashtable();
    private Vector precedence = new Vector();
    private Vector parserContextStack = new Vector();
    protected String data = "";
    protected int next = 0;
    protected int suspend = 0;

    public BaseParser() {
        this.initializeStructures();
        this.addReserved();
        this.addConstants();
        this.addFunctions();
        this.addOperations();
    }

    public final Object parse(String d) throws ParseException {
        return this.parseWithArgumentList(d, null, null);
    }

    public final Object parseWithArgumentList(String d, String[] ids, Object[] values) throws ParseException {
        try {
            this.pushContext(d);
            if (d == null) {
                throw new ParseException("Data to parse was null", -1);
            }
            this.assignArgumentList(ids, values);
            Object value = this.parseExpression();
            if (value == null) {
                throw new ParseException("Expected expression", this.next);
            }
            if (this.next < this.data.length()) {
                throw new ParseException("Expected end of expression", this.next);
            }
            this.popContext();
            return value;
        }
        catch (Throwable ex) {
            this.throwAgainAndPop(ex.getMessage(), d);
            return null;
        }
    }

    public final double call(String name, double[] arguments) throws ParseException {
        String message = null;
        if (name == null) {
            message = "Null name passed to call";
            throw new ParseException(message, 0);
        }
        AbstractFunction f = this.getFunction(name);
        if (f == null) {
            message = "Function " + name + " is not installed in this parser";
            throw new ParseException(message, 0);
        }
        return BaseParser.call(f, arguments);
    }

    public final double call(String name, double x) throws ParseException {
        return this.call(name, new double[]{x});
    }

    public final double call(String name, double x, double y) throws ParseException {
        return this.call(name, new double[]{x, y});
    }

    public final double call(String name, double x, double y, double z) throws ParseException {
        return this.call(name, new double[]{x, y, z});
    }

    public final double call(String name, double x, double y, double z, double w) throws ParseException {
        return this.call(name, new double[]{x, y, z, w});
    }

    public final XPoint2D[][] makeTable(String names, double endpointA, double endpointB, int divisions) throws ParseException {
        if (names == null) {
            return null;
        }
        String message = null;
        String[] list = Strings.splitCommaList(names);
        int N = list.length;
        XPoint2D[][] result = new XPoint2D[N][];
        if (divisions < 1) {
            divisions = 1;
        }
        int i = 0;
        while (i < N) {
            AbstractFunction f = this.getFunction(list[i]);
            if (f == null) {
                message = "Function " + list[i] + " is not installed in this parser";
                throw new ParseException(message, 0);
            }
            result[i] = BaseParser.makeTable(f, endpointA, endpointB, divisions);
            ++i;
        }
        return result;
    }

    public final XPoint2D[][] makeTable(String names, XInterval limits, int divisions) throws ParseException {
        if (limits == null) {
            return null;
        }
        double endpointA = limits.getMinimum();
        double endpointB = limits.getMaximum();
        return this.makeTable(names, endpointA, endpointB, divisions);
    }

    public static double call(AbstractFunction f, double[] arguments) throws ParseException {
        int size;
        String message = null;
        if (f == null) {
            message = "Null AbstractFunction passed to call";
            throw new ParseException(message, 0);
        }
        if (arguments == null) {
            message = "Null arguments passed to call";
            throw new ParseException(message, 0);
        }
        String name = f.name();
        int args = f.arguments();
        if (args != (size = arguments.length)) {
            message = "Function " + name + " requires " + args + " arguments" + " but provided " + size + " arguments";
            throw new ParseException(message, 0);
        }
        Object[] data = new XDouble[size];
        int i = 0;
        while (i < size) {
            data[i] = new XDouble(arguments[i]);
            ++i;
        }
        Object result = f.functionCall(data);
        if (!(result instanceof XNumber)) {
            message = "Function " + name + " failed to return a numeric value";
            throw new ParseException(message, 0);
        }
        XNumber v = (XNumber)result;
        return v.doubleValue();
    }

    public static double call(AbstractFunction f, double x) throws ParseException {
        return BaseParser.call(f, new double[]{x});
    }

    public static double call(AbstractFunction f, double x, double y) throws ParseException {
        return BaseParser.call(f, new double[]{x, y});
    }

    public static double call(AbstractFunction f, double x, double y, double z) throws ParseException {
        return BaseParser.call(f, new double[]{x, y, z});
    }

    public static double call(AbstractFunction f, double x, double y, double z, double w) throws ParseException {
        return BaseParser.call(f, new double[]{x, y, z, w});
    }

    public static XPoint2D[] makeTable(AbstractFunction f, double endpointA, double endpointB, int divisions) throws ParseException {
        if (f == null) {
            return null;
        }
        String name = f.name();
        int args = f.arguments();
        if (args != 1) {
            String message = "Method makeTable requires a function of one argument but was passed " + name + " which needs " + args + " arguments";
            throw new ParseException(message, 0);
        }
        if (divisions < 1) {
            divisions = 1;
        }
        int d = divisions;
        XPoint2D[] result = new XPoint2D[d + 1];
        result[0] = new XPoint2D(endpointA, BaseParser.call(f, endpointA));
        result[d] = new XPoint2D(endpointB, BaseParser.call(f, endpointB));
        if (d == 1) {
            return result;
        }
        double delta = (endpointB - endpointA) / (double)d;
        int i = 1;
        while (i < d) {
            double x = endpointA + (double)i * delta;
            result[i] = new XPoint2D(x, BaseParser.call(f, x));
            ++i;
        }
        return result;
    }

    public static XPoint2D[] makeTable(AbstractFunction f, XInterval limits, int divisions) throws ParseException {
        if (limits == null) {
            return null;
        }
        double endpointA = limits.getMinimum();
        double endpointB = limits.getMaximum();
        return BaseParser.makeTable(f, endpointA, endpointB, divisions);
    }

    public final void reserveID(String id) {
        String message = null;
        if (!BaseParser.isPossibleIdentifier(id)) {
            message = String.valueOf(id) + " is not a valid identifier" + " for defining a reserved ID";
        } else if (this.isConstantID(id)) {
            message = String.valueOf(id) + " may not define a reserved ID" + " since it already defines a constant ID";
        } else if (this.isFunctionName(id)) {
            message = String.valueOf(id) + " may not define a reserved ID" + " since it already defines a function name";
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        if (!this.reserved.containsKey(id)) {
            this.reserved.put(id, id);
        }
    }

    public final void addConstant(String id, Object value) {
        if (id == null || value == null) {
            return;
        }
        String message = null;
        if (!BaseParser.isPossibleIdentifier(id)) {
            message = String.valueOf(id) + " is not a valid identifier" + " for defining a constant";
        } else if (this.isReservedID(id)) {
            message = String.valueOf(id) + " may not define a constant ID" + " since it already defines a reserved ID";
        } else if (this.isConstantID(id)) {
            message = String.valueOf(id) + " may not define a constant ID" + " since it already defines a constant ID";
        } else if (this.isFunctionName(id)) {
            message = String.valueOf(id) + " may not define a constant ID" + " since it already defines a function name";
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        this.constants.put(id, value);
    }

    public final boolean isPossibleVariableID(String id) {
        if (id == null) {
            return false;
        }
        if (!BaseParser.isPossibleIdentifier(id)) {
            return false;
        }
        if (this.isReservedID(id)) {
            return false;
        }
        if (this.isConstantID(id)) {
            return false;
        }
        return !this.isFunctionName(id);
    }

    public final Object assignSetVariable(String id, Object value) {
        return this.assignVariable(id, value, this.set_variables);
    }

    public final Object assignLetVariable(String id, Object value) {
        return this.assignVariable(id, value, this.let_variables);
    }

    public void assignArgumentList(String[] ids, Object[] values) {
        int i;
        int length;
        if (ids == null && values == null) {
            return;
        }
        String message = null;
        if (ids == null) {
            message = "Null id list passed to assignArgumentList";
        } else if (values == null) {
            message = "Null value list passed to assignArgumentList";
        } else if (ids.length != values.length) {
            message = "In assignArgumentList the id list and the value list do not have the same length";
        } else {
            length = ids.length;
            i = 0;
            while (i < length) {
                if (ids[i] == null) {
                    message = "In assignArgumentList the id in position " + i + " is null";
                    break;
                }
                if (values[i] == null) {
                    message = "In assignArgumentList the value in position " + i + " is null";
                    break;
                }
                if (!this.isPossibleVariableID(ids[i])) {
                    message = "In assignArgumentList the id in position " + i + ", namely, " + ids[i] + ", is not a possible variable id";
                    break;
                }
                ++i;
            }
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        length = ids.length;
        i = 0;
        while (i < length) {
            this.assignLetVariable(ids[i], values[i]);
            ++i;
        }
    }

    public final void addFunction(AbstractFunction function) {
        if (function == null) {
            return;
        }
        String name = function.name();
        String message = null;
        if (this.isReservedID(name)) {
            message = String.valueOf(name) + " may not define a function name" + " since it already defines a reserved ID";
        } else if (this.isConstantID(name)) {
            message = String.valueOf(name) + " may not define a function name" + " since it already defines a constant ID";
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        this.functions.put(name, function);
    }

    public final AbstractFunction removeFunction(String name) {
        if (name == null) {
            return null;
        }
        return (AbstractFunction)this.functions.remove(name);
    }

    public final Operation addOperationAtPrecedenceOf(Operation compare, Operation op) {
        int pos = this.precedenceOf(compare);
        if (pos == -1) {
            String message = "addOperation... error: compare operator not installed";
            throw new IllegalArgumentException(message);
        }
        this.addOperation(op, pos);
        return op;
    }

    public final Operation addOperationBeforePrecedenceOf(Operation compare, Operation op) {
        int pos = this.precedenceOf(compare);
        if (pos == -1) {
            String message = "addOperation... error: compare operator not installed";
            throw new IllegalArgumentException(message);
        }
        if (pos == 0) {
            String message = "addOperation... error: may not install before precedence 0";
            throw new IllegalArgumentException(message);
        }
        this.precedence.insertElementAt(new Hashtable(), pos);
        this.addOperation(op, pos);
        return op;
    }

    public final Operation addOperationAfterPrecedenceOf(Operation compare, Operation op) {
        int pos = this.precedenceOf(compare);
        if (pos == -1) {
            String message = "addOperation... error: compare operator not installed";
            throw new IllegalArgumentException(message);
        }
        this.precedence.insertElementAt(new Hashtable(), pos + 1);
        this.addOperation(op, pos + 1);
        return op;
    }

    public final boolean isReservedID(String id) {
        if (id == null) {
            return false;
        }
        return this.reserved.containsKey(id);
    }

    public final boolean isConstantID(String id) {
        if (id == null) {
            return false;
        }
        return this.constants.containsKey(id);
    }

    public final boolean isSetVariableID(String id) {
        if (id == null) {
            return false;
        }
        return this.set_variables.containsKey(id);
    }

    public final boolean isLetVariableID(String id) {
        if (id == null) {
            return false;
        }
        return this.let_variables.containsKey(id);
    }

    public final boolean isEnvironmentID(String id) {
        if (id == null) {
            return false;
        }
        return this.isConstantID(id) || this.isSetVariableID(id) || this.isLetVariableID(id);
    }

    public final boolean isFunctionName(String name) {
        if (name == null) {
            return false;
        }
        return this.functions.containsKey(name);
    }

    public final boolean isSimpleFunctionName(String name) {
        AbstractFunction function = this.getFunction(name);
        if (function == null) {
            return false;
        }
        return function instanceof SimpleFunction;
    }

    public final boolean isOrdinaryFunctionName(String name) {
        AbstractFunction function = this.getFunction(name);
        if (function == null) {
            return false;
        }
        return !(function instanceof SimpleFunction);
    }

    public final boolean isOperationSymbol(String symbol) {
        if (symbol == null) {
            return false;
        }
        return this.operations.containsKey(symbol);
    }

    public final Object getValue(String id) {
        if (id == null) {
            return null;
        }
        if (this.isConstantID(id)) {
            return this.constants.get(id);
        }
        if (this.isLetVariableID(id)) {
            return this.let_variables.get(id);
        }
        if (this.isSetVariableID(id)) {
            return this.set_variables.get(id);
        }
        return null;
    }

    public final AbstractFunction getFunction(String name) {
        if (this.isFunctionName(name)) {
            return (AbstractFunction)this.functions.get(name);
        }
        return null;
    }

    public final Operation getOperation(String symbol) {
        if (this.isOperationSymbol(symbol)) {
            return (Operation)this.operations.get(symbol);
        }
        return null;
    }

    public final String[] reserved() {
        Enumeration e = this.reserved.keys();
        Vector list = new Vector();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        int size = list.size();
        Object[] result = list.toArray(new String[size]);
        Arrays.sort(result);
        return result;
    }

    public final String[] constants() {
        Enumeration e = this.constants.keys();
        Vector list = new Vector();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        int size = list.size();
        Object[] result = list.toArray(new String[size]);
        Arrays.sort(result);
        return result;
    }

    public final String[] set_variables() {
        Enumeration e = this.set_variables.keys();
        Vector list = new Vector();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        int size = list.size();
        Object[] result = list.toArray(new String[size]);
        Arrays.sort(result);
        return result;
    }

    public final String[] functionNames() {
        Enumeration e = this.functions.keys();
        Vector list = new Vector();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        int size = list.size();
        Object[] result = list.toArray(new String[size]);
        Arrays.sort(result);
        return result;
    }

    public final String[] simpleFunctionNames() {
        Enumeration e = this.functions.keys();
        Vector<String> list = new Vector<String>();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!this.isSimpleFunctionName(name)) continue;
            list.add(name);
        }
        int size = list.size();
        Object[] result = list.toArray(new String[size]);
        Arrays.sort(result);
        return result;
    }

    public final String[] ordinaryFunctionNames() {
        Enumeration e = this.functions.keys();
        Vector<String> list = new Vector<String>();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!this.isOrdinaryFunctionName(name)) continue;
            list.add(name);
        }
        int size = list.size();
        Object[] result = list.toArray(new String[size]);
        Arrays.sort(result);
        return result;
    }

    public final AbstractFunction[] functions() {
        String[] names = this.functionNames();
        int length = names.length;
        AbstractFunction[] fcns = new AbstractFunction[length];
        int i = 0;
        while (i < length) {
            fcns[i] = (AbstractFunction)this.functions.get(names[i]);
            ++i;
        }
        return fcns;
    }

    public final SimpleFunction[] simpleFunctions() {
        String[] names = this.simpleFunctionNames();
        int length = names.length;
        SimpleFunction[] fcns = new SimpleFunction[length];
        int i = 0;
        while (i < length) {
            fcns[i] = (SimpleFunction)this.functions.get(names[i]);
            ++i;
        }
        return fcns;
    }

    public final AbstractFunction[] ordinaryFunctions() {
        String[] names = this.ordinaryFunctionNames();
        int length = names.length;
        AbstractFunction[] fcns = new AbstractFunction[length];
        int i = 0;
        while (i < length) {
            fcns[i] = (AbstractFunction)this.functions.get(names[i]);
            ++i;
        }
        return fcns;
    }

    public final String[] operationSymbols() {
        Enumeration e = this.operations.keys();
        Vector list = new Vector();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        int size = list.size();
        return list.toArray(new String[size]);
    }

    public final Operation[] operations() {
        String[] symbols = this.operationSymbols();
        int length = symbols.length;
        Operation[] ops = new Operation[length];
        int i = 0;
        while (i < length) {
            ops[i] = (Operation)this.operations.get(symbols[i]);
            ++i;
        }
        return ops;
    }

    public final String simpleFunctionsToString() {
        StringBuffer buffer = new StringBuffer();
        SimpleFunction[] fcns = this.simpleFunctions();
        int length = fcns.length;
        int i = 0;
        while (i < length) {
            buffer.append(fcns[i].toString());
            ++i;
        }
        return buffer.toString();
    }

    public void stringToSimpleFunctions(String string) {
        String message = null;
        String me = "stringToSimpleFunctions";
        if (string == null) {
            message = "Null string passed to " + me;
            throw new IllegalArgumentException(message);
        }
        String[] lines = Strings.tokenize(string, "\n", true);
        int length = lines.length;
        if (length % 3 != 0) {
            message = "The string passed to " + me + "\nfails to consist of 3*N lines for some N" + "\nbut rather has " + length + " lines";
            throw new IllegalArgumentException(message);
        }
        int N = length / 3;
        int i = 0;
        int k = 0;
        try {
            while (i < N) {
                k = 3 * i;
                String name = lines[k];
                String parameters = lines[k + 1];
                String body = lines[k + 2];
                new SimpleFunction(this, name, parameters, body);
                ++i;
            }
        }
        catch (IllegalArgumentException iae) {
            message = "In " + me + "\nerror in function definition " + i + "\nat lines " + k + " to " + (k + 2) + "\n" + iae.getMessage();
            throw new IllegalArgumentException(message);
        }
    }

    public static final boolean isPossibleIdentifier(String id) {
        if (id == null || id.length() == 0) {
            return false;
        }
        int length = id.length();
        char c = id.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        int i = 1;
        while (i < length) {
            c = id.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isPossibleOperation(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals("")) {
            return true;
        }
        if (string.equals("\u0000")) {
            return true;
        }
        int length = string.length();
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            switch (c) {
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '\\': 
                case '^': 
                case '`': 
                case '|': 
                case '~': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected void addReserved() {
        this.reserveID("set");
        this.reserveID("let");
        this.reserveID("if");
        this.reserveID("eval");
        this.reserveID("random");
    }

    protected void addConstants() {
    }

    protected void addFunctions() {
    }

    protected void addOperations() {
    }

    protected Object nextTerm() throws ParseException {
        Operation[] operations = this.nextUnaryOperations();
        int length = operations.length;
        Object term = this.nextSimpleTerm();
        if (this.evaluate()) {
            int i = length - 1;
            while (i >= 0) {
                term = operations[i].performOperation(null, term);
                --i;
            }
        }
        return term;
    }

    protected Object nextSimpleTerm() throws ParseException {
        this.skipWhitespace();
        Object term = null;
        if (this.nextTokenIs(this.NESTED_EXPRESSION_START)) {
            term = this.parseNestedExpression();
        } else if (this.startsNumber()) {
            term = this.parseNumber();
        } else if (this.startsIdentifier()) {
            term = this.parseIdentifierExpression();
        } else {
            throw new ParseException("Expected term", this.next);
        }
        this.skipWhitespace();
        return term;
    }

    protected Operation[] nextUnaryOperations() throws ParseException {
        Operation operation;
        Vector<Operation> operations = new Vector<Operation>();
        while ((operation = this.nextOperation()) != null) {
            if (operation.isUnary()) {
                operations.add(operation);
                continue;
            }
            throw new ParseException("Expected a pending unary operation", this.next);
        }
        return operations.toArray(new Operation[0]);
    }

    protected Object parseIdentifierExpression() throws ParseException {
        String identifier = this.nextIdentifier();
        Object term = null;
        if (this.isReservedID(identifier)) {
            term = this.parseSpecialFunction(identifier);
        } else if (this.isFunctionName(identifier)) {
            term = this.parseFunctionCall(identifier);
        } else if (this.isEnvironmentID(identifier)) {
            term = this.evaluateIdentifier(identifier);
        } else {
            String message = "Unrecognized identifier: " + identifier;
            throw new ParseException(message, this.next);
        }
        return term;
    }

    protected Object parseSpecialFunction(String identifier) throws ParseException {
        if (!this.isReservedID(identifier)) {
            throw new ParseException("Unrecognized special function " + identifier, this.next);
        }
        if (identifier.equals("set")) {
            return this.parseAssignment(this.set_variables);
        }
        if (identifier.equals("let")) {
            return this.parseAssignment(this.let_variables);
        }
        if (identifier.equals("if")) {
            return this.parseIfThenElse();
        }
        if (identifier.equals("eval")) {
            return this.parseEval();
        }
        if (identifier.equals("random")) {
            return this.parseRandom();
        }
        return null;
    }

    protected final void pushContext(String d) {
        this.parserContextStack.add(new ParserContext(this.data, this.next, this.let_variables));
        this.data = d == null ? "" : d;
        this.next = 0;
        this.let_variables = new Hashtable();
    }

    protected final void specialPush(String d) {
        this.parserContextStack.add(new ParserContext(this.data, this.next, this.let_variables));
        this.data = d == null ? "" : d;
        this.next = 0;
    }

    protected final void popContext() {
        int size = this.parserContextStack.size();
        ParserContext context = (ParserContext)this.parserContextStack.remove(size - 1);
        this.data = context.data();
        this.next = context.next();
        this.let_variables = context.let_variables();
    }

    protected final void throwAgainAndPop(String message, String d) throws ParseException {
        if (message == null) {
            message = "";
        }
        if (d != null) {
            message = String.valueOf(message) + "\nat position " + this.next + "\n" + d + "\n" + Strings.prefixRepeatChar("^", '.', this.next);
        }
        ParseException pe = new ParseException(message, this.next);
        this.popContext();
        throw pe;
    }

    /*
     * Unable to fully structure code
     */
    protected final ObjectOperationPair parseExpression(ObjectOperationPair pending) throws ParseException {
        left = pending.value();
        term = null;
        oldOp = pending.operation();
        newOp = null;
        oldPr = this.precedenceOf(oldOp);
        newPr = -1;
        if (oldOp == null) {
            throw new ParseException("Expected a pending binary operation", this.next);
        }
        while (true) {
            term = this.nextTerm();
            newOp = this.nextOperation();
            newPr = this.precedenceOf(newOp);
            if (newOp == null || newOp.isBinary()) ** GOTO lbl19
            throw new ParseException("Expected a pending binary operation", this.next);
lbl-1000:
            // 1 sources

            {
                ooPair = this.parseExpression(new ObjectOperationPair(term, newOp));
                term = ooPair.value();
                newOp = ooPair.operation();
                newPr = this.precedenceOf(newOp);
lbl19:
                // 2 sources

                ** while (newPr > oldPr)
            }
lbl20:
            // 1 sources

            if (this.evaluate()) {
                term = oldOp.performOperation(left, term);
            }
            if (newPr != oldPr) break;
            left = term;
            oldOp = newOp;
        }
        return new ObjectOperationPair(term, newOp);
    }

    protected final Object parseExpression() throws ParseException {
        return this.parseExpression(new ObjectOperationPair()).value();
    }

    protected final String extractExpression() throws ParseException {
        ++this.suspend;
        int start = this.next;
        this.parseExpression();
        int finish = this.next;
        --this.suspend;
        return this.data.substring(start, finish).trim();
    }

    protected final Object parseNestedExpression() throws ParseException {
        Object term = null;
        if (this.nextTokenIs(this.NESTED_EXPRESSION_START)) {
            this.next += this.NESTED_EXPRESSION_START.length();
            term = this.parseExpression();
            this.skipWhitespace();
            if (this.next == this.data.length() || !this.nextTokenIs(this.NESTED_EXPRESSION_END)) {
                throw new ParseException("Expected end of nested expression", this.next);
            }
            this.next += this.NESTED_EXPRESSION_END.length();
            this.skipWhitespace();
        }
        return term;
    }

    protected final Object evaluateIdentifier(String identifier) throws ParseException {
        if (!this.evaluate()) {
            return null;
        }
        if (!this.isEnvironmentID(identifier)) {
            String message = "Unrecognized constant or variable " + identifier;
            throw new ParseException(message, this.next);
        }
        return this.getValue(identifier);
    }

    protected final Object parseAssignment(Hashtable binding) throws ParseException {
        Object[] identifierExpression = this.parseIdentifierExpressionList();
        String identifier = (String)identifierExpression[0];
        Object expression = identifierExpression[1];
        try {
            if (this.evaluate()) {
                this.assignVariable(identifier, expression, binding);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException(ex.getMessage(), this.next);
        }
        return expression;
    }

    protected final Object assignVariable(String id, Object value, Hashtable binding) {
        if (id == null || binding == null) {
            return null;
        }
        String message = null;
        if (!BaseParser.isPossibleIdentifier(id)) {
            message = String.valueOf(id) + " is not a valid identifier" + " for defining a variable";
        }
        if (this.isReservedID(id)) {
            message = String.valueOf(id) + " may not define a variable ID" + " since it already defines a reserved ID";
        }
        if (this.isConstantID(id)) {
            message = String.valueOf(id) + " may not define a variable ID" + " since it already defines a constant ID";
        }
        if (this.isFunctionName(id)) {
            message = String.valueOf(id) + " may not define a variable ID" + " since it already defines a function name";
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        if (value == null) {
            binding.remove(id);
        } else {
            binding.put(id, value);
        }
        return value;
    }

    protected final Object parseFunctionCall(String identifier) throws ParseException {
        if (!this.isFunctionName(identifier)) {
            throw new ParseException("Unrecognized function " + identifier, this.next);
        }
        AbstractFunction function = this.getFunction(identifier);
        Object term = null;
        try {
            Object[] values = this.parseArgumentList();
            if (this.evaluate()) {
                term = function.functionCall(values);
            }
        }
        catch (ParseException exception) {
            throw new ParseException(exception.getMessage(), this.next);
        }
        return term;
    }

    protected final Object parseIfThenElse() throws ParseException {
        Object result = null;
        if (!this.nextTokenIs(this.ARGUMENT_LIST_START)) {
            String message = "Expected start of argument list";
            throw new ParseException(message, this.next);
        }
        this.next += this.ARGUMENT_LIST_START.length();
        this.skipWhitespace();
        if (this.evaluate()) {
            String message;
            Object test = this.parseExpression();
            boolean first = true;
            if (!(test instanceof XBoolean)) {
                throw new ParseException("Expected boolean test in if", this.next);
            }
            XBoolean bool = (XBoolean)test;
            first = bool.getValue();
            if (!this.nextTokenIs(this.ARGUMENT_SEPARATOR)) {
                message = "Expected argument separator in list";
                throw new ParseException(message, this.next);
            }
            this.next += this.ARGUMENT_SEPARATOR.length();
            this.skipWhitespace();
            if (first) {
                result = this.parseExpression();
            } else {
                this.extractExpression();
            }
            if (!this.nextTokenIs(this.ARGUMENT_SEPARATOR)) {
                message = "Expected argument separator in list";
                throw new ParseException(message, this.next);
            }
            this.next += this.ARGUMENT_SEPARATOR.length();
            this.skipWhitespace();
            if (first) {
                this.extractExpression();
            } else {
                result = this.parseExpression();
            }
        } else {
            this.extractExpression();
            if (!this.nextTokenIs(this.ARGUMENT_SEPARATOR)) {
                String message = "Expected argument separator in list";
                throw new ParseException(message, this.next);
            }
            this.next += this.ARGUMENT_SEPARATOR.length();
            this.skipWhitespace();
            this.extractExpression();
            if (!this.nextTokenIs(this.ARGUMENT_SEPARATOR)) {
                String message = "Expected argument separator in list";
                throw new ParseException(message, this.next);
            }
            this.next += this.ARGUMENT_SEPARATOR.length();
            this.skipWhitespace();
            this.extractExpression();
        }
        if (!this.nextTokenIs(this.ARGUMENT_LIST_END)) {
            String message = "Expected end of argument list";
            throw new ParseException(message, this.next);
        }
        this.next += this.ARGUMENT_LIST_END.length();
        this.skipWhitespace();
        return result;
    }

    protected final Object parseEval() throws ParseException {
        Object[] values = this.parseArgumentList();
        int length = values.length;
        if (length == 0) {
            return null;
        }
        return values[length - 1];
    }

    protected final Object parseRandom() throws ParseException {
        String message = null;
        Object[] values = this.parseArgumentList();
        if (values == null) {
            message = "Null arguments to random";
            throw new ParseException(message, 0);
        }
        int length = values.length;
        if (length > 2) {
            message = "random requires 0, 1, or 2 arguments";
            throw new ParseException(message, 0);
        }
        int i = 0;
        while (i < length) {
            if (!(values[i] instanceof XNumber)) {
                message = "random expects numeric argument in position " + i;
                throw new ParseException(message, 0);
            }
            ++i;
        }
        XDouble x = null;
        double vx = 0.0;
        XDouble y = null;
        double vy = 0.0;
        double r = Math.random();
        switch (length) {
            case 0: {
                return new XDouble(r);
            }
            case 1: {
                x = ParserUtilities.toXDouble((XNumber)values[0]);
                vx = x.getValue();
                return new XDouble(r * vx);
            }
            case 2: {
                x = ParserUtilities.toXDouble((XNumber)values[0]);
                vx = x.getValue();
                y = ParserUtilities.toXDouble((XNumber)values[1]);
                vy = y.getValue();
                return new XDouble(vx + r * (vy - vx));
            }
        }
        return null;
    }

    protected final boolean evaluate() {
        return this.suspend <= 0;
    }

    protected final Object[] parseArgumentList() throws ParseException {
        Vector<Object> values = new Vector<Object>();
        if (!this.nextTokenIs(this.ARGUMENT_LIST_START)) {
            String message = "Expected start of argument list";
            throw new ParseException(message, this.next);
        }
        this.next += this.ARGUMENT_LIST_START.length();
        this.skipWhitespace();
        boolean expecting = !this.nextTokenIs(this.ARGUMENT_LIST_END);
        while (expecting) {
            values.add(this.parseExpression());
            this.skipWhitespace();
            if (this.nextTokenIs(this.ARGUMENT_SEPARATOR)) {
                this.next += this.ARGUMENT_SEPARATOR.length();
            } else {
                expecting = false;
            }
            this.skipWhitespace();
        }
        if (!this.nextTokenIs(this.ARGUMENT_LIST_END)) {
            String message = "Expected end of argument list";
            throw new ParseException(message, this.next);
        }
        this.next += this.ARGUMENT_LIST_END.length();
        this.skipWhitespace();
        return values.toArray();
    }

    protected final Object[] parseIdentifierExpressionList() throws ParseException {
        if (!this.nextTokenIs(this.ARGUMENT_LIST_START)) {
            String message = "Expected start of argument list";
            throw new ParseException(message, this.next);
        }
        this.next += this.ARGUMENT_LIST_START.length();
        this.skipWhitespace();
        String identifier = this.nextIdentifier();
        if (identifier.equals("")) {
            String message = "Expected identifier in list";
            throw new ParseException(message, this.next);
        }
        if (!this.nextTokenIs(this.ARGUMENT_SEPARATOR)) {
            String message = "Expected argument separator in list";
            throw new ParseException(message, this.next);
        }
        this.next += this.ARGUMENT_SEPARATOR.length();
        this.skipWhitespace();
        Object expression = this.parseExpression();
        if (!this.nextTokenIs(this.ARGUMENT_LIST_END)) {
            String message = "Expected end of argument list";
            throw new ParseException(message, this.next);
        }
        this.next += this.ARGUMENT_LIST_END.length();
        this.skipWhitespace();
        return new Object[]{identifier, expression};
    }

    protected final void initializeStructures() {
        Hashtable<String, Operation> hashtable = new Hashtable<String, Operation>();
        this.precedence.add(hashtable);
        this.operations.put("", IDENTITY);
        hashtable.put("", IDENTITY);
    }

    protected final void addOperation(Operation op, int pos) {
        if (op == null) {
            return;
        }
        if (pos < 0 || pos >= this.precedence.size()) {
            return;
        }
        String symbol = op.symbol();
        if (symbol.equals("") || symbol.equals("\u0000")) {
            return;
        }
        Operation oldop = (Operation)this.operations.get(symbol);
        if (oldop != null) {
            int i = 0;
            while (i < this.precedence.size()) {
                Hashtable hashtable = (Hashtable)this.precedence.get(i);
                if (hashtable.containsKey(symbol)) {
                    hashtable.remove(symbol);
                }
                ++i;
            }
        }
        this.operations.put(symbol, op);
        Hashtable hashtable = (Hashtable)this.precedence.get(pos);
        hashtable.put(symbol, op);
        int n = symbol.length() - 1;
        int i = 1;
        while (i <= n) {
            String prefix = symbol.substring(0, i);
            if (!this.prefixes.containsKey(prefix)) {
                this.prefixes.put(prefix, prefix);
            }
            ++i;
        }
    }

    protected final int precedenceOf(Operation op) {
        if (op == null) {
            return -1;
        }
        int i = 0;
        while (i < this.precedence.size()) {
            Hashtable hashtable = (Hashtable)this.precedence.get(i);
            if (hashtable.containsKey(op.symbol())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected final Operation isOperationOrPrefix(String symbol) {
        if (this.operations.containsKey(symbol)) {
            return (Operation)this.operations.get(symbol);
        }
        if (this.prefixes.containsKey(symbol)) {
            return OPERATION_PREFIX;
        }
        return null;
    }

    protected final Operation nextOperation() {
        this.skipWhitespace();
        int end = this.next;
        Operation temp = null;
        Operation last = null;
        while (end < this.data.length()) {
            if ((temp = this.isOperationOrPrefix(this.data.substring(this.next, ++end))) == null) break;
            if (temp == OPERATION_PREFIX) continue;
            last = temp;
        }
        if (last != null) {
            this.next += last.symbol().length();
        }
        this.skipWhitespace();
        return last;
    }

    protected final boolean nextTokenIs(String pattern) {
        this.skipWhitespace();
        return this.nextTokenIs(pattern, this.next);
    }

    protected final boolean nextTokenIs(String pattern, int start) {
        if (pattern == null || pattern.length() == 0 || start + pattern.length() > this.data.length()) {
            return false;
        }
        int i = 0;
        while (i < pattern.length()) {
            if (pattern.charAt(i) != this.data.charAt(start + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected final String nextIdentifier() {
        if (!this.startsIdentifier()) {
            return "";
        }
        int start = this.next++;
        while (this.withinIdentifier()) {
            ++this.next;
        }
        return this.data.substring(start, this.next);
    }

    protected final boolean startsIdentifier() {
        this.skipWhitespace();
        if (this.next >= this.data.length()) {
            return false;
        }
        char c = this.data.charAt(this.next);
        return Character.isLetter(c) || c == this.UNDERSCORE;
    }

    protected final boolean withinIdentifier() {
        if (this.next >= this.data.length()) {
            return false;
        }
        char c = this.data.charAt(this.next);
        return Character.isLetter(c) || Character.isDigit(c) || c == this.UNDERSCORE;
    }

    protected final Object parseNumber() throws ParseException {
        this.skipWhitespace();
        int end = this.next;
        int type = 100;
        if (this.isSignAt(this.next)) {
            if (this.data.charAt(this.next) == '+') {
                ++this.next;
            }
            ++end;
        }
        if (this.nextTokenIs(this.RADIX_POINT, end = this.afterDigits(end))) {
            type = 101;
            end += this.RADIX_POINT.length();
            end = this.afterDigits(end);
        }
        if (this.isExponentAt(end)) {
            type = 101;
            ++end;
            end = this.afterSign(end);
            end = this.afterDigits(end);
        }
        String number = this.data.substring(this.next, end);
        this.next = end;
        if (type == 100) {
            try {
                BigInteger i = new BigInteger(number);
                return new XBigInteger(i);
            }
            catch (NumberFormatException ex) {
                return new ParseException("Expected valid numeric value: " + number + " " + ex.getMessage(), this.next);
            }
        }
        try {
            Double d = new Double(number);
            return new XDouble(d);
        }
        catch (NumberFormatException ex) {
            return new ParseException("Expected valid numeric value: " + number + " " + ex.getMessage(), this.next);
        }
    }

    protected final boolean startsNumber() {
        this.skipWhitespace();
        if (this.next >= this.data.length()) {
            return false;
        }
        return Character.isDigit(this.data.charAt(this.next)) || this.nextTokenIs(this.RADIX_POINT);
    }

    protected final boolean isSignAt(int start) {
        if (start >= this.data.length()) {
            return false;
        }
        char c = this.data.charAt(start);
        return c == '+' || c == '-';
    }

    protected final boolean isExponentAt(int start) {
        if (start >= this.data.length()) {
            return false;
        }
        char c = this.data.charAt(start);
        return c == 'E' || c == 'e';
    }

    protected final int afterSign(int start) {
        return this.isSignAt(start) ? start + 1 : start;
    }

    protected final int afterDigits(int start) {
        while (start < this.data.length()) {
            char c = this.data.charAt(start);
            if (!Character.isDigit(c)) break;
            ++start;
        }
        return start;
    }

    protected final void skipWhitespace() {
        while (this.next < this.data.length() && Character.isWhitespace(this.data.charAt(this.next))) {
            ++this.next;
        }
    }

    protected final void setLeftParenthesisToken(String token) {
        if (token != null && token.length() > 0) {
            this.ARGUMENT_LIST_START = token;
        }
    }

    protected final void setRightParenthesisToken(String token) {
        if (token != null && token.length() > 0) {
            this.ARGUMENT_LIST_END = token;
        }
    }

    protected final void setRadixPointToken(String token) {
        if (token != null && token.length() > 0) {
            this.RADIX_POINT = token;
        }
    }

    protected final void setArgumentSeparatorToken(String token) {
        if (token != null && token.length() > 0) {
            this.ARGUMENT_SEPARATOR = token;
        }
    }
}

