/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.parser;

import edu.neu.ccs.Function;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.BaseParser;
import java.text.ParseException;

public abstract class AbstractFunction {
    private String name = "";
    private int arguments = 0;

    public AbstractFunction(String name, int arguments) {
        String message = null;
        if (name == null) {
            message = "A function name must not be null";
        } else if ((name = name.trim()).length() == 0) {
            message = "A function name must not be empty";
        } else if (!BaseParser.isPossibleIdentifier(name)) {
            message = String.valueOf(name) + " is not a valid identifier\n" + "and therefore may not be a function name";
        } else if (arguments < 0) {
            message = "function " + name + " cannot be defined with " + arguments + " arguments";
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        this.name = name;
        this.arguments = arguments;
    }

    public abstract Object functionCall(Object[] var1) throws ParseException;

    public final String name() {
        return this.name;
    }

    public final int arguments() {
        return this.arguments;
    }

    public final void checkValues(Object[] values) throws ParseException {
        if (values == null) {
            throw new ParseException("Null arguments to function " + this.name, 0);
        }
        if (values.length != this.arguments) {
            throw new ParseException("Function " + this.name + " expects " + this.arguments + " argument(s) but was given " + values.length + " argument(s)", 0);
        }
    }

    public final void checkValuesAsXObject(Object[] values) throws ParseException {
        this.checkValues(values);
        int i = 0;
        while (i < this.arguments) {
            if (!(values[i] instanceof XObject)) {
                throw new ParseException("Function " + this.name + " expects XObject argument in position " + i, 0);
            }
            ++i;
        }
    }

    public final void checkValuesAsNumeric(Object[] values) throws ParseException {
        this.checkValues(values);
        int i = 0;
        while (i < this.arguments) {
            if (!(values[i] instanceof XNumber)) {
                throw new ParseException("Function " + this.name + " expects numeric argument in position " + i, 0);
            }
            ++i;
        }
    }

    public static AbstractFunction makeNoArg(String name, final Function.NoArg f) {
        return new AbstractFunction(name, 0){
            {
                if (noArg == null) {
                    String message = "makeNoArg must be passed a non-null Function.NoArg";
                    throw new IllegalArgumentException(message);
                }
            }

            public Object functionCall(Object[] values) throws ParseException {
                this.checkValuesAsNumeric(values);
                return new XDouble(f.evaluate());
            }
        };
    }

    public static AbstractFunction makeOneArg(String name, final Function.OneArg f) {
        return new AbstractFunction(name, 1){
            {
                if (oneArg == null) {
                    String message = "makeOneArg must be passed a non-null Function.OneArg";
                    throw new IllegalArgumentException(message);
                }
            }

            public Object functionCall(Object[] values) throws ParseException {
                this.checkValuesAsNumeric(values);
                double arg0 = ((XNumber)values[0]).doubleValue();
                return new XDouble(f.evaluate(arg0));
            }
        };
    }

    public static AbstractFunction makeTwoArg(String name, final Function.TwoArg f) {
        return new AbstractFunction(name, 2){
            {
                if (twoArg == null) {
                    String message = "makeTwoArg must be passed a non-null Function.TwoArg";
                    throw new IllegalArgumentException(message);
                }
            }

            public Object functionCall(Object[] values) throws ParseException {
                this.checkValuesAsNumeric(values);
                double arg0 = ((XNumber)values[0]).doubleValue();
                double arg1 = ((XNumber)values[1]).doubleValue();
                return new XDouble(f.evaluate(arg0, arg1));
            }
        };
    }

    public static AbstractFunction makeThreeArg(String name, final Function.ThreeArg f) {
        return new AbstractFunction(name, 3){
            {
                if (threeArg == null) {
                    String message = "makeThreeArg must be passed a non-null Function.ThreeArg";
                    throw new IllegalArgumentException(message);
                }
            }

            public Object functionCall(Object[] values) throws ParseException {
                this.checkValuesAsNumeric(values);
                double arg0 = ((XNumber)values[0]).doubleValue();
                double arg1 = ((XNumber)values[1]).doubleValue();
                double arg2 = ((XNumber)values[2]).doubleValue();
                return new XDouble(f.evaluate(arg0, arg1, arg2));
            }
        };
    }

    public static AbstractFunction makeFourArg(String name, final Function.FourArg f) {
        return new AbstractFunction(name, 4){
            {
                if (fourArg == null) {
                    String message = "makeFourArg must be passed a non-null Function.FourArg";
                    throw new IllegalArgumentException(message);
                }
            }

            public Object functionCall(Object[] values) throws ParseException {
                this.checkValuesAsNumeric(values);
                double arg0 = ((XNumber)values[0]).doubleValue();
                double arg1 = ((XNumber)values[1]).doubleValue();
                double arg2 = ((XNumber)values[2]).doubleValue();
                double arg3 = ((XNumber)values[3]).doubleValue();
                return new XDouble(f.evaluate(arg0, arg1, arg2, arg3));
            }
        };
    }
}

