/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.jpf;

import edu.neu.ccs.Colors;
import edu.neu.ccs.XBigDecimal;
import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XByte;
import edu.neu.ccs.XChar;
import edu.neu.ccs.XColor;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XFloat;
import edu.neu.ccs.XInt;
import edu.neu.ccs.XLong;
import edu.neu.ccs.XShort;
import edu.neu.ccs.XString;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.ColorView;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Fonts;
import edu.neu.ccs.gui.Halo;
import edu.neu.ccs.gui.JPTScrollPane;
import edu.neu.ccs.gui.LookAndFeelTools;
import edu.neu.ccs.gui.PaintSwatch;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.StringViewer;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.TypedView;
import edu.neu.ccs.jpf.ActivityIcon;
import edu.neu.ccs.jpf.JPFHelper;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;

public class MethodGUI
extends DisplayPanel
implements JPTConstants {
    public static final int TFVWidth = 250;
    public static final int SVWidth = 400;
    public static final int SVHeight = 100;
    public static final int gapSize = 10;
    public static final int swatchSize = 48;
    public static final int margin = 200;
    public static final int V_AS_NEEDED = 20;
    public static final int H_AS_NEEDED = 30;
    public static final String FONTNAME = Fonts.getMonospacedFontFamilyName();
    private static int staticFontSize = 14 + (int)LookAndFeelTools.getNetFontSizeAdjustment();
    private static Font staticFont = new Font(FONTNAME, 1, staticFontSize);
    protected Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    protected int screenWidth;
    protected int screenHeight;
    protected int scrollWidth;
    protected int scrollHeight;
    protected Object initializer;
    protected Method method;
    protected String methodName;
    protected Class returnType;
    protected String returnTypeName;
    protected Class[] parameterTypes;
    protected String[] parameterTypeNames;
    protected int orientation;
    protected TypedView[] parameterViews;
    protected TypedView returnView;
    protected PaintSwatch paintView;
    protected Action evaluate;
    protected JButton evaluateButton;
    protected int maxCols;
    protected TablePanel mainPanel;
    protected JPTScrollPane scrollpane;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;

    public MethodGUI(Method method) {
        this(method, null, 0);
    }

    public MethodGUI(Method method, Object initializer) {
        this(method, initializer, 0);
    }

    public MethodGUI(Method method, Object initializer, int orientation) {
        this.screenWidth = this.screenSize.width;
        this.screenHeight = this.screenSize.height;
        this.scrollWidth = this.screenWidth - 200;
        this.scrollHeight = this.screenHeight - 200;
        this.initializer = null;
        this.method = null;
        this.methodName = null;
        this.returnType = null;
        this.returnTypeName = null;
        this.parameterTypes = null;
        this.parameterTypeNames = null;
        this.orientation = 0;
        this.parameterViews = null;
        this.returnView = null;
        this.paintView = null;
        this.evaluate = null;
        this.evaluateButton = null;
        this.maxCols = 0;
        this.mainPanel = null;
        this.scrollpane = null;
        this.mainPanel = new TablePanel(0, 0, 10, 10, 0);
        String message = null;
        if (method == null) {
            message = "Null method in MethodGUI constructor";
        } else if (!JPFHelper.isJPFMethod(method)) {
            message = "The method passed to MethodGUI constructor is not a JPF method";
        } else if (!JPFHelper.isStatic(method) && initializer == null) {
            message = "Non-static method with no initializer in MethodGUI constructor";
        }
        if (message != null) {
            this.add(new StringViewer(message, 600, 100));
            return;
        }
        this.method = method;
        this.initializer = initializer;
        this.orientation = orientation;
        this.extractInformation();
        this.createEvaluate();
        this.buildTable();
        this.buildScrollPane();
    }

    public JButton getEvaluateButton() {
        return this.evaluateButton;
    }

    protected void extractInformation() {
        this.methodName = this.method.getName();
        this.returnType = this.method.getReturnType();
        this.returnTypeName = JPFHelper.className(this.returnType);
        this.parameterTypes = this.method.getParameterTypes();
        this.parameterTypeNames = new String[this.parameterTypes.length];
        int length = this.parameterTypes.length;
        int i = 0;
        while (i < length) {
            this.parameterTypeNames[i] = JPFHelper.className(this.parameterTypes[i]);
            ++i;
        }
    }

    protected void createEvaluate() {
        this.evaluate = new SimpleAction(this.methodName){

            public void perform() {
                MethodGUI.this.evaluate();
            }
        };
    }

    protected void evaluate() {
        if (this.returnType.equals(Void.TYPE)) {
            this.evaluateVoid();
        } else {
            this.evaluateWithReturn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateVoid() {
        block7: {
            try {
                Object[] parameters = this.extractParameterValues();
                if (JPFHelper.isStatic(this.method)) {
                    this.method.invoke(null, parameters);
                    break block7;
                }
                Object object = this.initializer;
                synchronized (object) {
                    this.method.invoke(this.initializer, parameters);
                }
            }
            catch (CancelledException parameters) {
            }
            catch (Throwable exception) {
                String trace = JPFHelper.getAdaptedExceptionTrace(exception, this.method);
                StringViewer.showStringInFrame(trace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateWithReturn() {
        Object value = null;
        try {
            Object[] parameters = this.extractParameterValues();
            if (JPFHelper.isStatic(this.method)) {
                value = this.method.invoke(null, parameters);
            } else {
                Object object = this.initializer;
                synchronized (object) {
                    value = this.method.invoke(this.initializer, parameters);
                }
            }
            this.showReturnValue(value);
        }
        catch (CancelledException ce) {
            if (this.returnView != null) {
                this.returnView.setViewState("Cancelled");
            } else {
                this.paintView.setPaint(Colors.Transparent);
            }
        }
        catch (Throwable exception) {
            if (this.returnView != null) {
                this.returnView.setViewState("Error");
            } else {
                this.paintView.setPaint(Colors.Transparent);
            }
            String trace = JPFHelper.getAdaptedExceptionTrace(exception, this.method);
            StringViewer.showStringInFrame(trace);
        }
    }

    protected Object extractParameterValue(TypedView view, Class c) throws CancelledException {
        if (view == null) {
            return null;
        }
        Object object = view.requestObject();
        if (object instanceof XByte) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("edu.neu.ccs.XByte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!c.equals(clazz)) {
                object = new Byte(((XByte)object).getValue());
            }
        } else if (object instanceof XShort) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("edu.neu.ccs.XShort");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!c.equals(clazz)) {
                object = new Short(((XShort)object).getValue());
            }
        } else if (object instanceof XInt) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("edu.neu.ccs.XInt");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!c.equals(clazz)) {
                object = new Integer(((XInt)object).getValue());
            }
        } else if (object instanceof XLong) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("edu.neu.ccs.XLong");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!c.equals(clazz)) {
                object = new Long(((XLong)object).getValue());
            }
        } else if (object instanceof XFloat) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("edu.neu.ccs.XFloat");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!c.equals(clazz)) {
                object = new Float(((XFloat)object).getValue());
            }
        } else if (object instanceof XDouble) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("edu.neu.ccs.XDouble");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!c.equals(clazz)) {
                object = new Double(((XDouble)object).getValue());
            }
        } else if (object instanceof XChar) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("edu.neu.ccs.XChar");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!c.equals(clazz)) {
                object = new Character(((XChar)object).getValue());
            }
        } else if (object instanceof XBoolean) {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("edu.neu.ccs.XBoolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!c.equals(clazz)) {
                object = new Boolean(((XBoolean)object).getValue());
            }
        } else if (object instanceof XString) {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("edu.neu.ccs.XString");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!c.equals(clazz)) {
                object = new String(((XString)object).getValue());
            }
        } else if (object instanceof XColor) {
            Class<?> clazz = class$10;
            if (clazz == null) {
                try {
                    clazz = class$10 = Class.forName("java.awt.Color");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz)) {
                object = ((XColor)object).getValue();
            }
        } else if (object instanceof XBigInteger) {
            Class<?> clazz = class$11;
            if (clazz == null) {
                try {
                    clazz = class$11 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz)) {
                object = ((XBigInteger)object).getValue();
            }
        } else if (object instanceof XBigDecimal) {
            Class<?> clazz = class$12;
            if (clazz == null) {
                try {
                    clazz = class$12 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz)) {
                object = ((XBigDecimal)object).getValue();
            }
        }
        return object;
    }

    protected Object[] extractParameterValues() throws CancelledException {
        int length = this.parameterViews.length;
        Object[] values = new Object[length];
        int i = 0;
        while (i < length) {
            values[i] = this.extractParameterValue(this.parameterViews[i], this.parameterTypes[i]);
            ++i;
        }
        return values;
    }

    protected void showReturnValue(Object value) {
        if (value == null) {
            if (this.returnView != null) {
                this.returnView.setViewState("null");
            } else {
                this.paintView.setPaint(Colors.Transparent);
            }
            return;
        }
        if (value instanceof XColor) {
            value = ((XColor)value).getValue();
        }
        if (value instanceof Paint) {
            this.paintView.setPaint((Paint)value);
            return;
        }
        this.returnView.setViewState(value.toString());
    }

    protected void buildTable() {
        this.maxCols = this.screenWidth / 250;
        if (this.orientation != 1) {
            this.orientation = 0;
        }
        int rows = 3;
        int cols = this.parameterTypes.length + 1 + (this.returnType.equals(Void.TYPE) ? 0 : 1);
        if (cols > this.maxCols) {
            this.orientation = 1;
        }
        int max = Math.max(rows, cols);
        this.mainPanel.setRows(max);
        this.mainPanel.setColumns(max);
        this.buildParameterViews();
        this.buildReturnView();
        if (this.orientation == 1) {
            this.buildVerticalGUI();
        } else {
            this.buildHorizontalGUI();
        }
        this.mainPanel.emptyBorder(10);
    }

    protected void buildVerticalGUI() {
        int length = this.parameterTypes.length;
        int row = 0;
        while (row < length) {
            this.mainPanel.addObject((Object)this.parameterTypeNames[row], row, 0);
            this.mainPanel.addObject((Object)this.createInputIcon(), row, 1);
            this.mainPanel.addObject((Object)new Halo(this.parameterViews[row]), row, 2);
            ++row;
        }
        row = length;
        this.mainPanel.addObject((Object)"Method", row, 0);
        this.mainPanel.addObject((Object)this.createActionIcon(), row, 1);
        this.evaluateButton = (JButton)this.mainPanel.addObject((Object)this.evaluate, row, 2);
        if (!this.returnType.equals(Void.TYPE)) {
            row = length + 1;
            this.mainPanel.addObject((Object)this.returnTypeName, row, 0);
            this.mainPanel.addObject((Object)this.createOutputIcon(), row, 1);
            this.mainPanel.addObject(this.getReturnView(), row, 2);
        }
        this.mainPanel.setColumnAlignment(0, 7);
        this.mainPanel.setColumnAlignment(2, 7);
    }

    protected void buildHorizontalGUI() {
        int length = this.parameterTypes.length;
        int next = 0;
        if (!this.returnType.equals(Void.TYPE)) {
            this.mainPanel.addObject((Object)this.returnTypeName, 0, 0);
            this.mainPanel.addObject((Object)this.createOutputIcon(), 1, 0);
            this.mainPanel.addObject(this.getReturnView(), 2, 0);
            next = 1;
        }
        int col = next++;
        this.mainPanel.addObject((Object)"Method", 0, col);
        this.mainPanel.addObject((Object)this.createActionIcon(), 1, col);
        this.evaluateButton = (JButton)this.mainPanel.addObject((Object)this.evaluate, 2, col);
        col = 0;
        while (col < length) {
            this.mainPanel.addObject((Object)this.parameterTypeNames[col], 0, col + next);
            this.mainPanel.addObject((Object)this.createInputIcon(), 1, col + next);
            this.mainPanel.addObject((Object)new Halo(this.parameterViews[col]), 2, col + next);
            ++col;
        }
    }

    protected TypedView createView(Class c) {
        block50: {
            block49: {
                if (c == null) {
                    return null;
                }
                Class<?> clazz = class$10;
                if (clazz == null) {
                    try {
                        clazz = class$10 = Class.forName("java.awt.Color");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz)) break block49;
                Class<?> clazz2 = class$13;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$13 = Class.forName("edu.neu.ccs.XColor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!c.equals(clazz2)) break block50;
            }
            return new ColorView();
        }
        if (JPFHelper.isSimilarToPrimitive(c)) {
            TextFieldView tfv = new TextFieldView("", this.getErrorPrompt(c), "InputError", 250);
            tfv.setFont(staticFont);
            tfv.setDataType(JPFHelper.getPrimitiveStringable(c));
            return tfv;
        }
        this.orientation = 1;
        StringViewer sv = new StringViewer(400, 100, staticFont);
        Class<?> clazz = class$14;
        if (clazz == null) {
            try {
                clazz = class$14 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c.equals(clazz)) {
            Class<?> clazz3 = class$9;
            if (clazz3 == null) {
                try {
                    clazz3 = class$9 = Class.forName("edu.neu.ccs.XString");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            sv.setDataType(clazz3);
        } else {
            Class<?> clazz4 = class$11;
            if (clazz4 == null) {
                try {
                    clazz4 = class$11 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz4)) {
                Class<?> clazz5 = class$15;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$15 = Class.forName("edu.neu.ccs.XBigInteger");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                sv.setDataType(clazz5);
            } else {
                Class<?> clazz6 = class$12;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$12 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz6)) {
                    Class<?> clazz7 = class$16;
                    if (clazz7 == null) {
                        try {
                            clazz7 = class$16 = Class.forName("edu.neu.ccs.XBigDecimal");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    sv.setDataType(clazz7);
                } else {
                    Class<?> clazz8 = class$17;
                    if (clazz8 == null) {
                        try {
                            clazz8 = class$17 = Class.forName("edu.neu.ccs.Stringable");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz8.isAssignableFrom(c)) {
                        sv.setDataType(c);
                    }
                }
            }
        }
        return sv;
    }

    protected void buildParameterViews() {
        int length = this.parameterTypes.length;
        this.parameterViews = new TypedView[length];
        int i = 0;
        while (i < length) {
            this.parameterViews[i] = this.createView(this.parameterTypes[i]);
            ++i;
        }
    }

    protected void buildReturnView() {
        Class<?> clazz = class$18;
        if (clazz == null) {
            try {
                clazz = class$18 = Class.forName("java.awt.Paint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(this.returnType)) {
            this.paintView = new PaintSwatch(Colors.Transparent, 48, 48);
            this.returnView = null;
        } else {
            this.returnView = this.createView(this.returnType);
            this.paintView = null;
        }
    }

    protected Object getReturnView() {
        if (this.returnView != null) {
            return this.returnView;
        }
        return this.paintView;
    }

    protected String getErrorPrompt(Class c) {
        return "Error in data of type " + JPFHelper.className(c);
    }

    protected JComponent createInputIcon() {
        return new ActivityIcon.InputIcon();
    }

    protected JComponent createActionIcon() {
        return new ActivityIcon.ActionIcon();
    }

    protected JComponent createOutputIcon() {
        return new ActivityIcon.OutputIcon();
    }

    protected void buildScrollPane() {
        this.scrollpane = new JPTScrollPane(this.mainPanel, 20, 30);
        this.scrollpane.boundViewportPreferredSize(this.scrollWidth, this.scrollHeight);
        this.add(this.scrollpane);
    }

    public static Font getDefaultFont() {
        return staticFont;
    }

    public static void setDefaultFont(Font newfont) {
        if (newfont != null) {
            staticFont = newfont;
        }
    }
}

