/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.jpf;

import edu.neu.ccs.gui.ActionsPanel;
import edu.neu.ccs.gui.BufferedPanel;
import edu.neu.ccs.gui.Display;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.HTable;
import edu.neu.ccs.gui.ImagePaintable;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.JPTScrollPane;
import edu.neu.ccs.gui.PaintableComponent;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.SimpleThreadedAction;
import edu.neu.ccs.gui.StringViewer;
import edu.neu.ccs.gui.TableLayout;
import edu.neu.ccs.gui.VTable;
import edu.neu.ccs.jpf.JPFHelper;
import edu.neu.ccs.jpf.MethodFilter;
import edu.neu.ccs.jpf.MethodGUI;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.StackTrace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JRootPane;

public class JPFPane
extends DisplayPanel
implements JPTConstants {
    public static final int BUFFER_WIDTH = 400;
    public static final int BUFFER_HEIGHT = 400;
    public static final int SCROLL_WIDTH = 400;
    public static final int SCROLL_HEIGHT = 400;
    private static final Color commonButtonColor = new Color(255, 255, 100);
    private static final Color exitButtonColor = Color.red;
    private static final Color methodButtonColor = new Color(127, 255, 127);
    private static final Color methodButtonColorDisabled = new Color(231, 231, 231);
    protected Object initializer = null;
    protected Class initializerClass = null;
    protected Class baseClass = null;
    protected MethodFilter filter = null;
    protected BufferedPanel window = new BufferedPanel(400, 400);
    protected boolean showGraphics = true;
    protected ActionsPanel methodButtonsPanel = null;
    protected ActionsPanel commonButtonsPanel = null;
    protected ActionsPanel exitButtonPanel = null;
    protected VTable buttonsPanel = null;
    protected JButton[] methodButtons = null;
    protected JButton exitButton = null;
    protected DisplayPanel LHS = null;
    protected DisplayPanel RHS = null;
    protected HTable mainPanel = null;
    protected Action clearGraphicsAction = new SimpleAction("Clear Graphics"){

        public void perform() {
            JPFPane.this.clearGraphics();
        }
    };
    protected Action makeShapshotAction = new SimpleAction("Graphics Snapshot"){

        public void perform() {
            JPFPane.this.makeShapshot();
        }
    };
    protected Action exitAction = new SimpleAction("Exit"){

        public void perform() {
            System.exit(0);
        }
    };
    static /* synthetic */ Class class$0;

    public JPFPane(Object initializer, Class baseClass) {
        this(initializer, baseClass, null, true);
    }

    public JPFPane(Object initializer, Class baseClass, boolean showGraphics) {
        this(initializer, baseClass, null, showGraphics);
    }

    public JPFPane(Object initializer, Class baseClass, MethodFilter filter) {
        this(initializer, baseClass, filter, true);
    }

    public JPFPane(Object initializer, Class baseClass, MethodFilter filter, boolean showGraphics) {
        if (initializer == null) {
            this.add(new StringViewer("Null initializer passed to JPFPane"));
            return;
        }
        this.initializer = initializer;
        this.initializerClass = initializer.getClass();
        if (baseClass == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            baseClass = clazz;
        }
        this.baseClass = baseClass;
        this.showGraphics = showGraphics;
        this.filter = filter;
        this.buildGUI();
    }

    public final Object getInitializer() {
        return this.initializer;
    }

    public final Class getInitializerClass() {
        return this.initializerClass;
    }

    public final Class getBaseClass() {
        return this.baseClass;
    }

    public final MethodFilter getMethodFilter() {
        return this.filter;
    }

    public final BufferedPanel getGraphicsWindow() {
        return this.window;
    }

    public final void clearGraphics() {
        this.window.clearPanelAndSequenceData();
        this.window.repaint();
    }

    public final boolean isGraphicsVisible() {
        return this.showGraphics;
    }

    public final void setGraphicsVisible(boolean visible) {
        if (this.showGraphics == visible) {
            return;
        }
        this.toggleGraphics();
    }

    public final void toggleGraphics() {
        boolean bl = this.showGraphics = !this.showGraphics;
        if (this.showGraphics) {
            this.mainPanel.add(this.RHS);
        } else {
            this.mainPanel.remove(this.RHS);
        }
    }

    public final void makeShapshot() {
        BufferedImage snapshot = this.window.makeSnapshot();
        ImagePaintable paintable = new ImagePaintable(snapshot);
        PaintableComponent component = new PaintableComponent(paintable);
        component.frame(7);
    }

    public final void addCommonButton(Action action, String tooltip) {
        JButton button = this.addOneButton(this.commonButtonsPanel, action, tooltip);
        if (button != null) {
            button.setBackground(commonButtonColor);
            this.commonButtonsPanel.uniformizeWidth();
        }
    }

    public final void setExitAction(Action action) {
        if (action != null) {
            this.exitButton.setAction(action);
        }
    }

    public final void exitFramework() {
        this.exitButton.doClick();
    }

    protected void buildGUI() {
        try {
            this.buildButtons();
            this.LHS = new Display((Displayable)this.buttonsPanel, null, "Tasks");
            this.RHS = new Display((Displayable)this.window, null, "Graphics");
            Object[] stuff = null;
            stuff = this.showGraphics ? new Object[]{this.LHS, this.RHS} : new Object[]{this.LHS};
            this.mainPanel = new HTable(stuff, 5, 5, 1);
            this.add(this.mainPanel);
        }
        catch (Throwable throwable) {
            this.add(new StringViewer(StackTrace.getTrace(throwable)));
        }
    }

    protected void buildButtons() {
        this.commonButtonsPanel = new ActionsPanel(new TableLayout(1, 1, 0, 0, 0, 1));
        if (this.showGraphics) {
            this.addCommonButton(this.clearGraphicsAction, "Clear the graphics window");
            this.addCommonButton(this.makeShapshotAction, "Snapshot the graphics window");
        }
        this.exitButtonPanel = new ActionsPanel(new TableLayout(1, 1, 0, 0, 0, 1));
        this.exitButton = this.addOneButton(this.exitButtonPanel, this.exitAction, "Exit the framework");
        this.exitButton.setBackground(exitButtonColor);
        this.methodButtonsPanel = new ActionsPanel(new TableLayout(1, 1, 0, 0, 0, 1));
        Method[] methods = this.getMethodList();
        int length = methods.length;
        int i = 0;
        while (i < length) {
            if (methods[i] != null) {
                JButton button = this.addOneButton(this.methodButtonsPanel, this.makeActionFromMethod(methods[i]), JPFHelper.getMethodToolTip(methods[i]));
                button.setBackground(methodButtonColor);
            }
            ++i;
        }
        this.methodButtonsPanel.uniformizeWidth();
        this.methodButtons = this.methodButtonsPanel.getActionButtons();
        JPTScrollPane scrollpane = new JPTScrollPane(this.methodButtonsPanel);
        int methodWidth = 400;
        int methodHeight = 400;
        JButton testButton = new JButton("MyTest");
        Dimension buttonSize = testButton.getPreferredSize();
        methodHeight -= methodHeight % buttonSize.height;
        scrollpane.boundViewportPreferredSize(methodWidth, methodHeight);
        Object[] buttonsStuff = new Object[]{scrollpane, this.commonButtonsPanel, this.exitButtonPanel};
        this.buttonsPanel = new VTable(buttonsStuff, 5, 5, 0);
    }

    protected JButton addOneButton(ActionsPanel panel, Action action, String tooltip) {
        if (panel == null) {
            return null;
        }
        if (action == null) {
            return null;
        }
        JButton button = panel.addAction(action);
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
        return button;
    }

    protected void setMethodButtonsEnabled(boolean enable) {
        Color color = enable ? methodButtonColor : methodButtonColorDisabled;
        int N = this.methodButtons.length;
        int i = 0;
        while (i < N) {
            this.methodButtons[i].setEnabled(enable);
            this.methodButtons[i].setBackground(color);
            ++i;
        }
    }

    protected Method[] getMethodList() {
        Method[] methods = JPFHelper.getPublicMethods(this.initializerClass, this.baseClass);
        JPFHelper.acceptJPFMethods(methods);
        JPFHelper.removeDuplicateVirtualMethods(methods);
        if (this.filter != null) {
            this.filter.prune(this.initializer, methods);
        }
        return methods;
    }

    protected Action makeActionFromMethod(final Method method) {
        if (method == null) {
            return null;
        }
        String methodName = JPFHelper.isStatic(method) ? String.valueOf(JPFHelper.className(method.getDeclaringClass())) + "." + method.getName() : method.getName();
        return new SimpleThreadedAction(methodName){

            public void perform() {
                JPFPane.this.performAction(method);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Method method) {
        block10: {
            this.setMethodButtonsEnabled(false);
            String methodName = method.getName();
            try {
                try {
                    if (JPFHelper.isGUIMethod(method)) {
                        this.performActionUsingGUI(method);
                        break block10;
                    }
                    if (JPFHelper.isStatic(method)) {
                        method.invoke(null, null);
                        break block10;
                    }
                    Object object = this.initializer;
                    synchronized (object) {
                        method.invoke(this.initializer, null);
                    }
                }
                catch (Exception exception) {
                    String trace = JPFHelper.getAdaptedExceptionTrace(exception, method);
                    StringViewer.showStringInFrame(trace);
                }
            }
            finally {
                this.setMethodButtonsEnabled(true);
            }
        }
    }

    protected void performActionUsingGUI(Method method) {
        String title = String.valueOf(method.getName()) + " Evaluator";
        MethodGUI gui = new MethodGUI(method, this.initializer);
        JPTFrame.frame((Object)gui, title, 1);
        JRootPane pane = gui.getRootPane();
        if (pane != null) {
            pane.setDefaultButton(gui.getEvaluateButton());
        }
    }
}

