/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.jpf;

import edu.neu.ccs.quick.QuickHashtable;
import edu.neu.ccs.quick.QuickVector;
import edu.neu.ccs.util.StackTrace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JPFHelper {
    private static Object[][] primitivePairs;
    private static QuickHashtable primitiveTable;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;
    static /* synthetic */ Class class$27;
    static /* synthetic */ Class class$28;
    static /* synthetic */ Class class$29;
    static /* synthetic */ Class class$30;

    static {
        Object[][] objectArrayArray = new Object[24][];
        Object[] objectArray = new Object[2];
        objectArray[0] = Byte.TYPE;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.neu.ccs.XByte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[1] = clazz;
        objectArrayArray[0] = objectArray;
        Object[] objectArray2 = new Object[2];
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray2[0] = clazz2;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("edu.neu.ccs.XByte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray2[1] = clazz3;
        objectArrayArray[1] = objectArray2;
        Object[] objectArray3 = new Object[2];
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("edu.neu.ccs.XByte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray3[0] = clazz4;
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("edu.neu.ccs.XByte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray3[1] = clazz5;
        objectArrayArray[2] = objectArray3;
        Object[] objectArray4 = new Object[2];
        objectArray4[0] = Short.TYPE;
        Class<?> clazz6 = class$4;
        if (clazz6 == null) {
            try {
                clazz6 = class$4 = Class.forName("edu.neu.ccs.XShort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray4[1] = clazz6;
        objectArrayArray[3] = objectArray4;
        Object[] objectArray5 = new Object[2];
        Class<?> clazz7 = class$5;
        if (clazz7 == null) {
            try {
                clazz7 = class$5 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray5[0] = clazz7;
        Class<?> clazz8 = class$4;
        if (clazz8 == null) {
            try {
                clazz8 = class$4 = Class.forName("edu.neu.ccs.XShort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray5[1] = clazz8;
        objectArrayArray[4] = objectArray5;
        Object[] objectArray6 = new Object[2];
        Class<?> clazz9 = class$4;
        if (clazz9 == null) {
            try {
                clazz9 = class$4 = Class.forName("edu.neu.ccs.XShort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray6[0] = clazz9;
        Class<?> clazz10 = class$4;
        if (clazz10 == null) {
            try {
                clazz10 = class$4 = Class.forName("edu.neu.ccs.XShort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray6[1] = clazz10;
        objectArrayArray[5] = objectArray6;
        Object[] objectArray7 = new Object[2];
        objectArray7[0] = Integer.TYPE;
        Class<?> clazz11 = class$7;
        if (clazz11 == null) {
            try {
                clazz11 = class$7 = Class.forName("edu.neu.ccs.XInt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray7[1] = clazz11;
        objectArrayArray[6] = objectArray7;
        Object[] objectArray8 = new Object[2];
        Class<?> clazz12 = class$8;
        if (clazz12 == null) {
            try {
                clazz12 = class$8 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray8[0] = clazz12;
        Class<?> clazz13 = class$7;
        if (clazz13 == null) {
            try {
                clazz13 = class$7 = Class.forName("edu.neu.ccs.XInt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray8[1] = clazz13;
        objectArrayArray[7] = objectArray8;
        Object[] objectArray9 = new Object[2];
        Class<?> clazz14 = class$7;
        if (clazz14 == null) {
            try {
                clazz14 = class$7 = Class.forName("edu.neu.ccs.XInt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray9[0] = clazz14;
        Class<?> clazz15 = class$7;
        if (clazz15 == null) {
            try {
                clazz15 = class$7 = Class.forName("edu.neu.ccs.XInt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray9[1] = clazz15;
        objectArrayArray[8] = objectArray9;
        Object[] objectArray10 = new Object[2];
        objectArray10[0] = Long.TYPE;
        Class<?> clazz16 = class$10;
        if (clazz16 == null) {
            try {
                clazz16 = class$10 = Class.forName("edu.neu.ccs.XLong");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray10[1] = clazz16;
        objectArrayArray[9] = objectArray10;
        Object[] objectArray11 = new Object[2];
        Class<?> clazz17 = class$11;
        if (clazz17 == null) {
            try {
                clazz17 = class$11 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray11[0] = clazz17;
        Class<?> clazz18 = class$10;
        if (clazz18 == null) {
            try {
                clazz18 = class$10 = Class.forName("edu.neu.ccs.XLong");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray11[1] = clazz18;
        objectArrayArray[10] = objectArray11;
        Object[] objectArray12 = new Object[2];
        Class<?> clazz19 = class$10;
        if (clazz19 == null) {
            try {
                clazz19 = class$10 = Class.forName("edu.neu.ccs.XLong");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray12[0] = clazz19;
        Class<?> clazz20 = class$10;
        if (clazz20 == null) {
            try {
                clazz20 = class$10 = Class.forName("edu.neu.ccs.XLong");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray12[1] = clazz20;
        objectArrayArray[11] = objectArray12;
        Object[] objectArray13 = new Object[2];
        objectArray13[0] = Float.TYPE;
        Class<?> clazz21 = class$13;
        if (clazz21 == null) {
            try {
                clazz21 = class$13 = Class.forName("edu.neu.ccs.XFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray13[1] = clazz21;
        objectArrayArray[12] = objectArray13;
        Object[] objectArray14 = new Object[2];
        Class<?> clazz22 = class$14;
        if (clazz22 == null) {
            try {
                clazz22 = class$14 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray14[0] = clazz22;
        Class<?> clazz23 = class$13;
        if (clazz23 == null) {
            try {
                clazz23 = class$13 = Class.forName("edu.neu.ccs.XFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray14[1] = clazz23;
        objectArrayArray[13] = objectArray14;
        Object[] objectArray15 = new Object[2];
        Class<?> clazz24 = class$13;
        if (clazz24 == null) {
            try {
                clazz24 = class$13 = Class.forName("edu.neu.ccs.XFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray15[0] = clazz24;
        Class<?> clazz25 = class$13;
        if (clazz25 == null) {
            try {
                clazz25 = class$13 = Class.forName("edu.neu.ccs.XFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray15[1] = clazz25;
        objectArrayArray[14] = objectArray15;
        Object[] objectArray16 = new Object[2];
        objectArray16[0] = Double.TYPE;
        Class<?> clazz26 = class$16;
        if (clazz26 == null) {
            try {
                clazz26 = class$16 = Class.forName("edu.neu.ccs.XDouble");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray16[1] = clazz26;
        objectArrayArray[15] = objectArray16;
        Object[] objectArray17 = new Object[2];
        Class<?> clazz27 = class$17;
        if (clazz27 == null) {
            try {
                clazz27 = class$17 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray17[0] = clazz27;
        Class<?> clazz28 = class$16;
        if (clazz28 == null) {
            try {
                clazz28 = class$16 = Class.forName("edu.neu.ccs.XDouble");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray17[1] = clazz28;
        objectArrayArray[16] = objectArray17;
        Object[] objectArray18 = new Object[2];
        Class<?> clazz29 = class$16;
        if (clazz29 == null) {
            try {
                clazz29 = class$16 = Class.forName("edu.neu.ccs.XDouble");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray18[0] = clazz29;
        Class<?> clazz30 = class$16;
        if (clazz30 == null) {
            try {
                clazz30 = class$16 = Class.forName("edu.neu.ccs.XDouble");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray18[1] = clazz30;
        objectArrayArray[17] = objectArray18;
        Object[] objectArray19 = new Object[2];
        objectArray19[0] = Character.TYPE;
        Class<?> clazz31 = class$19;
        if (clazz31 == null) {
            try {
                clazz31 = class$19 = Class.forName("edu.neu.ccs.XChar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray19[1] = clazz31;
        objectArrayArray[18] = objectArray19;
        Object[] objectArray20 = new Object[2];
        Class<?> clazz32 = class$20;
        if (clazz32 == null) {
            try {
                clazz32 = class$20 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray20[0] = clazz32;
        Class<?> clazz33 = class$19;
        if (clazz33 == null) {
            try {
                clazz33 = class$19 = Class.forName("edu.neu.ccs.XChar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray20[1] = clazz33;
        objectArrayArray[19] = objectArray20;
        Object[] objectArray21 = new Object[2];
        Class<?> clazz34 = class$19;
        if (clazz34 == null) {
            try {
                clazz34 = class$19 = Class.forName("edu.neu.ccs.XChar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray21[0] = clazz34;
        Class<?> clazz35 = class$19;
        if (clazz35 == null) {
            try {
                clazz35 = class$19 = Class.forName("edu.neu.ccs.XChar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray21[1] = clazz35;
        objectArrayArray[20] = objectArray21;
        Object[] objectArray22 = new Object[2];
        objectArray22[0] = Boolean.TYPE;
        Class<?> clazz36 = class$22;
        if (clazz36 == null) {
            try {
                clazz36 = class$22 = Class.forName("edu.neu.ccs.XBoolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray22[1] = clazz36;
        objectArrayArray[21] = objectArray22;
        Object[] objectArray23 = new Object[2];
        Class<?> clazz37 = class$23;
        if (clazz37 == null) {
            try {
                clazz37 = class$23 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray23[0] = clazz37;
        Class<?> clazz38 = class$22;
        if (clazz38 == null) {
            try {
                clazz38 = class$22 = Class.forName("edu.neu.ccs.XBoolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray23[1] = clazz38;
        objectArrayArray[22] = objectArray23;
        Object[] objectArray24 = new Object[2];
        Class<?> clazz39 = class$22;
        if (clazz39 == null) {
            try {
                clazz39 = class$22 = Class.forName("edu.neu.ccs.XBoolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray24[0] = clazz39;
        Class<?> clazz40 = class$22;
        if (clazz40 == null) {
            try {
                clazz40 = class$22 = Class.forName("edu.neu.ccs.XBoolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray24[1] = clazz40;
        objectArrayArray[23] = objectArray24;
        primitivePairs = objectArrayArray;
        primitiveTable = new QuickHashtable(primitivePairs);
    }

    private JPFHelper() {
    }

    public static boolean isPublic(Method method) {
        if (method == null) {
            return false;
        }
        int modifiers = method.getModifiers();
        return (modifiers & 1) != 0;
    }

    public static boolean isStatic(Method method) {
        if (method == null) {
            return false;
        }
        int modifiers = method.getModifiers();
        return (modifiers & 8) != 0;
    }

    public static boolean isAbstract(Method method) {
        if (method == null) {
            return false;
        }
        int modifiers = method.getModifiers();
        return (modifiers & 0x400) != 0;
    }

    public static boolean isJPFMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getName().equals("main")) {
            return false;
        }
        int modifiers = method.getModifiers();
        if ((modifiers & 0x400) != 0) {
            return false;
        }
        if ((modifiers & 1) == 0) {
            return false;
        }
        Class<?> returnType = method.getReturnType();
        if (!JPFHelper.isAcceptableTypeForReturn(returnType)) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        int length = parameterTypes.length;
        int i = 0;
        while (i < length) {
            if (!JPFHelper.isAcceptableTypeForParameter(parameterTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSimpleMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getName().equals("main")) {
            return false;
        }
        int modifiers = method.getModifiers();
        if ((modifiers & 0x400) != 0) {
            return false;
        }
        if ((modifiers & 1) == 0) {
            return false;
        }
        return method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 0;
    }

    public static boolean isGUIMethod(Method method) {
        if (JPFHelper.isJPFMethod(method)) {
            return method.getReturnType() != Void.TYPE || method.getParameterTypes().length > 0;
        }
        return false;
    }

    public static boolean isSimilarToPrimitive(Class c) {
        if (c == null) {
            return false;
        }
        return primitiveTable.containsKey(c);
    }

    public static Class getPrimitiveStringable(Class c) {
        if (!JPFHelper.isSimilarToPrimitive(c)) {
            return null;
        }
        return (Class)primitiveTable.get(c);
    }

    public static boolean isAcceptableTypeForParameter(Class c) {
        if (c == null) {
            return false;
        }
        if (JPFHelper.isSimilarToPrimitive(c)) {
            return true;
        }
        Class<?> clazz = class$25;
        if (clazz == null) {
            try {
                clazz = class$25 = Class.forName("edu.neu.ccs.Stringable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(c)) {
            return true;
        }
        Class<?> clazz2 = class$26;
        if (clazz2 == null) {
            try {
                clazz2 = class$26 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c.equals(clazz2)) {
            return true;
        }
        Class<?> clazz3 = class$27;
        if (clazz3 == null) {
            try {
                clazz3 = class$27 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c.equals(clazz3)) {
            return true;
        }
        Class<?> clazz4 = class$28;
        if (clazz4 == null) {
            try {
                clazz4 = class$28 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c.equals(clazz4)) {
            return true;
        }
        Class<?> clazz5 = class$29;
        if (clazz5 == null) {
            try {
                clazz5 = class$29 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return c.equals(clazz5);
    }

    public static boolean isAcceptableTypeForReturn(Class c) {
        if (c == null) {
            return false;
        }
        if (c.equals(Void.TYPE)) {
            return true;
        }
        Class<?> clazz = class$30;
        if (clazz == null) {
            try {
                clazz = class$30 = Class.forName("java.awt.Paint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(c)) {
            return true;
        }
        return JPFHelper.isAcceptableTypeForParameter(c);
    }

    public static Class[] getClassChain(Class c) {
        QuickVector vector = new QuickVector();
        while (c != null) {
            vector.add(c);
            c = c.getSuperclass();
        }
        return vector.toArray(new Class[0]);
    }

    public static Class[] getClassChain(Class c, Class d) {
        QuickVector vector = new QuickVector();
        while (c != null && c != d) {
            vector.add(c);
            c = c.getSuperclass();
        }
        return vector.toArray(new Class[0]);
    }

    public static Method[] getPublicMethods(Class c, Class d) {
        if (c == null || c.isPrimitive() || c.isInterface() || c.isArray()) {
            return new Method[0];
        }
        Method[] methods = c.getMethods();
        int n = methods.length;
        QuickVector vector = new QuickVector();
        while (c != null && c != d) {
            int i = 0;
            while (i < n) {
                if (c == methods[i].getDeclaringClass()) {
                    vector.add(methods[i]);
                }
                ++i;
            }
            c = c.getSuperclass();
        }
        return vector.toArray(new Method[0]);
    }

    public static Method[] joinMethodArrays(Method[] listA, Method[] listB) {
        if (listA == null) {
            return listB;
        }
        if (listB == null) {
            return listA;
        }
        int lengthA = listA.length;
        int lengthB = listB.length;
        if (lengthA == 0) {
            return listB;
        }
        if (lengthB == 0) {
            return listA;
        }
        int length = lengthA + lengthB;
        Method[] list = new Method[length];
        int i = 0;
        while (i < lengthA) {
            list[i] = listA[i];
            ++i;
        }
        i = lengthA;
        while (i < length) {
            list[i] = listB[i - lengthA];
            ++i;
        }
        return list;
    }

    public static void acceptJPFMethods(Method[] methods) {
        if (methods == null) {
            return;
        }
        int length = methods.length;
        int i = 0;
        while (i < length) {
            if (!JPFHelper.isJPFMethod(methods[i])) {
                methods[i] = null;
            }
            ++i;
        }
    }

    public static void removeDuplicateVirtualMethods(Method[] methods) {
        if (methods == null) {
            return;
        }
        int length = methods.length;
        int i = 0;
        while (i < length) {
            if (methods[i] != null) {
                if (JPFHelper.isAbstract(methods[i])) {
                    methods[i] = null;
                } else if (!JPFHelper.isStatic(methods[i])) {
                    int j = i + 1;
                    while (j < length) {
                        if (methods[j] != null) {
                            if (JPFHelper.isAbstract(methods[j])) {
                                methods[j] = null;
                            } else if (!JPFHelper.isStatic(methods[j]) && JPFHelper.isDuplicate(methods[i], methods[j])) {
                                methods[j] = null;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public static boolean isDuplicate(Method method1, Method method2) {
        if (method1 == null || method2 == null) {
            return false;
        }
        return method1.getName().equals(method2.getName()) && method1.getModifiers() == method2.getModifiers() && method2.getReturnType() == method2.getReturnType() && JPFHelper.isDuplicateParameterList(method1, method2);
    }

    public static boolean isDuplicateParameterList(Method method1, Method method2) {
        Class<?>[] types2;
        int length2;
        if (method1 == null || method2 == null) {
            return false;
        }
        Class<?>[] types1 = method1.getParameterTypes();
        int length1 = types1.length;
        if (length1 != (length2 = (types2 = method2.getParameterTypes()).length)) {
            return false;
        }
        int i = 0;
        while (i < length1) {
            if (types1[i] != types2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String className(Class c) {
        if (c == null) {
            return "null";
        }
        return JPFHelper.simpleName(c.getName());
    }

    public static String classQualifier(Class c) {
        if (c == null) {
            return "null";
        }
        return JPFHelper.nameQualifier(c.getName());
    }

    public static String simpleName(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(".");
        if (pos < 0) {
            return name;
        }
        return name.substring(pos + 1);
    }

    public static String nameQualifier(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(".");
        if (pos <= 0) {
            return "";
        }
        return name.substring(0, pos);
    }

    public static String getMethodToolTip(Method method) {
        if (method == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (JPFHelper.isStatic(method)) {
            buffer.append("static ");
        }
        buffer.append(JPFHelper.className(method.getReturnType()));
        buffer.append(" ");
        buffer.append(method.getName());
        buffer.append("(");
        buffer.append(JPFHelper.getParameterNames(method));
        buffer.append(") in ");
        buffer.append(JPFHelper.className(method.getDeclaringClass()));
        return buffer.toString();
    }

    public static String getParameterNames(Method method) {
        if (method == null) {
            return "";
        }
        Class<?>[] types = method.getParameterTypes();
        int length = types.length;
        if (length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(JPFHelper.className(types[0]));
        int i = 1;
        while (i < length) {
            buffer.append(", ");
            buffer.append(JPFHelper.className(types[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static String getAdaptedExceptionTrace(Throwable exception, Method method) {
        StringBuffer buffer = new StringBuffer();
        if (exception instanceof IllegalAccessException) {
            IllegalAccessException illAccEx = (IllegalAccessException)exception;
            buffer.append("JPF Error: IllegalAccessException: ");
            buffer.append(illAccEx);
            buffer.append("\n\n");
        } else if (exception instanceof IllegalArgumentException) {
            IllegalArgumentException illArgEx = (IllegalArgumentException)exception;
            buffer.append("JPF Error: IllegalArgumentException: ");
            buffer.append(illArgEx);
            buffer.append("\n\n");
        } else if (exception instanceof InvocationTargetException) {
            InvocationTargetException invTarEx = (InvocationTargetException)exception;
            exception = invTarEx.getTargetException();
        }
        buffer.append("Exception in method:\n");
        buffer.append(JPFHelper.getMethodToolTip(method));
        buffer.append("\n\n");
        String message = StackTrace.getTrace(exception);
        int index = message.indexOf(".reflect.");
        if (index >= 0 && (index = (message = message.substring(0, index)).lastIndexOf("\n")) >= 0) {
            message = message.substring(0, index);
        }
        if (message.length() > 0) {
            buffer.append(message);
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

