/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.jpf;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.gui.BufferedPanel;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.PaintableSequence;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.jpf.JPFHelper;
import edu.neu.ccs.jpf.JPFPane;
import edu.neu.ccs.jpf.MethodFilter;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Insets;
import javax.swing.Action;

public class JPF
implements JPTConstants,
ConsoleAware {
    public BufferedPanel window = null;
    public PaintableSequence sequence = null;
    protected JPFPane thePane = null;
    protected JPTFrame theFrame = null;
    protected Action toggleGraphicsAction = new SimpleAction("Toggle Graphics"){

        public void perform() {
            JPF.this.toggleGraphics();
        }
    };
    protected Action toggleConsoleAction = new SimpleAction("Toggle Console"){

        public void perform() {
            JPF.this.toggleConsole();
        }
    };
    protected Action exitAction = new SimpleAction("Exit"){

        public void perform() {
            JPF.this.setConsoleActivated(false);
            System.exit(0);
        }
    };
    static /* synthetic */ Class class$0;

    public JPF() {
        this(false, null);
    }

    public JPF(boolean showConsole) {
        this(showConsole, null);
    }

    public JPF(boolean showConsole, MethodFilter filter) {
        Class<?> clazz;
        if (showConsole) {
            this.showConsole();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("edu.neu.ccs.jpf.JPF");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.thePane = new JPFPane((Object)this, (Class)clazz, filter);
        this.addToggleButtons();
        this.thePane.setExitAction(this.exitAction);
        this.window = this.thePane.getGraphicsWindow();
        this.sequence = this.window.getPaintableSequence();
        String title = JPFHelper.className(this.getClass());
        this.theFrame = JPTFrame.frame((Object)this.thePane, title, 3);
    }

    public final JPFPane getPane() {
        return this.thePane;
    }

    public final JPTFrame getFrame() {
        return this.theFrame;
    }

    public final void showConsole() {
        this.setConsoleActivated(true);
    }

    public final boolean isConsoleActivated() {
        return console.isActivated();
    }

    public final void setConsoleActivated(boolean activate) {
        if (console.isActivated() == activate) {
            return;
        }
        console.setActivated(activate);
    }

    public final void normalConsole() {
        this.setConsoleActivated(true);
        console.normal();
    }

    public final void iconifyConsole() {
        this.setConsoleActivated(true);
        console.iconify();
    }

    public final void maximizeConsole() {
        this.setConsoleActivated(true);
        console.maximize();
    }

    public final void toggleConsole() {
        if (console.isActivated()) {
            console.toggle();
        } else {
            console.setActivated(true);
        }
    }

    public final void clearGraphics() {
        this.thePane.clearGraphics();
    }

    public final boolean isGraphicsVisible() {
        return this.thePane.isGraphicsVisible();
    }

    public final void setGraphicsVisible(boolean visible) {
        if (this.thePane.isGraphicsVisible() == visible) {
            return;
        }
        this.thePane.setGraphicsVisible(visible);
        this.theFrame.pack();
        this.theFrame.setLocation(3);
    }

    public final void toggleGraphics() {
        this.thePane.toggleGraphics();
        this.theFrame.pack();
        this.theFrame.setLocation(3);
    }

    public final void makeShapshot() {
        this.thePane.makeShapshot();
    }

    public final void exitFramework() {
        this.thePane.exitFramework();
    }

    protected final void addToggleButtons() {
        this.thePane.addCommonButton(this.toggleGraphicsAction, "Toggle Graphics");
        this.thePane.addCommonButton(this.toggleConsoleAction, "Toggle Console");
    }

    public static JPTFrame frame(Object object) {
        return JPF.frame(object, null, 0, null);
    }

    public static JPTFrame frame(Object object, int location) {
        return JPF.frame(object, null, location, null);
    }

    public static JPTFrame frame(Object object, String title) {
        return JPF.frame(object, title, 0, null);
    }

    public static JPTFrame frame(Object object, String title, int location) {
        return JPF.frame(object, title, location, null);
    }

    public static JPTFrame frame(Object object, String title, Insets insets) {
        return JPF.frame(object, title, 0, insets);
    }

    public static JPTFrame frame(Object object, String title, int location, Insets insets) {
        return JPTFrame.frame(object, title, location, insets);
    }

    public static GeneralDialog OKDialog(Object object) {
        return JPF.OKDialog(object, null);
    }

    public static GeneralDialog OKDialog(Object object, String title) {
        GeneralDialog dialog = GeneralDialog.makeOKDialog(object, title);
        dialog.setVisible(true);
        return dialog;
    }

    public static GeneralDialog OKCancelDialog(Object object) {
        return JPF.OKCancelDialog(object, null);
    }

    public static GeneralDialog OKCancelDialog(Object object, String title) {
        GeneralDialog dialog = GeneralDialog.makeOKCancelDialog(object, title);
        dialog.setVisible(true);
        return dialog;
    }

    public static GeneralDialog YesNoCancelDialog(Object object) {
        return JPF.YesNoCancelDialog(object, null);
    }

    public static GeneralDialog YesNoCancelDialog(Object object, String title) {
        GeneralDialog dialog = GeneralDialog.makeYesNoCancelDialog(object, title);
        dialog.setVisible(true);
        return dialog;
    }

    public static GeneralDialog generalDialog(Object object, Object[][] actionData) {
        return JPF.generalDialog(object, null, actionData, null);
    }

    public static GeneralDialog generalDialog(Object object, Object[][] actionData, Object defaultAction) {
        return JPF.generalDialog(object, null, actionData, defaultAction);
    }

    public static GeneralDialog generalDialog(Object object, String title, Object[][] actionData) {
        return JPF.generalDialog(object, title, actionData, null);
    }

    public static GeneralDialog generalDialog(Object object, String title, Object[][] actionData, Object defaultAction) {
        GeneralDialog dialog = new GeneralDialog(object, title, actionData, defaultAction);
        dialog.setVisible(true);
        return dialog;
    }
}

