/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ImagePaintable;
import edu.neu.ccs.gui.ImagePaintableLite;
import edu.neu.ccs.util.WebTools;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;

public class WebImageTools {
    private WebImageTools() {
    }

    public static Image[] readImages(String imagesURL, String[] imageFileNames) {
        if (imagesURL == null || imageFileNames == null) {
            return new Image[0];
        }
        try {
            imagesURL = imagesURL.trim();
            imagesURL = WebTools.appendSlashIfNeeded(imagesURL);
            int length = imageFileNames.length;
            Image[] images = new Image[length];
            int i = 0;
            while (i < length) {
                URL url = new URL(String.valueOf(imagesURL) + imageFileNames[i]);
                ImageIcon imageicon = new ImageIcon(url);
                images[i] = imageicon.getImage();
                ++i;
            }
            return images;
        }
        catch (Exception ex) {
            return new Image[0];
        }
    }

    public static Image[] readImages(String imagesURL, String filelist) {
        return WebImageTools.readImages(imagesURL, null, filelist);
    }

    public static Image[] readImages(String imagesURL, String filelistURL, String filelist) {
        if (imagesURL == null || filelist == null) {
            return new Image[0];
        }
        imagesURL = imagesURL.trim();
        String[] imageFileNames = WebImageTools.readImageFileNamesFromWeb(imagesURL, filelistURL, filelist);
        return WebImageTools.readImages(imagesURL, imageFileNames);
    }

    public static ImagePaintable[] readImagesAsPaintable(String imagesURL, String[] imageFileNames) {
        if (imagesURL == null || imageFileNames == null) {
            return new ImagePaintable[0];
        }
        try {
            imagesURL = imagesURL.trim();
            imagesURL = WebTools.appendSlashIfNeeded(imagesURL);
            int length = imageFileNames.length;
            ImagePaintable[] paintables = new ImagePaintable[length];
            int i = 0;
            while (i < length) {
                URL url = new URL(String.valueOf(imagesURL) + imageFileNames[i]);
                paintables[i] = new ImagePaintable(url);
                ++i;
            }
            return paintables;
        }
        catch (Exception ex) {
            return new ImagePaintable[0];
        }
    }

    public static ImagePaintable[] readImagesAsPaintable(String imagesURL, String filelist) {
        return WebImageTools.readImagesAsPaintable(imagesURL, null, filelist);
    }

    public static ImagePaintable[] readImagesAsPaintable(String imagesURL, String filelistURL, String filelist) {
        if (imagesURL == null || filelist == null) {
            return new ImagePaintable[0];
        }
        imagesURL = imagesURL.trim();
        String[] imageFileNames = WebImageTools.readImageFileNamesFromWeb(imagesURL, filelistURL, filelist);
        return WebImageTools.readImagesAsPaintable(imagesURL, imageFileNames);
    }

    public static ImagePaintableLite[] readImagesAsPaintableLite(String imagesURL, String[] imageFileNames) {
        if (imagesURL == null || imageFileNames == null) {
            return new ImagePaintableLite[0];
        }
        try {
            imagesURL = imagesURL.trim();
            imagesURL = WebTools.appendSlashIfNeeded(imagesURL);
            int length = imageFileNames.length;
            ImagePaintableLite[] paintables = new ImagePaintableLite[length];
            int i = 0;
            while (i < length) {
                URL url = new URL(String.valueOf(imagesURL) + imageFileNames[i]);
                paintables[i] = new ImagePaintableLite(url);
                ++i;
            }
            return paintables;
        }
        catch (Exception ex) {
            return new ImagePaintableLite[0];
        }
    }

    public static ImagePaintableLite[] readImagesAsPaintableLite(String imagesURL, String filelist) {
        return WebImageTools.readImagesAsPaintableLite(imagesURL, null, filelist);
    }

    public static ImagePaintableLite[] readImagesAsPaintableLite(String imagesURL, String filelistURL, String filelist) {
        if (imagesURL == null || filelist == null) {
            return new ImagePaintableLite[0];
        }
        imagesURL = imagesURL.trim();
        String[] imageFileNames = WebImageTools.readImageFileNamesFromWeb(imagesURL, filelistURL, filelist);
        return WebImageTools.readImagesAsPaintableLite(imagesURL, imageFileNames);
    }

    public static String[] readImageFileNamesFromWeb(String imagesURL, String filelistURL, String filelist) {
        imagesURL = imagesURL == null ? "" : imagesURL.trim();
        if ((filelistURL = filelistURL == null ? imagesURL : filelistURL.trim()).length() == 0) {
            filelistURL = imagesURL;
        }
        if ((filelist = filelist == null ? "" : filelist.trim()).length() == 0) {
            filelist = "imagelist.txt";
        }
        return WebTools.readFileNamesFromWeb(filelistURL, filelist);
    }
}

