/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.XColor;
import edu.neu.ccs.gui.Borders;
import edu.neu.ccs.gui.ColorView;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.JPTScrollPane;
import edu.neu.ccs.gui.PaintSwatch;
import edu.neu.ccs.gui.TableGenerator;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.VTable;
import edu.neu.ccs.util.Hex;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class VisualColorList
extends DisplayPanel {
    public static final int MIN_SWATCH = 20;
    public static final int DEF_SWATCH = 25;
    public static final int MAX_SWATCH = 50;
    public static final int MIN_HEIGHT = 120;
    public static final int DEF_HEIGHT = 525;
    public static final int MAX_HEIGHT = 720;
    private static final int MAX_WIDTH = 720;
    private static final int BORDER_SIZE = 2;
    private static final Border BORDER = PaintSwatch.BLACK_BORDER;
    private static final int HGAP = 12;
    private static final int VGAP = 6;
    private int swatchSize = 25;
    private int paneHeight = 525;
    private String[] nameArray = null;
    private String[] rgbaArray = null;
    private String[] hexArray = null;
    private JPTScrollPane colorPane = null;
    private ColorView colorView = null;

    public VisualColorList() {
        this(25, 525);
    }

    public VisualColorList(int swatchSize) {
        this(swatchSize, 525);
    }

    public VisualColorList(int swatchSize, int paneHeight) {
        this.adjustGeometricParameters(swatchSize, paneHeight);
        this.fillStringArrays();
        this.colorPane = this.makeColorPane();
        this.colorView = this.makeColorView();
        Object[] mainStuff = new Object[]{this.colorPane, this.colorView};
        VTable mainTable = new VTable(mainStuff, 12, 6, 0);
        this.add(mainTable);
    }

    public ColorView getColorView() {
        return this.colorView;
    }

    private void adjustGeometricParameters(int swatchSize, int paneHeight) {
        swatchSize = swatchSize >= 20 ? swatchSize : 20;
        this.swatchSize = swatchSize = swatchSize <= 50 ? swatchSize : 50;
        paneHeight = paneHeight >= 120 ? paneHeight : 120;
        paneHeight = paneHeight <= 720 ? paneHeight : 720;
        int itemHeight = swatchSize + 4 + 6;
        paneHeight = itemHeight * (paneHeight / itemHeight);
        while (paneHeight < 120) {
            paneHeight += itemHeight;
        }
        this.paneHeight = paneHeight;
    }

    private void fillStringArrays() {
        this.nameArray = Colors.getColorNamesAsArray();
        int length = this.nameArray.length;
        this.rgbaArray = new String[length];
        this.hexArray = new String[length];
        int i = 0;
        while (i < length) {
            Color color = XColor.getColor(this.nameArray[i]);
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            int a = color.getAlpha();
            String rh = Hex.byteToHex((byte)r);
            String gh = Hex.byteToHex((byte)g);
            String bh = Hex.byteToHex((byte)b);
            this.rgbaArray[i] = String.valueOf(r) + "," + g + "," + b;
            this.hexArray[i] = "#" + rh + gh + bh;
            if (a < 255) {
                int n = i;
                this.rgbaArray[n] = String.valueOf(this.rgbaArray[n]) + "," + a;
                String ah = Hex.byteToHex((byte)a);
                int n2 = i;
                this.hexArray[n2] = String.valueOf(this.hexArray[n2]) + ah;
            }
            ++i;
        }
    }

    private JPTScrollPane makeColorPane() {
        TableGenerator generator = this.makeTableGenerator(this.nameArray, this.rgbaArray, this.hexArray);
        int length = this.nameArray.length;
        TablePanel colorPanel = new TablePanel(generator, length, 4, 12, 6, 0);
        JPTScrollPane colorPane = new JPTScrollPane(colorPanel);
        colorPane.boundViewportPreferredSize(720, this.paneHeight);
        Border border = Borders.sandwich(Borders.title(" The Standard Named Colors "), Borders.empty(4));
        colorPane.setBorder(border);
        return colorPane;
    }

    private ColorView makeColorView() {
        int size = this.swatchSize;
        Dimension dimension = new Dimension(size, size);
        ColorView colorView = new ColorView(Color.black, true, dimension);
        Border border = Borders.sandwich(Borders.title(" Color View "), Borders.empty(4));
        colorView.setBorder(border);
        return colorView;
    }

    private PaintSwatch makeSwatch(String name) {
        return new PaintSwatch(Colors.getColorFromName(name), this.swatchSize, this.swatchSize, BORDER);
    }

    private TableGenerator makeTableGenerator(final String[] nameArray, final String[] rgbaArray, final String[] hexArray) {
        return new TableGenerator(){

            public Object makeContents(int row, int col) {
                int length = nameArray.length;
                if (row < 0 || row >= length) {
                    return null;
                }
                switch (col) {
                    case 0: {
                        return VisualColorList.this.makeSwatch(nameArray[row]);
                    }
                    case 1: {
                        return new JLabel(nameArray[row]);
                    }
                    case 2: {
                        return new JLabel(rgbaArray[row]);
                    }
                    case 3: {
                        return new JLabel(hexArray[row]);
                    }
                }
                return null;
            }
        };
    }

    public static void main(String[] args) {
        new VisualColorList().frame("Visual Color List");
    }
}

