/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.BaseShape;
import edu.neu.ccs.gui.ClosureMode;
import edu.neu.ccs.gui.Path;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.FloatArray;

public class TweakableShape
extends BaseShape {
    public static final String SET_VERTEX = "set.vertex";
    public static final String SET_TANGENT = "set.tangent";
    public static final String SET_VERTEX_TANGENT = "set.vertex.tangent";
    public static final String ADD_VERTEX_TANGENT = "add.vertex.tangent";
    public static final String REMOVE_VERTEX_TANGENT = "remove.vertex.tangent";

    public TweakableShape() {
        this(null, null, null, null, null);
    }

    public TweakableShape(float[][] vertex) {
        this(vertex, null, null, null, null);
    }

    public TweakableShape(float[][] vertex, float[][] tangent) {
        this(vertex, tangent, null, null, null);
    }

    public TweakableShape(float[][] vertex, float[][] tangent, Path.Strategy pathstrategy) {
        this(vertex, tangent, pathstrategy, null, null);
    }

    public TweakableShape(float[][] vertex, float[][] tangent, Path.Strategy pathstrategy, ClosureMode closuremode) {
        this(vertex, tangent, pathstrategy, closuremode, null);
    }

    public TweakableShape(float[][] vertex, float[][] tangent, Path.Strategy pathstrategy, ClosureMode closuremode, WindingRule windingrule) {
        this.vertex = new float[0][2];
        this.tangent = new float[0][2];
        if (pathstrategy == null) {
            pathstrategy = Path.BEZIER_CUBIC;
        }
        this.setPathStrategy(pathstrategy);
        this.setClosureMode(closuremode);
        this.setWindingRule(windingrule);
        this.setVertexTangentData(vertex, tangent);
        this.makePath();
    }

    public final void setVertexData(float[][] vertex) {
        if (!FloatArray.checkArray(vertex, 2)) {
            return;
        }
        if (vertex.length != this.tangent.length) {
            return;
        }
        this.vertex = FloatArray.deepclone(vertex);
        this.makePath();
        this.firePropertyChange(SET_VERTEX, null, null);
    }

    public final void setTangentData(float[][] tangent) {
        if (tangent == null) {
            this.tangent = new float[this.vertex.length][2];
        } else {
            if (!FloatArray.checkArray(tangent, 2)) {
                return;
            }
            if (tangent.length != this.vertex.length) {
                return;
            }
            this.tangent = FloatArray.deepclone(tangent);
        }
        this.makePath();
        this.firePropertyChange(SET_TANGENT, null, null);
    }

    public final void setVertexTangentData(float[][] vertex, float[][] tangent) {
        if (vertex == null) {
            this.vertex = new float[0][2];
            this.tangent = new float[0][2];
        } else {
            if (!FloatArray.checkArray(vertex, 2)) {
                return;
            }
            int N = vertex.length;
            if (tangent == null) {
                this.tangent = new float[N][2];
            } else {
                if (!FloatArray.checkArray(tangent, 2)) {
                    return;
                }
                if (tangent.length != N) {
                    return;
                }
                this.tangent = FloatArray.deepclone(tangent);
            }
            this.vertex = FloatArray.deepclone(vertex);
        }
        this.makePath();
        this.firePropertyChange(SET_VERTEX_TANGENT, null, null);
    }

    public final void setVertexTangentData(float[][] vertex_tangent) {
        if (vertex_tangent == null) {
            this.vertex = new float[0][2];
            this.tangent = new float[0][2];
        } else {
            if (!FloatArray.checkArray(vertex_tangent, 4)) {
                return;
            }
            int N = vertex_tangent.length;
            this.vertex = new float[N][2];
            this.tangent = new float[N][2];
            int i = 0;
            while (i < N) {
                this.vertex[i][0] = vertex_tangent[i][0];
                this.vertex[i][1] = vertex_tangent[i][1];
                this.tangent[i][0] = vertex_tangent[i][2];
                this.tangent[i][1] = vertex_tangent[i][3];
                ++i;
            }
        }
        this.makePath();
        this.firePropertyChange(SET_VERTEX_TANGENT, null, null);
    }

    public final void setVertex(int index, float x, float y) {
        if (index < 0 || index >= this.vertex.length) {
            return;
        }
        this.vertex[index][0] = x;
        this.vertex[index][1] = y;
        this.makePath();
        this.firePropertyChange(SET_VERTEX, null, null);
    }

    public final void setVertex(int index, float[] point) {
        if (point == null || point.length != 2) {
            return;
        }
        this.setVertex(index, point[0], point[1]);
    }

    public final void setTangent(int index, float dx, float dy) {
        if (index < 0 || index >= this.vertex.length) {
            return;
        }
        this.tangent[index][0] = dx;
        this.tangent[index][1] = dy;
        this.makePath();
        this.firePropertyChange(SET_TANGENT, null, null);
    }

    public final void setTangent(int index, float[] delta) {
        if (delta == null || delta.length != 2) {
            return;
        }
        this.setTangent(index, delta[0], delta[1]);
    }

    public final void setTangentViaControlA(int index, float x, float y) {
        if (index < 0 || index >= this.vertex.length) {
            return;
        }
        this.tangent[index][0] = x - this.vertex[index][0];
        this.tangent[index][1] = y - this.vertex[index][1];
        this.makePath();
        this.firePropertyChange(SET_TANGENT, null, null);
    }

    public final void setTangentViaControlA(int index, float[] control) {
        if (control == null || control.length != 2) {
            return;
        }
        this.setTangentViaControlA(index, control[0], control[1]);
    }

    public final void setTangentViaControlB(int index, float x, float y) {
        if (index < 0 || index >= this.vertex.length) {
            return;
        }
        this.tangent[index][0] = this.vertex[index][0] - x;
        this.tangent[index][1] = this.vertex[index][1] - y;
        this.makePath();
        this.firePropertyChange(SET_TANGENT, null, null);
    }

    public final void setTangentViaControlB(int index, float[] control) {
        if (control == null || control.length != 2) {
            return;
        }
        this.setTangentViaControlB(index, control[0], control[1]);
    }

    public final void setVertexTangent(int index, float x, float y, float dx, float dy) {
        if (index < 0 || index >= this.vertex.length) {
            return;
        }
        this.vertex[index][0] = x;
        this.vertex[index][1] = y;
        this.tangent[index][0] = dx;
        this.tangent[index][1] = dy;
        this.makePath();
        this.firePropertyChange(SET_VERTEX_TANGENT, null, null);
    }

    public final void setVertexTangent(int index, float[] point, float[] delta) {
        if (point == null || point.length != 2) {
            return;
        }
        if (delta == null || delta.length != 2) {
            return;
        }
        this.setVertexTangent(index, point[0], point[1], delta[0], delta[1]);
    }

    public final void setVertexTangent(int index, float[] array) {
        if (array == null || array.length != 4) {
            return;
        }
        this.setVertexTangent(index, array[0], array[1], array[2], array[3]);
    }

    public final void addVertexTangent(int index, float x, float y, float dx, float dy) {
        int N = this.vertex.length;
        int M = N + 1;
        if (index < 0) {
            index = 0;
        } else if (index > N) {
            index = N;
        }
        float[][] oldvertex = this.vertex;
        float[][] oldtangent = this.tangent;
        this.vertex = new float[M][2];
        this.tangent = new float[M][2];
        int i = 0;
        while (i < index) {
            this.vertex[i][0] = oldvertex[i][0];
            this.vertex[i][1] = oldvertex[i][1];
            this.tangent[i][0] = oldtangent[i][0];
            this.tangent[i][1] = oldtangent[i][1];
            ++i;
        }
        this.vertex[index][0] = x;
        this.vertex[index][1] = y;
        this.tangent[index][0] = dx;
        this.tangent[index][1] = dy;
        i = index + 1;
        while (i < M) {
            int j = i - 1;
            this.vertex[i][0] = oldvertex[j][0];
            this.vertex[i][1] = oldvertex[j][1];
            this.tangent[i][0] = oldtangent[j][0];
            this.tangent[i][1] = oldtangent[j][1];
            ++i;
        }
        this.makePath();
        this.firePropertyChange(ADD_VERTEX_TANGENT, null, null);
    }

    public final void addVertexTangent(int index, float[] point, float[] delta) {
        if (point == null || point.length != 2) {
            return;
        }
        if (delta == null || delta.length != 2) {
            return;
        }
        this.addVertexTangent(index, point[0], point[1], delta[0], delta[1]);
    }

    public final void addVertexTangent(int index, float[] array) {
        if (array == null || array.length != 4) {
            return;
        }
        this.addVertexTangent(index, array[0], array[1], array[2], array[3]);
    }

    public final void addVerticesTangents(int index, float[][] points, float[][] deltas) {
        int j;
        if (!FloatArray.checkArrayPair(points, deltas, 2)) {
            return;
        }
        int K = points.length;
        if (K == 0) {
            return;
        }
        int N = this.vertex.length;
        int M = N + K;
        float[][] oldvertex = this.vertex;
        float[][] oldtangent = this.tangent;
        this.vertex = new float[M][2];
        this.tangent = new float[M][2];
        if (index < 0) {
            index = 0;
        } else if (index > N) {
            index = N;
        }
        int i = 0;
        while (i < index) {
            this.vertex[i][0] = oldvertex[i][0];
            this.vertex[i][1] = oldvertex[i][1];
            this.tangent[i][0] = oldtangent[i][0];
            this.tangent[i][1] = oldtangent[i][1];
            ++i;
        }
        i = 0;
        while (i < K) {
            j = i + index;
            this.vertex[j][0] = points[i][0];
            this.vertex[j][1] = points[i][1];
            this.tangent[j][0] = deltas[i][0];
            this.tangent[j][1] = deltas[i][1];
            ++i;
        }
        i = index;
        while (i < N) {
            j = i + K;
            this.vertex[j][0] = oldvertex[i][0];
            this.vertex[j][1] = oldvertex[i][1];
            this.tangent[j][0] = oldtangent[i][0];
            this.tangent[j][1] = oldtangent[i][1];
            ++i;
        }
        this.makePath();
        this.firePropertyChange(ADD_VERTEX_TANGENT, null, null);
    }

    public final void addVerticesTangents(int index, float[][] array) {
        int j;
        if (!FloatArray.checkArray(array, 4)) {
            return;
        }
        int K = array.length;
        if (K == 0) {
            return;
        }
        int N = this.vertex.length;
        int M = N + K;
        float[][] oldvertex = this.vertex;
        float[][] oldtangent = this.tangent;
        this.vertex = new float[M][2];
        this.tangent = new float[M][2];
        if (index < 0) {
            index = 0;
        } else if (index > N) {
            index = N;
        }
        int i = 0;
        while (i < index) {
            this.vertex[i][0] = oldvertex[i][0];
            this.vertex[i][1] = oldvertex[i][1];
            this.tangent[i][0] = oldtangent[i][0];
            this.tangent[i][1] = oldtangent[i][1];
            ++i;
        }
        i = 0;
        while (i < K) {
            j = i + index;
            this.vertex[j][0] = array[i][0];
            this.vertex[j][1] = array[i][1];
            this.tangent[j][0] = array[i][2];
            this.tangent[j][1] = array[i][3];
            ++i;
        }
        i = index;
        while (i < N) {
            j = i + K;
            this.vertex[j][0] = oldvertex[i][0];
            this.vertex[j][1] = oldvertex[i][1];
            this.tangent[j][0] = oldtangent[i][0];
            this.tangent[j][1] = oldtangent[i][1];
            ++i;
        }
        this.makePath();
        this.firePropertyChange(ADD_VERTEX_TANGENT, null, null);
    }

    public final void appendVertexTangent(float x, float y, float dx, float dy) {
        this.addVertexTangent(this.vertex.length, x, y, dx, dy);
    }

    public final void appendVertexTangent(float[] point, float[] delta) {
        this.addVertexTangent(this.vertex.length, point, delta);
    }

    public final void appendVertexTangent(float[] array) {
        this.addVertexTangent(this.vertex.length, array);
    }

    public final void appendVerticesTangents(float[][] points, float[][] deltas) {
        this.addVerticesTangents(this.vertex.length, points, deltas);
    }

    public final void appendVerticesTangents(float[][] array) {
        this.addVerticesTangents(this.vertex.length, array);
    }

    public final float[] removeVertexTangent(int index) {
        int N = this.vertex.length;
        int M = N - 1;
        if (index < 0 || index >= N) {
            return null;
        }
        float[][] oldvertex = this.vertex;
        float[][] oldtangent = this.tangent;
        this.vertex = new float[M][2];
        this.tangent = new float[M][2];
        int i = 0;
        while (i < index) {
            this.vertex[i][0] = oldvertex[i][0];
            this.vertex[i][1] = oldvertex[i][1];
            this.tangent[i][0] = oldtangent[i][0];
            this.tangent[i][1] = oldtangent[i][1];
            ++i;
        }
        i = index + 1;
        while (i < N) {
            int j = i - 1;
            this.vertex[j][0] = oldvertex[i][0];
            this.vertex[j][1] = oldvertex[i][1];
            this.tangent[j][0] = oldtangent[i][0];
            this.tangent[j][1] = oldtangent[i][1];
            ++i;
        }
        this.makePath();
        this.firePropertyChange(REMOVE_VERTEX_TANGENT, null, null);
        float x = oldvertex[index][0];
        float y = oldvertex[index][1];
        float dx = oldtangent[index][0];
        float dy = oldtangent[index][1];
        return new float[]{x, y, dx, dy};
    }

    public final float[][] removeVerticesTangents(int m, int n) {
        int j;
        int K;
        int N = this.vertex.length;
        if (m < 0) {
            m = 0;
        }
        if (n > N) {
            n = N;
        }
        if ((K = n - m) <= 0) {
            return new float[0][4];
        }
        int M = N - K;
        float[][] oldvertex = this.vertex;
        float[][] oldtangent = this.tangent;
        this.vertex = new float[M][2];
        this.tangent = new float[M][2];
        float[][] result = new float[K][4];
        int i = 0;
        while (i < m) {
            this.vertex[i][0] = oldvertex[i][0];
            this.vertex[i][1] = oldvertex[i][1];
            this.tangent[i][0] = oldtangent[i][0];
            this.tangent[i][1] = oldtangent[i][1];
            ++i;
        }
        i = m;
        while (i < n) {
            j = i - m;
            result[j][0] = oldvertex[i][0];
            result[j][1] = oldvertex[i][1];
            result[j][2] = oldtangent[i][0];
            result[j][3] = oldtangent[i][1];
            ++i;
        }
        i = n;
        while (i < N) {
            j = i - K;
            this.vertex[j][0] = oldvertex[i][0];
            this.vertex[j][1] = oldvertex[i][1];
            this.tangent[j][0] = oldtangent[i][0];
            this.tangent[j][1] = oldtangent[i][1];
            ++i;
        }
        this.makePath();
        this.firePropertyChange(REMOVE_VERTEX_TANGENT, null, null);
        return result;
    }

    public final float[][] removeAllVerticesTangents() {
        return this.removeVerticesTangents(0, this.vertex.length);
    }
}

