/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.util.MathUtilities;
import java.awt.geom.AffineTransform;

public class TransformFactory {
    private TransformFactory() {
    }

    public static AffineTransform translate(double tx, double ty) {
        AffineTransform T = new AffineTransform();
        T.translate(tx, ty);
        return T;
    }

    public static AffineTransform rotate(double x, double y, double degrees) {
        AffineTransform T = new AffineTransform();
        double radians = Math.toRadians(degrees);
        T.translate(x, y);
        T.rotate(radians);
        T.translate(-x, -y);
        return T;
    }

    public static AffineTransform scale(double x, double y, double degrees, double s, double t) {
        AffineTransform T = new AffineTransform();
        double radians = Math.toRadians(degrees);
        T.translate(x, y);
        T.rotate(radians);
        T.scale(s, t);
        T.rotate(-radians);
        T.translate(-x, -y);
        return T;
    }

    public static AffineTransform shear(double x, double y, double degrees, double s) {
        AffineTransform T = new AffineTransform();
        double radians = Math.toRadians(degrees);
        T.translate(x, y);
        T.rotate(radians);
        T.shear(s, 0.0);
        T.rotate(-radians);
        T.translate(-x, -y);
        return T;
    }

    public static AffineTransform reflect(double x, double y, double degrees) {
        return TransformFactory.scale(x, y, degrees, 1.0, -1.0);
    }

    public static AffineTransform glide(double degrees, double distance) {
        double radians = Math.toRadians(degrees);
        double tx = distance * Math.cos(radians);
        double ty = distance * Math.sin(radians);
        return TransformFactory.translate(tx, ty);
    }

    public static AffineTransform glidereflect(double x, double y, double degrees, double distance) {
        double radians = Math.toRadians(degrees);
        double tx = distance * Math.cos(radians);
        double ty = distance * Math.sin(radians);
        return TransformFactory.compose(new AffineTransform[]{TransformFactory.translate(tx, ty), TransformFactory.reflect(x, y, degrees)});
    }

    public static AffineTransform transform(double m00, double m10, double m01, double m11, double m02, double m12) {
        AffineTransform T = new AffineTransform();
        T.setTransform(m00, m10, m01, m11, m02, m12);
        return T;
    }

    public static AffineTransform centeredTransform(double x, double y, AffineTransform t) {
        if (t == null) {
            return new AffineTransform();
        }
        return TransformFactory.compose(new AffineTransform[]{TransformFactory.translate(x, y), t, TransformFactory.translate(-x, -y)});
    }

    public static AffineTransform centeredTransform(double x, double y, double m00, double m10, double m01, double m11, double m02, double m12) {
        return TransformFactory.centeredTransform(x, y, TransformFactory.transform(m00, m10, m01, m11, m02, m12));
    }

    public static AffineTransform compose(AffineTransform[] transforms) {
        AffineTransform T = new AffineTransform();
        if (transforms == null) {
            return T;
        }
        int length = transforms.length;
        int i = 0;
        while (i < length) {
            if (transforms[i] != null) {
                T.concatenate(transforms[i]);
            }
            ++i;
        }
        return T;
    }

    public static AffineTransform compose(AffineTransform M, AffineTransform N) {
        return TransformFactory.compose(new AffineTransform[]{M, N});
    }

    public static AffineTransform rotateAtOrigin(double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            return new AffineTransform();
        }
        double r = Math.sqrt(dx * dx + dy * dy);
        double m00 = dx / r;
        double m10 = dy / r;
        return new AffineTransform(m00, m10, -m10, m00, 0.0, 0.0);
    }

    public static AffineTransform rotateAtOrigin(double x1, double y1, double x2, double y2) {
        return TransformFactory.rotateAtOrigin(x2 - x1, y2 - y1);
    }

    public static AffineTransform rotateAtX1Y1(double x1, double y1, double x2, double y2) {
        return TransformFactory.centeredTransform(x1, y1, TransformFactory.rotateAtOrigin(x1, y1, x2, y2));
    }

    public static AffineTransform rotateAtX2Y2(double x1, double y1, double x2, double y2) {
        return TransformFactory.centeredTransform(x2, y2, TransformFactory.rotateAtOrigin(x1, y1, x2, y2));
    }

    public static AffineTransform reflectAtOrigin(double dx, double dy) {
        if (dy == 0.0) {
            return new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        }
        if (dx == 0.0) {
            return new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
        double r = Math.sqrt(dx * dx + dy * dy);
        double cos1 = dx / r;
        double sin1 = dy / r;
        double m00 = cos1 * cos1 - sin1 * sin1;
        double m10 = 2.0 * sin1 * cos1;
        return new AffineTransform(m00, m10, m10, -m00, 0.0, 0.0);
    }

    public static AffineTransform reflectThroughLine(double x1, double y1, double x2, double y2) {
        return TransformFactory.centeredTransform(x1, y1, TransformFactory.reflectAtOrigin(x2 - x1, y2 - y1));
    }

    public static AffineTransform randomTranslate(double maxshift) {
        maxshift = Math.abs(maxshift);
        double tx = MathUtilities.randomDouble(-maxshift, maxshift);
        double ty = MathUtilities.randomDouble(-maxshift, maxshift);
        return TransformFactory.translate(tx, ty);
    }

    public static AffineTransform randomRotate(double x, double y, double maxangle) {
        maxangle = Math.abs(maxangle);
        double degrees = MathUtilities.randomDouble(-maxangle, maxangle);
        return TransformFactory.rotate(x, y, degrees);
    }

    public static AffineTransform randomTranslateRotate(double x, double y, double maxshift, double maxangle) {
        return TransformFactory.compose(new AffineTransform[]{TransformFactory.randomTranslate(maxshift), TransformFactory.randomRotate(x, y, maxangle)});
    }

    public static AffineTransform randomScale(double x, double y, double degrees, double maxdelta) {
        maxdelta = Math.abs(maxdelta);
        double s = MathUtilities.randomDouble(-maxdelta, maxdelta) + 1.0;
        double t = MathUtilities.randomDouble(-maxdelta, maxdelta) + 1.0;
        return TransformFactory.scale(x, y, degrees, s, t);
    }

    public static AffineTransform randomCenteredTransform(double x, double y, double maxshift) {
        maxshift = Math.abs(maxshift);
        double m00 = MathUtilities.randomDouble(-maxshift, maxshift) + 1.0;
        double m10 = MathUtilities.randomDouble(-maxshift, maxshift);
        double m01 = MathUtilities.randomDouble(-maxshift, maxshift);
        double m11 = MathUtilities.randomDouble(-maxshift, maxshift) + 1.0;
        double m02 = MathUtilities.randomDouble(-maxshift, maxshift);
        double m12 = MathUtilities.randomDouble(-maxshift, maxshift);
        return TransformFactory.centeredTransform(x, y, m00, m10, m01, m11, m02, m12);
    }
}

