/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.Paintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;

public class Tile
extends AbstractPaintable {
    protected Paintable paintable = null;
    protected int row = 0;
    protected int col = 0;

    public Tile() {
    }

    public Tile(Object o) {
        this.initializeTile(o, null, null);
    }

    public Tile(Object o, Paint background) {
        this.initializeTile(o, background, null);
    }

    public Tile(Object o, AffineTransform m) {
        this.initializeTile(o, null, m);
    }

    public Tile(Object o, Paint background, AffineTransform m) {
        this.initializeTile(o, background, m);
    }

    public void initializeTile(Object o, Paint background, AffineTransform m) {
        this.setPaintable(o);
        this.setBackgroundPaint(background);
        this.setMutator(m);
    }

    public void originalPaint(Graphics g) {
        if (g == null || this.paintable == null) {
            return;
        }
        Graphics2D h = (Graphics2D)g.create();
        this.paintable.paint(h);
    }

    public XRect getActualBounds2D() {
        if (this.paintable == null) {
            return null;
        }
        return this.paintable.getBounds2D();
    }

    public boolean originalContains(double x, double y) {
        if (this.paintable == null) {
            return false;
        }
        return this.paintable.contains(x, y);
    }

    public Paintable makePaintable(Object o) {
        return ComponentFactory.makePaintable(o);
    }

    public void setPaintable(Object o) {
        Paintable paintable = this.makePaintable(o);
        if (paintable == this.paintable) {
            return;
        }
        this.removeAndAddForwardingListener(this.paintable, paintable);
        this.paintable = paintable;
        this.firePropertyChange("set.paintable", null, null);
    }

    public Paintable getPaintable() {
        return this.paintable;
    }

    public void setRowCol(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }
}

