/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.TextAnchor;
import edu.neu.ccs.gui.TextBounds;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import javax.swing.JLabel;

public class TextPaintable
extends AbstractPaintable {
    public static final String SET_STRING = "set.string";
    public static final String SET_FONT = "set.font";
    public static final String SET_FILL_PAINT = "set.fill.paint";
    public static final String SET_ANCHOR_LOCATOR = "set.anchor.locator";
    public static final String SET_ANCHOR_POSITION = "set.anchor.position";
    public static final String SET_BOUNDS_STRATEGY = "set.bounds.strategy";
    public static final FontRenderContext standardFRC = new FontRenderContext(null, true, false);
    private String string = "";
    private Font font = null;
    private Paint fillpaint = null;
    private TextBounds.Strategy strategy = null;
    private TextAnchor.Locator locator = null;
    private float anchorX = 0.0f;
    private float anchorY = 0.0f;
    private TextLayout textLayout = null;

    public TextPaintable() {
        this(null, null, null, null, null, 0.0f, 0.0f);
    }

    public TextPaintable(String string) {
        this(string, null, null, null, null, 0.0f, 0.0f);
    }

    public TextPaintable(String string, float anchorX, float anchorY) {
        this(string, null, null, null, null, anchorX, anchorY);
    }

    public TextPaintable(String string, TextAnchor.Locator locator, float anchorX, float anchorY) {
        this(string, null, null, null, locator, anchorX, anchorY);
    }

    public TextPaintable(String string, Font font) {
        this(string, font, null, null, null, 0.0f, 0.0f);
    }

    public TextPaintable(String string, Font font, float anchorX, float anchorY) {
        this(string, font, null, null, null, anchorX, anchorY);
    }

    public TextPaintable(String string, Font font, TextAnchor.Locator locator, float anchorX, float anchorY) {
        this(string, font, null, null, locator, anchorX, anchorY);
    }

    public TextPaintable(String string, Font font, Paint fillpaint) {
        this(string, font, fillpaint, null, null, 0.0f, 0.0f);
    }

    public TextPaintable(String string, Font font, Paint fillpaint, float anchorX, float anchorY) {
        this(string, font, fillpaint, null, null, anchorX, anchorY);
    }

    public TextPaintable(String string, Font font, Paint fillpaint, TextAnchor.Locator locator, float anchorX, float anchorY) {
        this(string, font, fillpaint, null, locator, anchorX, anchorY);
    }

    public TextPaintable(String string, Font font, Paint fillpaint, TextBounds.Strategy strategy) {
        this(string, font, fillpaint, strategy, null, 0.0f, 0.0f);
    }

    public TextPaintable(String string, Font font, Paint fillpaint, TextBounds.Strategy strategy, float anchorX, float anchorY) {
        this(string, font, fillpaint, strategy, null, anchorX, anchorY);
    }

    public TextPaintable(String string, Font font, Paint fillpaint, TextBounds.Strategy strategy, TextAnchor.Locator locator) {
        this(string, font, fillpaint, strategy, locator, 0.0f, 0.0f);
    }

    public TextPaintable(String string, Font font, Paint fillpaint, TextBounds.Strategy strategy, TextAnchor.Locator locator, float anchorX, float anchorY) {
        this.setFont(font);
        this.setString(string);
        this.setFillPaint(fillpaint);
        this.setBoundsStrategy(strategy);
        this.setAnchorLocator(locator);
        this.setAnchorPosition(anchorX, anchorY);
        this.resetTextLayout();
    }

    public void originalPaint(Graphics g) {
        if (this.string.length() == 0 || g == null || !this.isVisible()) {
            return;
        }
        Graphics2D h = (Graphics2D)g.create();
        h.setFont(this.font);
        h.setPaint(this.fillpaint);
        this.textLayout.draw(h, this.getLeftX(), this.getBaseLineY());
    }

    public XRect getActualBounds2D() {
        if (this.string.length() == 0) {
            return null;
        }
        return this.strategy.getBounds2D(this);
    }

    public XPoint2D getOriginalCenter() {
        XPoint2D center = this.getDefaultOriginalCenter();
        if (center != null) {
            return center;
        }
        return new XPoint2D(this.anchorX, this.anchorY);
    }

    public boolean originalContains(double x, double y) {
        if (this.string.length() == 0) {
            return false;
        }
        if (!this.possiblyContains(x, y)) {
            return false;
        }
        return this.getOutline().contains(x, y);
    }

    public TextLayout getTextLayout() {
        return this.textLayout;
    }

    public XRect getStringBounds() {
        if (this.string.length() == 0) {
            return new XRect(this.anchorX, this.anchorY, 0.0, 0.0);
        }
        return this.locator.getBounds2D(this.string, this.font, this.anchorX, this.anchorY);
    }

    public XRect getTightBounds() {
        if (this.string.length() == 0) {
            return new XRect(this.anchorX, this.anchorY, 0.0, 0.0);
        }
        XRect area = new XRect(this.textLayout.getBounds());
        float x = (float)area.getX();
        float y = (float)area.getY();
        float w = (float)area.getWidth();
        float h = (float)area.getHeight();
        if (w <= 0.0f || h <= 0.0f) {
            return new XRect(this.anchorX, this.anchorY, 0.0, 0.0);
        }
        float x0 = this.getLeftX();
        float y0 = this.getBaseLineY();
        area.setRect(x + x0, y + y0, w, h);
        return area;
    }

    public XRect getLooseBounds() {
        XRect area = this.getStringBounds();
        return area.createUnionRect(this.getTightBounds());
    }

    public Shape getOutline() {
        return this.string.length() == 0 ? new GeneralPath() : this.textLayout.getOutline(TransformFactory.translate(this.getLeftX(), this.getBaseLineY()));
    }

    public void setString(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this.string)) {
            return;
        }
        this.string = string;
        this.resetTextLayout();
        this.firePropertyChange(SET_STRING, null, null);
    }

    public String getString() {
        return this.string;
    }

    public void setFont(Font font) {
        if (font == null) {
            font = TextPaintable.getDefaultFont();
        }
        if (font.equals(this.font)) {
            return;
        }
        this.removeAndAddForwardingListener(this.font, font);
        this.font = font;
        this.resetTextLayout();
        this.firePropertyChange(SET_FONT, null, null);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFillPaint(Paint fillpaint) {
        if (fillpaint == null) {
            fillpaint = Color.black;
        }
        if (fillpaint.equals(this.fillpaint)) {
            return;
        }
        this.removeAndAddForwardingListener(this.fillpaint, fillpaint);
        this.fillpaint = fillpaint;
        this.firePropertyChange(SET_FILL_PAINT, null, null);
    }

    public Paint getFillPaint() {
        return this.fillpaint;
    }

    public void setBoundsStrategy(TextBounds.Strategy strategy) {
        if (strategy == null) {
            strategy = TextBounds.LOOSE;
        }
        if (strategy.equals(this.strategy)) {
            return;
        }
        this.strategy = strategy;
        this.firePropertyChange(SET_BOUNDS_STRATEGY, null, null);
    }

    public TextBounds.Strategy getBoundsStrategy() {
        return this.strategy;
    }

    public void setAnchorLocator(TextAnchor.Locator locator) {
        if (locator == null) {
            locator = TextAnchor.LEFT_ASCENTLINE;
        }
        if (locator.equals(this.locator)) {
            return;
        }
        this.locator = locator;
        this.firePropertyChange(SET_ANCHOR_LOCATOR, null, null);
    }

    public TextAnchor.Locator getAnchorLocator() {
        return this.locator;
    }

    public void setAnchorPosition(float anchorX, float anchorY) {
        float dx = anchorX - this.anchorX;
        float dy = anchorY - this.anchorY;
        this.shiftAnchorPosition(dx, dy);
    }

    public void setAnchorPosition(float[] position) {
        if (position == null || position.length != 2) {
            return;
        }
        this.setAnchorPosition(position[0], position[1]);
    }

    public void shiftAnchorPosition(float dx, float dy) {
        if (dx == 0.0f && dy == 0.0f) {
            return;
        }
        this.anchorX += dx;
        this.anchorY += dy;
        this.addPreMutation(TransformFactory.translate(-dx, -dy));
        this.addPostMutation(TransformFactory.translate(dx, dy));
        this.firePropertyChange(SET_ANCHOR_POSITION, null, null);
    }

    public float[] getAnchorPosition() {
        return new float[]{this.anchorX, this.anchorY};
    }

    public float getLeftX() {
        if (this.string.length() == 0) {
            return this.anchorX;
        }
        return this.locator.getLeftX(this.string, this.font, this.anchorX);
    }

    public float getRightX() {
        if (this.string.length() == 0) {
            return this.anchorX;
        }
        return this.locator.getRightX(this.string, this.font, this.anchorX);
    }

    public float getCenterX() {
        if (this.string.length() == 0) {
            return this.anchorX;
        }
        return this.locator.getCenterX(this.string, this.font, this.anchorX);
    }

    public float getBaseLineY() {
        if (this.string.length() == 0) {
            return this.anchorY;
        }
        return this.locator.getBaseLineY(this.string, this.font, this.anchorY);
    }

    public float getAscentLineY() {
        if (this.string.length() == 0) {
            return this.anchorY;
        }
        return this.locator.getAscentLineY(this.string, this.font, this.anchorY);
    }

    public float getDescentLineY() {
        if (this.string.length() == 0) {
            return this.anchorY;
        }
        return this.locator.getDescentLineY(this.string, this.font, this.anchorY);
    }

    public float getLeadingLineY() {
        if (this.string.length() == 0) {
            return this.anchorY;
        }
        return this.locator.getLeadingLineY(this.string, this.font, this.anchorY);
    }

    public float getWidth() {
        return (float)this.getBounds2D().getWidth();
    }

    public float getHeight() {
        return (float)this.getBounds2D().getHeight();
    }

    public static Font getDefaultFont() {
        JLabel label = new JLabel();
        return label.getFont();
    }

    private void resetTextLayout() {
        this.textLayout = this.string.length() == 0 ? null : new TextLayout(this.string, this.font, standardFRC);
    }
}

