/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.util.FileExtensionFilter;
import edu.neu.ccs.util.FileUtilities;
import java.io.File;
import javax.swing.JFileChooser;

public class TextFileIO {
    protected String extension = null;
    protected FileExtensionFilter textFileFilter = null;
    protected File home = new File(".");
    protected JFileChooser filechooser = new JFileChooser();

    public TextFileIO() {
        this(null);
    }

    public TextFileIO(String extension) {
        this.extension = extension;
        if (extension != null) {
            this.textFileFilter = new FileExtensionFilter(extension);
            this.filechooser.setFileFilter(this.textFileFilter);
        }
        this.filechooser.setCurrentDirectory(this.home);
    }

    public String readDataFromFile() {
        return this.readDataFromFile(true);
    }

    public String readDataFromFile(boolean displayErrorDialogs) {
        int result = this.filechooser.showOpenDialog(null);
        if (result == 1) {
            return null;
        }
        if (result == -1) {
            if (displayErrorDialogs) {
                GeneralDialog.showOKDialog("File Open Dialog Error", "File Read Error");
            }
            return null;
        }
        File source = this.filechooser.getSelectedFile();
        this.filechooser.setCurrentDirectory(source);
        return this.readDataFromFile(source, displayErrorDialogs);
    }

    public String readDataFromFile(File source, boolean displayErrorDialogs) {
        String data = null;
        if (source == null) {
            if (displayErrorDialogs) {
                String message = "Error in reading file\nNull source File object\n";
                GeneralDialog.showOKDialog(message, "File Read Error");
            }
            return null;
        }
        try {
            data = FileUtilities.readFile(source);
        }
        catch (Throwable ex) {
            if (displayErrorDialogs) {
                String message = "Error in reading file\n" + source.getName() + "\n\n" + ex.getMessage() + "\n";
                GeneralDialog.showOKDialog(message, "File Read Error");
            }
            return null;
        }
        return data;
    }

    public boolean saveDataToFile(String data) {
        return this.saveDataToFile(data, true);
    }

    public boolean saveDataToFile(String data, boolean displayErrorDialogs) {
        int result = this.filechooser.showSaveDialog(null);
        if (result == 1) {
            return false;
        }
        if (result == -1) {
            GeneralDialog.showOKDialog("File Save Dialog Error", "File Save Error");
            return false;
        }
        File target = this.filechooser.getSelectedFile();
        String path = target.getPath();
        if (this.textFileFilter != null && !this.textFileFilter.accept(target)) {
            path = String.valueOf(path) + "." + this.extension;
            target = new File(path);
        }
        this.filechooser.setCurrentDirectory(target);
        return this.saveDataToFile(target, data, displayErrorDialogs);
    }

    public boolean saveDataToFile(File target, String data, boolean displayErrorDialogs) {
        if (target == null) {
            if (displayErrorDialogs) {
                String message = "Error in writing file\nNull target File\n";
                GeneralDialog.showOKDialog(message, "File Save Error");
            }
            return false;
        }
        try {
            FileUtilities.writeFile(target, data, true);
        }
        catch (Exception ex) {
            if (displayErrorDialogs) {
                String message = "Error in writing file\n" + target.getName() + "\n\n" + ex.getMessage() + "\n";
                GeneralDialog.showOKDialog(message, "File Save Error");
            }
            return false;
        }
        return true;
    }
}

