/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.HexXByte;
import edu.neu.ccs.HexXDouble;
import edu.neu.ccs.HexXFloat;
import edu.neu.ccs.HexXInt;
import edu.neu.ccs.HexXLong;
import edu.neu.ccs.HexXShort;
import edu.neu.ccs.Stringable;
import edu.neu.ccs.XBigDecimal;
import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XByte;
import edu.neu.ccs.XChar;
import edu.neu.ccs.XColor;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XFloat;
import edu.neu.ccs.XInt;
import edu.neu.ccs.XLong;
import edu.neu.ccs.XShort;
import edu.neu.ccs.XString;
import edu.neu.ccs.filter.StringableFilter;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.FocusActionAdapter;
import edu.neu.ccs.gui.Fragile;
import edu.neu.ccs.gui.GeneralView;
import edu.neu.ccs.gui.GeneralViewSupport;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.MalformedDataListener;
import edu.neu.ccs.gui.Refresh;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class TextFieldView
extends JTextField
implements GeneralView,
Fragile,
JPTConstants {
    public static final String PREFERRED_WIDTH = "set.preferred.width";
    public static final String AUTO_SELECT = "auto.select";
    public static final int DEFAULT_WIDTH = 50;
    public static final int EXTRA_WIDTH = 10;
    protected int preferredWidth = 50;
    public static final boolean DEFAULT_AUTOSELECT_POLICY = true;
    protected boolean autoSelect = true;
    protected GeneralViewSupport delegate = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;

    public TextFieldView() {
        this("", null, null, null, null, 0);
    }

    public TextFieldView(int width) {
        this("", null, null, null, null, width);
    }

    public TextFieldView(String text) {
        this(text, null, null, null, null, 0);
    }

    public TextFieldView(String text, int width) {
        this(text, null, null, null, null, width);
    }

    public TextFieldView(String text, String errorPrompt, String dialogTitle) {
        this(text, errorPrompt, dialogTitle, null, null, 0);
    }

    public TextFieldView(String text, String errorPrompt, String dialogTitle, int width) {
        this(text, errorPrompt, dialogTitle, null, null, width);
    }

    public TextFieldView(String text, String errorPrompt, String dialogTitle, String suggestion) {
        this(text, errorPrompt, dialogTitle, suggestion, null, 0);
    }

    public TextFieldView(String text, String errorPrompt, String dialogTitle, String suggestion, int width) {
        this(text, errorPrompt, dialogTitle, suggestion, null, width);
    }

    public TextFieldView(Font font) {
        this("", null, null, null, font, 0);
    }

    public TextFieldView(Font font, int width) {
        this("", null, null, null, font, width);
    }

    public TextFieldView(String text, Font font) {
        this(text, null, null, null, font, 0);
    }

    public TextFieldView(String text, Font font, int width) {
        this(text, null, null, null, font, width);
    }

    public TextFieldView(String text, String errorPrompt, String dialogTitle, Font font) {
        this(text, errorPrompt, dialogTitle, null, font, 0);
    }

    public TextFieldView(String text, String errorPrompt, String dialogTitle, Font font, int width) {
        this(text, errorPrompt, dialogTitle, null, font, width);
    }

    public TextFieldView(String text, String errorPrompt, String dialogTitle, String suggestion, Font font) {
        this(text, errorPrompt, dialogTitle, suggestion, font, 0);
    }

    public TextFieldView(String text, String errorPrompt, String dialogTitle, String suggestion, Font font, int width) {
        super(text);
        this.initialize(errorPrompt, dialogTitle, suggestion, font, width);
    }

    public TextFieldView(Document document) {
        this(document, null, null, null, 0);
    }

    public TextFieldView(Document document, int width) {
        this(document, null, null, null, width);
    }

    public TextFieldView(Document document, String errorPrompt, String dialogTitle) {
        this(document, errorPrompt, dialogTitle, null, 0);
    }

    public TextFieldView(Document document, String errorPrompt, String dialogTitle, int width) {
        this(document, errorPrompt, dialogTitle, null, width);
    }

    public TextFieldView(Document document, String errorPrompt, String dialogTitle, String suggestion) {
        this(document, errorPrompt, dialogTitle, suggestion, 0);
    }

    public TextFieldView(Document document, String errorPrompt, String dialogTitle, String suggestion, int width) {
        super(document, null, 0);
        this.initialize(errorPrompt, dialogTitle, suggestion, null, width);
    }

    private void initialize(String errorPrompt, String dialogTitle, String suggestion, Font font, int width) {
        this.delegate = new GeneralViewSupport(this, this.listenerList, null, errorPrompt, dialogTitle, suggestion);
        String text = this.getText();
        this.setDefaultViewState(text);
        if (font != null) {
            super.setFont(font);
        }
        this.setPreferredWidth(width, text);
        this.installFocusActions();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int width = this.getPreferredWidth();
        if (width > 0) {
            dimension.width = width;
        }
        return dimension;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(int width) {
        int oldWidth = this.getPreferredWidth();
        this.preferredWidth = width < 0 ? -1 : (width == 0 ? 50 : width);
        this.refreshComponent();
        if (this.preferredWidth != oldWidth) {
            this.firePropertyChange(PREFERRED_WIDTH, oldWidth, this.preferredWidth);
        }
    }

    public void setPreferredWidth(int minWidth, String sample) {
        if (sample == null || sample.length() == 0) {
            this.setPreferredWidth(minWidth);
        } else {
            if (minWidth == 0) {
                minWidth = 50;
            }
            int width = TextFieldView.getSampleWidth(this.getFont(), sample);
            this.setPreferredWidth(Math.max(minWidth, width));
        }
    }

    public static int getSampleWidth(int N, char c) {
        if (N <= 0) {
            return 0;
        }
        StringBuffer buffer = new StringBuffer(N);
        int i = 0;
        while (i < N) {
            buffer.append(c);
            ++i;
        }
        String sample = buffer.toString();
        return TextFieldView.getSampleWidth(null, sample);
    }

    public static int getSampleWidth(String sample) {
        return TextFieldView.getSampleWidth(null, sample);
    }

    public static int getSampleWidth(Font font, String sample) {
        if (sample == null || sample.length() == 0) {
            return 0;
        }
        JLabel test = new JLabel(sample);
        if (font != null) {
            test.setFont(font);
        }
        Dimension dimension = test.getPreferredSize();
        return dimension.width + 10;
    }

    public static int getWidthEstimate(String[] strings) {
        return TextFieldView.getWidthEstimate(null, strings);
    }

    public static int getWidthEstimate(Font font, String[] strings) {
        int width = 0;
        if (strings == null) {
            return width;
        }
        int length = strings.length;
        int i = 0;
        while (i < length) {
            width = Math.max(width, TextFieldView.getSampleWidth(font, strings[i]));
            ++i;
        }
        return width;
    }

    public void setFont(Font font) {
        if (font == null) {
            font = TextFieldView.getDefaultFont();
        }
        super.setFont(font);
        this.refreshComponent();
        this.firePropertyChange("set.font", null, null);
    }

    public static Font getDefaultFont() {
        return new JTextField(" ").getFont();
    }

    public void refreshComponent() {
        Refresh.packParentWindow(this);
    }

    public void setAutoSelect(boolean b) {
        boolean oldAuto = this.getAutoSelect();
        this.autoSelect = b;
        if (this.getAutoSelect() != oldAuto) {
            this.firePropertyChange(AUTO_SELECT, oldAuto, this.getAutoSelect());
        }
    }

    public boolean getAutoSelect() {
        return this.autoSelect;
    }

    public GeneralView makeCopy() {
        TextFieldView copy = new TextFieldView();
        copy.setFont(this.getFont());
        copy.setPreferredWidth(this.getPreferredWidth());
        copy.setDataType(this.getDataType());
        copy.setViewState(this.getViewState());
        copy.setDefaultViewState(this.getDefaultViewState());
        copy.setInputProperties(new InputProperties(this.getInputProperties()));
        copy.setFilter(this.getFilter());
        copy.setAutoSelect(this.getAutoSelect());
        return copy;
    }

    public void setDataType(Class dataType) {
        this.delegate.setDataType(dataType);
    }

    public Class getDataType() {
        return this.delegate.getDataType();
    }

    public void setFilter(StringableFilter filter) {
        this.delegate.setFilter(filter);
    }

    public StringableFilter getFilter() {
        return this.delegate.getFilter();
    }

    public Stringable demandObject() {
        return this.delegate.demandObject();
    }

    public Stringable requestObject() throws CancelledException {
        return this.delegate.requestObject();
    }

    public Stringable demandObject(StringableFilter filter) {
        return this.delegate.demandObject(filter);
    }

    public Stringable requestObject(StringableFilter filter) throws CancelledException {
        return this.delegate.requestObject(filter);
    }

    public Stringable demandObject(Class dataType, StringableFilter filter) {
        return this.delegate.demandObject(dataType, filter);
    }

    public Stringable requestObject(Class dataType, StringableFilter filter) throws CancelledException {
        return this.delegate.requestObject(dataType, filter);
    }

    public void setInputProperties(InputProperties properties) {
        this.delegate.setInputProperties(properties);
    }

    public InputProperties getInputProperties() {
        return this.delegate.getInputProperties();
    }

    public void setErrorPromptTitleSuggestion(String errorPrompt, String dialogTitle, String suggestion) {
        this.delegate.setErrorPromptTitleSuggestion(errorPrompt, dialogTitle, suggestion);
    }

    public void setViewState(String data) {
        String oldData = this.getText();
        if (data == null) {
            data = "";
        }
        this.setText(data);
        this.firePropertyChange("view.state", oldData, data);
    }

    public String getViewState() {
        return this.getText();
    }

    public void setDefaultViewState(String data) {
        this.delegate.setDefaultViewState(data);
    }

    public String getDefaultViewState() {
        return this.delegate.getDefaultViewState();
    }

    public void reset() {
        this.delegate.reset();
    }

    public void addMalformedDataListener(MalformedDataListener l) {
        this.delegate.addMalformedDataListener(l);
    }

    public void removeMalformedDataListener(MalformedDataListener l) {
        this.delegate.removeMalformedDataListener(l);
    }

    public byte demandByte() {
        return this.demandByte(null);
    }

    public byte demandByte(StringableFilter f) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.neu.ccs.XByte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XByte object = (XByte)this.demandObject(clazz, f);
        return object.getValue();
    }

    public byte demandByteAsHex() {
        return this.demandByteAsHex(null);
    }

    public byte demandByteAsHex(StringableFilter f) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.neu.ccs.HexXByte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HexXByte object = (HexXByte)this.demandObject(clazz, f);
        return object.getValue();
    }

    public byte requestByte() throws CancelledException {
        return this.requestByte(null);
    }

    public byte requestByte(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.neu.ccs.XByte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XByte object = (XByte)this.requestObject(clazz, f);
        return object.getValue();
    }

    public byte requestByteAsHex() throws CancelledException {
        return this.requestByteAsHex(null);
    }

    public byte requestByteAsHex(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.neu.ccs.HexXByte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HexXByte object = (HexXByte)this.requestObject(clazz, f);
        return object.getValue();
    }

    public short demandShort() {
        return this.demandShort(null);
    }

    public short demandShort(StringableFilter f) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("edu.neu.ccs.XShort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XShort object = (XShort)this.demandObject(clazz, f);
        return object.getValue();
    }

    public short demandShortAsHex() {
        return this.demandShortAsHex(null);
    }

    public short demandShortAsHex(StringableFilter f) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("edu.neu.ccs.HexXShort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HexXShort object = (HexXShort)this.demandObject(clazz, f);
        return object.getValue();
    }

    public short requestShort() throws CancelledException {
        return this.requestShort(null);
    }

    public short requestShort(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("edu.neu.ccs.XShort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XShort object = (XShort)this.requestObject(clazz, f);
        return object.getValue();
    }

    public short requestShortAsHex() throws CancelledException {
        return this.requestShortAsHex(null);
    }

    public short requestShortAsHex(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("edu.neu.ccs.HexXShort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HexXShort object = (HexXShort)this.requestObject(clazz, f);
        return object.getValue();
    }

    public int demandInt() {
        return this.demandInt(null);
    }

    public int demandInt(StringableFilter f) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("edu.neu.ccs.XInt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XInt object = (XInt)this.demandObject(clazz, f);
        return object.getValue();
    }

    public int demandIntAsHex() {
        return this.demandIntAsHex(null);
    }

    public int demandIntAsHex(StringableFilter f) {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("edu.neu.ccs.HexXInt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HexXInt object = (HexXInt)this.demandObject(clazz, f);
        return object.getValue();
    }

    public int requestInt() throws CancelledException {
        return this.requestInt(null);
    }

    public int requestInt(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("edu.neu.ccs.XInt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XInt object = (XInt)this.requestObject(clazz, f);
        return object.getValue();
    }

    public int requestIntAsHex() throws CancelledException {
        return this.requestIntAsHex(null);
    }

    public int requestIntAsHex(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("edu.neu.ccs.HexXInt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HexXInt object = (HexXInt)this.requestObject(clazz, f);
        return object.getValue();
    }

    public long demandLong() {
        return this.demandLong(null);
    }

    public long demandLong(StringableFilter f) {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("edu.neu.ccs.XLong");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XLong object = (XLong)this.demandObject(clazz, f);
        return object.getValue();
    }

    public long demandLongAsHex() {
        return this.demandLongAsHex(null);
    }

    public long demandLongAsHex(StringableFilter f) {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("edu.neu.ccs.HexXLong");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HexXLong object = (HexXLong)this.demandObject(clazz, f);
        return object.getValue();
    }

    public long requestLong() throws CancelledException {
        return this.requestLong(null);
    }

    public long requestLong(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("edu.neu.ccs.XLong");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XLong object = (XLong)this.requestObject(clazz, f);
        return object.getValue();
    }

    public long requestLongAsHex() throws CancelledException {
        return this.requestLongAsHex(null);
    }

    public long requestLongAsHex(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("edu.neu.ccs.HexXLong");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HexXLong object = (HexXLong)this.requestObject(clazz, f);
        return object.getValue();
    }

    public float demandFloat() {
        return this.demandFloat(null);
    }

    public float demandFloat(StringableFilter f) {
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("edu.neu.ccs.XFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XFloat object = (XFloat)this.demandObject(clazz, f);
        return object.getValue();
    }

    public float demandFloatAsHex() {
        return this.demandFloatAsHex(null);
    }

    public float demandFloatAsHex(StringableFilter f) {
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("edu.neu.ccs.HexXFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HexXFloat object = (HexXFloat)this.demandObject(clazz, f);
        return object.getValue();
    }

    public float requestFloat() throws CancelledException {
        return this.requestFloat(null);
    }

    public float requestFloat(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("edu.neu.ccs.XFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XFloat object = (XFloat)this.requestObject(clazz, f);
        return object.getValue();
    }

    public float requestFloatAsHex() throws CancelledException {
        return this.requestFloatAsHex(null);
    }

    public float requestFloatAsHex(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("edu.neu.ccs.HexXFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HexXFloat object = (HexXFloat)this.requestObject(clazz, f);
        return object.getValue();
    }

    public double demandDouble() {
        return this.demandDouble(null);
    }

    public double demandDouble(StringableFilter f) {
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("edu.neu.ccs.XDouble");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XDouble object = (XDouble)this.demandObject(clazz, f);
        return object.getValue();
    }

    public double demandDoubleAsHex() {
        return this.demandDoubleAsHex(null);
    }

    public double demandDoubleAsHex(StringableFilter f) {
        Class<?> clazz = class$11;
        if (clazz == null) {
            try {
                clazz = class$11 = Class.forName("edu.neu.ccs.HexXDouble");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HexXDouble object = (HexXDouble)this.demandObject(clazz, f);
        return object.getValue();
    }

    public double requestDouble() throws CancelledException {
        return this.requestDouble(null);
    }

    public double requestDouble(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("edu.neu.ccs.XDouble");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XDouble object = (XDouble)this.requestObject(clazz, f);
        return object.getValue();
    }

    public double requestDoubleAsHex() throws CancelledException {
        return this.requestDoubleAsHex(null);
    }

    public double requestDoubleAsHex(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$11;
        if (clazz == null) {
            try {
                clazz = class$11 = Class.forName("edu.neu.ccs.HexXDouble");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HexXDouble object = (HexXDouble)this.requestObject(clazz, f);
        return object.getValue();
    }

    public char demandChar() {
        return this.demandChar(null);
    }

    public char demandChar(StringableFilter f) {
        Class<?> clazz = class$12;
        if (clazz == null) {
            try {
                clazz = class$12 = Class.forName("edu.neu.ccs.XChar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XChar object = (XChar)this.demandObject(clazz, f);
        return object.getValue();
    }

    public char requestChar() throws CancelledException {
        return this.requestChar(null);
    }

    public char requestChar(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$12;
        if (clazz == null) {
            try {
                clazz = class$12 = Class.forName("edu.neu.ccs.XChar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XChar object = (XChar)this.requestObject(clazz, f);
        return object.getValue();
    }

    public boolean demandBoolean() {
        return this.demandBoolean(null);
    }

    public boolean demandBoolean(StringableFilter f) {
        Class<?> clazz = class$13;
        if (clazz == null) {
            try {
                clazz = class$13 = Class.forName("edu.neu.ccs.XBoolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XBoolean object = (XBoolean)this.demandObject(clazz, f);
        return object.getValue();
    }

    public boolean requestBoolean() throws CancelledException {
        return this.requestBoolean(null);
    }

    public boolean requestBoolean(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$13;
        if (clazz == null) {
            try {
                clazz = class$13 = Class.forName("edu.neu.ccs.XBoolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XBoolean object = (XBoolean)this.requestObject(clazz, f);
        return object.getValue();
    }

    public String demandString() {
        return this.demandString(null);
    }

    public String demandString(StringableFilter f) {
        Class<?> clazz = class$14;
        if (clazz == null) {
            try {
                clazz = class$14 = Class.forName("edu.neu.ccs.XString");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XString object = (XString)this.demandObject(clazz, f);
        return object.getValue();
    }

    public String requestString() throws CancelledException {
        return this.requestString(null);
    }

    public String requestString(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$14;
        if (clazz == null) {
            try {
                clazz = class$14 = Class.forName("edu.neu.ccs.XString");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XString object = (XString)this.requestObject(clazz, f);
        return object.getValue();
    }

    public Color demandColor() {
        return this.demandColor(null);
    }

    public Color demandColor(StringableFilter f) {
        Class<?> clazz = class$15;
        if (clazz == null) {
            try {
                clazz = class$15 = Class.forName("edu.neu.ccs.XColor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XColor object = (XColor)this.demandObject(clazz, f);
        return object.getValue();
    }

    public Color requestColor() throws CancelledException {
        return this.requestColor(null);
    }

    public Color requestColor(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$15;
        if (clazz == null) {
            try {
                clazz = class$15 = Class.forName("edu.neu.ccs.XColor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XColor object = (XColor)this.requestObject(clazz, f);
        return object.getValue();
    }

    public BigInteger demandBigInteger() {
        return this.demandBigInteger(null);
    }

    public BigInteger demandBigInteger(StringableFilter f) {
        Class<?> clazz = class$16;
        if (clazz == null) {
            try {
                clazz = class$16 = Class.forName("edu.neu.ccs.XBigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XBigInteger object = (XBigInteger)this.demandObject(clazz, f);
        return object.getValue();
    }

    public BigInteger requestBigInteger() throws CancelledException {
        return this.requestBigInteger(null);
    }

    public BigInteger requestBigInteger(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$16;
        if (clazz == null) {
            try {
                clazz = class$16 = Class.forName("edu.neu.ccs.XBigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XBigInteger object = (XBigInteger)this.requestObject(clazz, f);
        return object.getValue();
    }

    public BigDecimal demandBigDecimal() {
        return this.demandBigDecimal(null);
    }

    public BigDecimal demandBigDecimal(StringableFilter f) {
        Class<?> clazz = class$17;
        if (clazz == null) {
            try {
                clazz = class$17 = Class.forName("edu.neu.ccs.XBigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XBigDecimal object = (XBigDecimal)this.demandObject(clazz, f);
        return object.getValue();
    }

    public BigDecimal requestBigDecimal() throws CancelledException {
        return this.requestBigDecimal(null);
    }

    public BigDecimal requestBigDecimal(StringableFilter f) throws CancelledException {
        Class<?> clazz = class$17;
        if (clazz == null) {
            try {
                clazz = class$17 = Class.forName("edu.neu.ccs.XBigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XBigDecimal object = (XBigDecimal)this.requestObject(clazz, f);
        return object.getValue();
    }

    protected void installFocusActions() {
        FocusActionAdapter adapter = new FocusActionAdapter();
        adapter.addFocusGainedAction(new SimpleAction(){

            public void perform() {
                if (TextFieldView.this.getAutoSelect()) {
                    TextFieldView.this.selectAll();
                }
            }
        });
        this.addFocusListener(adapter);
    }
}

