/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.TextPaintable;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;

public class TextAnchor {
    static final FontRenderContext standardFRC = TextPaintable.standardFRC;
    public static final XLocator LEFT = new XLocator(){

        public float getLeftX(String string, Font font, float anchorX) {
            return anchorX;
        }

        public float getRightX(String string, Font font, float anchorX) {
            if (string == null || font == null) {
                return anchorX;
            }
            Rectangle2D bounds = font.getStringBounds(string, standardFRC);
            return anchorX + (float)bounds.getWidth();
        }

        public float getCenterX(String string, Font font, float anchorX) {
            if (string == null || font == null) {
                return anchorX;
            }
            Rectangle2D bounds = font.getStringBounds(string, standardFRC);
            return anchorX + (float)(bounds.getWidth() / 2.0);
        }
    };
    public static final XLocator RIGHT = new XLocator(){

        public float getLeftX(String string, Font font, float anchorX) {
            if (string == null || font == null) {
                return anchorX;
            }
            Rectangle2D bounds = font.getStringBounds(string, standardFRC);
            return anchorX - (float)bounds.getWidth();
        }

        public float getRightX(String string, Font font, float anchorX) {
            return anchorX;
        }

        public float getCenterX(String string, Font font, float anchorX) {
            if (string == null || font == null) {
                return anchorX;
            }
            Rectangle2D bounds = font.getStringBounds(string, standardFRC);
            return anchorX - (float)(bounds.getWidth() / 2.0);
        }
    };
    public static final XLocator CENTER = new XLocator(){

        public float getLeftX(String string, Font font, float anchorX) {
            if (string == null || font == null) {
                return anchorX;
            }
            Rectangle2D bounds = font.getStringBounds(string, standardFRC);
            return anchorX - (float)(bounds.getWidth() / 2.0);
        }

        public float getRightX(String string, Font font, float anchorX) {
            if (string == null || font == null) {
                return anchorX;
            }
            Rectangle2D bounds = font.getStringBounds(string, standardFRC);
            return anchorX + (float)(bounds.getWidth() / 2.0);
        }

        public float getCenterX(String string, Font font, float anchorX) {
            return anchorX;
        }
    };
    public static final YLocator BASELINE = new YLocator(){

        public float getBaseLineY(String string, Font font, float anchorY) {
            return anchorY;
        }

        public float getAscentLineY(String string, Font font, float anchorY) {
            if (string == null || font == null) {
                return anchorY;
            }
            LineMetrics metrics = font.getLineMetrics(string, standardFRC);
            return anchorY - metrics.getAscent();
        }

        public float getDescentLineY(String string, Font font, float anchorY) {
            if (string == null || font == null) {
                return anchorY;
            }
            LineMetrics metrics = font.getLineMetrics(string, standardFRC);
            return anchorY + metrics.getDescent();
        }

        public float getLeadingLineY(String string, Font font, float anchorY) {
            if (string == null || font == null) {
                return anchorY;
            }
            LineMetrics metrics = font.getLineMetrics(string, standardFRC);
            return anchorY + metrics.getDescent() + metrics.getLeading();
        }
    };
    public static final YLocator ASCENTLINE = new YLocator(){

        public float getBaseLineY(String string, Font font, float anchorY) {
            if (string == null || font == null) {
                return anchorY;
            }
            LineMetrics metrics = font.getLineMetrics(string, standardFRC);
            return anchorY + metrics.getAscent();
        }

        public float getAscentLineY(String string, Font font, float anchorY) {
            return anchorY;
        }

        public float getDescentLineY(String string, Font font, float anchorY) {
            if (string == null || font == null) {
                return anchorY;
            }
            LineMetrics metrics = font.getLineMetrics(string, standardFRC);
            return anchorY + metrics.getAscent() + metrics.getDescent();
        }

        public float getLeadingLineY(String string, Font font, float anchorY) {
            if (string == null || font == null) {
                return anchorY;
            }
            LineMetrics metrics = font.getLineMetrics(string, standardFRC);
            return anchorY + metrics.getAscent() + metrics.getDescent() + metrics.getLeading();
        }
    };
    public static final YLocator DESCENTLINE = new YLocator(){

        public float getBaseLineY(String string, Font font, float anchorY) {
            if (string == null || font == null) {
                return anchorY;
            }
            LineMetrics metrics = font.getLineMetrics(string, standardFRC);
            return anchorY - metrics.getDescent();
        }

        public float getAscentLineY(String string, Font font, float anchorY) {
            if (string == null || font == null) {
                return anchorY;
            }
            LineMetrics metrics = font.getLineMetrics(string, standardFRC);
            return anchorY - metrics.getDescent() - metrics.getAscent();
        }

        public float getDescentLineY(String string, Font font, float anchorY) {
            return anchorY;
        }

        public float getLeadingLineY(String string, Font font, float anchorY) {
            if (string == null || font == null) {
                return anchorY;
            }
            LineMetrics metrics = font.getLineMetrics(string, standardFRC);
            return anchorY + metrics.getLeading();
        }
    };
    public static final YLocator LEADINGLINE = new YLocator(){

        public float getBaseLineY(String string, Font font, float anchorY) {
            if (string == null || font == null) {
                return anchorY;
            }
            LineMetrics metrics = font.getLineMetrics(string, standardFRC);
            return anchorY - metrics.getLeading() - metrics.getDescent();
        }

        public float getAscentLineY(String string, Font font, float anchorY) {
            if (string == null || font == null) {
                return anchorY;
            }
            LineMetrics metrics = font.getLineMetrics(string, standardFRC);
            return anchorY - metrics.getLeading() - metrics.getDescent() - metrics.getAscent();
        }

        public float getDescentLineY(String string, Font font, float anchorY) {
            if (string == null || font == null) {
                return anchorY;
            }
            LineMetrics metrics = font.getLineMetrics(string, standardFRC);
            return anchorY - metrics.getLeading();
        }

        public float getLeadingLineY(String string, Font font, float anchorY) {
            return anchorY;
        }
    };
    public static final Locator LEFT_BASELINE = TextAnchor.makeLocator(LEFT, BASELINE);
    public static final Locator RIGHT_BASELINE = TextAnchor.makeLocator(RIGHT, BASELINE);
    public static final Locator CENTER_BASELINE = TextAnchor.makeLocator(CENTER, BASELINE);
    public static final Locator LEFT_ASCENTLINE = TextAnchor.makeLocator(LEFT, ASCENTLINE);
    public static final Locator RIGHT_ASCENTLINE = TextAnchor.makeLocator(RIGHT, ASCENTLINE);
    public static final Locator CENTER_ASCENTLINE = TextAnchor.makeLocator(CENTER, ASCENTLINE);
    public static final Locator LEFT_DESCENTLINE = TextAnchor.makeLocator(LEFT, DESCENTLINE);
    public static final Locator RIGHT_DESCENTLINE = TextAnchor.makeLocator(RIGHT, DESCENTLINE);
    public static final Locator CENTER_DESCENTLINE = TextAnchor.makeLocator(CENTER, DESCENTLINE);
    public static final Locator LEFT_LEADINGLINE = TextAnchor.makeLocator(LEFT, LEADINGLINE);
    public static final Locator RIGHT_LEADINGLINE = TextAnchor.makeLocator(RIGHT, LEADINGLINE);
    public static final Locator CENTER_LEADINGLINE = TextAnchor.makeLocator(CENTER, LEADINGLINE);

    private TextAnchor() {
    }

    public static Locator makeLocator(final XLocator xlocator, final YLocator ylocator) {
        return new Locator(){

            public float getLeftX(String string, Font font, float anchorX) {
                return xlocator.getLeftX(string, font, anchorX);
            }

            public float getRightX(String string, Font font, float anchorX) {
                return xlocator.getRightX(string, font, anchorX);
            }

            public float getCenterX(String string, Font font, float anchorX) {
                return xlocator.getCenterX(string, font, anchorX);
            }

            public float getBaseLineY(String string, Font font, float anchorY) {
                return ylocator.getBaseLineY(string, font, anchorY);
            }

            public float getAscentLineY(String string, Font font, float anchorY) {
                return ylocator.getAscentLineY(string, font, anchorY);
            }

            public float getDescentLineY(String string, Font font, float anchorY) {
                return ylocator.getDescentLineY(string, font, anchorY);
            }

            public float getLeadingLineY(String string, Font font, float anchorY) {
                return ylocator.getLeadingLineY(string, font, anchorY);
            }

            public float getWidth(String string, Font font, float anchorX) {
                return this.getRightX(string, font, anchorX) - this.getLeftX(string, font, anchorX);
            }

            public float getHeight(String string, Font font, float anchorY) {
                return this.getLeadingLineY(string, font, anchorY) - this.getAscentLineY(string, font, anchorY);
            }

            public XRect getBounds2D(String string, Font font, float anchorX, float anchorY) {
                double x = this.getLeftX(string, font, anchorX);
                double y = this.getAscentLineY(string, font, anchorY);
                double w = (double)this.getRightX(string, font, anchorX) - x;
                double h = (double)this.getLeadingLineY(string, font, anchorY) - y;
                return new XRect(x, y, w, h);
            }

            public XPoint2D getCenter(String string, Font font, float anchorX, float anchorY) {
                double x = this.getCenterX(string, font, anchorX);
                double y = this.getBaseLineY(string, font, anchorY);
                return new XPoint2D(x, y);
            }
        };
    }

    public static interface XLocator {
        public float getLeftX(String var1, Font var2, float var3);

        public float getRightX(String var1, Font var2, float var3);

        public float getCenterX(String var1, Font var2, float var3);
    }

    public static interface YLocator {
        public float getBaseLineY(String var1, Font var2, float var3);

        public float getAscentLineY(String var1, Font var2, float var3);

        public float getDescentLineY(String var1, Font var2, float var3);

        public float getLeadingLineY(String var1, Font var2, float var3);
    }

    public static interface Locator {
        public float getLeftX(String var1, Font var2, float var3);

        public float getRightX(String var1, Font var2, float var3);

        public float getCenterX(String var1, Font var2, float var3);

        public float getBaseLineY(String var1, Font var2, float var3);

        public float getAscentLineY(String var1, Font var2, float var3);

        public float getDescentLineY(String var1, Font var2, float var3);

        public float getLeadingLineY(String var1, Font var2, float var3);

        public float getWidth(String var1, Font var2, float var3);

        public float getHeight(String var1, Font var2, float var3);

        public XRect getBounds2D(String var1, Font var2, float var3, float var4);

        public XPoint2D getCenter(String var1, Font var2, float var3, float var4);
    }
}

