/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.util.FloatArray;

public class Tangent {
    private static final int minTerms = 1;
    private static final int maxTerms = 7;
    private static final Strategy standardBezierStrategy = Tangent.bezierStrategy(7);

    private Tangent() {
    }

    public static Strategy bezierStrategy() {
        return standardBezierStrategy;
    }

    public static Strategy bezierStrategy(int terms) {
        final int t = terms < 1 ? 1 : terms;
        return new Strategy(){

            public float[][] makeTangents(float[][] vertex) {
                return Tangent.bezierTangents(vertex, t);
            }

            public float[][] makeTangents(float[][] vertex, float[][] endTangent) {
                return Tangent.bezierTangents(vertex, endTangent, t);
            }
        };
    }

    public static float[][] bezierTangents(float[][] vertex, int terms) {
        if (!FloatArray.checkArray(vertex, 2)) {
            return new float[0][2];
        }
        int N = vertex.length;
        float[][] tangent = new float[N][2];
        if (N <= 2) {
            return tangent;
        }
        float[] a = Tangent.bezierCoefficients(N, terms);
        int m = a.length - 1;
        int i = 0;
        while (i < N) {
            int k = 1;
            while (k <= m) {
                int r = i + k;
                int s = i - k;
                if (r >= N) {
                    r -= N;
                }
                if (s < 0) {
                    s += N;
                }
                float[] fArray = tangent[i];
                fArray[0] = fArray[0] + a[k] * (vertex[r][0] - vertex[s][0]);
                float[] fArray2 = tangent[i];
                fArray2[1] = fArray2[1] + a[k] * (vertex[r][1] - vertex[s][1]);
                ++k;
            }
            ++i;
        }
        return tangent;
    }

    public static float[][] bezierTangents(float[][] vertex, float[][] endTangent, int terms) {
        if (!FloatArray.checkArray(endTangent, 2) || endTangent.length != 2) {
            return Tangent.bezierTangents(vertex, terms);
        }
        if (!FloatArray.checkArray(vertex, 2)) {
            return new float[0][2];
        }
        int N = vertex.length;
        int M = N - 1;
        float[][] tangent = new float[N][2];
        if (N > 0) {
            tangent[0][0] = endTangent[0][0];
            tangent[0][1] = endTangent[0][1];
        }
        if (N > 1) {
            tangent[M][0] = endTangent[1][0];
            tangent[M][1] = endTangent[1][1];
        }
        if (N <= 2) {
            return tangent;
        }
        float[][] v = FloatArray.deepclone(vertex);
        v[0][0] = vertex[0][0] + tangent[0][0];
        v[0][1] = vertex[0][1] + tangent[0][1];
        v[M][0] = vertex[M][0] - tangent[M][0];
        v[M][1] = vertex[M][1] - tangent[M][1];
        int Z = 2 * M;
        float[] a = Tangent.bezierCoefficients(Z, terms);
        int m = a.length - 1;
        int i = 1;
        while (i < M) {
            int k = 1;
            while (k <= m) {
                int r = i + k;
                int s = i - k;
                if (r >= N) {
                    r = Z - r;
                }
                if (s < 0) {
                    s = -s;
                }
                float[] fArray = tangent[i];
                fArray[0] = fArray[0] + a[k] * (v[r][0] - v[s][0]);
                float[] fArray2 = tangent[i];
                fArray2[1] = fArray2[1] + a[k] * (v[r][1] - v[s][1]);
                ++k;
            }
            ++i;
        }
        return tangent;
    }

    public static float[] bezierCoefficients(int N, int terms) {
        if (N <= 2) {
            return new float[0];
        }
        int m = (N - 1) / 2;
        if (terms < 1) {
            terms = 1;
        }
        if (m > terms) {
            m = terms;
        }
        float[] a = new float[m + 1];
        float[] h = new float[m + 1];
        h[0] = 1.0f;
        h[1] = N % 2 == 1 ? -3 : -4;
        int i = 2;
        while (i <= m) {
            h[i] = -4.0f * h[i - 1] - h[i - 2];
            ++i;
        }
        int k = 1;
        while (k <= m) {
            a[k] = -h[m - k] / h[m];
            ++k;
        }
        return a;
    }

    public static Strategy chordStrategy(final float factor) {
        return new Strategy(){

            public float[][] makeTangents(float[][] vertex) {
                return Tangent.chordTangents(vertex, factor);
            }

            public float[][] makeTangents(float[][] vertex, float[][] endTangent) {
                return Tangent.chordTangents(vertex, endTangent, factor);
            }
        };
    }

    public static float[][] chordTangents(float[][] vertex, float factor) {
        if (!FloatArray.checkArray(vertex, 2)) {
            return new float[0][2];
        }
        int N = vertex.length;
        float[][] tangent = new float[N][2];
        if (N <= 2) {
            return tangent;
        }
        int i = 0;
        while (i < N) {
            int r = i + 1;
            int s = i - 1;
            if (r >= N) {
                r -= N;
            }
            if (s < 0) {
                s += N;
            }
            tangent[i][0] = factor * (vertex[r][0] - vertex[s][0]);
            tangent[i][1] = factor * (vertex[r][1] - vertex[s][1]);
            ++i;
        }
        return tangent;
    }

    public static float[][] chordTangents(float[][] vertex, float[][] endTangent, float factor) {
        if (!FloatArray.checkArray(endTangent, 2) || endTangent.length != 2) {
            return Tangent.chordTangents(vertex, factor);
        }
        if (!FloatArray.checkArray(vertex, 2)) {
            return new float[0][2];
        }
        int N = vertex.length;
        int M = N - 1;
        float[][] tangent = new float[N][2];
        if (N > 0) {
            tangent[0][0] = endTangent[0][0];
            tangent[0][1] = endTangent[0][1];
        }
        if (N > 1) {
            tangent[M][0] = endTangent[1][0];
            tangent[M][1] = endTangent[1][1];
        }
        if (N <= 2) {
            return tangent;
        }
        int i = 1;
        while (i < M) {
            int r = i + 1;
            int s = i - 1;
            tangent[i][0] = factor * (vertex[r][0] - vertex[s][0]);
            tangent[i][1] = factor * (vertex[r][1] - vertex[s][1]);
            ++i;
        }
        return tangent;
    }

    public static interface Strategy {
        public float[][] makeTangents(float[][] var1);

        public float[][] makeTangents(float[][] var1, float[][] var2);
    }
}

