/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.CellPosition;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.TableGenerator;
import edu.neu.ccs.gui.TableLayout;
import edu.neu.ccs.util.DimensionUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;

public class TablePanel
extends DisplayPanel {
    public static final int DEFAULT_ALIGNMENT = 6;
    public static final int DEFAULT_ORIENTATION = 0;
    protected TableGenerator tg = null;

    public TablePanel() {
        this(1, 1, 0, 0, 6);
    }

    public TablePanel(int align) {
        this(1, 1, 0, 0, align);
    }

    public TablePanel(int rows, int cols) {
        this(rows, cols, 0, 0, 6);
    }

    public TablePanel(int rows, int cols, int align) {
        this(rows, cols, 0, 0, align);
    }

    public TablePanel(int rows, int cols, int hgap, int vgap) {
        this(rows, cols, hgap, vgap, 6);
    }

    public TablePanel(int rows, int cols, int hgap, int vgap, int align) {
        this(rows, cols, hgap, vgap, align, 0);
    }

    public TablePanel(int rows, int cols, int hgap, int vgap, int align, int orientation) {
        super.setLayout(new TableLayout(rows, cols, hgap, vgap, align, orientation));
        this.resetPreferredSize();
    }

    public TablePanel(Object[] contents, int orientation) {
        this(contents, orientation, 0, 0, 6);
    }

    public TablePanel(Object[] contents, int orientation, int align) {
        this(contents, orientation, 0, 0, align);
    }

    public TablePanel(Object[] contents, int orientation, int hgap, int vgap) {
        this(contents, orientation, hgap, vgap, 6);
    }

    public TablePanel(Object[] contents, int orientation, int hgap, int vgap, int align) {
        if (contents == null || contents.length == 0) {
            super.setLayout(new TableLayout(1, 1, hgap, vgap, align, orientation));
            return;
        }
        int length = contents.length;
        if (orientation == 1) {
            super.setLayout(new TableLayout(length, 1, hgap, vgap, align, orientation));
            int row = 0;
            while (row < length) {
                this.addObject(contents[row], row, 0);
                ++row;
            }
        } else {
            super.setLayout(new TableLayout(1, length, hgap, vgap, align, orientation));
            int col = 0;
            while (col < length) {
                this.addObject(contents[col], 0, col);
                ++col;
            }
        }
        this.resetPreferredSize();
    }

    public TablePanel(Object[][] contents) {
        this(contents, 0, 0, 6);
    }

    public TablePanel(Object[][] contents, int align) {
        this(contents, 0, 0, align);
    }

    public TablePanel(Object[][] contents, int hgap, int vgap) {
        this(contents, hgap, vgap, 6);
    }

    public TablePanel(Object[][] contents, int hgap, int vgap, int align) {
        if (contents == null || contents.length == 0) {
            super.setLayout(new TableLayout(1, 1, hgap, vgap, align, 1));
            return;
        }
        int rows = contents.length;
        int cols = 0;
        int row = 0;
        while (row < rows) {
            if (contents[row] != null) {
                cols = Math.max(cols, contents[row].length);
            }
            ++row;
        }
        if (cols == 0) {
            super.setLayout(new TableLayout(1, 1, hgap, vgap, align, 1));
            return;
        }
        super.setLayout(new TableLayout(rows, cols, hgap, vgap, align, 1));
        row = 0;
        while (row < rows) {
            if (contents[row] != null) {
                cols = contents[row].length;
                int col = 0;
                while (col < cols) {
                    this.addObject(contents[row][col], row, col);
                    ++col;
                }
            }
            ++row;
        }
        this.resetPreferredSize();
    }

    public TablePanel(TableGenerator tg, int rows, int cols) {
        this(tg, rows, cols, 0, 0, 6);
    }

    public TablePanel(TableGenerator tg, int rows, int cols, int align) {
        this(tg, rows, cols, 0, 0, align);
    }

    public TablePanel(TableGenerator tg, int rows, int cols, int hgap, int vgap) {
        this(tg, rows, cols, hgap, vgap, 6);
    }

    public TablePanel(TableGenerator tg, int rows, int cols, int hgap, int vgap, int align) {
        super.setLayout(new TableLayout(rows, cols, hgap, vgap, align));
        this.tg = tg;
        this.createCells(0, 0, rows, cols);
        this.resetPreferredSize();
    }

    public Component addObject(Object object, int row, int col) {
        return this.addObject(object, new CellPosition(row, col));
    }

    public Component addObject(Object object, CellPosition position) {
        if (position == null) {
            return super.addObject(object);
        }
        Component component = this.getTableEntry(position);
        if (component != null) {
            this.remove(component);
            this.getTableLayout().removeLayoutComponent(position);
        }
        return super.addObject(object, position);
    }

    public Component[][] getComponentTable() {
        return this.getTableLayout().getComponentTable();
    }

    public Component getTableEntry(int row, int col) {
        return this.getTableLayout().getTableEntry(row, col);
    }

    public Component getTableEntry(CellPosition position) {
        return this.getTableLayout().getTableEntry(position);
    }

    public TableGenerator getTableGenerator() {
        return this.tg;
    }

    public void autoEmptyBorder() {
        int vgap = this.getVerticalGap();
        int hgap = this.getHorizontalGap();
        this.emptyBorder(vgap, hgap);
    }

    public void setRows(int rows) {
        int oldRows = this.getRowCount();
        if (rows < 0 || rows == oldRows) {
            return;
        }
        int cols = this.getColumnCount();
        if (oldRows < rows) {
            this.getTableLayout().setRows(rows);
            this.createCells(oldRows, 0, rows, cols);
        } else {
            this.removeCells(rows, 0, oldRows, cols);
            this.getTableLayout().setRows(rows);
        }
        this.resetPreferredSize();
    }

    public void setColumns(int cols) {
        int oldCols = this.getColumnCount();
        if (cols < 0 || cols == oldCols) {
            return;
        }
        int rows = this.getRowCount();
        if (oldCols < cols) {
            this.getTableLayout().setColumns(cols);
            this.createCells(0, oldCols, rows, cols);
        } else {
            this.removeCells(0, cols, rows, oldCols);
            this.getTableLayout().setColumns(cols);
        }
        this.resetPreferredSize();
    }

    public int getRowCount() {
        return this.getTableLayout().getRowCount();
    }

    public int getColumnCount() {
        return this.getTableLayout().getColumnCount();
    }

    public boolean isValidRow(int row) {
        return this.getTableLayout().isValidRow(row);
    }

    public boolean isValidColumn(int col) {
        return this.getTableLayout().isValidColumn(col);
    }

    public boolean isEmptyRow(int row) {
        return this.getTableLayout().isEmptyRow(row);
    }

    public boolean isEmptyColumn(int col) {
        return this.getTableLayout().isEmptyColumn(col);
    }

    public void setHorizontalGap(int hgap) {
        this.getTableLayout().setHorizontalGap(hgap);
        this.resetPreferredSize();
    }

    public int getHorizontalGap() {
        return this.getTableLayout().getHorizontalGap();
    }

    public void setVerticalGap(int vgap) {
        this.getTableLayout().setVerticalGap(vgap);
        this.resetPreferredSize();
    }

    public int getVerticalGap() {
        return this.getTableLayout().getVerticalGap();
    }

    public void setOrientation(int orientation) {
        this.getTableLayout().setOrientation(orientation);
    }

    public int getOrientation() {
        return this.getTableLayout().getOrientation();
    }

    public void setTableAlignment(int align) {
        this.getTableLayout().setTableAlignment(align);
        this.refreshComponent();
    }

    public int getTableAlignment() {
        return this.getTableLayout().getTableAlignment();
    }

    public void setRowAlignment(int row, int align) {
        this.getTableLayout().setRowAlignment(row, align);
        this.refreshComponent();
    }

    public int getRowAlignment(int row) {
        return this.getTableLayout().getRowAlignment(row);
    }

    public void setColumnAlignment(int col, int align) {
        this.getTableLayout().setColumnAlignment(col, align);
        this.refreshComponent();
    }

    public int getColumnAlignment(int col) {
        return this.getTableLayout().getColumnAlignment(col);
    }

    public void setCellAlignment(CellPosition p, int align) {
        if (p != null) {
            this.setCellAlignment(p.row, p.col, align);
        }
    }

    public void setCellAlignment(int row, int col, int align) {
        this.getTableLayout().setCellAlignment(row, col, align);
        this.refreshComponent();
    }

    public int getCellAlignment(CellPosition p) {
        return this.getTableLayout().getCellAlignment(p);
    }

    public int getCellAlignment(int row, int col) {
        return this.getTableLayout().getCellAlignment(row, col);
    }

    public int getEffectiveCellAlignment(CellPosition p) {
        return this.getTableLayout().getEffectiveCellAlignment(p);
    }

    public int getEffectiveCellAlignment(int row, int col) {
        return this.getTableLayout().getEffectiveCellAlignment(row, col);
    }

    public void setMinimumRowHeight(int row, int height) {
        this.getTableLayout().setMinimumRowHeight(row, height);
        this.resetPreferredSize();
    }

    public int getMinimumRowHeight(int row) {
        return this.getTableLayout().getMinimumRowHeight(row);
    }

    public void setMinimumColumnWidth(int col, int width) {
        this.getTableLayout().setMinimumColumnWidth(col, width);
        this.resetPreferredSize();
    }

    public int getMinimumColumnWidth(int col) {
        return this.getTableLayout().getMinimumColumnWidth(col);
    }

    public void setAllMinimumRowHeights(int height) {
        this.getTableLayout().setAllMinimumRowHeights(height);
        this.resetPreferredSize();
    }

    public void setAllMinimumColumnWidths(int width) {
        this.getTableLayout().setAllMinimumColumnWidths(width);
        this.resetPreferredSize();
    }

    public TableLayout getTableLayout() {
        return (TableLayout)this.getLayout();
    }

    public void setLayout(LayoutManager manager) {
    }

    public Dimension getMinimumSize() {
        return this.getTableLayout().minimumLayoutSize(this);
    }

    public Dimension getPreferredSize() {
        return this.getTableLayout().preferredLayoutSize(this);
    }

    public Dimension getMaximumSize() {
        return this.getTableLayout().maximumLayoutSize(this);
    }

    public void uniformizeCellSize() {
        Component[] list = this.getComponents();
        int length = list.length;
        JComponent component = null;
        Dimension d = new Dimension();
        int i = 0;
        while (i < length) {
            if (list[i] instanceof JComponent) {
                component = (JComponent)list[i];
                d = DimensionUtilities.max(d, component.getPreferredSize());
            }
            ++i;
        }
        this.setAllMinimumColumnWidths((int)d.getWidth());
        this.setAllMinimumRowHeights((int)d.getHeight());
    }

    public void uniformizeCellWidth() {
        Component[] list = this.getComponents();
        int length = list.length;
        JComponent component = null;
        Dimension d = null;
        int maxWidth = 0;
        int i = 0;
        while (i < length) {
            if (list[i] instanceof JComponent) {
                component = (JComponent)list[i];
                d = component.getPreferredSize();
                maxWidth = Math.max(maxWidth, (int)d.getWidth());
            }
            ++i;
        }
        this.setAllMinimumColumnWidths(maxWidth);
    }

    public void uniformizeCellHeight() {
        Component[] list = this.getComponents();
        int length = list.length;
        JComponent component = null;
        Dimension d = null;
        int maxHeight = 0;
        int i = 0;
        while (i < length) {
            if (list[i] instanceof JComponent) {
                component = (JComponent)list[i];
                d = component.getPreferredSize();
                maxHeight = Math.max(maxHeight, (int)d.getHeight());
            }
            ++i;
        }
        this.setAllMinimumRowHeights(maxHeight);
    }

    protected void createCells(int loRows, int loCols, int hiRows, int hiCols) {
        if (this.tg == null) {
            return;
        }
        int row = loRows;
        while (row < hiRows) {
            int col = loCols;
            while (col < hiCols) {
                this.addObject(this.tg.makeContents(row, col), row, col);
                ++col;
            }
            ++row;
        }
    }

    protected void removeCells(int loRows, int loCols, int hiRows, int hiCols) {
        Component[][] cell = this.getComponentTable();
        Component c = null;
        CellPosition p = new CellPosition();
        int row = loRows;
        while (row < hiRows) {
            int col = loCols;
            while (col < hiCols) {
                c = cell[row][col];
                if (c != null) {
                    this.remove(c);
                }
                ++col;
            }
            ++row;
        }
    }

    protected void resetPreferredSize() {
        this.setPreferredSize(this.getPreferredSize());
        this.refreshComponent();
    }
}

