/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.CellPosition;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;

public class TableLayout
implements LayoutManager2,
JPTConstants {
    public static final int DEFAULT_ALIGNMENT = 6;
    public static final int DEFAULT_ORIENTATION = 0;
    public static final int NO_ALIGNMENT_SET = 36;
    public static final int INVALID_ALIGNMENT = 37;
    public static final int NO_MINIMUM_SET = -1;
    protected int rows = 0;
    protected int cols = 0;
    protected int hgap = 0;
    protected int vgap = 0;
    protected Component[][] table = new Component[0][0];
    protected int orientation = 0;
    protected int tableAlignment = 6;
    protected int[] rowAlignment = new int[0];
    protected int[] colAlignment = new int[0];
    protected int[][] cellAlignment = new int[0][0];
    protected int[] minRowHeight = new int[0];
    protected int[] minColWidth = new int[0];

    public TableLayout(int rows, int cols) {
        this(rows, cols, 0, 0, 6, 0);
    }

    public TableLayout(int rows, int cols, int align) {
        this(rows, cols, 0, 0, align, 0);
    }

    public TableLayout(int rows, int cols, int hgap, int vgap) {
        this(rows, cols, hgap, vgap, 6);
    }

    public TableLayout(int rows, int cols, int hgap, int vgap, int align) {
        this(rows, cols, hgap, vgap, align, 0);
    }

    public TableLayout(int rows, int cols, int hgap, int vgap, int align, int orientation) {
        this.setRows(rows);
        this.setColumns(cols);
        this.setHorizontalGap(hgap);
        this.setVerticalGap(vgap);
        this.setTableAlignment(align);
        this.setOrientation(orientation);
    }

    public void addLayoutComponent(Component c, Object position) {
        CellPosition p = null;
        if (position instanceof CellPosition) {
            p = (CellPosition)position;
        }
        if (p == null) {
            p = this.getNextAvailablePosition();
        }
        if (p == null) {
            p = this.getOrientation() == 1 ? new CellPosition(this.rows, 0) : new CellPosition(0, this.cols);
        }
        if (p.row < 0) {
            p.row = 0;
        }
        if (p.col < 0) {
            p.col = 0;
        }
        if (p.row >= this.rows) {
            this.setRows(p.row + 1);
        }
        if (p.col >= this.cols) {
            this.setColumns(p.col + 1);
        }
        this.table[p.row][p.col] = c;
    }

    public void addLayoutComponent(String name, Component c) {
        this.addLayoutComponent(c, this.getNextAvailablePosition());
    }

    public void removeLayoutComponent(Component c) {
        int row = 0;
        while (row < this.rows) {
            int col = 0;
            while (col < this.cols) {
                if (c == this.table[row][col]) {
                    this.table[row][col] = null;
                }
                ++col;
            }
            ++row;
        }
    }

    public void removeLayoutComponent(int row, int col) {
        if (this.isValidRow(row) && this.isValidColumn(col)) {
            this.table[row][col] = null;
        }
    }

    public void removeLayoutComponent(CellPosition position) {
        if (position == null) {
            return;
        }
        this.removeLayoutComponent(position.row, position.col);
    }

    public void invalidateLayout(Container parent) {
    }

    public void layoutContainer(Container parent) {
        Insets insets = null;
        insets = parent != null ? parent.getInsets() : new Insets(0, 0, 0, 0);
        this.layoutContainer(this.preferredColumnWidths(), this.preferredRowHeights(), insets);
    }

    public Dimension minimumLayoutSize(Container parent) {
        int height = 0;
        int row = 0;
        while (row < this.rows) {
            int h = this.minimumRowHeight(row);
            if (h > 0) {
                if (height > 0) {
                    height += this.vgap;
                }
                height += h;
            }
            ++row;
        }
        int width = 0;
        int col = 0;
        while (col < this.cols) {
            int w = this.minimumColumnWidth(col);
            if (w > 0) {
                if (width > 0) {
                    width += this.hgap;
                }
                width += w;
            }
            ++col;
        }
        Insets insets = null;
        insets = parent != null ? parent.getInsets() : new Insets(0, 0, 0, 0);
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    public Dimension preferredLayoutSize(Container parent) {
        int height = 0;
        int row = 0;
        while (row < this.rows) {
            int h = this.preferredRowHeight(row);
            if (h > 0) {
                if (height > 0) {
                    height += this.vgap;
                }
                height += h;
            }
            ++row;
        }
        int width = 0;
        int col = 0;
        while (col < this.cols) {
            int w = this.preferredColumnWidth(col);
            if (w > 0) {
                if (width > 0) {
                    width += this.hgap;
                }
                width += w;
            }
            ++col;
        }
        Insets insets = null;
        insets = parent != null ? parent.getInsets() : new Insets(0, 0, 0, 0);
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    public Dimension maximumLayoutSize(Container parent) {
        int height = 0;
        int row = 0;
        while (row < this.rows) {
            int h = this.maximumRowHeight(row);
            if (h > 0) {
                if (height > 0) {
                    height += this.vgap;
                }
                height += h;
            }
            ++row;
        }
        int width = 0;
        int col = 0;
        while (col < this.cols) {
            int w = this.maximumColumnWidth(col);
            if (w > 0) {
                if (width > 0) {
                    width += this.hgap;
                }
                width += w;
            }
            ++col;
        }
        Insets insets = null;
        insets = parent != null ? parent.getInsets() : new Insets(0, 0, 0, 0);
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public Component[][] getComponentTable() {
        Component[][] copy = new Component[this.rows][this.cols];
        int row = 0;
        while (row < this.rows) {
            int col = 0;
            while (col < this.cols) {
                copy[row][col] = this.table[row][col];
                ++col;
            }
            ++row;
        }
        return copy;
    }

    public Component getTableEntry(int row, int col) {
        if (this.isValidRow(row) && this.isValidColumn(col)) {
            return this.table[row][col];
        }
        return null;
    }

    public Component getTableEntry(CellPosition position) {
        if (position == null) {
            return null;
        }
        return this.getTableEntry(position.row, position.col);
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.cols;
    }

    public boolean isValidRow(int row) {
        return row >= 0 && row < this.rows;
    }

    public boolean isValidColumn(int col) {
        return col >= 0 && col < this.cols;
    }

    public boolean isEmptyRow(int row) {
        if (!this.isValidRow(row)) {
            return true;
        }
        int col = 0;
        while (col < this.cols) {
            if (this.table[row][col] != null) {
                return false;
            }
            ++col;
        }
        return true;
    }

    public boolean isEmptyColumn(int col) {
        if (!this.isValidColumn(col)) {
            return true;
        }
        int row = 0;
        while (row < this.rows) {
            if (this.table[row][col] != null) {
                return false;
            }
            ++row;
        }
        return true;
    }

    public void setHorizontalGap(int hgap) {
        if (hgap >= 0) {
            this.hgap = hgap;
        }
    }

    public int getHorizontalGap() {
        return this.hgap;
    }

    public void setVerticalGap(int vgap) {
        if (vgap >= 0) {
            this.vgap = vgap;
        }
    }

    public int getVerticalGap() {
        return this.vgap;
    }

    public void setOrientation(int orientation) {
        switch (orientation) {
            case -1: {
                orientation = 0;
            }
            case 0: 
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setTableAlignment(int align) {
        if ((align = this.adjustAlignment(align)) == 37 || align == 36) {
            return;
        }
        this.tableAlignment = align;
        int row = 0;
        while (row < this.rows) {
            this.rowAlignment[row] = align;
            int col = 0;
            while (col < this.cols) {
                this.cellAlignment[row][col] = align;
                ++col;
            }
            ++row;
        }
        int col = 0;
        while (col < this.cols) {
            this.colAlignment[col] = align;
            ++col;
        }
    }

    public int getTableAlignment() {
        return this.tableAlignment;
    }

    public void setRowAlignment(int row, int align) {
        if (!this.isValidRow(row)) {
            return;
        }
        if ((align = this.adjustAlignment(align)) == 37) {
            return;
        }
        this.rowAlignment[row] = align;
        int col = 0;
        while (col < this.cols) {
            this.cellAlignment[row][col] = align;
            ++col;
        }
    }

    public int getRowAlignment(int row) {
        if (!this.isValidRow(row)) {
            return 36;
        }
        return this.rowAlignment[row];
    }

    public void setColumnAlignment(int col, int align) {
        if (!this.isValidColumn(col)) {
            return;
        }
        if ((align = this.adjustAlignment(align)) == 37) {
            return;
        }
        this.colAlignment[col] = align;
        int row = 0;
        while (row < this.rows) {
            this.cellAlignment[row][col] = align;
            ++row;
        }
    }

    public int getColumnAlignment(int col) {
        if (!this.isValidColumn(col)) {
            return 36;
        }
        return this.colAlignment[col];
    }

    public void setCellAlignment(CellPosition p, int align) {
        if (p != null) {
            this.setCellAlignmentImpl(p.row, p.col, align);
        }
    }

    public void setCellAlignment(int row, int col, int align) {
        this.setCellAlignmentImpl(row, col, align);
    }

    public int getCellAlignment(CellPosition p) {
        if (p != null) {
            return this.getCellAlignment(p.row, p.col);
        }
        return this.tableAlignment;
    }

    public int getCellAlignment(int row, int col) {
        if (this.isValidRow(row) && this.isValidColumn(col)) {
            return this.cellAlignment[row][col];
        }
        return this.tableAlignment;
    }

    public int getEffectiveCellAlignment(CellPosition p) {
        if (p != null) {
            return this.getEffectiveCellAlignment(p.row, p.col);
        }
        return this.tableAlignment;
    }

    public int getEffectiveCellAlignment(int row, int col) {
        if (this.isValidRow(row) && this.isValidColumn(col) && this.cellAlignment[row][col] != 36) {
            return this.cellAlignment[row][col];
        }
        return this.tableAlignment;
    }

    public void setMinimumRowHeight(int row, int height) {
        if (!this.isValidRow(row)) {
            return;
        }
        if (height < -1) {
            return;
        }
        this.minRowHeight[row] = height;
    }

    public int getMinimumRowHeight(int row) {
        if (this.isValidRow(row)) {
            return this.minRowHeight[row];
        }
        return -1;
    }

    public void setAllMinimumRowHeights(int height) {
        if (height < -1) {
            return;
        }
        int row = 0;
        while (row < this.rows) {
            this.minRowHeight[row] = height;
            ++row;
        }
    }

    public void setMinimumColumnWidth(int col, int width) {
        if (!this.isValidColumn(col)) {
            return;
        }
        if (width < -1) {
            return;
        }
        this.minColWidth[col] = width;
    }

    public int getMinimumColumnWidth(int col) {
        if (this.isValidColumn(col)) {
            return this.minColWidth[col];
        }
        return -1;
    }

    public void setAllMinimumColumnWidths(int width) {
        if (width < -1) {
            return;
        }
        int col = 0;
        while (col < this.cols) {
            this.minColWidth[col] = width;
            ++col;
        }
    }

    public int minimumRowHeight(int row) {
        if (!this.isValidRow(row)) {
            return 0;
        }
        int height = 0;
        int col = 0;
        while (col < this.cols) {
            if (this.table[row][col] != null) {
                height = Math.max(height, this.table[row][col].getMinimumSize().height);
            }
            ++col;
        }
        if (height > 0) {
            height = Math.max(height, this.minRowHeight[row]);
        }
        return height;
    }

    public int minimumColumnWidth(int col) {
        if (!this.isValidColumn(col)) {
            return 0;
        }
        int width = 0;
        int row = 0;
        while (row < this.rows) {
            if (this.table[row][col] != null) {
                width = Math.max(width, this.table[row][col].getMinimumSize().width);
            }
            ++row;
        }
        if (width > 0) {
            width = Math.max(width, this.minColWidth[col]);
        }
        return width;
    }

    public int preferredRowHeight(int row) {
        if (!this.isValidRow(row)) {
            return 0;
        }
        int height = 0;
        int col = 0;
        while (col < this.cols) {
            if (this.table[row][col] != null) {
                height = Math.max(height, this.table[row][col].getPreferredSize().height);
            }
            ++col;
        }
        if (height > 0) {
            height = Math.max(height, this.minRowHeight[row]);
        }
        return height;
    }

    public int preferredColumnWidth(int col) {
        if (!this.isValidColumn(col)) {
            return 0;
        }
        int width = 0;
        int row = 0;
        while (row < this.rows) {
            if (this.table[row][col] != null) {
                width = Math.max(width, this.table[row][col].getPreferredSize().width);
            }
            ++row;
        }
        if (width > 0) {
            width = Math.max(width, this.minColWidth[col]);
        }
        return width;
    }

    public int maximumRowHeight(int row) {
        if (!this.isValidRow(row)) {
            return 0;
        }
        int height = 0;
        int col = 0;
        while (col < this.cols) {
            if (this.table[row][col] != null) {
                height = Math.max(height, this.table[row][col].getMaximumSize().height);
            }
            ++col;
        }
        if (height > 0) {
            height = Math.max(height, this.minRowHeight[row]);
        }
        return height;
    }

    public int maximumColumnWidth(int col) {
        if (!this.isValidColumn(col)) {
            return 0;
        }
        int width = 0;
        int row = 0;
        while (row < this.rows) {
            if (this.table[row][col] != null) {
                width = Math.max(width, this.table[row][col].getMaximumSize().width);
            }
            ++row;
        }
        if (width > 0) {
            width = Math.max(width, this.minColWidth[col]);
        }
        return width;
    }

    public int[] minimumRowHeights() {
        int[] heights = new int[this.rows];
        int i = 0;
        while (i < this.rows) {
            heights[i] = this.minimumRowHeight(i);
            ++i;
        }
        return heights;
    }

    public int[] minimumColumnWidths() {
        int[] widths = new int[this.cols];
        int i = 0;
        while (i < this.cols) {
            widths[i] = this.minimumColumnWidth(i);
            ++i;
        }
        return widths;
    }

    public int[] preferredRowHeights() {
        int[] heights = new int[this.rows];
        int i = 0;
        while (i < this.rows) {
            heights[i] = this.preferredRowHeight(i);
            ++i;
        }
        return heights;
    }

    public int[] preferredColumnWidths() {
        int[] widths = new int[this.cols];
        int i = 0;
        while (i < this.cols) {
            widths[i] = this.preferredColumnWidth(i);
            ++i;
        }
        return widths;
    }

    public int[] maximumRowHeights() {
        int[] heights = new int[this.rows];
        int i = 0;
        while (i < this.rows) {
            heights[i] = this.maximumRowHeight(i);
            ++i;
        }
        return heights;
    }

    public int[] maximumColumnWidths() {
        int[] widths = new int[this.cols];
        int i = 0;
        while (i < this.cols) {
            widths[i] = this.maximumColumnWidth(i);
            ++i;
        }
        return widths;
    }

    protected void layoutContainer(int[] widths, int[] heights, Insets insets) {
        if (widths == null || heights == null) {
            return;
        }
        int colMax = Math.min(this.cols, widths.length);
        int rowMax = Math.min(this.rows, heights.length);
        Dimension size = null;
        Point location = null;
        int x = insets.left;
        int y = insets.top;
        int componentWidth = 0;
        int componentHeight = 0;
        Component c = null;
        int row = 0;
        while (row < rowMax) {
            if (heights[row] > 0) {
                x = insets.left;
                int col = 0;
                while (col < colMax) {
                    if (widths[col] > 0) {
                        c = this.table[row][col];
                        if (c != null) {
                            size = new Dimension(c.getPreferredSize());
                            componentWidth = size.width;
                            componentHeight = size.height;
                            location = this.applyAlignment(x, y, widths[col], heights[row], componentWidth, componentHeight, this.getEffectiveCellAlignment(row, col));
                            c.setBounds(location.x, location.y, componentWidth, componentHeight);
                        }
                        x += this.hgap + widths[col];
                    }
                    ++col;
                }
                y += this.vgap + heights[row];
            }
            ++row;
        }
    }

    protected CellPosition getNextAvailablePosition() {
        if (this.orientation == 0) {
            int col = 0;
            while (col < this.cols) {
                int row = 0;
                while (row < this.rows) {
                    if (this.table[row][col] == null) {
                        return new CellPosition(row, col);
                    }
                    ++row;
                }
                ++col;
            }
            return new CellPosition(0, this.cols);
        }
        if (this.orientation == 1) {
            int row = 0;
            while (row < this.rows) {
                int col = 0;
                while (col < this.cols) {
                    if (this.table[row][col] == null) {
                        return new CellPosition(row, col);
                    }
                    ++col;
                }
                ++row;
            }
            return new CellPosition(this.rows, 0);
        }
        return null;
    }

    protected Point applyAlignment(int x, int y, int cellWidth, int cellHeight, int componentWidth, int componentHeight, int align) {
        Point p = new Point();
        int dx = cellWidth - componentWidth;
        int dy = cellHeight - componentHeight;
        if (dx < 0) {
            dx = 0;
        }
        if (dy < 0) {
            dy = 0;
        }
        int flushWest = x;
        int centerWE = x + dx / 2;
        int flushEast = x + dx;
        int flushNorth = y;
        int centerNS = y + dy / 2;
        int flushSouth = y + dy;
        switch (align) {
            case 2: {
                p.setLocation(flushEast, flushNorth);
                break;
            }
            case 3: {
                p.setLocation(flushEast, centerNS);
                break;
            }
            case 4: {
                p.setLocation(flushEast, flushSouth);
                break;
            }
            case 1: {
                p.setLocation(centerWE, flushNorth);
                break;
            }
            case 0: {
                p.setLocation(centerWE, centerNS);
                break;
            }
            case 5: {
                p.setLocation(centerWE, flushSouth);
                break;
            }
            case 8: {
                p.setLocation(flushWest, flushNorth);
                break;
            }
            case 7: {
                p.setLocation(flushWest, centerNS);
                break;
            }
            default: {
                p.setLocation(flushWest, flushSouth);
            }
        }
        return p;
    }

    void setRows(int rowCount) {
        int col;
        if (rowCount < 0) {
            rowCount = 0;
        }
        int oldRows = this.rows;
        int oldCols = this.cols;
        this.rows = rowCount;
        Component[][] newTable = new Component[this.rows][oldCols];
        int[][] newCellAlignment = new int[this.rows][oldCols];
        int[] newRowAlignment = new int[this.rows];
        int[] newMinRowHeight = new int[this.rows];
        int maxRow = Math.min(this.rows, oldRows);
        int row = 0;
        while (row < maxRow) {
            col = 0;
            while (col < oldCols) {
                newTable[row][col] = this.table[row][col];
                newCellAlignment[row][col] = this.cellAlignment[row][col];
                ++col;
            }
            newRowAlignment[row] = this.rowAlignment[row];
            newMinRowHeight[row] = this.minRowHeight[row];
            ++row;
        }
        if (this.rows > oldRows) {
            row = maxRow;
            while (row < this.rows) {
                col = 0;
                while (col < oldCols) {
                    newCellAlignment[row][col] = this.colAlignment[col];
                    ++col;
                }
                newRowAlignment[row] = 36;
                newMinRowHeight[row] = -1;
                ++row;
            }
        }
        this.table = newTable;
        this.cellAlignment = newCellAlignment;
        this.rowAlignment = newRowAlignment;
        this.minRowHeight = newMinRowHeight;
    }

    void setColumns(int colCount) {
        int row;
        if (colCount < 0) {
            colCount = 0;
        }
        int oldRows = this.rows;
        int oldCols = this.cols;
        this.cols = colCount;
        Component[][] newTable = new Component[oldRows][this.cols];
        int[][] newCellAlignment = new int[oldRows][this.cols];
        int[] newColAlignment = new int[this.cols];
        int[] newMinColWidth = new int[this.cols];
        int maxCol = Math.min(this.cols, oldCols);
        int col = 0;
        while (col < maxCol) {
            row = 0;
            while (row < oldRows) {
                newTable[row][col] = this.table[row][col];
                newCellAlignment[row][col] = this.cellAlignment[row][col];
                ++row;
            }
            newColAlignment[col] = this.colAlignment[col];
            newMinColWidth[col] = this.minColWidth[col];
            ++col;
        }
        if (this.cols > oldCols) {
            col = oldCols;
            while (col < this.cols) {
                row = 0;
                while (row < oldRows) {
                    newCellAlignment[row][col] = this.rowAlignment[row];
                    ++row;
                }
                newColAlignment[col] = 36;
                newMinColWidth[col] = -1;
                ++col;
            }
        }
        this.table = newTable;
        this.cellAlignment = newCellAlignment;
        this.colAlignment = newColAlignment;
        this.minColWidth = newMinColWidth;
    }

    void setCellAlignmentImpl(int row, int col, int align) {
        if (!this.isValidRow(row) || !this.isValidColumn(col)) {
            return;
        }
        if ((align = this.adjustAlignment(align)) == 37) {
            return;
        }
        this.cellAlignment[row][col] = align;
    }

    int adjustAlignment(int align) {
        switch (align) {
            case -1: {
                align = 6;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 36: {
                break;
            }
            default: {
                align = 37;
            }
        }
        return align;
    }
}

