/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.gui.SwatchNamePair;
import edu.neu.ccs.quick.StringObjectMap;
import edu.neu.ccs.util.DimensionUtilities;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class SwatchNameRenderer
implements ListCellRenderer {
    private StringObjectMap nameCellMap;
    private Dimension maxDimension = new Dimension(0, 0);

    public SwatchNameRenderer() {
        String[] names = Colors.getColorNamesAsArray();
        int length = names.length;
        Object[][] pairs = new Object[length][2];
        int i = 0;
        while (i < length) {
            SwatchNamePair swatchpair = new SwatchNamePair(names[i]);
            pairs[i][0] = names[i];
            pairs[i][1] = swatchpair;
            this.maxDimension = DimensionUtilities.max(this.maxDimension, swatchpair.getPreferredSize());
            ++i;
        }
        this.nameCellMap = new StringObjectMap(pairs);
    }

    private SwatchNamePair getListCellFromMap(String name) {
        return (SwatchNamePair)this.nameCellMap.getObject(name);
    }

    public String[] getStrings() {
        return this.nameCellMap.getStrings();
    }

    public Dimension getMaximumPreferredSize() {
        return DimensionUtilities.createDimension(this.maxDimension);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof String)) {
            return null;
        }
        String name = (String)value;
        SwatchNamePair swatchpair = this.getListCellFromMap(name);
        if (swatchpair == null) {
            return null;
        }
        if (isSelected) {
            swatchpair.setBackground(list.getSelectionBackground());
            swatchpair.setForeground(list.getSelectionForeground());
        } else {
            swatchpair.setBackground(list.getBackground());
            swatchpair.setForeground(list.getForeground());
        }
        return swatchpair;
    }
}

