/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.TextFileIO;
import java.io.File;
import java.text.ParseException;

public class StringableFileIO {
    protected Stringable model = null;
    protected TextFileIO textFileIO = null;

    public StringableFileIO(Stringable model, String extension) {
        if (model == null) {
            throw new NullPointerException("Null model passed to StringableFileIO constructor");
        }
        this.model = model;
        this.textFileIO = new TextFileIO(extension);
    }

    public Stringable getModel() {
        return this.model;
    }

    public boolean readDataFromFile() {
        return this.readDataFromFile(true);
    }

    public boolean readDataFromFile(boolean displayErrorDialogs) {
        String data = this.textFileIO.readDataFromFile(displayErrorDialogs);
        return this.setModel(data, displayErrorDialogs);
    }

    public boolean readDataFromFile(File source, boolean displayErrorDialogs) {
        String data = this.textFileIO.readDataFromFile(source, displayErrorDialogs);
        return this.setModel(data, displayErrorDialogs);
    }

    protected boolean setModel(String data, boolean displayErrorDialogs) {
        if (data == null) {
            return false;
        }
        try {
            this.model.fromStringData(data);
        }
        catch (ParseException ex) {
            if (displayErrorDialogs) {
                String message = "Error in setting model from file data\n" + ex.getMessage() + "\n";
                GeneralDialog.showOKDialog(message, "File Read Error");
            }
            return false;
        }
        return true;
    }

    public boolean saveDataToFile() {
        return this.saveDataToFile(true);
    }

    public boolean saveDataToFile(boolean displayErrorDialogs) {
        String data = this.model.toStringData();
        return this.textFileIO.saveDataToFile(data, displayErrorDialogs);
    }

    public boolean saveDataToFile(File target, boolean displayErrorDialogs) {
        String data = this.model.toStringData();
        return this.textFileIO.saveDataToFile(target, data, displayErrorDialogs);
    }
}

