/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.filter.StringableFilter;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Fonts;
import edu.neu.ccs.gui.Fragile;
import edu.neu.ccs.gui.GeneralView;
import edu.neu.ccs.gui.GeneralViewSupport;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.JPTScrollPane;
import edu.neu.ccs.gui.LookAndFeelTools;
import edu.neu.ccs.gui.MalformedDataListener;
import edu.neu.ccs.gui.TextAreaView;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;

public class StringViewer
extends DisplayPanel
implements GeneralView,
Fragile,
JPTConstants {
    public static final int WIDTH = 800;
    public static final int HEIGHT = 600;
    public static final int MINIMUM = 100;
    public static final int V_ALWAYS = 22;
    public static final int H_ALWAYS = 32;
    public static final String FONTNAME = Fonts.getMonospacedFontFamilyName();
    private static int staticFontSize = 14 + (int)LookAndFeelTools.getNetFontSizeAdjustment();
    private static Font staticFont = new Font(FONTNAME, 1, staticFontSize);
    protected TextAreaView textarea = null;
    protected JPTScrollPane scrollpane = null;
    protected GeneralViewSupport delegate = null;
    static /* synthetic */ Class class$0;

    public StringViewer() {
        this.initialize(null, 800, 600, null);
    }

    public StringViewer(int width, int height) {
        this.initialize(null, width, height, null);
    }

    public StringViewer(Font font) {
        this.initialize(null, 800, 600, font);
    }

    public StringViewer(int width, int height, Font font) {
        this.initialize(null, width, height, font);
    }

    public StringViewer(String text) {
        this.initialize(text, 800, 600, null);
    }

    public StringViewer(String text, int width, int height) {
        this.initialize(text, width, height, null);
    }

    public StringViewer(String text, Font font) {
        this.initialize(text, 800, 600, font);
    }

    public StringViewer(String text, int width, int height, Font font) {
        this.initialize(text, width, height, font);
    }

    protected void initialize(String text, int width, int height, Font font) {
        this.delegate = new GeneralViewSupport(this, this.listenerList, null, null, null, null);
        if (text == null) {
            text = "";
        }
        this.textarea = new TextAreaView(text);
        if (font == null) {
            font = staticFont;
        }
        this.textarea.setFont(font);
        this.scrollpane = new JPTScrollPane(this.textarea, 22, 32);
        width = width < 100 ? 100 : width;
        height = height < 100 ? 100 : height;
        this.scrollpane.setViewportPreferredSize(width, height);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.neu.ccs.XString");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDataType(clazz);
        this.addObject(this.scrollpane);
    }

    public TextAreaView getTextArea() {
        return this.textarea;
    }

    public JPTScrollPane getScrollPane() {
        return this.scrollpane;
    }

    public String getText() {
        return this.textarea.getText();
    }

    public int getTextLength() {
        return this.textarea.getText().length();
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.textarea.setText(text);
    }

    public void setTextWithNewline(String text) {
        if (text == null || text.length() == 0) {
            this.textarea.setText("\n");
        } else {
            this.textarea.setText(String.valueOf(text) + "\n");
        }
    }

    public void append(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.textarea.append(text);
    }

    public void appendWithNewline(String text) {
        if (text == null || text.length() == 0) {
            this.textarea.append("\n");
        } else {
            this.textarea.append(String.valueOf(text) + "\n");
        }
    }

    public void insert(String text, int position) {
        if (text == null || text.length() == 0) {
            return;
        }
        int length = this.getTextLength();
        if (position < 0) {
            position = 0;
        } else if (position > length) {
            position = length;
        }
        this.textarea.insert(text, position);
    }

    public void insert(int position, String text) {
        this.insert(text, position);
    }

    public void setViewState(String data) {
        this.setText(data);
    }

    public String getViewState() {
        return this.getText();
    }

    public void setDefaultViewState(String data) {
        this.delegate.setDefaultViewState(data);
    }

    public String getDefaultViewState() {
        return this.delegate.getDefaultViewState();
    }

    public void reset() {
        this.delegate.reset();
    }

    public GeneralView makeCopy() {
        String text = this.getText();
        Dimension dimension = this.scrollpane.getViewport().getPreferredSize();
        int width = dimension.width;
        int height = dimension.height;
        Font font = this.textarea.getFont();
        StringViewer copy = new StringViewer(text, width, height, font);
        copy.setDataType(this.getDataType());
        copy.setViewState(this.getViewState());
        copy.setDefaultViewState(this.getDefaultViewState());
        copy.setInputProperties(new InputProperties(this.getInputProperties()));
        copy.setFilter(this.getFilter());
        return copy;
    }

    public void setDataType(Class dataType) {
        this.delegate.setDataType(dataType);
    }

    public Class getDataType() {
        return this.delegate.getDataType();
    }

    public void setFilter(StringableFilter filter) {
        this.delegate.setFilter(filter);
    }

    public StringableFilter getFilter() {
        return this.delegate.getFilter();
    }

    public Stringable demandObject() {
        return this.delegate.demandObject();
    }

    public Stringable requestObject() throws CancelledException {
        return this.delegate.requestObject();
    }

    public Stringable demandObject(StringableFilter filter) {
        return this.delegate.demandObject(filter);
    }

    public Stringable requestObject(StringableFilter filter) throws CancelledException {
        return this.delegate.requestObject(filter);
    }

    public Stringable demandObject(Class dataType, StringableFilter filter) {
        return this.delegate.demandObject(dataType, filter);
    }

    public Stringable requestObject(Class dataType, StringableFilter filter) throws CancelledException {
        return this.delegate.requestObject(dataType, filter);
    }

    public void setInputProperties(InputProperties properties) {
        this.delegate.setInputProperties(properties);
    }

    public InputProperties getInputProperties() {
        return this.delegate.getInputProperties();
    }

    public void setErrorPromptTitleSuggestion(String errorPrompt, String dialogTitle, String suggestion) {
        this.delegate.setErrorPromptTitleSuggestion(errorPrompt, dialogTitle, suggestion);
    }

    public void addMalformedDataListener(MalformedDataListener l) {
        this.delegate.addMalformedDataListener(l);
    }

    public void removeMalformedDataListener(MalformedDataListener l) {
        this.delegate.removeMalformedDataListener(l);
    }

    public void addActionListener(ActionListener listener) {
    }

    public void removeActionListener(ActionListener listener) {
    }

    public static JPTScrollPane makeScrollView(String string, int width, int height) {
        if (string == null) {
            string = "Null String passed to StringViewer.makeScrollView";
        }
        TextAreaView textarea = new TextAreaView(string);
        textarea.setFont(staticFont);
        JPTScrollPane scrollpane = new JPTScrollPane(textarea, 22, 32);
        width = width < 100 ? 100 : width;
        height = height < 100 ? 100 : height;
        scrollpane.setViewportPreferredSize(width, height);
        return scrollpane;
    }

    public static JPTScrollPane makeScrollView(String string) {
        return StringViewer.makeScrollView(string, 800, 600);
    }

    public static void showStringInFrame(String string, int width, int height) {
        StringViewer.makeScrollView(string, width, height).frame();
    }

    public static void showStringInFrame(String string) {
        StringViewer.showStringInFrame(string, 800, 600);
    }

    public static void showStringInDialog(String string, int width, int height) {
        StringViewer.makeScrollView(string, width, height).OKDialog();
    }

    public static void showStringInDialog(String string) {
        StringViewer.showStringInDialog(string, 800, 600);
    }

    public static Font getDefaultFont() {
        return staticFont;
    }

    public static void setDefaultFont(Font newfont) {
        if (newfont != null) {
            staticFont = newfont;
        }
    }
}

