/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Dropdown;
import edu.neu.ccs.gui.StringObjectView;
import edu.neu.ccs.quick.StringObjectMap;
import edu.neu.ccs.quick.StringObjectPair;
import java.awt.Font;
import javax.swing.Action;

public class StringObjectDropdown
extends Dropdown
implements StringObjectView {
    protected StringObjectMap pairmap = null;
    protected boolean sort = false;

    public StringObjectDropdown() {
        this.initializeSODropdown(null, null, null, 0, false);
    }

    public StringObjectDropdown(Object[][] pairs) {
        this.initializeSODropdown(StringObjectPair.toArray(pairs), null, null, 0, false);
    }

    public StringObjectDropdown(Object[][] pairs, Action action) {
        this.initializeSODropdown(StringObjectPair.toArray(pairs), action, null, 0, false);
    }

    public StringObjectDropdown(Object[][] pairs, Action action, int minWidth) {
        this.initializeSODropdown(StringObjectPair.toArray(pairs), action, null, minWidth, false);
    }

    public StringObjectDropdown(Object[][] pairs, Action action, Font font) {
        this.initializeSODropdown(StringObjectPair.toArray(pairs), action, font, 0, false);
    }

    public StringObjectDropdown(Object[][] pairs, Action action, Font font, int minWidth) {
        this.initializeSODropdown(StringObjectPair.toArray(pairs), action, font, minWidth, false);
    }

    public StringObjectDropdown(Object[][] pairs, Action action, boolean sort) {
        this.initializeSODropdown(StringObjectPair.toArray(pairs), action, null, 0, sort);
    }

    public StringObjectDropdown(Object[][] pairs, Action action, int minWidth, boolean sort) {
        this.initializeSODropdown(StringObjectPair.toArray(pairs), action, null, minWidth, sort);
    }

    public StringObjectDropdown(Object[][] pairs, Action action, Font font, boolean sort) {
        this.initializeSODropdown(StringObjectPair.toArray(pairs), action, font, 0, sort);
    }

    public StringObjectDropdown(Object[][] pairs, Action action, Font font, int minWidth, boolean sort) {
        this.initializeSODropdown(StringObjectPair.toArray(pairs), action, font, minWidth, sort);
    }

    public StringObjectDropdown(StringObjectPair[] pairs) {
        this.initializeSODropdown(pairs, null, null, 0, false);
    }

    public StringObjectDropdown(StringObjectPair[] pairs, Action action) {
        this.initializeSODropdown(pairs, action, null, 0, false);
    }

    public StringObjectDropdown(StringObjectPair[] pairs, Action action, int minWidth) {
        this.initializeSODropdown(pairs, action, null, minWidth, false);
    }

    public StringObjectDropdown(StringObjectPair[] pairs, Action action, Font font) {
        this.initializeSODropdown(pairs, action, font, 0, false);
    }

    public StringObjectDropdown(StringObjectPair[] pairs, Action action, Font font, int minWidth) {
        this.initializeSODropdown(pairs, action, font, minWidth, false);
    }

    public StringObjectDropdown(StringObjectPair[] pairs, Action action, boolean sort) {
        this.initializeSODropdown(pairs, action, null, 0, sort);
    }

    public StringObjectDropdown(StringObjectPair[] pairs, Action action, int minWidth, boolean sort) {
        this.initializeSODropdown(pairs, action, null, minWidth, sort);
    }

    public StringObjectDropdown(StringObjectPair[] pairs, Action action, Font font, boolean sort) {
        this.initializeSODropdown(pairs, action, font, 0, sort);
    }

    public StringObjectDropdown(StringObjectPair[] pairs, Action action, Font font, int minWidth, boolean sort) {
        this.initializeSODropdown(pairs, action, font, minWidth, sort);
    }

    public StringObjectDropdown(StringObjectMap map) {
        StringObjectPair[] pairs = map == null ? null : map.getStringObjectPairs();
        this.initializeSODropdown(pairs, null, null, 0, false);
    }

    public StringObjectDropdown(StringObjectMap map, Action action) {
        StringObjectPair[] pairs = map == null ? null : map.getStringObjectPairs();
        this.initializeSODropdown(pairs, action, null, 0, false);
    }

    public StringObjectDropdown(StringObjectMap map, Action action, int minWidth) {
        StringObjectPair[] pairs = map == null ? null : map.getStringObjectPairs();
        this.initializeSODropdown(pairs, action, null, minWidth, false);
    }

    public StringObjectDropdown(StringObjectMap map, Action action, Font font) {
        StringObjectPair[] pairs = map == null ? null : map.getStringObjectPairs();
        this.initializeSODropdown(pairs, action, font, 0, false);
    }

    public StringObjectDropdown(StringObjectMap map, Action action, Font font, int minWidth) {
        StringObjectPair[] pairs = map == null ? null : map.getStringObjectPairs();
        this.initializeSODropdown(pairs, action, font, minWidth, false);
    }

    public StringObjectDropdown(StringObjectMap map, Action action, boolean sort) {
        StringObjectPair[] pairs = map == null ? null : map.getStringObjectPairs();
        this.initializeSODropdown(pairs, action, null, 0, sort);
    }

    public StringObjectDropdown(StringObjectMap map, Action action, int minWidth, boolean sort) {
        StringObjectPair[] pairs = map == null ? null : map.getStringObjectPairs();
        this.initializeSODropdown(pairs, action, null, minWidth, sort);
    }

    public StringObjectDropdown(StringObjectMap map, Action action, Font font, boolean sort) {
        StringObjectPair[] pairs = map == null ? null : map.getStringObjectPairs();
        this.initializeSODropdown(pairs, action, font, 0, sort);
    }

    public StringObjectDropdown(StringObjectMap map, Action action, Font font, int minWidth, boolean sort) {
        StringObjectPair[] pairs = map == null ? null : map.getStringObjectPairs();
        this.initializeSODropdown(pairs, action, font, minWidth, sort);
    }

    protected final void initializeSODropdown(StringObjectPair[] pairs, Action action, Font font, int minWidth, boolean sort) {
        super.removeAllItems();
        this.pairmap = new StringObjectMap();
        this.pairmap.addPairs(pairs);
        this.sort = sort;
        String[] strings = this.getStrings();
        this.initializeDropdown(strings, null, font, minWidth, false);
        if (action != null) {
            this.addActionListener(action);
        }
    }

    public final String getSelectedString() {
        return (String)this.getSelectedItem();
    }

    public final Object getSelectedObject() {
        return this.pairmap.getObject(this.getSelectedString());
    }

    public final void setSelectedString(String string) {
        if (!this.pairmap.containsString(string)) {
            return;
        }
        String oldString = this.getSelectedString();
        if (string.equals(oldString)) {
            return;
        }
        this.setSelectedItem(string);
        this.firePropertyChange("view.state", oldString, string);
    }

    public final void setSelectedObject(Object object) {
        this.setSelectedString(this.pairmap.getString(object));
    }

    public final StringObjectPair[] getStringObjectPairs() {
        StringObjectPair[] pairs = this.sort ? this.pairmap.getSortedStringObjectPairs() : this.pairmap.getStringObjectPairs();
        return pairs;
    }

    public final String[] getStrings() {
        String[] strings = this.sort ? this.pairmap.getSortedStrings() : this.pairmap.getStrings();
        return strings;
    }

    public final Object[] getObjects() {
        Object[] objects = this.sort ? this.pairmap.getSortedObjects() : this.pairmap.getObjects();
        return objects;
    }

    public final String getString(Object object) {
        return this.pairmap.getString(object);
    }

    public final Object getObject(String string) {
        return this.pairmap.getObject(string);
    }

    public final void setPairs(Object[][] pairs) {
        this.removeAllItems();
        this.addPairs(pairs);
    }

    public final void setPairs(StringObjectPair[] pairs) {
        this.removeAllItems();
        this.addPairs(pairs);
    }

    public final void setPairs(StringObjectMap map) {
        this.removeAllItems();
        this.addPairs(map);
    }

    public final void addPair(String string, Object object) {
        if (string == null) {
            return;
        }
        if (object == null) {
            return;
        }
        this.addPair(new StringObjectPair(string, object));
    }

    public final void addPair(StringObjectPair pair) {
        if (pair == null) {
            return;
        }
        this.addPairs(new StringObjectPair[]{pair});
    }

    public final void addPairs(Object[][] pairs) {
        if (pairs == null) {
            return;
        }
        this.addPairs(StringObjectPair.toArray(pairs));
    }

    public final void addPairs(StringObjectPair[] pairs) {
        if (pairs == null) {
            return;
        }
        StringObjectPair[] oldContents = this.pairmap.getStringObjectPairs();
        int a = oldContents.length;
        int b = pairs.length;
        int c = a + b;
        StringObjectPair[] newContents = new StringObjectPair[c];
        int i = 0;
        while (i < a) {
            newContents[i] = oldContents[i];
            ++i;
        }
        i = 0;
        while (i < b) {
            newContents[a + i] = pairs[i];
            ++i;
        }
        this.initializeSODropdown(newContents, null, null, this.getMinimumWidth(), this.sort);
    }

    public final void addPairs(StringObjectMap map) {
        if (map == null) {
            return;
        }
        this.addPairs(map.getStringObjectPairs());
    }

    public final void removeAllItems() {
        super.removeAllItems();
        this.pairmap.clear();
    }

    public void setFont(Font font) {
        if (this.pairmap == null) {
            super.setFont(font);
            return;
        }
        if (font == null) {
            font = StringObjectDropdown.getDefaultFont();
        }
        String selection = this.getSelectedString();
        String defaultViewState = this.getDefaultViewState();
        StringObjectPair[] pairs = this.pairmap.getStringObjectPairs();
        int minWidth = this.getMinimumWidth();
        this.removeAllItems();
        this.initializeSODropdown(pairs, null, font, minWidth, this.sort);
        this.setSelectedString(selection);
        this.setDefaultViewState(defaultViewState);
    }
}

