/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XInt;
import edu.neu.ccs.XLine2D;
import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.ActionSequence;
import edu.neu.ccs.gui.BasePane;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.HTable;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.MouseAction;
import edu.neu.ccs.gui.MouseActionAdapter;
import edu.neu.ccs.gui.PaintMode;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableComponent;
import edu.neu.ccs.gui.PaintableSequence;
import edu.neu.ccs.gui.PlotMarkAlgorithm;
import edu.neu.ccs.gui.ShapePaintable;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.TextAnchor;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.TextPaintable;
import edu.neu.ccs.gui.TypedView;
import edu.neu.ccs.gui.VTable;
import edu.neu.ccs.util.MathUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.ParseException;

public class SliderView
extends BasePane
implements TypedView {
    public static final int MINIMUM_PIXELS = 20;
    public static final int THUMB_SIZE = 9;
    public static final int THUMB_PLUS = 10;
    public static final int TRACK_THICK = 6;
    public static final int TRACK_BORDER_THICK = 2;
    public static final int MAJOR_TICK_SIZE = 8;
    public static final int MINOR_TICK_SIZE = 4;
    public static final Stroke STROKE2 = new BasicStroke(2.0f);
    public static final int PRESS_ACTION = 0;
    public static final int SLIDING_ACTION = 1;
    public static final int RELEASE_ACTION = 2;
    protected Shape thumbShape = null;
    protected ShapePaintable thumb = null;
    protected Paint ordinaryThumbPaint = Color.white;
    protected Paint selectedThumbPaint = Color.red;
    protected XRect trackRect = null;
    protected ShapePaintable track = null;
    protected Paint trackPaint = Color.yellow;
    protected XRect trackBorderRect = null;
    protected ShapePaintable trackBorder = null;
    protected Color commonColor = Color.black;
    protected final PaintableSequence tickSequence = new PaintableSequence();
    protected final PaintableSequence labelSequence = new PaintableSequence();
    protected final PaintableSequence objectSequence = new PaintableSequence();
    protected final PaintableSequence mainSequence = new PaintableSequence();
    protected XRect mainBounds = null;
    protected int cornerX = 0;
    protected int cornerY = 0;
    protected PaintableComponent mainComponent = new PaintableComponent(this.mainSequence);
    protected MouseActionAdapter adapter = this.mainComponent.getMouseActionAdapter();
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected MouseAction mousePressAction = new MouseAction(){

        public void mouseActionPerformed(MouseEvent evt) {
            SliderView.this.mousePress(evt);
        }
    };
    protected MouseAction mouseSlidingAction = new MouseAction(){

        public void mouseActionPerformed(MouseEvent evt) {
            SliderView.this.mouseSliding(evt);
        }
    };
    protected MouseAction mouseReleaseAction = new MouseAction(){

        public void mouseActionPerformed(MouseEvent evt) {
            SliderView.this.mouseRelease(evt);
        }
    };
    protected ActionSequence pressActions = new ActionSequence();
    protected ActionSequence slidingActions = new ActionSequence();
    protected ActionSequence releaseActions = new ActionSequence();
    public final ActionEvent pressEvent = new ActionEvent(this, 0, "");
    public final ActionEvent slidingEvent = new ActionEvent(this, 1, "");
    public final ActionEvent releaseEvent = new ActionEvent(this, 2, "");
    protected TextFieldView valueTFV = new TextFieldView();
    protected SimpleAction setValueFromValueTFV = new SimpleAction(){

        public void perform() {
            SliderView.this.setValueFromValueTFV();
        }
    };
    protected int orientation = 0;
    protected int minimum;
    protected int maximum;
    protected int delta;
    protected int value;
    protected int defaultValue;
    protected int pixels;
    protected int limit;
    protected int location;
    protected double f_loc_to_val;
    protected double t_loc_to_val;
    protected double f_val_to_loc;
    protected double t_val_to_loc;
    protected int majorTicks;
    protected int minorTicks;
    protected boolean dragging = false;
    protected InputProperties properties = new InputProperties();
    static /* synthetic */ Class class$0;

    public SliderView() {
        this(0, 0, 100, 50, 101, 0, 0, null, null, null, null, true);
    }

    public SliderView(int orientation) {
        this(orientation, 0, 100, 50, 101, 0, 0, null, null, null, null, true);
    }

    public SliderView(int orientation, int minimum, int maximum, int value) {
        this(orientation, minimum, maximum, value, 101, 0, 0, null, null, null, null, true);
    }

    public SliderView(int orientation, int minimum, int maximum, int value, int pixels) {
        this(orientation, minimum, maximum, value, pixels, 0, 0, null, null, null, null, true);
    }

    public SliderView(int orientation, int minimum, int maximum, int value, int pixels, int majorTicks, int minorTicks) {
        this(orientation, minimum, maximum, value, pixels, majorTicks, minorTicks, null, null, null, null, true);
    }

    public SliderView(int orientation, int minimum, int maximum, int value, int pixels, int majorTicks, int minorTicks, Paint ordinaryThumbPaint, Paint selectedThumbPaint, Paint trackPaint, Color commonColor, boolean showValueTFV) {
        this.initializeNumerics(orientation, minimum, maximum, value, pixels, majorTicks, minorTicks);
        this.initializePaints(ordinaryThumbPaint, selectedThumbPaint, trackPaint, commonColor);
        this.initializeValueTFV();
        this.initializeThumb();
        this.initializeTrack();
        this.installDefaultMajorTicks();
        this.installDefaultMinorTicks();
        this.installDefaultLabels();
        this.initializeMainSequence();
        this.initializeMouse();
        this.installMainPanel(showValueTFV);
    }

    protected final void initializeNumerics(int orientation, int minimum, int maximum, int value, int pixels, int majorTicks, int minorTicks) {
        String message = "";
        if (minimum == maximum) {
            message = "Slider minimum cannot equal slider maximum\n";
        }
        if (pixels < 20) {
            message = String.valueOf(message) + "Slider pixels must be at least 20\n";
        }
        if (message.length() > 0) {
            throw new IllegalArgumentException(message);
        }
        if (orientation != 1) {
            orientation = 0;
        }
        this.orientation = orientation;
        this.minimum = minimum;
        this.maximum = maximum;
        this.delta = maximum - minimum;
        this.value = value = this.getValidValue(value);
        this.defaultValue = value;
        this.pixels = pixels;
        this.limit = pixels - 1;
        this.f_loc_to_val = this.delta;
        this.f_loc_to_val /= (double)this.limit;
        this.t_loc_to_val = minimum;
        this.f_val_to_loc = this.limit;
        this.f_val_to_loc /= (double)this.delta;
        this.t_val_to_loc = -this.f_val_to_loc * (double)minimum;
        this.location = this.valueToLocation(value);
        majorTicks = majorTicks > 0 ? majorTicks : 0;
        int n = minorTicks = minorTicks > 0 ? minorTicks : 0;
        if (majorTicks > 0 && minorTicks > 0) {
            minorTicks = MathUtilities.GCD(majorTicks, minorTicks);
        }
        this.majorTicks = majorTicks;
        this.minorTicks = minorTicks;
    }

    protected final void initializePaints(Paint ordinaryThumbPaint, Paint selectedThumbPaint, Paint trackPaint, Color commonColor) {
        if (ordinaryThumbPaint != null) {
            this.ordinaryThumbPaint = ordinaryThumbPaint;
        }
        if (selectedThumbPaint != null) {
            this.selectedThumbPaint = selectedThumbPaint;
        }
        if (trackPaint != null) {
            this.trackPaint = trackPaint;
        }
        if (commonColor != null) {
            this.commonColor = commonColor;
        }
    }

    protected final void initializeValueTFV() {
        this.valueTFV.addActionListener(this.setValueFromValueTFV);
        this.valueTFV.setFont(this.labelFont);
        this.valueTFV.setForeground(this.commonColor);
        this.valueTFV.setSelectedTextColor(this.commonColor);
        String minString = "" + this.minimum;
        String maxString = "" + this.maximum;
        int n1 = minString.length();
        int n2 = maxString.length();
        String sample = n1 > n2 ? minString : maxString;
        int width = TextFieldView.getSampleWidth(this.labelFont, sample);
        this.valueTFV.setPreferredWidth(width);
    }

    protected final void initializeThumb() {
        int s = 9;
        int p = 10;
        if (this.orientation == 0) {
            PlotMarkAlgorithm alg = PlotMarkAlgorithm.ThumbS;
            this.thumbShape = alg.makeShape(0.0, s, s);
        } else {
            PlotMarkAlgorithm alg = PlotMarkAlgorithm.ThumbE;
            this.thumbShape = alg.makeShape(s, 0.0, s);
        }
        this.thumb = new ShapePaintable(this.thumbShape, PaintMode.FILL_DRAW, this.ordinaryThumbPaint, (Paint)this.commonColor, STROKE2);
        this.thumb.setDefaultOriginalBounds2D(new XRect(-p, -p, 2 * p, 2 * p));
        this.thumb.setDefaultOriginalCenter(new XPoint2D(0.0, 0.0));
    }

    protected final void initializeTrack() {
        int t = 6;
        int h = t / 2;
        int b = 2;
        int p = 10;
        XRect bounds = null;
        if (this.orientation == 0) {
            this.trackRect = new XRect(0.0, -h, this.pixels, t);
            this.trackBorderRect = new XRect(-b, -(h + b), this.pixels + 2 * b, t + 2 * b);
            bounds = new XRect(-p, -p, this.pixels + 2 * p, 2 * p);
        } else {
            this.trackRect = new XRect(-h, 0.0, t, this.pixels);
            this.trackBorderRect = new XRect(-(h + b), -b, t + 2 * b, this.pixels + 2 * b);
            bounds = new XRect(-p, -p, 2 * p, this.pixels + 2 * p);
        }
        this.track = new ShapePaintable(this.trackRect, PaintMode.FILL, this.trackPaint);
        this.trackBorder = new ShapePaintable(this.trackBorderRect, PaintMode.FILL, (Paint)this.commonColor);
        this.track.setDefaultOriginalBounds2D(bounds);
        this.trackBorder.setDefaultOriginalBounds2D(bounds);
    }

    protected final void initializeMainSequence() {
        this.mainSequence.appendPaintable(this.thumb);
        this.mainSequence.appendPaintable(this.track);
        this.mainSequence.appendPaintable(this.trackBorder);
        this.mainSequence.appendPaintable(this.tickSequence);
        this.mainSequence.appendPaintable(this.labelSequence);
        this.mainSequence.appendPaintable(this.objectSequence);
        this.resetThumb();
    }

    protected final void initializeMouse() {
        this.adapter.addMousePressedAction(this.mousePressAction);
        this.adapter.addMouseDraggedAction(this.mouseSlidingAction);
        this.adapter.addMouseReleasedAction(this.mouseReleaseAction);
    }

    protected final void installMainPanel(boolean showValueTFV) {
        TablePanel mainPanel = null;
        Object[] stuff = null;
        stuff = showValueTFV ? new Object[]{this.mainComponent, this.valueTFV} : new Object[]{this.mainComponent};
        mainPanel = this.orientation == 0 ? new HTable(stuff, this.gap, this.gap, 1) : new VTable(stuff, this.gap, this.gap, 7);
        this.addObject(mainPanel);
        this.updateValueTFV();
    }

    public final ShapePaintable makeTick(int val, int size) {
        val = this.getValidValue(val);
        int loc = this.valueToLocation(val);
        int p = 10 + this.gap;
        int q = p + size;
        XLine2D line = new XLine2D();
        if (this.orientation == 0) {
            line.setLine(loc, p, loc, q);
        } else {
            line.setLine(p, loc, q, loc);
        }
        ShapePaintable paintable = new ShapePaintable(line, PaintMode.DRAW, null, (Paint)this.commonColor, STROKE2);
        return paintable;
    }

    public int[] getTickValues(int spacing) {
        int b;
        if (spacing <= 0) {
            return new int[0];
        }
        int[] values = null;
        int a = this.minimum % spacing;
        if (a < 0) {
            a += spacing;
        }
        if ((b = this.maximum % spacing) < 0) {
            b += spacing;
        }
        int count = 0;
        int s = this.minimum;
        int t = this.maximum;
        if (this.delta > 0) {
            if (a > 0) {
                ++count;
                s += spacing - a;
            }
            if (b > 0) {
                ++count;
                t -= b;
            }
            if (s <= t) {
                count += (t - s) / spacing + 1;
            }
            values = new int[count];
            int k = 0;
            if (a > 0) {
                values[k] = this.minimum;
                ++k;
            }
            while (s <= t) {
                values[k] = s;
                ++k;
                s += spacing;
            }
            if (b > 0) {
                values[k] = this.maximum;
                ++k;
            }
        } else {
            if (a > 0) {
                ++count;
                s -= a;
            }
            if (b > 0) {
                ++count;
                t += spacing - b;
            }
            if (s >= t) {
                count += (s - t) / spacing + 1;
            }
            values = new int[count];
            int k = 0;
            if (a > 0) {
                values[k] = this.minimum;
                ++k;
            }
            while (s >= t) {
                values[k] = s;
                ++k;
                s -= spacing;
            }
            if (b > 0) {
                values[k] = this.maximum;
                ++k;
            }
        }
        return values;
    }

    public final void installTicks(int[] values, int size) {
        if (values == null || size <= 0) {
            return;
        }
        int n = values.length;
        int i = 0;
        while (i < n) {
            this.tickSequence.appendPaintable(this.makeTick(values[i], size));
            ++i;
        }
    }

    public final void installDefaultMajorTicks() {
        if (this.majorTicks <= 0) {
            return;
        }
        int[] values = this.getTickValues(this.majorTicks);
        this.installTicks(values, 8);
    }

    public final void installDefaultMinorTicks() {
        if (this.minorTicks <= 0) {
            return;
        }
        int[] values = this.getTickValues(this.minorTicks);
        this.installTicks(values, 4);
    }

    public final void installStandardTicks() {
        if (this.majorTicks > 0 || this.minorTicks > 0) {
            return;
        }
        this.majorTicks = Math.abs(this.delta / 10);
        this.installDefaultMajorTicks();
        this.majorTicks = 0;
    }

    public final TextPaintable makeLabel(int val, String label, int size) {
        val = this.getValidValue(val);
        int loc = this.valueToLocation(val);
        int p = 10 + this.gap;
        if (size > 0) {
            p += size + this.gap;
        }
        TextPaintable paintable = null;
        paintable = this.orientation == 0 ? new TextPaintable(label, this.labelFont, (Paint)this.commonColor, TextAnchor.CENTER_ASCENTLINE, (float)loc, (float)p) : new TextPaintable(label, this.labelFont, (Paint)this.commonColor, TextAnchor.LEFT_ASCENTLINE, (float)p, (float)(loc - this.fontSize / 2 + 1));
        return paintable;
    }

    public final String[] makeLabelStrings(int[] values) {
        if (values == null) {
            return new String[0];
        }
        int length = values.length;
        String[] labels = new String[length];
        int i = 0;
        while (i < length) {
            labels[i] = "" + values[i];
            ++i;
        }
        return labels;
    }

    public final TextPaintable[] makeLabels(int[] values, String[] labels, int size) {
        if (values == null || labels == null) {
            return new TextPaintable[0];
        }
        int a = values.length;
        int b = labels.length;
        int n = Math.min(a, b);
        TextPaintable[] tp = new TextPaintable[n];
        int i = 0;
        while (i < n) {
            tp[i] = this.makeLabel(values[i], labels[i], size);
            ++i;
        }
        return tp;
    }

    public final void installLabels(int[] values, String[] labels, int size) {
        this.labelSequence.appendSequence(this.makeLabels(values, labels, size));
    }

    public final void installDefaultLabels() {
        if (this.majorTicks <= 0) {
            return;
        }
        int[] values = this.getTickValues(this.majorTicks);
        String[] labels = this.makeLabelStrings(values);
        this.installLabels(values, labels, 8);
    }

    public void installStandardLabels() {
        if (this.majorTicks > 0 || this.minorTicks > 0) {
            return;
        }
        this.majorTicks = Math.abs(this.delta / 10);
        this.installDefaultLabels();
        this.majorTicks = 0;
    }

    public final void installObjects(Paintable[] objects) {
        this.objectSequence.appendSequence(objects);
    }

    public final int getValidValue(int val) {
        if (this.delta > 0) {
            if (val < this.minimum) {
                return this.minimum;
            }
            if (val > this.maximum) {
                return this.maximum;
            }
            return val;
        }
        if (val > this.minimum) {
            return this.minimum;
        }
        if (val < this.maximum) {
            return this.maximum;
        }
        return val;
    }

    public final int getValidLocation(int loc) {
        if (loc < 0) {
            return 0;
        }
        if (loc > this.limit) {
            return this.limit;
        }
        return loc;
    }

    public final int valueToLocation(int val) {
        return (int)Math.round(this.f_val_to_loc * (double)val + this.t_val_to_loc);
    }

    public final int locationToValue(int loc) {
        return (int)Math.round(this.f_loc_to_val * (double)loc + this.t_loc_to_val);
    }

    public final int getValue() {
        return this.value;
    }

    public final void setValue(int val) {
        this.pressActions.actionPerformed(this.pressEvent);
        this.setValueHelper(val);
        this.slidingActions.actionPerformed(this.slidingEvent);
        this.releaseActions.actionPerformed(this.releaseEvent);
    }

    public final void setValueHelper(int val) {
        this.value = this.getValidValue(val);
        this.location = this.valueToLocation(this.value);
        this.resetThumb();
        this.updateValueTFV();
    }

    public final int getTrackLocation() {
        return this.location;
    }

    public final void setTrackLocation(int loc) {
        this.pressActions.actionPerformed(this.pressEvent);
        this.setTrackLocationHelper(loc);
        this.slidingActions.actionPerformed(this.slidingEvent);
        this.releaseActions.actionPerformed(this.releaseEvent);
    }

    public final void setTrackLocationHelper(int loc) {
        this.location = this.getValidLocation(loc);
        this.value = this.locationToValue(this.location);
        this.resetThumb();
        this.updateValueTFV();
    }

    public final void resetThumb() {
        if (this.orientation == 0) {
            this.thumb.moveCenterTo(this.location, 0.0);
        } else {
            this.thumb.moveCenterTo(0.0, this.location);
        }
    }

    public final void setOrdinaryThumbPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.ordinaryThumbPaint = paint;
        if (!this.dragging) {
            this.thumb.setFillPaint(paint);
        }
    }

    public final void setSelectedThumbPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.selectedThumbPaint = paint;
        if (this.dragging) {
            this.thumb.setFillPaint(paint);
        }
    }

    public final void setTrackPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.trackPaint = paint;
        this.track.setFillPaint(paint);
    }

    public final void setCommonColor(Color color) {
        Paintable paintable;
        if (color == null) {
            return;
        }
        this.commonColor = color;
        this.trackBorder.setFillPaint(color);
        int n = this.tickSequence.length();
        int i = 0;
        while (i < n) {
            paintable = this.tickSequence.getPaintable(i);
            if (paintable instanceof ShapePaintable) {
                ShapePaintable sp = (ShapePaintable)paintable;
                sp.setDrawPaint(color);
            }
            ++i;
        }
        n = this.labelSequence.length();
        i = 0;
        while (i < n) {
            paintable = this.labelSequence.getPaintable(i);
            if (paintable instanceof TextPaintable) {
                TextPaintable tp = (TextPaintable)paintable;
                tp.setFillPaint(color);
            }
            ++i;
        }
        this.valueTFV.setForeground(this.commonColor);
        this.valueTFV.setSelectedTextColor(this.commonColor);
    }

    public void addPressAction(ActionListener a) {
        this.pressActions.add(a);
    }

    public void addSlidingAction(ActionListener a) {
        this.slidingActions.add(a);
    }

    public void addReleaseAction(ActionListener a) {
        this.releaseActions.add(a);
    }

    public void removePressAction(ActionListener a) {
        this.pressActions.remove(a);
    }

    public void removeSlidingAction(ActionListener a) {
        this.slidingActions.remove(a);
    }

    public void removeReleaseAction(ActionListener a) {
        this.releaseActions.remove(a);
    }

    public void setPressActions(ActionSequence sequence) {
        if (sequence == null) {
            this.pressActions.clear();
        } else {
            this.pressActions = sequence;
        }
    }

    public void setSlidingActions(ActionSequence sequence) {
        if (sequence == null) {
            this.slidingActions.clear();
        } else {
            this.slidingActions = sequence;
        }
    }

    public void setReleaseActions(ActionSequence sequence) {
        if (sequence == null) {
            this.releaseActions.clear();
        } else {
            this.releaseActions = sequence;
        }
    }

    public ActionSequence getPressActions() {
        return this.pressActions;
    }

    public ActionSequence getSlidingActions() {
        return this.slidingActions;
    }

    public ActionSequence getReleaseActions() {
        return this.releaseActions;
    }

    protected final void freezeBounds() {
        if (this.mainBounds != null) {
            return;
        }
        this.mainBounds = this.mainSequence.getBounds2D();
        this.mainSequence.setDefaultBounds2D(this.mainBounds);
        this.cornerX = (int)Math.round(this.mainBounds.x);
        this.cornerY = (int)Math.round(this.mainBounds.y);
    }

    protected final void setMouseCoordinates(MouseEvent evt) {
        if (evt == null) {
            return;
        }
        this.mouseX = this.cornerX + evt.getX();
        this.mouseY = this.cornerY + evt.getY();
    }

    protected final void updateValueTFV() {
        this.valueTFV.setViewState("" + this.value);
    }

    protected final void setValueFromValueTFV() {
        try {
            int val = this.valueTFV.requestInt();
            this.setValue(val);
        }
        catch (CancelledException ex) {
            this.updateValueTFV();
        }
    }

    protected final void mousePress(MouseEvent evt) {
        this.freezeBounds();
        this.setMouseCoordinates(evt);
        int index = this.mainSequence.hitsItemAtIndex(this.mouseX, this.mouseY);
        boolean bl = this.dragging = index >= 0 && index <= 2;
        if (this.dragging) {
            this.pressActions.actionPerformed(this.pressEvent);
            this.thumb.setFillPaint(this.selectedThumbPaint);
            if (this.orientation == 0) {
                this.setTrackLocationHelper(this.mouseX);
            } else {
                this.setTrackLocationHelper(this.mouseY);
            }
        }
    }

    protected final void mouseSliding(MouseEvent evt) {
        if (this.dragging) {
            this.setMouseCoordinates(evt);
            if (this.orientation == 0) {
                this.setTrackLocationHelper(this.mouseX);
            } else {
                this.setTrackLocationHelper(this.mouseY);
            }
            this.slidingActions.actionPerformed(this.slidingEvent);
        }
    }

    protected final void mouseRelease(MouseEvent evt) {
        if (this.dragging) {
            this.thumb.setFillPaint(this.ordinaryThumbPaint);
            this.setMouseCoordinates(evt);
            if (this.orientation == 0) {
                this.setTrackLocationHelper(this.mouseX);
            } else {
                this.setTrackLocationHelper(this.mouseY);
            }
            this.setValueHelper(this.value);
            this.dragging = false;
            this.slidingActions.actionPerformed(this.slidingEvent);
            this.releaseActions.actionPerformed(this.releaseEvent);
        }
    }

    public Stringable demandObject() {
        return new XInt(this.getValue());
    }

    public Stringable requestObject() {
        return this.demandObject();
    }

    public void setInputProperties(InputProperties p) {
        if (p == null) {
            p = InputProperties.BASE_PROPERTIES;
        }
        this.properties = p;
    }

    public InputProperties getInputProperties() {
        return this.properties;
    }

    public Class getDataType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.neu.ccs.XInt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void setViewState(String data) {
        try {
            XInt x = new XInt(data);
            this.setValue(x.getValue());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getViewState() {
        return "" + this.value;
    }

    public void setDefaultViewState(String data) {
        try {
            XInt x = new XInt(data);
            this.defaultValue = this.getValidValue(x.getValue());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getDefaultViewState() {
        return "" + this.defaultValue;
    }

    public void reset() {
        this.setValue(this.defaultValue);
    }

    public String toString() {
        return "" + this.value;
    }
}

