/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.HTable;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.SimpleFunctionPane;
import edu.neu.ccs.gui.TextFileIO;
import javax.swing.JButton;

public class SimpleFunctionPaneWithIO
extends SimpleFunctionPane {
    protected TextFileIO fileIO = new TextFileIO("fcn");
    protected SimpleAction save = new SimpleAction("Save Definitions"){

        public void perform() {
            SimpleFunctionPaneWithIO.this.saveDefinitions();
        }
    };
    protected SimpleAction read = new SimpleAction("Read Definitions"){

        public void perform() {
            SimpleFunctionPaneWithIO.this.readDefinitions();
        }
    };
    protected JButton saveButton = new JButton(this.save);
    protected JButton readButton = new JButton(this.read);
    protected Object[] IOButtons;
    protected HTable IOButtonsTable;

    public SimpleFunctionPaneWithIO() {
        this.saveButton.setFont(this.buttonFont);
        this.readButton.setFont(this.buttonFont);
        this.IOButtons = new Object[]{this.saveButton, this.readButton};
        this.IOButtonsTable = new HTable(this.IOButtons, this.gap, this.gap, 0);
        this.mainTable.addObject((Object)this.IOButtonsTable, 2);
    }

    protected void saveDefinitions() {
        String defs = this.parser.simpleFunctionsToString();
        this.fileIO.saveDataToFile(defs);
    }

    protected void readDefinitions() {
        try {
            try {
                String defs = this.fileIO.readDataFromFile();
                this.parser.stringToSimpleFunctions(defs);
            }
            catch (Throwable ex) {
                String message = "Error reading simple function definitions\n" + ex.getMessage();
                GeneralDialog.showOKDialog(message, "Simple Function Error");
            }
        }
        finally {
            this.populateFcnsList();
        }
    }

    public static void main(String[] args) {
        new SimpleFunctionPaneWithIO().frame("Simple Function Pane With IO");
    }
}

