/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Strings;
import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.BasePane;
import edu.neu.ccs.gui.Dropdown;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.HTable;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.VTable;
import edu.neu.ccs.parser.BaseParser;
import edu.neu.ccs.parser.ParserUtilities;
import edu.neu.ccs.parser.SimpleFunction;
import java.awt.Color;
import javax.swing.JButton;

public class SimpleFunctionPane
extends BasePane {
    protected BaseParser parser = ParserUtilities.getDefaultParser();
    protected Annotation fcnsLabel = new Annotation("Existing Simple Functions", this.labelFont);
    protected Dropdown fcnsList = new Dropdown(this.fieldFont, this.smallFieldWidth);
    protected SimpleAction selectFcn = new SimpleAction("Select Function"){

        public void perform() {
            SimpleFunctionPane.this.selectFunction();
        }
    };
    protected Annotation ordinaryFcnsLabel;
    protected Dropdown ordinaryFcnsList;
    protected SimpleAction revertOrdinaryAction;
    protected Annotation reservedLabel;
    protected Dropdown reservedList;
    protected SimpleAction revertReservedAction;
    protected Annotation nameLabel;
    protected TextFieldView nameTFV;
    protected Annotation paramsLabel;
    protected TextFieldView paramsTFV;
    protected Annotation bodyLabel;
    protected TextFieldView bodyTFV;
    protected Object[][] innerStuff;
    protected TablePanel innerPanel;
    protected Object[] definitionStuff;
    protected VTable definitionPanel;
    protected SimpleAction defFun;
    protected SimpleAction remFun;
    protected SimpleAction clear;
    protected JButton defFunButton;
    protected JButton remFunButton;
    protected JButton clearButton;
    protected Object[] defButtons;
    protected HTable defButtonsTable;
    protected Object[] mainStuff;
    protected VTable mainTable;

    public SimpleFunctionPane() {
        this.populateFcnsList();
        this.fcnsList.addActionListener(this.selectFcn);
        this.ordinaryFcnsLabel = new Annotation("Built-In Functions", this.labelFont);
        this.ordinaryFcnsList = new Dropdown(this.fieldFont, this.smallFieldWidth);
        this.revertOrdinaryAction = new SimpleAction(){

            public void perform() {
                SimpleFunctionPane.this.revertOrdinaryFcnsList();
            }
        };
        this.populateOrdinaryFcnsList();
        this.ordinaryFcnsList.addActionListener(this.revertOrdinaryAction);
        this.ordinaryFcnsList.setFocusable(false);
        this.reservedLabel = new Annotation("Special Forms", this.labelFont);
        this.reservedList = new Dropdown(this.fieldFont, this.smallFieldWidth);
        this.revertReservedAction = new SimpleAction(){

            public void perform() {
                SimpleFunctionPane.this.revertReservedList();
            }
        };
        this.populateReservedList();
        this.reservedList.addActionListener(this.revertReservedAction);
        this.reservedList.setFocusable(false);
        this.nameLabel = new Annotation("Function Name", this.labelFont);
        this.nameTFV = new TextFieldView(this.fieldFont, this.smallFieldWidth);
        this.paramsLabel = new Annotation("Function Parameters", this.labelFont);
        this.paramsTFV = new TextFieldView(this.fieldFont, this.smallFieldWidth);
        this.bodyLabel = new Annotation("Function Body", this.labelFont);
        this.bodyTFV = new TextFieldView(this.fieldFont, this.largeFieldWidth);
        this.innerStuff = new Object[][]{{this.fcnsLabel, this.ordinaryFcnsLabel}, {this.fcnsList, this.ordinaryFcnsList}, {this.nameLabel, this.reservedLabel}, {this.nameTFV, this.reservedList}};
        this.innerPanel = new TablePanel(this.innerStuff, 10 * this.gap, this.gap, 7);
        this.definitionStuff = new Object[]{this.innerPanel, this.paramsLabel, this.paramsTFV, this.bodyLabel, this.bodyTFV};
        this.definitionPanel = new VTable(this.definitionStuff, this.gap, this.gap, 7);
        this.defFun = new SimpleAction("Define Function"){

            public void perform() {
                SimpleFunctionPane.this.defineFunction();
            }
        };
        this.remFun = new SimpleAction("Remove Function"){

            public void perform() {
                SimpleFunctionPane.this.removeFunction();
            }
        };
        this.clear = new SimpleAction("Clear Fields"){

            public void perform() {
                SimpleFunctionPane.this.clearFields();
            }
        };
        this.defFunButton = new JButton(this.defFun);
        this.remFunButton = new JButton(this.remFun);
        this.clearButton = new JButton(this.clear);
        this.defFunButton.setFont(this.buttonFont);
        this.remFunButton.setFont(this.buttonFont);
        this.clearButton.setFont(this.buttonFont);
        this.defButtons = new Object[]{this.defFunButton, this.remFunButton, this.clearButton};
        this.defButtonsTable = new HTable(this.defButtons, this.gap, this.gap, 0);
        this.mainStuff = new Object[]{this.definitionPanel, this.defButtonsTable};
        this.mainTable = new VTable(this.mainStuff, this.gap, this.gap, 0);
        this.mainTable.emptyBorder(this.gap);
        this.mainTable.titleBorder(" Simple Function Definition Pane ", this.labelFont, Color.black);
        this.add(this.mainTable);
    }

    protected void populateFcnsList() {
        String[] names = this.parser.simpleFunctionNames();
        int length = names.length;
        String[] list = new String[length + 1];
        list[0] = "";
        int i = 0;
        while (i < length) {
            list[i + 1] = names[i];
            ++i;
        }
        this.fcnsList.setItems(list);
    }

    protected void populateOrdinaryFcnsList() {
        String[] names = this.parser.ordinaryFunctionNames();
        int length = names.length;
        String[] list = new String[length + 1];
        list[0] = "";
        int i = 0;
        while (i < length) {
            list[i + 1] = names[i];
            ++i;
        }
        this.ordinaryFcnsList.setItems(list);
    }

    protected void revertOrdinaryFcnsList() {
        this.ordinaryFcnsList.setSelectedIndex(0);
    }

    protected void populateReservedList() {
        String[] names = this.parser.reserved();
        int length = names.length;
        String[] list = new String[length + 1];
        list[0] = "";
        int i = 0;
        while (i < length) {
            list[i + 1] = names[i];
            ++i;
        }
        this.reservedList.setItems(list);
    }

    protected void revertReservedList() {
        this.reservedList.setSelectedIndex(0);
    }

    protected void selectFunction() {
        String name = (String)this.fcnsList.getSelectedItem();
        if (this.parser.isSimpleFunctionName(name)) {
            SimpleFunction function = (SimpleFunction)this.parser.getFunction(name);
            this.nameTFV.setViewState(function.name());
            this.paramsTFV.setViewState(function.parametersAsString());
            this.bodyTFV.setViewState(function.body());
            this.fcnsList.setSelectedIndex(0);
        }
    }

    protected void defineFunction() {
        String name = this.nameTFV.getViewState().trim();
        String body = this.bodyTFV.getViewState().trim();
        String[] parameters = Strings.splitCommaList(this.paramsTFV.getViewState());
        String message = SimpleFunction.testFunctionName(name);
        if (message == null) {
            message = SimpleFunction.testParameterArrayNames(parameters, name);
        }
        if (message == null) {
            message = SimpleFunction.testFunctionBody(body);
        }
        if (message != null) {
            GeneralDialog.showOKDialog(message, "Simple Function Definition Error");
            return;
        }
        new SimpleFunction(name, parameters, body);
        this.populateFcnsList();
        this.clearFields();
    }

    protected void removeFunction() {
        String name = this.nameTFV.getViewState().trim();
        String message = null;
        if (this.parser.isSimpleFunctionName(name)) {
            this.parser.removeFunction(name);
            this.populateFcnsList();
            this.clearFields();
            return;
        }
        message = this.parser.isOrdinaryFunctionName(name) ? "You may not remove an existing built-in function " : "Function " + name + " is not installed";
        GeneralDialog.showOKDialog(message, "Simple Function Removal Error");
    }

    protected void clearFields() {
        this.nameTFV.setViewState("");
        this.paramsTFV.setViewState("");
        this.bodyTFV.setViewState("");
    }

    public static void main(String[] args) {
        new SimpleFunctionPane().frame("Simple Function Pane");
    }
}

