/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.PaintMode;
import edu.neu.ccs.gui.PathList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;

public class ShapePaintable
extends AbstractPaintable {
    public static final PaintMode DEFAULT_PAINTMODE = PaintMode.DRAW;
    public static final Paint DEFAULT_FILLPAINT = Color.black;
    public static final Paint DEFAULT_DRAWPAINT = Color.black;
    public static final Stroke DEFAULT_DRAWSTROKE = new BasicStroke(2.0f);
    public static final String SET_SHAPE = "set.shape";
    public static final String SET_PAINT_MODE = "set.paint.mode";
    public static final String SET_FILL_PAINT = "set.fill.paint";
    public static final String SET_DRAW_PAINT = "set.draw.paint";
    public static final String SET_DRAW_STROKE = "set.draw.stroke";
    private Shape shape = null;
    private PaintMode paintmode = DEFAULT_PAINTMODE;
    private Paint fillpaint = DEFAULT_FILLPAINT;
    private Paint drawpaint = DEFAULT_DRAWPAINT;
    private Stroke drawstroke = DEFAULT_DRAWSTROKE;

    public ShapePaintable() {
        this((Shape)null, (PaintMode)null, (Paint)null, (Paint)null, (Stroke)null);
    }

    public ShapePaintable(Shape shape) {
        this(shape, null, null, null, null);
    }

    public ShapePaintable(Shape shape, PaintMode paintmode) {
        this(shape, paintmode, null, null, null);
    }

    public ShapePaintable(Shape shape, PaintMode paintmode, Paint fillpaint) {
        this(shape, paintmode, fillpaint, null, null);
    }

    public ShapePaintable(Shape shape, PaintMode paintmode, Paint fillpaint, Paint drawpaint) {
        this(shape, paintmode, fillpaint, drawpaint, null);
    }

    public ShapePaintable(Shape shape, PaintMode paintmode, Paint fillpaint, Paint drawpaint, Stroke drawstroke) {
        this.setShape(shape);
        this.setPaintMode(paintmode);
        this.setFillPaint(fillpaint);
        this.setDrawPaint(drawpaint);
        this.setDrawStroke(drawstroke);
    }

    public ShapePaintable(PathList pathlist) {
        this(pathlist == null ? null : pathlist.makeShape(), null, null, null, null);
    }

    public ShapePaintable(PathList pathlist, PaintMode paintmode) {
        this(pathlist == null ? null : pathlist.makeShape(), paintmode, null, null, null);
    }

    public ShapePaintable(PathList pathlist, PaintMode paintmode, Paint fillpaint) {
        this(pathlist == null ? null : pathlist.makeShape(), paintmode, fillpaint, null, null);
    }

    public ShapePaintable(PathList pathlist, PaintMode paintmode, Paint fillpaint, Paint drawpaint) {
        this(pathlist == null ? null : pathlist.makeShape(), paintmode, fillpaint, drawpaint, null);
    }

    public ShapePaintable(PathList pathlist, PaintMode paintmode, Paint fillpaint, Paint drawpaint, Stroke drawstroke) {
        this(pathlist == null ? null : pathlist.makeShape(), paintmode, fillpaint, drawpaint, drawstroke);
    }

    public final void originalPaint(Graphics g) {
        if (this.shape == null || g == null || !this.isVisible()) {
            return;
        }
        Graphics h = g.create();
        this.paintmode.originalPaint(this, h);
    }

    public final XRect getActualBounds2D() {
        if (this.shape == null) {
            return null;
        }
        XRect bounds = this.paintmode.getActualBounds2D(this);
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        if (w <= 0.0 || h <= 0.0) {
            return null;
        }
        return bounds;
    }

    public final boolean originalContains(double x, double y) {
        return this.paintmode.originalContains(this, x, y);
    }

    public final void setShape(Shape shape) {
        if (shape == this.shape) {
            return;
        }
        this.removeAndAddForwardingListener(this.shape, shape);
        this.shape = shape;
        this.firePropertyChange(SET_SHAPE, null, null);
    }

    public final Shape getShape() {
        return this.shape;
    }

    public final Shape getStrokedShape() {
        if (this.shape == null) {
            return null;
        }
        return this.drawstroke.createStrokedShape(this.shape);
    }

    public Shape getOutline() {
        return this.paintmode.getOutline(this);
    }

    public final void setFillPaint(Paint fillpaint) {
        if (fillpaint == null || fillpaint.equals(this.fillpaint)) {
            return;
        }
        this.removeAndAddForwardingListener(this.fillpaint, fillpaint);
        this.fillpaint = fillpaint;
        this.firePropertyChange(SET_FILL_PAINT, null, null);
    }

    public final Paint getFillPaint() {
        return this.fillpaint;
    }

    public final void setDrawPaint(Paint drawpaint) {
        if (drawpaint == null || drawpaint.equals(this.drawpaint)) {
            return;
        }
        this.removeAndAddForwardingListener(this.drawpaint, drawpaint);
        this.drawpaint = drawpaint;
        this.firePropertyChange(SET_DRAW_PAINT, null, null);
    }

    public final Paint getDrawPaint() {
        return this.drawpaint;
    }

    public final void setDrawStroke(Stroke drawstroke) {
        if (drawstroke == null || drawstroke.equals(this.drawstroke)) {
            return;
        }
        this.removeAndAddForwardingListener(this.drawstroke, drawstroke);
        this.drawstroke = drawstroke;
        this.firePropertyChange(SET_DRAW_STROKE, null, null);
    }

    public final Stroke getDrawStroke() {
        return this.drawstroke;
    }

    public final void setPaintMode(PaintMode paintmode) {
        if (paintmode == null || paintmode.equals(this.paintmode)) {
            return;
        }
        this.removeAndAddForwardingListener(this.paintmode, paintmode);
        this.paintmode = paintmode;
        this.firePropertyChange(SET_PAINT_MODE, null, null);
    }

    public final PaintMode getPaintMode() {
        return this.paintmode;
    }

    public final void setFillMode() {
        this.setPaintMode(PaintMode.FILL);
    }

    public final void setDrawMode() {
        this.setPaintMode(PaintMode.DRAW);
    }

    public final void setFillDrawMode() {
        this.setPaintMode(PaintMode.FILL_DRAW);
    }
}

