/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class ShapeCapsule
extends JComponent {
    protected Shape shape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    protected Paint paint = Color.black;

    public ShapeCapsule(Shape shape) {
        this(shape, null);
    }

    public ShapeCapsule(Shape shape, Paint color) {
        this.setPaint(color);
        this.setShape(shape);
    }

    public void setShape(Shape s) {
        if (s == null) {
            return;
        }
        this.shape = new GeneralPath(s);
        Rectangle bounds = this.shape.getBounds();
        Insets insets = this.getInsets();
        super.setBounds(bounds.x - insets.left, bounds.y - insets.top, bounds.width + insets.left + insets.right, bounds.height + insets.top + insets.bottom);
        this.setPreferredSize(new Dimension(bounds.width, bounds.height));
        this.repaint();
    }

    public Shape getShape() {
        return new GeneralPath(this.shape);
    }

    public void setPaint(Paint color) {
        this.paint = color;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setLocation(Point location) {
        this.setBounds(location.x, location.y, this.getWidth(), this.getHeight());
    }

    public void setLocation(int x, int y) {
        this.setBounds(x, y, this.getWidth(), this.getHeight());
    }

    public void setSize(Dimension size) {
        this.setBoundsImpl(this.getX(), this.getY(), size.width, size.height);
    }

    public void setSize(int width, int height) {
        this.setBoundsImpl(this.getX(), this.getY(), width, height);
    }

    public void setBounds(Rectangle bounds) {
        this.setBoundsImpl(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBoundsImpl(x, y, width, height);
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath path = new GeneralPath(this.getShape());
        Rectangle bounds = path.getBounds();
        Insets insets = this.getInsets();
        path.transform(AffineTransform.getTranslateInstance(0 - (bounds.x + insets.left), 0 - (bounds.y + insets.top)));
        g2.setPaint(this.getPaint());
        g2.fill(path);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    private void setBoundsImpl(int x, int y, int width, int height) {
        GeneralPath path = new GeneralPath(this.shape);
        Rectangle bounds = path.getBounds();
        path.transform(AffineTransform.getTranslateInstance(-bounds.x, -bounds.y));
        path.transform(AffineTransform.getScaleInstance((double)width / (double)bounds.width, (double)height / (double)bounds.height));
        path.transform(AffineTransform.getTranslateInstance(x, y));
        this.setShape(path);
    }
}

