/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.BooleanView;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.ImageViewer;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.ThreadedAction;

public class RequestImageViewer
extends DisplayPanel {
    private TextFieldView directoryView = new TextFieldView("", 600);
    private TextFieldView filelistView = new TextFieldView("imagelist.txt", 600);
    private JPTFrame helpFrame = null;
    private SimpleAction help = new SimpleAction("Show Image Viewer Help"){

        public void perform() {
            RequestImageViewer.this.showHelp();
        }
    };
    private SimpleAction action = new SimpleAction("Make Image Viewer"){

        public void perform() {
            RequestImageViewer.this.makeImageViewer();
        }
    };
    private ThreadedAction threadedaction = new ThreadedAction(this.action);
    private BooleanView autoscaleview = new BooleanView("Scale Images to Fit Screen", false);
    private TablePanel panel = new TablePanel(new Object[][]{{"Images Directory", this.directoryView}, {"Image List Name", this.filelistView}}, 10, 10, 0);
    private TablePanel helpPanel;
    private TablePanel mainPanel;

    public RequestImageViewer() {
        Object[][] objectArray = new Object[4][];
        objectArray[0] = new Object[]{"Images Directory:", "The local directory with the images"};
        Object[] objectArray2 = new Object[2];
        objectArray2[1] = "     No default";
        objectArray[1] = objectArray2;
        objectArray[2] = new Object[]{"Image List Name:", "The text file that contains the list of image file names"};
        Object[] objectArray3 = new Object[2];
        objectArray3[1] = "     If blank, then reads all images in the directory";
        objectArray[3] = objectArray3;
        this.helpPanel = new TablePanel(objectArray, 10, 10, 7);
        this.mainPanel = new TablePanel(new Object[]{this.help, this.panel, this.autoscaleview, this.threadedaction}, 1, 10, 10, 0);
        this.add(this.mainPanel);
        this.frame("Request Image Viewer");
    }

    private void makeImageViewer() {
        String directory = this.directoryView.getViewState();
        String filelist = this.filelistView.getViewState();
        boolean autoscale = this.autoscaleview.getBooleanValue();
        new ImageViewer(directory, filelist, autoscale);
    }

    private void showHelp() {
        if (this.helpFrame == null) {
            this.helpFrame = this.helpPanel.frame("Image Viewer Help", 1);
        } else {
            this.helpFrame.show();
        }
    }
}

