/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.PolygonShape;
import edu.neu.ccs.util.MathUtilities;

public class RegularShape {
    private RegularShape() {
    }

    public static PolygonShape polygon(double x, double y, double r, int vertices) {
        return new PolygonShape(RegularShape.regularShapeDataFloat(x, y, r, vertices, 1));
    }

    public static PolygonShape star(double x, double y, double r, int vertices, int jump) {
        return new PolygonShape(RegularShape.regularShapeDataFloat(x, y, r, vertices, jump));
    }

    public static double[][] regularShapeData(double x, double y, double r, int vertices, int jump) {
        if ((vertices = Math.abs(vertices)) < 3) {
            vertices = 3;
        }
        if (vertices < 5) {
            jump = 1;
        } else {
            jump = Math.abs(jump);
            int half = vertices / 2;
            if ((jump %= vertices) > half) {
                jump = vertices - jump;
            }
            if (jump == 0 || 2 * jump == vertices) {
                jump = 1;
            }
        }
        double[][] result = null;
        if (jump == 1) {
            int V = vertices;
            int I = 0;
            result = new double[V][2];
            double T = 0.0;
            double C = 360.0 / (double)V;
            while (I < V) {
                result[I][0] = x + r * MathUtilities.sindeg(T);
                result[I][1] = y - r * MathUtilities.cosdeg(T);
                ++I;
                T += C;
            }
        } else {
            int V = 2 * vertices;
            int I = 0;
            result = new double[V][2];
            double T = 0.0;
            double C = 360.0 / (double)V;
            double A = 90.0 - C * (double)jump;
            double B = 180.0 - A - C;
            double sinA = MathUtilities.sindeg(A);
            double sinB = MathUtilities.sindeg(B);
            double s = r * sinA / sinB;
            while (I < V) {
                result[I][0] = x + r * MathUtilities.sindeg(T);
                result[I][1] = y - r * MathUtilities.cosdeg(T);
                result[++I][0] = x + s * MathUtilities.sindeg(T += C);
                result[I][1] = y - s * MathUtilities.cosdeg(T);
                ++I;
                T += C;
            }
        }
        return result;
    }

    public static float[][] regularShapeDataFloat(double x, double y, double r, int vertices, int jump) {
        double[][] dataD = RegularShape.regularShapeData(x, y, r, vertices, jump);
        int V = dataD.length;
        float[][] dataF = new float[V][2];
        int i = 0;
        while (i < V) {
            int j = 0;
            while (j < 2) {
                dataF[i][j] = (float)dataD[i][j];
                ++j;
            }
            ++i;
        }
        return dataF;
    }
}

