/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ActionSequence;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.Refresh;
import edu.neu.ccs.gui.TableLayout;
import edu.neu.ccs.quick.QuickHashMap;
import edu.neu.ccs.quick.StringObjectMap;
import edu.neu.ccs.quick.StringObjectPair;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioPanel
extends JPanel
implements Displayable,
JPTConstants {
    public static final String OPTION_COUNT = "option.count";
    public static final String SELECTED_INDEX = "selected.index";
    public static final String SELECTED_LABEL = "selected.label";
    public static final String SELECTED_BUTTON = "selected.button";
    public static final String SET_LABEL_TEXT = "set.label.text";
    public static final String BACKGROUND = "set.background";
    protected static final int DEFAULT_SELECTION = 0;
    protected String defaultViewState = "";
    protected StringObjectMap labelButtonMap = new StringObjectMap();
    protected QuickHashMap labelIndexMap = new QuickHashMap();
    protected QuickHashMap modelButtonMap = new QuickHashMap();
    protected ButtonGroup buttonGroup = new ButtonGroup();
    protected TableLayout defaultLayout = new TableLayout(1, 1, 0, 0, 7, 1);
    protected ActionSequence commonactions = new ActionSequence();

    public RadioPanel() {
        this.initializeRadioPanel(null, 0, null);
    }

    public RadioPanel(LayoutManager layout) {
        this.initializeRadioPanel(null, 0, layout);
    }

    public RadioPanel(String[] strings) {
        this.initializeRadioPanel(strings, 0, null);
    }

    public RadioPanel(String[] strings, LayoutManager layout) {
        this.initializeRadioPanel(strings, 0, layout);
    }

    public RadioPanel(String[] strings, int selection) {
        this.initializeRadioPanel(strings, selection, null);
    }

    public RadioPanel(String[] strings, int selection, LayoutManager layout) {
        this.initializeRadioPanel(strings, selection, layout);
    }

    public RadioPanel(String[] strings, ActionListener action) {
        this.addActionListener(action);
        this.initializeRadioPanel(strings, 0, null);
    }

    public RadioPanel(String[] strings, ActionListener action, LayoutManager layout) {
        this.addActionListener(action);
        this.initializeRadioPanel(strings, 0, layout);
    }

    public RadioPanel(String[] strings, ActionListener action, int selection) {
        this.addActionListener(action);
        this.initializeRadioPanel(strings, selection, null);
    }

    public RadioPanel(String[] strings, ActionListener action, int selection, LayoutManager layout) {
        this.addActionListener(action);
        this.initializeRadioPanel(strings, selection, layout);
    }

    public RadioPanel(String[] strings, ActionListener[] actions) {
        this.initializeRadioPanel(strings, 0, null);
        this.addActionListeners(actions);
    }

    public RadioPanel(String[] strings, ActionListener[] actions, LayoutManager layout) {
        this.initializeRadioPanel(strings, 0, layout);
        this.addActionListeners(actions);
    }

    public RadioPanel(String[] strings, ActionListener[] actions, int selection) {
        this.initializeRadioPanel(strings, selection, null);
        this.addActionListeners(actions);
    }

    public RadioPanel(String[] strings, ActionListener[] actions, int selection, LayoutManager layout) {
        this.initializeRadioPanel(strings, selection, layout);
        this.addActionListeners(actions);
    }

    protected final void initializeRadioPanel(String[] strings, int selection, LayoutManager layout) {
        super.setFont(RadioPanel.getDefaultFont());
        if (layout == null) {
            layout = this.defaultLayout;
        }
        this.setLayout(layout);
        this.addOptions(strings);
        this.setSelectedIndex(selection);
        this.setDefaultViewState(this.getViewState());
    }

    public final int getIndex(String label) {
        if (label == null) {
            return -1;
        }
        if (!this.labelButtonMap.containsString(label)) {
            return -1;
        }
        Integer index = (Integer)this.labelIndexMap.get(label);
        return index;
    }

    public final int getIndex(JRadioButton button) {
        return this.getIndex(this.getLabel(button));
    }

    public final String getLabel(int index) {
        return this.labelButtonMap.getString(index);
    }

    public final String getLabel(JRadioButton button) {
        if (button == null) {
            return null;
        }
        if (!this.labelButtonMap.containsObject(button)) {
            return null;
        }
        return button.getText();
    }

    public final JRadioButton getOptionButton(int index) {
        return (JRadioButton)this.labelButtonMap.getObject(index);
    }

    public final JRadioButton getOptionButton(String label) {
        return (JRadioButton)this.labelButtonMap.getObject(label);
    }

    protected final JRadioButton getOptionButton(ButtonModel model) {
        return (JRadioButton)this.modelButtonMap.get(model);
    }

    protected final ButtonModel getButtonModel(JRadioButton button) {
        if (button == null) {
            return null;
        }
        if (!this.labelButtonMap.containsObject(button)) {
            return null;
        }
        return button.getModel();
    }

    public final boolean setSelectedIndex(int index) {
        if (this.getOptionCount() == 0) {
            return false;
        }
        int oldIndex = this.getSelectedIndex();
        if (index == oldIndex) {
            return false;
        }
        ButtonModel model = this.getButtonModel(this.getOptionButton(index));
        if (model == null) {
            return false;
        }
        this.buttonGroup.setSelected(model, true);
        this.repaint();
        this.firePropertyChange(SELECTED_INDEX, oldIndex, index);
        return true;
    }

    public final int getSelectedIndex() {
        return this.getIndex(this.getSelectedButton());
    }

    public final boolean setSelectedLabel(String label) {
        if (this.getOptionCount() == 0) {
            return false;
        }
        if (label == null) {
            return false;
        }
        String oldLabel = this.getSelectedLabel();
        if (label.equals(oldLabel)) {
            return false;
        }
        ButtonModel model = this.getButtonModel(this.getOptionButton(label));
        if (model == null) {
            return false;
        }
        this.buttonGroup.setSelected(model, true);
        this.repaint();
        this.firePropertyChange(SELECTED_LABEL, oldLabel, label);
        return true;
    }

    public final String getSelectedLabel() {
        return this.getLabel(this.getSelectedButton());
    }

    public final boolean setSelectedButton(JRadioButton button) {
        if (this.getOptionCount() == 0) {
            return false;
        }
        if (button == null) {
            return false;
        }
        JRadioButton oldButton = this.getSelectedButton();
        if (button == oldButton) {
            return false;
        }
        ButtonModel model = this.getButtonModel(button);
        if (model == null) {
            return false;
        }
        this.buttonGroup.setSelected(model, true);
        this.repaint();
        this.firePropertyChange(SELECTED_BUTTON, oldButton, button);
        return true;
    }

    public final JRadioButton getSelectedButton() {
        if (this.getOptionCount() == 0) {
            return null;
        }
        return this.getOptionButton(this.buttonGroup.getSelection());
    }

    public final boolean setLabelText(int index, String label) {
        if (index < 0 || index >= this.getOptionCount()) {
            return false;
        }
        if (label == null) {
            return false;
        }
        StringObjectPair pair = this.labelButtonMap.remove(index);
        String string = pair.getString();
        JRadioButton button = (JRadioButton)pair.getObject();
        if (this.labelButtonMap.containsString(label)) {
            this.labelButtonMap.addPair(index, pair);
            return false;
        }
        this.labelIndexMap.remove(string);
        this.labelButtonMap.addPair(index, label, button);
        this.labelIndexMap.put(label, new Integer(index));
        button.setText(label);
        this.refreshComponent();
        this.firePropertyChange(SET_LABEL_TEXT, string, label);
        return true;
    }

    public final String getLabelText(int index) {
        return this.getLabel(index);
    }

    public final void addOption(String label) {
        this.addOption(label, null, false);
    }

    public final void addOption(String label, Action action) {
        this.addOption(label, action, false);
    }

    public final void addOption(String label, boolean selected) {
        this.addOption(label, null, selected);
    }

    public final void addOption(String label, Action action, boolean selected) {
        if (label == null) {
            return;
        }
        if (this.labelButtonMap.containsString(label)) {
            return;
        }
        int index = this.labelButtonMap.size();
        if (index == 0) {
            selected = true;
            this.setDefaultViewState(label);
        }
        JRadioButton button = new JRadioButton(label);
        button.setFont(this.getFont());
        ButtonModel model = button.getModel();
        this.labelButtonMap.addPair(label, button);
        this.labelIndexMap.put(label, new Integer(index));
        this.modelButtonMap.put(model, button);
        button.addActionListener(this.commonactions);
        if (action != null) {
            button.addActionListener(action);
        }
        this.buttonGroup.add(button);
        this.buttonGroup.setSelected(model, selected);
        this.add(button);
        this.refreshComponent();
        this.firePropertyChange(OPTION_COUNT, index, index + 1);
    }

    public final void addOptions(String[] labels) {
        if (labels == null) {
            return;
        }
        int i = 0;
        while (i < labels.length) {
            this.addOption(labels[i]);
            ++i;
        }
    }

    public final void addOptions(String[] labels, Action action) {
        if (labels == null) {
            return;
        }
        int i = 0;
        while (i < labels.length) {
            this.addOption(labels[i], action);
            ++i;
        }
    }

    public final void addOptions(String[] labels, Action[] actions) {
        if (labels == null) {
            return;
        }
        int actionslength = actions != null ? actions.length : 0;
        int i = 0;
        while (i < labels.length) {
            if (i < actionslength) {
                this.addOption(labels[i], actions[i]);
            } else {
                this.addOption(labels[i]);
            }
            ++i;
        }
    }

    public final int getOptionCount() {
        return this.labelButtonMap.size();
    }

    public final JRadioButton[] getOptionButtons() {
        if (this.labelButtonMap == null) {
            return new JRadioButton[0];
        }
        Object[] objects = this.labelButtonMap.getObjects();
        int length = objects.length;
        JRadioButton[] buttons = new JRadioButton[length];
        int i = 0;
        while (i < length) {
            buttons[i] = (JRadioButton)objects[i];
            ++i;
        }
        return buttons;
    }

    public final void addActionListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        this.commonactions.add(listener);
    }

    public final void addActionListener(int index, ActionListener listener) {
        if (listener == null) {
            return;
        }
        if (index < 0 || index >= this.getOptionCount()) {
            return;
        }
        this.getOptionButton(index).addActionListener(listener);
    }

    public final void addActionListeners(ActionListener[] listeners) {
        if (listeners == null) {
            return;
        }
        int length = Math.min(this.getOptionCount(), listeners.length);
        int i = 0;
        while (i < length) {
            this.addActionListener(i, listeners[i]);
            ++i;
        }
    }

    public final void removeActionListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        this.commonactions.remove(listener);
    }

    public final void removeActionListener(int index, ActionListener listener) {
        if (listener == null) {
            return;
        }
        if (index < 0 || index >= this.getOptionCount()) {
            return;
        }
        this.getOptionButton(index).removeActionListener(listener);
    }

    public final void removeActionListeners(ActionListener[] listeners) {
        if (listeners == null) {
            return;
        }
        int length = Math.min(this.getOptionCount(), listeners.length);
        int i = 0;
        while (i < length) {
            this.removeActionListener(i, listeners[i]);
            ++i;
        }
    }

    public void setFont(Font font) {
        if (this.labelButtonMap == null) {
            super.setFont(font);
            return;
        }
        if (font == null) {
            font = RadioPanel.getDefaultFont();
        }
        super.setFont(font);
        JRadioButton[] buttons = this.getOptionButtons();
        int length = buttons.length;
        if (length > 0) {
            int i = 0;
            while (i < length) {
                buttons[i].setFont(font);
                ++i;
            }
        }
        this.refreshComponent();
        this.firePropertyChange("set.font", null, null);
    }

    public static Font getDefaultFont() {
        return new JRadioButton(" ").getFont();
    }

    public void setBackground(Color color) {
        if (this.labelButtonMap == null) {
            super.setBackground(color);
            return;
        }
        if (color == null) {
            color = RadioPanel.getDefaultBackground();
        }
        super.setBackground(color);
        JRadioButton[] buttons = this.getOptionButtons();
        int length = buttons.length;
        if (length > 0) {
            int i = 0;
            while (i < length) {
                buttons[i].setBackground(color);
                ++i;
            }
        }
        this.repaint();
        this.firePropertyChange(BACKGROUND, null, null);
    }

    public static Color getDefaultBackground() {
        return new JRadioButton(" ").getBackground();
    }

    public void setViewState(String state) {
        String oldState = this.getSelectedLabel();
        if (this.setSelectedLabel(state)) {
            this.firePropertyChange("view.state", oldState, state);
        }
    }

    public String getViewState() {
        return this.getSelectedLabel();
    }

    public void setDefaultViewState(String state) {
        if (state == null) {
            return;
        }
        String oldState = this.getDefaultViewState();
        if (state.equals(oldState)) {
            return;
        }
        this.defaultViewState = state;
        this.firePropertyChange("default.view.state", oldState, state);
    }

    public String getDefaultViewState() {
        return this.defaultViewState;
    }

    public final void reset() {
        this.setViewState(this.getDefaultViewState());
    }

    public final void setEnabled(boolean isEnabled) {
        int length = this.getOptionCount();
        int i = 0;
        while (i < length) {
            this.getOptionButton(i).setEnabled(isEnabled);
            ++i;
        }
        super.setEnabled(isEnabled);
    }

    public void refreshComponent() {
        Refresh.packParentWindow(this);
    }
}

