/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XCircle;
import edu.neu.ccs.XSquare;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public abstract class PlotMarkAlgorithm {
    public static final PlotMarkAlgorithm HBar = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)(x - (double)s), (float)y);
            path.lineTo((float)(x + (double)s), (float)y);
            return path;
        }
    };
    public static final PlotMarkAlgorithm VBar = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)(y - (double)s));
            path.lineTo((float)x, (float)(y + (double)s));
            return path;
        }
    };
    public static final PlotMarkAlgorithm Plus = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)(x - (double)s), (float)y);
            path.lineTo((float)(x + (double)s), (float)y);
            path.moveTo((float)x, (float)(y - (double)s));
            path.lineTo((float)x, (float)(y + (double)s));
            return path;
        }
    };
    public static final PlotMarkAlgorithm Cross = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)(x - (double)s), (float)(y - (double)s));
            path.lineTo((float)(x + (double)s), (float)(y + (double)s));
            path.moveTo((float)(x + (double)s), (float)(y - (double)s));
            path.lineTo((float)(x - (double)s), (float)(y + (double)s));
            return path;
        }
    };
    public static final PlotMarkAlgorithm Asterisk = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)(x - (double)s), (float)y);
            path.lineTo((float)(x + (double)s), (float)y);
            path.moveTo((float)x, (float)(y - (double)s));
            path.lineTo((float)x, (float)(y + (double)s));
            path.moveTo((float)(x - (double)s), (float)(y - (double)s));
            path.lineTo((float)(x + (double)s), (float)(y + (double)s));
            path.moveTo((float)(x + (double)s), (float)(y - (double)s));
            path.lineTo((float)(x - (double)s), (float)(y + (double)s));
            return path;
        }
    };
    public static final PlotMarkAlgorithm Square = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            return new XSquare(x, y, size);
        }
    };
    public static final PlotMarkAlgorithm Diamond = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)(y - (double)s));
            path.lineTo((float)(x + (double)s), (float)y);
            path.lineTo((float)x, (float)(y + (double)s));
            path.lineTo((float)(x - (double)s), (float)y);
            path.closePath();
            return path;
        }
    };
    public static PlotMarkAlgorithm BetterCircle = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size > 16384) {
                return JavaCircle.makeShape(x, y, size);
            }
            int a = (int)Math.round(x);
            int b = (int)Math.round(y);
            return 8.BetterCirclePath(a, b, size);
        }
    };
    public static final PlotMarkAlgorithm JavaCircle = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            return new XCircle(x, y, size);
        }
    };
    public static final PlotMarkAlgorithm WedgeN = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            int d = 2 * size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x + (double)s), (float)(y + (double)d));
            path.lineTo((float)(x - (double)s), (float)(y + (double)d));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm WedgeE = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            int d = 2 * size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x - (double)d), (float)(y + (double)s));
            path.lineTo((float)(x - (double)d), (float)(y - (double)s));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm WedgeS = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            int d = 2 * size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x - (double)s), (float)(y - (double)d));
            path.lineTo((float)(x + (double)s), (float)(y - (double)d));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm WedgeW = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            int d = 2 * size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x + (double)d), (float)(y - (double)s));
            path.lineTo((float)(x + (double)d), (float)(y + (double)s));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm BluntWedgeN = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x + (double)s), (float)(y + (double)s));
            path.lineTo((float)(x - (double)s), (float)(y + (double)s));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm BluntWedgeE = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x - (double)s), (float)(y + (double)s));
            path.lineTo((float)(x - (double)s), (float)(y - (double)s));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm BluntWedgeS = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x - (double)s), (float)(y - (double)s));
            path.lineTo((float)(x + (double)s), (float)(y - (double)s));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm BluntWedgeW = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x + (double)s), (float)(y - (double)s));
            path.lineTo((float)(x + (double)s), (float)(y + (double)s));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm SharpWedgeN = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            int d = 3 * size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x + (double)s), (float)(y + (double)d));
            path.lineTo((float)(x - (double)s), (float)(y + (double)d));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm SharpWedgeE = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            int d = 3 * size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x - (double)d), (float)(y + (double)s));
            path.lineTo((float)(x - (double)d), (float)(y - (double)s));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm SharpWedgeS = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            int d = 3 * size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x - (double)s), (float)(y - (double)d));
            path.lineTo((float)(x + (double)s), (float)(y - (double)d));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm SharpWedgeW = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            int d = 3 * size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x + (double)d), (float)(y - (double)s));
            path.lineTo((float)(x + (double)d), (float)(y + (double)s));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm ThumbN = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            int d = 2 * size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x + (double)s), (float)(y + (double)s));
            path.lineTo((float)(x + (double)s), (float)(y + (double)d));
            path.lineTo((float)(x - (double)s), (float)(y + (double)d));
            path.lineTo((float)(x - (double)s), (float)(y + (double)s));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm ThumbE = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            int d = 2 * size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x - (double)s), (float)(y + (double)s));
            path.lineTo((float)(x - (double)d), (float)(y + (double)s));
            path.lineTo((float)(x - (double)d), (float)(y - (double)s));
            path.lineTo((float)(x - (double)s), (float)(y - (double)s));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm ThumbS = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            int d = 2 * size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x - (double)s), (float)(y - (double)s));
            path.lineTo((float)(x - (double)s), (float)(y - (double)d));
            path.lineTo((float)(x + (double)s), (float)(y - (double)d));
            path.lineTo((float)(x + (double)s), (float)(y - (double)s));
            path.closePath();
            return path;
        }
    };
    public static final PlotMarkAlgorithm ThumbW = new PlotMarkAlgorithm(){

        public Shape makeShape(double x, double y, int size) {
            if (size < 0) {
                size = 0;
            }
            int s = size;
            int d = 2 * size;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x + (double)s), (float)(y - (double)s));
            path.lineTo((float)(x + (double)d), (float)(y - (double)s));
            path.lineTo((float)(x + (double)d), (float)(y + (double)s));
            path.lineTo((float)(x + (double)s), (float)(y + (double)s));
            path.closePath();
            return path;
        }
    };

    public final Shape makeShape(Point2D p, int size) {
        if (p == null) {
            return new GeneralPath();
        }
        return this.makeShape(p.getX(), p.getY(), size);
    }

    public abstract Shape makeShape(double var1, double var3, int var5);

    public static int[][] QuarterCircleData(int radius) {
        if (radius <= 0) {
            return new int[][]{new int[1], new int[1]};
        }
        if (radius > 16384) {
            return null;
        }
        int square = radius * radius + radius;
        int length = 2 * (radius + 1);
        int[] x = new int[length];
        int[] y = new int[length];
        int a = radius;
        int b = 0;
        x[0] = a;
        y[0] = b;
        int k = 1;
        while (b < a) {
            int limit = square - a * a;
            int c = b;
            while (c * c <= limit) {
                ++c;
            }
            if (a < --c) {
                c = a;
            }
            if (b < c) {
                b = c;
                x[k] = a;
                y[k] = b;
                ++k;
            }
            if (++b > --a) continue;
            x[k] = a;
            y[k] = b;
            ++k;
        }
        int s = k - 1;
        if (x[s] == y[s]) {
            --s;
        }
        while (s >= 0) {
            x[k] = y[s];
            y[k] = x[s];
            ++k;
            --s;
        }
        int[] xx = new int[k];
        int[] yy = new int[k];
        int i = 0;
        while (i < k) {
            xx[i] = x[i];
            yy[i] = y[i];
            ++i;
        }
        return new int[][]{xx, yy};
    }

    public static Shape BetterCirclePath(int x, int y, int radius) {
        GeneralPath path = new GeneralPath();
        if (radius <= 0) {
            path.moveTo(x, y);
            path.lineTo(x, y);
            path.closePath();
            return path;
        }
        int[][] data = PlotMarkAlgorithm.QuarterCircleData(radius);
        if (data == null) {
            return new XCircle(x, y, radius);
        }
        int[] xx = data[0];
        int[] yy = data[1];
        int k = xx.length;
        path.moveTo(x + xx[0], y + yy[0]);
        int i = 1;
        while (i < k) {
            path.lineTo(x + xx[i], y + yy[i]);
            ++i;
        }
        i = k - 2;
        while (i >= 0) {
            path.lineTo(x - xx[i], y + yy[i]);
            --i;
        }
        i = 1;
        while (i < k) {
            path.lineTo(x - xx[i], y - yy[i]);
            ++i;
        }
        i = k - 2;
        while (i >= 0) {
            path.lineTo(x + xx[i], y - yy[i]);
            --i;
        }
        path.closePath();
        return path;
    }
}

