/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PlotMarkAlgorithm;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class PlotMark {
    public static final PlotMark H_BAR = new PlotMark(PlotMarkAlgorithm.HBar, false);
    public static final PlotMark V_BAR = new PlotMark(PlotMarkAlgorithm.VBar, false);
    public static final PlotMark PLUS = new PlotMark(PlotMarkAlgorithm.Plus, false);
    public static final PlotMark CROSS = new PlotMark(PlotMarkAlgorithm.Cross, false);
    public static final PlotMark ASTERISK = new PlotMark(PlotMarkAlgorithm.Asterisk, false);
    public static final PlotMark SQUARE = new PlotMark(PlotMarkAlgorithm.Square, false);
    public static final PlotMark DIAMOND = new PlotMark(PlotMarkAlgorithm.Diamond, false);
    public static final PlotMark CIRCLE = new PlotMark(PlotMarkAlgorithm.BetterCircle, false);
    public static final PlotMark WEDGE_N = new PlotMark(PlotMarkAlgorithm.WedgeN, false);
    public static final PlotMark WEDGE_E = new PlotMark(PlotMarkAlgorithm.WedgeE, false);
    public static final PlotMark WEDGE_S = new PlotMark(PlotMarkAlgorithm.WedgeS, false);
    public static final PlotMark WEDGE_W = new PlotMark(PlotMarkAlgorithm.WedgeW, false);
    public static final PlotMark BLUNT_WEDGE_N = new PlotMark(PlotMarkAlgorithm.BluntWedgeN, false);
    public static final PlotMark BLUNT_WEDGE_E = new PlotMark(PlotMarkAlgorithm.BluntWedgeE, false);
    public static final PlotMark BLUNT_WEDGE_S = new PlotMark(PlotMarkAlgorithm.BluntWedgeS, false);
    public static final PlotMark BLUNT_WEDGE_W = new PlotMark(PlotMarkAlgorithm.BluntWedgeW, false);
    public static final PlotMark SHARP_WEDGE_N = new PlotMark(PlotMarkAlgorithm.SharpWedgeN, false);
    public static final PlotMark SHARP_WEDGE_E = new PlotMark(PlotMarkAlgorithm.SharpWedgeE, false);
    public static final PlotMark SHARP_WEDGE_S = new PlotMark(PlotMarkAlgorithm.SharpWedgeS, false);
    public static final PlotMark SHARP_WEDGE_W = new PlotMark(PlotMarkAlgorithm.SharpWedgeW, false);
    public static final PlotMark THUMB_N = new PlotMark(PlotMarkAlgorithm.ThumbN, false);
    public static final PlotMark THUMB_E = new PlotMark(PlotMarkAlgorithm.ThumbE, false);
    public static final PlotMark THUMB_S = new PlotMark(PlotMarkAlgorithm.ThumbS, false);
    public static final PlotMark THUMB_W = new PlotMark(PlotMarkAlgorithm.ThumbW, false);
    public static final PlotMark FILLED_SQUARE = new PlotMark(PlotMarkAlgorithm.Square, true);
    public static final PlotMark FILLED_DIAMOND = new PlotMark(PlotMarkAlgorithm.Diamond, true);
    public static final PlotMark FILLED_CIRCLE = new PlotMark(PlotMarkAlgorithm.BetterCircle, true);
    public static final PlotMark FILLED_WEDGE_N = new PlotMark(PlotMarkAlgorithm.WedgeN, true);
    public static final PlotMark FILLED_WEDGE_E = new PlotMark(PlotMarkAlgorithm.WedgeE, true);
    public static final PlotMark FILLED_WEDGE_S = new PlotMark(PlotMarkAlgorithm.WedgeS, true);
    public static final PlotMark FILLED_WEDGE_W = new PlotMark(PlotMarkAlgorithm.WedgeW, true);
    public static final PlotMark FILLED_BLUNT_WEDGE_N = new PlotMark(PlotMarkAlgorithm.BluntWedgeN, true);
    public static final PlotMark FILLED_BLUNT_WEDGE_E = new PlotMark(PlotMarkAlgorithm.BluntWedgeE, true);
    public static final PlotMark FILLED_BLUNT_WEDGE_S = new PlotMark(PlotMarkAlgorithm.BluntWedgeS, true);
    public static final PlotMark FILLED_BLUNT_WEDGE_W = new PlotMark(PlotMarkAlgorithm.BluntWedgeW, true);
    public static final PlotMark FILLED_SHARP_WEDGE_N = new PlotMark(PlotMarkAlgorithm.SharpWedgeN, true);
    public static final PlotMark FILLED_SHARP_WEDGE_E = new PlotMark(PlotMarkAlgorithm.SharpWedgeE, true);
    public static final PlotMark FILLED_SHARP_WEDGE_S = new PlotMark(PlotMarkAlgorithm.SharpWedgeS, true);
    public static final PlotMark FILLED_SHARP_WEDGE_W = new PlotMark(PlotMarkAlgorithm.SharpWedgeW, true);
    public static final PlotMark FILLED_THUMB_N = new PlotMark(PlotMarkAlgorithm.ThumbN, true);
    public static final PlotMark FILLED_THUMB_E = new PlotMark(PlotMarkAlgorithm.ThumbE, true);
    public static final PlotMark FILLED_THUMB_S = new PlotMark(PlotMarkAlgorithm.ThumbS, true);
    public static final PlotMark FILLED_THUMB_W = new PlotMark(PlotMarkAlgorithm.ThumbW, true);
    private static final PlotMarkAlgorithm DEFAULT_ALGORITHM = PlotMarkAlgorithm.Square;
    private static final int DEFAULT_SIZE = 3;
    private static final boolean DEFAULT_FILL = true;
    private static final Stroke standardStroke = new BasicStroke(1.0f);
    private PlotMarkAlgorithm algorithm = DEFAULT_ALGORITHM;
    private int size = 3;
    private boolean fill = true;
    private Shape shape = null;
    private Paintable paintable = null;

    public PlotMark() {
    }

    public PlotMark(PlotMarkAlgorithm algorithm) {
        this.initializePlotMark(algorithm, 3, true, null);
    }

    public PlotMark(PlotMarkAlgorithm algorithm, int size) {
        this.initializePlotMark(algorithm, size, true, null);
    }

    public PlotMark(PlotMarkAlgorithm algorithm, boolean fill) {
        this.initializePlotMark(algorithm, 3, fill, null);
    }

    public PlotMark(PlotMarkAlgorithm algorithm, int size, boolean fill) {
        this.initializePlotMark(algorithm, size, fill, null);
    }

    public PlotMark(PlotMark plotmark) {
        if (plotmark == null) {
            plotmark = FILLED_SQUARE;
        }
        this.initializePlotMark(plotmark.algorithm, plotmark.size, plotmark.fill, plotmark.paintable);
    }

    public PlotMark(PlotMark plotmark, int size) {
        if (plotmark == null) {
            plotmark = FILLED_SQUARE;
        }
        this.initializePlotMark(plotmark.algorithm, size, plotmark.fill, plotmark.paintable);
    }

    public PlotMark(PlotMark plotmark, boolean fill) {
        if (plotmark == null) {
            plotmark = FILLED_SQUARE;
        }
        this.initializePlotMark(plotmark.algorithm, plotmark.size, fill, plotmark.paintable);
    }

    public PlotMark(PlotMark plotmark, int size, boolean fill) {
        if (plotmark == null) {
            plotmark = FILLED_SQUARE;
        }
        this.initializePlotMark(plotmark.algorithm, size, fill, plotmark.paintable);
    }

    public PlotMark(Paintable paintable) {
        this.initializePlotMark(DEFAULT_ALGORITHM, 3, true, paintable);
    }

    private void initializePlotMark(PlotMarkAlgorithm algorithm, int size, boolean fill, Paintable paintable) {
        if (paintable != null) {
            this.algorithm = null;
            this.paintable = paintable;
            return;
        }
        if (algorithm == null) {
            algorithm = PlotMarkAlgorithm.Square;
        }
        this.algorithm = algorithm;
        if (size < 0) {
            size = 0;
        }
        this.size = size;
        this.fill = fill;
    }

    public final void mark(Graphics g, Point2D p) {
        if (g == null) {
            return;
        }
        if (p == null) {
            return;
        }
        this.mark(g, p.getX(), p.getY());
    }

    public final void mark(Graphics g, double x, double y) {
        if (g == null) {
            return;
        }
        if (this.algorithm != null) {
            if (this.shape == null) {
                this.shape = this.algorithm.makeShape(0.0, 0.0, this.size);
            }
            Graphics2D h = (Graphics2D)g.create();
            h.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            h.translate(x, y);
            if (this.fill) {
                h.fill(this.shape);
            }
            h.setStroke(standardStroke);
            h.draw(this.shape);
        } else if (this.paintable != null) {
            this.paintable.paintAt(g, x, y);
        }
    }

    public final void mark(Graphics g, AffineTransform T, Point2D p) {
        if (g == null) {
            return;
        }
        if (p == null) {
            return;
        }
        this.mark(g, T, p.getX(), p.getY());
    }

    public final void mark(Graphics g, AffineTransform T, double x, double y) {
        if (g == null) {
            return;
        }
        if (T == null || T.isIdentity()) {
            this.mark(g, x, y);
        } else {
            Point2D.Double p = new Point2D.Double(x, y);
            T.transform(p, p);
            this.mark(g, p.getX(), p.getY());
        }
    }

    public final PlotMarkAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean getFill() {
        return this.fill;
    }

    public final Paintable getPaintable() {
        return this.paintable;
    }
}

