/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.util.Metric;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.text.ParseException;
import java.util.Vector;

public class PathNode
implements Stringable {
    public static final int MOVE = 0;
    public static final int LINE = 1;
    public static final int QUAD = 2;
    public static final int CUBIC = 3;
    public static final int CLOSE = 4;
    public static final String standardMessage = "\nPathNode data format must be one of\nmove(x1,y1) or\nline(x1,y1) or\nquad(x1,y1,x2,y2) or\ncubic(x1,y1,x2,y2,x3,y3) or\nclose()\nwhere x1,y1,x2,y2,x3,y3 are numbers\n";
    protected int nodetype = 0;
    protected float x1 = 0.0f;
    protected float y1 = 0.0f;
    protected float x2 = 0.0f;
    protected float y2 = 0.0f;
    protected float x3 = 0.0f;
    protected float y3 = 0.0f;

    public PathNode() {
    }

    public PathNode(int type, float[] parameters) {
        this.setNodeType(type);
        this.setParameters(parameters);
    }

    public PathNode(int type, double[] parameters) {
        this.setNodeType(type);
        this.setParameters(parameters);
    }

    public PathNode(int type, double x1, double y1, double x2, double y2, double x3, double y3) {
        this.setNodeType(type);
        this.setParameters(x1, y1, x2, y2, x3, y3);
    }

    public PathNode(PathNode node) {
        this.setPathNode(node);
    }

    public PathNode(String data) throws ParseException {
        this.fromStringData(data);
    }

    public final void setToMove(double x1, double y1) {
        this.nodetype = 0;
        this.x1 = (float)x1;
        this.y1 = (float)y1;
    }

    public final void setToLine(double x1, double y1) {
        this.nodetype = 1;
        this.x1 = (float)x1;
        this.y1 = (float)y1;
    }

    public final void setToQuad(double x1, double y1, double x2, double y2) {
        this.nodetype = 2;
        this.x1 = (float)x1;
        this.y1 = (float)y1;
        this.x2 = (float)x2;
        this.y2 = (float)y2;
    }

    public final void setToCubic(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.nodetype = 3;
        this.x1 = (float)x1;
        this.y1 = (float)y1;
        this.x2 = (float)x2;
        this.y2 = (float)y2;
        this.x3 = (float)x3;
        this.y3 = (float)y3;
    }

    public final void setToClose() {
        this.nodetype = 4;
    }

    public final void setPathNode(PathNode node) {
        if (node != null) {
            this.nodetype = node.nodetype;
            switch (this.nodetype) {
                case 3: {
                    this.x3 = node.x3;
                    this.y3 = node.y3;
                }
                case 2: {
                    this.x2 = node.x2;
                    this.y2 = node.y2;
                }
                case 0: 
                case 1: {
                    this.x1 = node.x1;
                    this.y1 = node.y1;
                }
            }
        }
    }

    public final void setNodeType(int type) {
        if (type == this.nodetype) {
            return;
        }
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.nodetype = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid node type for PathNode: " + type);
            }
        }
    }

    public final int getNodeType() {
        return this.nodetype;
    }

    public final void setParameters(float[] parameters) {
        if (parameters == null) {
            switch (this.nodetype) {
                case 3: {
                    this.x3 = 0.0f;
                    this.y3 = 0.0f;
                }
                case 2: {
                    this.x2 = 0.0f;
                    this.y2 = 0.0f;
                }
                case 0: 
                case 1: {
                    this.x1 = 0.0f;
                    this.y1 = 0.0f;
                }
            }
        } else {
            int N = parameters.length;
            int M = this.getParameterCount();
            if (N < M) {
                throw new IllegalArgumentException("Too few arguments in PathNode.setParameters");
            }
            switch (this.nodetype) {
                case 3: {
                    this.x3 = parameters[4];
                    this.y3 = parameters[5];
                }
                case 2: {
                    this.x2 = parameters[2];
                    this.y2 = parameters[3];
                }
                case 0: 
                case 1: {
                    this.x1 = parameters[0];
                    this.y1 = parameters[1];
                }
            }
        }
    }

    public final void setParameters(double[] parameters) {
        if (parameters == null) {
            switch (this.nodetype) {
                case 3: {
                    this.x3 = 0.0f;
                    this.y3 = 0.0f;
                }
                case 2: {
                    this.x2 = 0.0f;
                    this.y2 = 0.0f;
                }
                case 0: 
                case 1: {
                    this.x1 = 0.0f;
                    this.y1 = 0.0f;
                }
            }
        } else {
            int N = parameters.length;
            int M = this.getParameterCount();
            if (N < M) {
                throw new IllegalArgumentException("Too few arguments in PathNode.setParameters");
            }
            switch (this.nodetype) {
                case 3: {
                    this.x3 = (float)parameters[4];
                    this.y3 = (float)parameters[5];
                }
                case 2: {
                    this.x2 = (float)parameters[2];
                    this.y2 = (float)parameters[3];
                }
                case 0: 
                case 1: {
                    this.x1 = (float)parameters[0];
                    this.y1 = (float)parameters[1];
                }
            }
        }
    }

    public final void setParameters(double x1, double y1, double x2, double y2, double x3, double y3) {
        switch (this.nodetype) {
            case 3: {
                this.x3 = (float)x3;
                this.y3 = (float)y3;
            }
            case 2: {
                this.x2 = (float)x2;
                this.y2 = (float)y2;
            }
            case 0: 
            case 1: {
                this.x1 = (float)x1;
                this.y1 = (float)y1;
            }
        }
    }

    public final void setParameters(double x1, double y1, double x2, double y2) {
        switch (this.nodetype) {
            case 3: {
                throw new IllegalArgumentException("Too few arguments in PathNode.setParameters");
            }
            case 2: {
                this.x2 = (float)x2;
                this.y2 = (float)y2;
            }
            case 0: 
            case 1: {
                this.x1 = (float)x1;
                this.y1 = (float)y1;
            }
        }
    }

    public final void setParameters(double x1, double y1) {
        switch (this.nodetype) {
            case 2: 
            case 3: {
                throw new IllegalArgumentException("Too few arguments in PathNode.setParameters");
            }
            case 0: 
            case 1: {
                this.x1 = (float)x1;
                this.y1 = (float)y1;
            }
        }
    }

    public final float[] getParameters() {
        return new float[]{this.x1, this.y1, this.x2, this.y2, this.x3, this.y3};
    }

    public final int getParameterCount() {
        int M = 0;
        switch (this.nodetype) {
            case 0: 
            case 1: {
                M = 2;
                break;
            }
            case 2: {
                M = 4;
                break;
            }
            case 3: {
                M = 6;
                break;
            }
        }
        return M;
    }

    public final int getSlotCount() {
        return this.getParameterCount() / 2;
    }

    public final void setX1(double x1) {
        this.x1 = (float)x1;
    }

    public final void setY1(double y1) {
        this.y1 = (float)y1;
    }

    public final void setX2(double x2) {
        this.x2 = (float)x2;
    }

    public final void setY2(double y2) {
        this.y2 = (float)y2;
    }

    public final void setX3(double x3) {
        this.x3 = (float)x3;
    }

    public final void setY3(double y3) {
        this.y3 = (float)y3;
    }

    public final float getX1() {
        return this.x1;
    }

    public final float getY1() {
        return this.y1;
    }

    public final float getX2() {
        return this.x2;
    }

    public final float getY2() {
        return this.y2;
    }

    public final float getX3() {
        return this.x3;
    }

    public final float getY3() {
        return this.y3;
    }

    public final float getEndX() {
        switch (this.nodetype) {
            case 0: 
            case 1: {
                return this.x1;
            }
            case 2: {
                return this.x2;
            }
            case 3: {
                return this.x3;
            }
        }
        return 0.0f;
    }

    public final float getEndY() {
        switch (this.nodetype) {
            case 0: 
            case 1: {
                return this.y1;
            }
            case 2: {
                return this.y2;
            }
            case 3: {
                return this.y3;
            }
        }
        return 0.0f;
    }

    public final void setSlot(int slot, double x, double y) {
        if (slot < 1 || slot > this.getSlotCount()) {
            return;
        }
        switch (slot) {
            case 1: {
                this.x1 = (float)x;
                this.y1 = (float)y;
                return;
            }
            case 2: {
                this.x2 = (float)x;
                this.y2 = (float)y;
                return;
            }
            case 3: {
                this.x3 = (float)x;
                this.y3 = (float)y;
                return;
            }
        }
    }

    public final void setSlot(int slot, float[] pair) {
        if (pair == null || pair.length != 2) {
            return;
        }
        this.setSlot(slot, pair[0], pair[1]);
    }

    public final void setSlot(int slot, double[] pair) {
        if (pair == null || pair.length != 2) {
            return;
        }
        this.setSlot(slot, pair[0], pair[1]);
    }

    public final float[] getSlot(int slot) {
        if (slot < 1 || slot > this.getSlotCount()) {
            return null;
        }
        switch (slot) {
            case 1: {
                return new float[]{this.x1, this.y1};
            }
            case 2: {
                return new float[]{this.x2, this.y2};
            }
            case 3: {
                return new float[]{this.x3, this.y3};
            }
        }
        return null;
    }

    public final float getSlotX(int slot) {
        if (slot < 1 || slot > this.getSlotCount()) {
            return 0.0f;
        }
        switch (slot) {
            case 1: {
                return this.x1;
            }
            case 2: {
                return this.x2;
            }
            case 3: {
                return this.x3;
            }
        }
        return 0.0f;
    }

    public final float getSlotY(int slot) {
        if (slot < 1 || slot > this.getSlotCount()) {
            return 0.0f;
        }
        switch (slot) {
            case 1: {
                return this.y1;
            }
            case 2: {
                return this.y2;
            }
            case 3: {
                return this.y3;
            }
        }
        return 0.0f;
    }

    public final int nearSlot(double x, double y, double epsilon) {
        return this.nearSlot(x, y, epsilon, Metric.MAX);
    }

    public final int nearSlot(double x, double y, double epsilon, Metric metric) {
        if (metric == null) {
            metric = Metric.MAX;
        }
        switch (this.nodetype) {
            case 3: {
                if (metric.isNear(this.x1, this.y1, x, y, epsilon)) {
                    return 1;
                }
                if (metric.isNear(this.x2, this.y2, x, y, epsilon)) {
                    return 2;
                }
                if (!metric.isNear(this.x3, this.y3, x, y, epsilon)) break;
                return 3;
            }
            case 2: {
                if (metric.isNear(this.x1, this.y1, x, y, epsilon)) {
                    return 1;
                }
                if (!metric.isNear(this.x2, this.y2, x, y, epsilon)) break;
                return 2;
            }
            case 0: 
            case 1: {
                if (!metric.isNear(this.x1, this.y1, x, y, epsilon)) break;
                return 1;
            }
        }
        return -1;
    }

    public final int nodeInfo(float[] coords) {
        if (coords == null || coords.length < 6) {
            String message = "Error in PathNode.nodeInfo:\nResult array must have size at least 6\n";
            throw new IllegalArgumentException(message);
        }
        coords[0] = this.x1;
        coords[1] = this.y1;
        coords[2] = this.x2;
        coords[3] = this.y2;
        coords[4] = this.x3;
        coords[5] = this.y3;
        return this.nodetype;
    }

    public final int nodeInfo(double[] coords) {
        if (coords == null || coords.length < 6) {
            String message = "Error in PathNode.nodeInfo:\nResult array must have size at least 6\n";
            throw new IllegalArgumentException(message);
        }
        coords[0] = this.x1;
        coords[1] = this.y1;
        coords[2] = this.x2;
        coords[3] = this.y2;
        coords[4] = this.x3;
        coords[5] = this.y3;
        return this.nodetype;
    }

    public final void changeMoveToLine() {
        if (this.nodetype == 0) {
            this.nodetype = 1;
        }
    }

    public final void changeLineToMove() {
        if (this.nodetype == 1) {
            this.nodetype = 0;
        }
    }

    public final void transform(AffineTransform T) {
        if (T == null || this.nodetype == 4) {
            return;
        }
        double m00 = T.getScaleX();
        double m01 = T.getShearX();
        double m02 = T.getTranslateX();
        double m10 = T.getScaleY();
        double m11 = T.getShearY();
        double m12 = T.getTranslateY();
        switch (this.nodetype) {
            case 3: {
                double x0 = this.x3;
                double y0 = this.y3;
                this.x3 = (float)(m00 * x0 + m01 * y0 + m02);
                this.y3 = (float)(m10 * x0 + m11 * y0 + m12);
            }
            case 2: {
                double x0 = this.x2;
                double y0 = this.y2;
                this.x2 = (float)(m00 * x0 + m01 * y0 + m02);
                this.y2 = (float)(m10 * x0 + m11 * y0 + m12);
            }
            case 0: 
            case 1: {
                double x0 = this.x1;
                double y0 = this.y1;
                this.x1 = (float)(m00 * x0 + m01 * y0 + m02);
                this.y1 = (float)(m10 * x0 + m11 * y0 + m12);
            }
        }
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getNodeTypeString());
        buffer.append("(");
        switch (this.nodetype) {
            case 3: {
                buffer.append(this.x1);
                buffer.append(",");
                buffer.append(this.y1);
                buffer.append(",");
                buffer.append(this.x2);
                buffer.append(",");
                buffer.append(this.y2);
                buffer.append(",");
                buffer.append(this.x3);
                buffer.append(",");
                buffer.append(this.y3);
                break;
            }
            case 2: {
                buffer.append(this.x1);
                buffer.append(",");
                buffer.append(this.y1);
                buffer.append(",");
                buffer.append(this.x2);
                buffer.append(",");
                buffer.append(this.y2);
                break;
            }
            case 0: 
            case 1: {
                buffer.append(this.x1);
                buffer.append(",");
                buffer.append(this.y1);
                break;
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    public final String toStringData() {
        return this.toString();
    }

    public final void fromStringData(String state) throws ParseException {
        if (state == null) {
            String message = "PathNode error: null data\n";
            throw new ParseException(message, -1);
        }
        if ((state = state.trim()).length() == 0) {
            this.nodetype = 0;
            this.x1 = 0.0f;
            this.y1 = 0.0f;
            return;
        }
        double[] doubles = null;
        String[] split = Strings.splitIn2(state);
        int type = this.getNodeTypeFromStringData(split[0]);
        String[] numbers = Strings.decode(split[1]);
        if (numbers != null) {
            try {
                doubles = Strings.stringsToDoubles(numbers);
            }
            catch (ParseException ex) {
                String message = "PathNode.fromStringData numeric error:\n" + ex.getMessage() + "\n" + standardMessage;
                throw new ParseException(message, -1);
            }
        } else {
            doubles = new double[]{};
        }
        int N = doubles.length;
        boolean ok = true;
        switch (type) {
            case 3: {
                ok = N >= 6;
                break;
            }
            case 2: {
                ok = N >= 4;
                break;
            }
            case 0: 
            case 1: {
                ok = N >= 2;
                break;
            }
        }
        if (!ok) {
            String message = "PathNode.fromStringData numeric error:\nInsufficient numeric parameters for node type\n" + state + "\n" + standardMessage;
            throw new ParseException(message, -1);
        }
        this.setNodeType(type);
        this.setParameters(doubles);
    }

    public final String getNodeTypeString() {
        switch (this.nodetype) {
            case 0: {
                return "move";
            }
            case 1: {
                return "line";
            }
            case 2: {
                return "quad";
            }
            case 3: {
                return "cubic";
            }
            case 4: {
                return "close";
            }
        }
        return "";
    }

    public final int getNodeTypeFromStringData(String data) throws ParseException {
        if (data == null) {
            String message = "PathNode type error: null data\n";
            throw new ParseException(message, -1);
        }
        String testdata = (data = data.trim()).toLowerCase();
        if (testdata.equals("move")) {
            return 0;
        }
        if (testdata.equals("line")) {
            return 1;
        }
        if (testdata.equals("quad")) {
            return 2;
        }
        if (testdata.equals("cubic")) {
            return 3;
        }
        if (testdata.equals("close")) {
            return 4;
        }
        String message = "PathNode type error: " + data + "\n" + standardMessage;
        throw new ParseException(message, -1);
    }

    public final String JavaCode() {
        return "PathNode." + this.toString();
    }

    public static PathNode move(double x1, double y1) {
        return new PathNode(0, x1, y1, 0.0, 0.0, 0.0, 0.0);
    }

    public static PathNode line(double x1, double y1) {
        return new PathNode(1, x1, y1, 0.0, 0.0, 0.0, 0.0);
    }

    public static PathNode quad(double x1, double y1, double x2, double y2) {
        return new PathNode(2, x1, y1, x2, y2, 0.0, 0.0);
    }

    public static PathNode cubic(double x1, double y1, double x2, double y2, double x3, double y3) {
        return new PathNode(3, x1, y1, x2, y2, x3, y3);
    }

    public static PathNode close() {
        return new PathNode(4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static PathNode[] getPathNodes(PathIterator iterator) {
        if (iterator == null) {
            return new PathNode[0];
        }
        Vector<PathNode> list = new Vector<PathNode>();
        float[] data = new float[6];
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(data);
            list.add(new PathNode(type, data));
            iterator.next();
        }
        PathNode[] result = list.toArray(new PathNode[0]);
        return result;
    }

    public static PathNode[] getPathNodes(Shape shape) {
        if (shape == null) {
            return new PathNode[0];
        }
        return PathNode.getPathNodes(shape.getPathIterator(null));
    }

    public static PathNode[] getPathNodes(Shape shape, AffineTransform transform) {
        if (shape == null) {
            return new PathNode[0];
        }
        return PathNode.getPathNodes(shape.getPathIterator(transform));
    }

    public static PathNode[] getPathNodes(Shape shape, AffineTransform transform, double flatness) {
        if (shape == null) {
            return new PathNode[0];
        }
        return PathNode.getPathNodes(shape.getPathIterator(transform, flatness));
    }
}

