/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.PathList;
import edu.neu.ccs.gui.PathNode;
import java.awt.Shape;
import java.awt.geom.PathIterator;

public class PathListIterator
implements PathIterator {
    public static final int MOVE = 0;
    public static final int LINE = 1;
    public static final int QUAD = 2;
    public static final int CUBIC = 3;
    public static final int CLOSE = 4;
    protected PathList pathList = null;
    private int pointer = 0;
    private int start = 0;
    private PathNode startNode = null;

    public PathListIterator() {
        this.setPathList(null);
    }

    public PathListIterator(PathList pathList) {
        this.setPathList(pathList);
    }

    public final void setPathList(PathList pathList) {
        this.pathList = pathList == null ? new PathList() : pathList;
        this.reset();
    }

    public final PathList getPathList() {
        return this.pathList;
    }

    public final boolean isValid() {
        return this.pathList.isValid();
    }

    public final int getWindingRule() {
        return this.pathList.getWindingRule().rule();
    }

    public final boolean isDone() {
        return this.pointer >= this.pathList.size();
    }

    public final void next() {
        if (this.pointer < this.pathList.size()) {
            ++this.pointer;
        }
    }

    public final void reset() {
        this.pointer = 0;
        while (this.pointer < this.pathList.size()) {
            if (this.pathList.get(this.pointer).getNodeType() != 4) break;
            ++this.pointer;
        }
        this.start = this.pointer;
        if (this.isDone()) {
            this.startNode = null;
            return;
        }
        this.startNode = this.pathList.get(this.start);
        int type = this.startNode.getNodeType();
        if (type == 0) {
            return;
        }
        float x = 0.0f;
        float y = 0.0f;
        switch (type) {
            case 1: {
                x = this.startNode.getX1();
                y = this.startNode.getY1();
                break;
            }
            case 2: {
                x = this.startNode.getX2();
                y = this.startNode.getY2();
                break;
            }
            case 3: {
                x = this.startNode.getX3();
                y = this.startNode.getY3();
                break;
            }
        }
        this.startNode = new PathNode(0, x, y, 0.0, 0.0, 0.0, 0.0);
    }

    public final int currentSegment(float[] coords) {
        if (this.isDone()) {
            throw new IndexOutOfBoundsException("Beyond final path node in PathListIterator");
        }
        if (this.pointer == this.start) {
            return this.startNode.nodeInfo(coords);
        }
        PathNode node = this.pathList.get(this.pointer);
        return node.nodeInfo(coords);
    }

    public final int currentSegment(double[] coords) {
        if (this.isDone()) {
            throw new IndexOutOfBoundsException("Beyond final path node in PathListIterator");
        }
        if (this.pointer == this.start) {
            return this.startNode.nodeInfo(coords);
        }
        PathNode node = this.pathList.get(this.pointer);
        return node.nodeInfo(coords);
    }

    public final Shape makeShape() {
        return this.pathList.makeShape();
    }
}

