/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.gui.PathList;
import edu.neu.ccs.gui.PathNode;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.Bezier;

public class PathListFunction {
    public static final int MOVE = 0;
    public static final int LINE = 1;
    public static final int QUAD = 2;
    public static final int CUBIC = 3;
    public static final int CLOSE = 4;
    private int N = 0;
    private int A = 0;
    private int B = 0;
    private PathNode[] nodes = null;
    private WindingRule rule = WindingRule.WIND_NON_ZERO;

    /*
     * Unable to fully structure code
     */
    public PathListFunction(PathList pathList) {
        super();
        if (pathList == null) {
            return;
        }
        this.N = pathList.size();
        if (this.N != 0) ** GOTO lbl14
        return;
        while (pathList.get(this.A).getNodeType() == 4) {
            ++this.A;
lbl14:
            // 2 sources

            if (this.A < this.N) continue;
        }
        if (this.A >= this.N) {
            this.N = 0;
            this.A = 0;
            return;
        }
        this.B = this.N - 1;
        this.nodes = new PathNode[this.N];
        node = pathList.get(this.A);
        x = node.getEndX();
        y = node.getEndY();
        this.nodes[this.A] = new PathNode(0, x, y, 0.0, 0.0, 0.0, 0.0);
        i = this.A + 1;
        while (i <= this.B) {
            node = pathList.get(i);
            if (node.getNodeType() != 4) {
                this.nodes[i] = new PathNode(node);
            } else {
                j = i - 1;
                while (j >= this.A) {
                    node = this.nodes[j];
                    if (node.getNodeType() == 0) {
                        x = node.getEndX();
                        y = node.getEndY();
                        this.nodes[i] = new PathNode(1, x, y, 0.0, 0.0, 0.0, 0.0);
                        break;
                    }
                    --j;
                }
            }
            ++i;
        }
        this.rule = pathList.getWindingRule();
    }

    public final double getX(double t) {
        if (this.N == 0) {
            return 0.0;
        }
        if (t < (double)this.A) {
            t = this.A;
        } else if (t > (double)this.B) {
            t = this.B;
        }
        int i = (int)t;
        double s = t - (double)i;
        double x0 = this.nodes[i].getEndX();
        if (s == 0.0) {
            return x0;
        }
        PathNode node = this.nodes[i + 1];
        int type = node.getNodeType();
        switch (type) {
            case 0: {
                return node.getX1();
            }
            case 1: {
                double x1 = node.getX1();
                return Bezier.bezierD(s, x0, x1);
            }
            case 2: {
                double x1 = node.getX1();
                double x2 = node.getX2();
                return Bezier.bezierD(s, x0, x1, x2);
            }
            case 3: {
                double x1 = node.getX1();
                double x2 = node.getX2();
                double x3 = node.getX3();
                return Bezier.bezierD(s, x0, x1, x2, x3);
            }
        }
        return 0.0;
    }

    public final double getY(double t) {
        if (this.N == 0) {
            return 0.0;
        }
        if (t < (double)this.A) {
            t = this.A;
        } else if (t > (double)this.B) {
            t = this.B;
        }
        int i = (int)t;
        double s = t - (double)i;
        double y0 = this.nodes[i].getEndY();
        if (s == 0.0) {
            return y0;
        }
        PathNode node = this.nodes[i + 1];
        int type = node.getNodeType();
        switch (type) {
            case 0: {
                return node.getY1();
            }
            case 1: {
                double y1 = node.getY1();
                return Bezier.bezierD(s, y0, y1);
            }
            case 2: {
                double y1 = node.getY1();
                double y2 = node.getY2();
                return Bezier.bezierD(s, y0, y1, y2);
            }
            case 3: {
                double y1 = node.getY1();
                double y2 = node.getY2();
                double y3 = node.getY3();
                return Bezier.bezierD(s, y0, y1, y2, y3);
            }
        }
        return 0.0;
    }

    public final XPoint2D getShapePoint2D(double t) {
        return new XPoint2D(this.getX(t), this.getY(t));
    }

    public final float[] getShapePoint(float t) {
        float x = (float)this.getX(t);
        float y = (float)this.getY(t);
        return new float[]{x, y};
    }

    public final boolean isEmpty() {
        return this.N == 0;
    }

    public final int getLower() {
        return this.A;
    }

    public final int getUpper() {
        return this.B;
    }

    public final XPoint2D[] getShapePoint2DArray(int divisions) {
        if (this.N == 0) {
            return new XPoint2D[0];
        }
        if (divisions < 1) {
            divisions = 1;
        }
        int C = 1 + (this.B - this.A) * divisions;
        XPoint2D[] result = new XPoint2D[C];
        double delta = 1.0 / (double)divisions;
        int i = 0;
        while (i < C) {
            double t = (double)this.A + (double)i * delta;
            result[i] = this.getShapePoint2D(t);
            ++i;
        }
        return result;
    }

    public final float[][] getShapePointArray(int divisions) {
        if (this.N == 0) {
            return new float[0][];
        }
        if (divisions < 1) {
            divisions = 1;
        }
        int C = 1 + (this.B - this.A) * divisions;
        float[][] result = new float[C][];
        float delta = 1.0f / (float)divisions;
        int i = 0;
        while (i < C) {
            float t = (float)this.A + (float)i * delta;
            result[i] = this.getShapePoint(t);
            ++i;
        }
        return result;
    }
}

