/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.gui.PaintMode;
import edu.neu.ccs.gui.PaintableSequence;
import edu.neu.ccs.gui.PathListFunction;
import edu.neu.ccs.gui.PathListIterator;
import edu.neu.ccs.gui.PathNode;
import edu.neu.ccs.gui.PlotMark;
import edu.neu.ccs.gui.PlotMarkAlgorithm;
import edu.neu.ccs.gui.PointPaintable;
import edu.neu.ccs.gui.ShapePaintable;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.Metric;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.text.ParseException;
import java.util.Vector;

public class PathList
implements Stringable {
    public static final int MOVE = 0;
    public static final int LINE = 1;
    public static final int QUAD = 2;
    public static final int CUBIC = 3;
    public static final int CLOSE = 4;
    private static final int CAP_ROUND = 1;
    private static final int JOIN_ROUND = 1;
    public static final String standardMessage = "\nPathList error\nLine 1 should be either of the 2 strings\nWIND_NON_ZERO or WIND_EVEN_ODD\n\nThe remaining lines should give the data\nfor the path nodes with one node per line\n";
    public static final String String_WIND_NON_ZERO = "WIND_NON_ZERO";
    public static final String String_WIND_EVEN_ODD = "WIND_EVEN_ODD";
    public static final String Alternate_WIND_NON_ZERO = "WINDNONZERO";
    public static final String Alternate_WIND_EVEN_ODD = "WINDEVENODD";
    protected Vector pathlist = new Vector();
    protected WindingRule windingrule = WindingRule.WIND_NON_ZERO;

    public PathList() {
    }

    public PathList(WindingRule rule) {
        this.setWindingRule(rule);
    }

    public PathList(PathNode[] nodes) {
        this.append(nodes);
    }

    public PathList(PathNode[] nodes, WindingRule rule) {
        this.append(nodes);
        this.setWindingRule(rule);
    }

    public PathList(PathNode[] nodes, int rule) {
        this.append(nodes);
        this.setWindingRule(rule);
    }

    public PathList(PathList list) {
        this.setPathList(list);
    }

    public PathList(Shape shape) {
        this.setPathList(shape);
    }

    public PathList(Shape shape, AffineTransform transform) {
        this.setPathList(shape, transform);
    }

    public PathList(Shape shape, AffineTransform transform, double flatness) {
        this.setPathList(shape, transform, flatness);
    }

    public PathList(PathIterator iterator) {
        this.setPathList(iterator);
    }

    public PathList(Point2D[] points, boolean close) {
        if (points == null) {
            return;
        }
        int N = points.length;
        boolean first = true;
        int i = 0;
        while (i < N) {
            if (points[i] != null) {
                double x = points[i].getX();
                double y = points[i].getY();
                if (first) {
                    this.append(PathNode.move(x, y));
                    first = false;
                } else {
                    this.append(PathNode.line(x, y));
                }
            }
            ++i;
        }
        if (close) {
            this.append(PathNode.close());
        }
    }

    public PathList(Point2D[] points, boolean close, WindingRule rule) {
        this(points, close);
        this.setWindingRule(rule);
    }

    public PathList(Point2D[] points, boolean close, int rule) {
        this(points, close);
        this.setWindingRule(rule);
    }

    public final Shape makeShape() {
        GeneralPath gp = new GeneralPath(this.getWindingRule().rule());
        boolean first = true;
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            if (first) {
                if (type != 4) {
                    gp.moveTo(node.getEndX(), node.getEndY());
                    first = false;
                }
            } else {
                switch (type) {
                    case 0: {
                        gp.moveTo(node.getX1(), node.getY1());
                        break;
                    }
                    case 1: {
                        gp.lineTo(node.getX1(), node.getY1());
                        break;
                    }
                    case 2: {
                        gp.quadTo(node.getX1(), node.getY1(), node.getX2(), node.getY2());
                        break;
                    }
                    case 3: {
                        gp.curveTo(node.getX1(), node.getY1(), node.getX2(), node.getY2(), node.getX3(), node.getY3());
                        break;
                    }
                    case 4: {
                        gp.closePath();
                        break;
                    }
                }
            }
            ++i;
        }
        return gp;
    }

    public final Shape makeVertexShape() {
        GeneralPath gp = new GeneralPath(this.getWindingRule().rule());
        boolean first = true;
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            if (first) {
                if (type != 4) {
                    gp.moveTo(node.getEndX(), node.getEndY());
                    first = false;
                }
            } else {
                switch (type) {
                    case 0: {
                        gp.moveTo(node.getEndX(), node.getEndY());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        gp.lineTo(node.getEndX(), node.getEndY());
                        break;
                    }
                    case 4: {
                        gp.closePath();
                        break;
                    }
                }
            }
            ++i;
        }
        return gp;
    }

    public final Shape makeBezierShape() {
        GeneralPath gp = new GeneralPath(this.getWindingRule().rule());
        boolean first = true;
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            if (first) {
                if (type != 4) {
                    gp.moveTo(node.getEndX(), node.getEndY());
                    first = false;
                }
            } else {
                switch (type) {
                    case 0: {
                        gp.moveTo(node.getX1(), node.getY1());
                        break;
                    }
                    case 1: {
                        gp.lineTo(node.getX1(), node.getY1());
                        break;
                    }
                    case 2: {
                        gp.lineTo(node.getX1(), node.getY1());
                        gp.lineTo(node.getX2(), node.getY2());
                        break;
                    }
                    case 3: {
                        gp.lineTo(node.getX1(), node.getY1());
                        gp.lineTo(node.getX2(), node.getY2());
                        gp.lineTo(node.getX3(), node.getY3());
                        break;
                    }
                    case 4: {
                        gp.closePath();
                        break;
                    }
                }
            }
            ++i;
        }
        return gp;
    }

    public final Shape makeVertexDotsShape() {
        GeneralPath gp = new GeneralPath(this.getWindingRule().rule());
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    float x = node.getEndX();
                    float y = node.getEndY();
                    gp.moveTo(x, y);
                    gp.lineTo(x, y);
                    break;
                }
            }
            ++i;
        }
        return gp;
    }

    public final Shape makeBezierDotsShape() {
        GeneralPath gp = new GeneralPath(this.getWindingRule().rule());
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    gp.moveTo(x1, y1);
                    gp.lineTo(x1, y1);
                    break;
                }
                case 1: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    gp.moveTo(x1, y1);
                    gp.lineTo(x1, y1);
                    break;
                }
                case 2: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    gp.moveTo(x1, y1);
                    gp.lineTo(x1, y1);
                    gp.moveTo(x2, y2);
                    gp.lineTo(x2, y2);
                    break;
                }
                case 3: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    float x3 = node.getX3();
                    float y3 = node.getY3();
                    gp.moveTo(x1, y1);
                    gp.lineTo(x1, y1);
                    gp.moveTo(x2, y2);
                    gp.lineTo(x2, y2);
                    gp.moveTo(x3, y3);
                    gp.lineTo(x3, y3);
                    break;
                }
            }
            ++i;
        }
        return gp;
    }

    public final Shape makeControlDotsShape() {
        GeneralPath gp = new GeneralPath(this.getWindingRule().rule());
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 2: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    gp.moveTo(x1, y1);
                    gp.lineTo(x1, y1);
                    break;
                }
                case 3: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    gp.moveTo(x1, y1);
                    gp.lineTo(x1, y1);
                    gp.moveTo(x2, y2);
                    gp.lineTo(x2, y2);
                    break;
                }
            }
            ++i;
        }
        return gp;
    }

    public final PathListIterator makePathListIterator() {
        return new PathListIterator(this);
    }

    public final PaintableSequence makeStructurePaintable(Color fillColor, Color drawColor, Color vertexDotsColor, Color controlDotsColor, Color vertexFrameColor, Color bezierFrameColor, Color pathPointsColor, int thickness, int divisions) {
        if (thickness < 1) {
            thickness = 1;
        }
        int epsilon = thickness + 2;
        BasicStroke stroke = new BasicStroke(thickness, 1, 1);
        PlotMark plotmark1 = new PlotMark(PlotMarkAlgorithm.Square, epsilon, true);
        Shape mainshape = this.makeShape();
        Shape shape = null;
        Color color = null;
        Point2D[] points = null;
        PaintableSequence sequence = new PaintableSequence();
        color = pathPointsColor;
        if (color != null && color.getAlpha() > 0) {
            if (divisions < 1) {
                divisions = 1;
            }
            PlotMark plotmark2 = new PlotMark(PlotMarkAlgorithm.Square, thickness, true);
            points = new PathListFunction(this).getShapePoint2DArray(divisions);
            sequence.appendPaintable(PointPaintable.makePaintableSequence(points, plotmark2, (Paint)color));
        }
        if ((color = controlDotsColor) != null && color.getAlpha() > 0) {
            points = this.makeControlPoints();
            sequence.appendPaintable(PointPaintable.makePaintableSequence(points, plotmark1, (Paint)color));
        }
        if ((color = vertexDotsColor) != null && color.getAlpha() > 0) {
            points = this.makeVertexPoints();
            sequence.appendPaintable(PointPaintable.makePaintableSequence(points, plotmark1, (Paint)color));
        }
        if ((color = drawColor) != null && color.getAlpha() > 0) {
            shape = mainshape;
            sequence.appendPaintable(new ShapePaintable(shape, PaintMode.DRAW, null, (Paint)color, (Stroke)stroke));
        }
        if ((color = bezierFrameColor) != null && color.getAlpha() > 0) {
            shape = this.makeBezierShape();
            sequence.appendPaintable(new ShapePaintable(shape, PaintMode.DRAW, null, (Paint)color, (Stroke)stroke));
        }
        if ((color = vertexFrameColor) != null && color.getAlpha() > 0) {
            shape = this.makeVertexShape();
            sequence.appendPaintable(new ShapePaintable(shape, PaintMode.DRAW, null, (Paint)color, (Stroke)stroke));
        }
        if ((color = fillColor) != null && color.getAlpha() > 0) {
            shape = mainshape;
            sequence.appendPaintable(new ShapePaintable(shape, PaintMode.FILL, (Paint)color));
        }
        return sequence;
    }

    public final PaintableSequence makeStructurePaintable(Color fillColor, Color drawColor, Color vertexDotsColor, Color controlDotsColor, Color vertexFrameColor, Color bezierFrameColor, int thickness) {
        Color pathPointsColor = Colors.transparent;
        int divisions = 1;
        return this.makeStructurePaintable(fillColor, drawColor, vertexDotsColor, controlDotsColor, vertexFrameColor, bezierFrameColor, pathPointsColor, thickness, divisions);
    }

    public final PaintableSequence makeStructurePaintable(Color fillColor, Color drawColor, int thickness) {
        Color vertexDotsColor = Colors.red;
        Color controlDotsColor = Colors.blue;
        Color vertexFrameColor = Colors.transparent;
        Color bezierFrameColor = Colors.darkorchid;
        Color pathPointsColor = Colors.transparent;
        int divisions = 1;
        return this.makeStructurePaintable(fillColor, drawColor, vertexDotsColor, controlDotsColor, vertexFrameColor, bezierFrameColor, pathPointsColor, thickness, divisions);
    }

    public final PaintableSequence makeStructurePaintable(int thickness) {
        Color fillColor = Colors.lime;
        Color drawColor = Colors.black;
        Color vertexDotsColor = Colors.red;
        Color controlDotsColor = Colors.blue;
        Color vertexFrameColor = Colors.transparent;
        Color bezierFrameColor = Colors.darkorchid;
        Color pathPointsColor = Colors.transparent;
        int divisions = 1;
        return this.makeStructurePaintable(fillColor, drawColor, vertexDotsColor, controlDotsColor, vertexFrameColor, bezierFrameColor, pathPointsColor, thickness, divisions);
    }

    public final PaintableSequence makeStructurePaintable() {
        Color fillColor = Colors.lime;
        Color drawColor = Colors.black;
        Color vertexDotsColor = Colors.red;
        Color controlDotsColor = Colors.blue;
        Color vertexFrameColor = Colors.transparent;
        Color bezierFrameColor = Colors.darkorchid;
        Color pathPointsColor = Colors.transparent;
        int thickness = 2;
        int divisions = 1;
        return this.makeStructurePaintable(fillColor, drawColor, vertexDotsColor, controlDotsColor, vertexFrameColor, bezierFrameColor, pathPointsColor, thickness, divisions);
    }

    public final void setPathList(PathList list) {
        if (list == null) {
            return;
        }
        this.removeAll();
        int N = list.size();
        int i = 0;
        while (i < N) {
            this.append(new PathNode(list.get(i)));
            ++i;
        }
        this.setWindingRule(list.getWindingRule());
    }

    public final void setPathList(Shape shape) {
        if (shape != null) {
            this.setPathList(shape.getPathIterator(null));
        }
    }

    public final void setPathList(Shape shape, AffineTransform transform) {
        if (shape != null) {
            this.setPathList(shape.getPathIterator(transform));
        }
    }

    public final void setPathList(Shape shape, AffineTransform transform, double flatness) {
        if (shape != null) {
            this.setPathList(shape.getPathIterator(transform, flatness));
        }
    }

    public final void setPathList(PathIterator iterator) {
        if (iterator != null) {
            this.removeAll();
            this.append(PathNode.getPathNodes(iterator));
            this.setWindingRule(iterator.getWindingRule());
        }
    }

    public final int size() {
        return this.pathlist.size();
    }

    public final void setWindingRule(WindingRule rule) {
        if (rule == null) {
            return;
        }
        this.windingrule = rule;
    }

    public final void setWindingRule(int rule) {
        if (rule == 1) {
            this.windingrule = WindingRule.WIND_NON_ZERO;
        } else if (rule == 0) {
            this.windingrule = WindingRule.WIND_EVEN_ODD;
        }
    }

    public final WindingRule getWindingRule() {
        return this.windingrule;
    }

    public final void setPathNodes(PathNode[] nodes) {
        if (nodes == null) {
            return;
        }
        this.removeAll();
        this.append(nodes);
    }

    public final PathNode[] getPathNodes() {
        return this.pathlist.toArray(new PathNode[0]);
    }

    public final void set(int index, PathNode node) {
        if (node == null) {
            return;
        }
        PathNode internal = this.get(index);
        if (internal != null) {
            internal.setPathNode(node);
        }
    }

    public final PathNode get(int index) {
        if (index >= 0 && index < this.size()) {
            return (PathNode)this.pathlist.get(index);
        }
        return null;
    }

    public final void add(int index, PathNode node) {
        if (node == null) {
            return;
        }
        if (index < 0) {
            index = 0;
        } else if (index > this.size()) {
            index = this.size();
        }
        this.pathlist.add(index, node);
    }

    public final void add(int index, PathNode[] nodes) {
        this.add(index, nodes, false);
    }

    public final void add(int index, PathNode[] nodes, boolean connect) {
        if (nodes == null) {
            return;
        }
        int N = nodes.length;
        if (N == 0) {
            return;
        }
        if (index < 0) {
            index = 0;
        } else if (index > this.size()) {
            index = this.size();
        }
        int start = index;
        int i = 0;
        while (i < N) {
            if (nodes[i] != null) {
                this.pathlist.add(index, nodes[i]);
                ++index;
            }
            ++i;
        }
        if (connect && start > 0 && index > start) {
            this.get(start).changeMoveToLine();
        }
    }

    public final void cloneAndAdd(int index, PathNode node) {
        if (node == null) {
            return;
        }
        if (index < 0) {
            index = 0;
        } else if (index > this.size()) {
            index = this.size();
        }
        this.pathlist.add(index, new PathNode(node));
    }

    public final void cloneAndAdd(int index, PathNode[] nodes) {
        this.cloneAndAdd(index, nodes, false);
    }

    public final void cloneAndAdd(int index, PathNode[] nodes, boolean connect) {
        if (nodes == null) {
            return;
        }
        int N = nodes.length;
        if (N == 0) {
            return;
        }
        if (index < 0) {
            index = 0;
        } else if (index > this.size()) {
            index = this.size();
        }
        int start = index;
        int i = 0;
        while (i < N) {
            if (nodes[i] != null) {
                this.pathlist.add(index, new PathNode(nodes[i]));
                ++index;
            }
            ++i;
        }
        if (connect && start > 0 && index > start) {
            this.get(start).changeMoveToLine();
        }
    }

    public final PathList move(double x1, double y1) {
        return this.append(PathNode.move(x1, y1));
    }

    public final PathList line(double x1, double y1) {
        return this.append(PathNode.line(x1, y1));
    }

    public final PathList quad(double x1, double y1, double x2, double y2) {
        return this.append(PathNode.quad(x1, y1, x2, y2));
    }

    public final PathList cubic(double x1, double y1, double x2, double y2, double x3, double y3) {
        return this.append(PathNode.cubic(x1, y1, x2, y2, x3, y3));
    }

    public final PathList close() {
        return this.append(PathNode.close());
    }

    public final PathList append(PathNode node) {
        if (node == null) {
            return this;
        }
        this.pathlist.add(node);
        return this;
    }

    public final PathList append(PathNode[] nodes) {
        return this.append(nodes, false);
    }

    public final PathList append(PathNode[] nodes, boolean connect) {
        int start;
        if (nodes == null) {
            return this;
        }
        int N = nodes.length;
        if (N == 0) {
            return this;
        }
        int index = start = this.size();
        int i = 0;
        while (i < N) {
            if (nodes[i] != null) {
                this.pathlist.add(nodes[i]);
                ++index;
            }
            ++i;
        }
        if (connect && start > 0 && index > start) {
            this.get(start).changeMoveToLine();
        }
        return this;
    }

    public final PathList cloneAndAppend(PathNode node) {
        if (node == null) {
            return this;
        }
        this.pathlist.add(new PathNode(node));
        return this;
    }

    public final PathList cloneAndAppend(PathNode[] nodes) {
        return this.cloneAndAppend(nodes, false);
    }

    public final PathList cloneAndAppend(PathNode[] nodes, boolean connect) {
        int start;
        if (nodes == null) {
            return this;
        }
        int N = nodes.length;
        if (N == 0) {
            return this;
        }
        int index = start = this.size();
        int i = 0;
        while (i < N) {
            if (nodes[i] != null) {
                this.pathlist.add(new PathNode(nodes[i]));
                ++index;
            }
            ++i;
        }
        if (connect && start > 0 && index > start) {
            this.get(start).changeMoveToLine();
        }
        return this;
    }

    public final PathList append(PathList pathList) {
        return this.append(pathList, false);
    }

    public final PathList append(PathList pathList, boolean connect) {
        return this.cloneAndAppend(pathList.getPathNodes(), connect);
    }

    public final PathList append(Shape shape) {
        return this.append(shape, false);
    }

    public final PathList append(Shape shape, boolean connect) {
        if (shape == null) {
            return this;
        }
        return this.append(shape.getPathIterator(null), connect);
    }

    public final PathList append(Shape shape, AffineTransform transform) {
        return this.append(shape, transform, false);
    }

    public final PathList append(Shape shape, AffineTransform transform, boolean connect) {
        if (shape == null) {
            return this;
        }
        return this.append(shape.getPathIterator(transform), connect);
    }

    public final PathList append(Shape shape, AffineTransform transform, double flatness) {
        return this.append(shape, transform, flatness, false);
    }

    public final PathList append(Shape shape, AffineTransform transform, double flatness, boolean connect) {
        if (shape == null) {
            return this;
        }
        return this.append(shape.getPathIterator(transform, flatness), connect);
    }

    public final PathList append(PathIterator iterator) {
        return this.append(iterator, false);
    }

    public final PathList append(PathIterator iterator, boolean connect) {
        if (iterator == null) {
            return this;
        }
        return this.append(PathNode.getPathNodes(iterator), connect);
    }

    public final PathNode remove(int index) {
        if (index >= 0 && index < this.size()) {
            return (PathNode)this.pathlist.remove(index);
        }
        return null;
    }

    public final PathNode[] remove(int m, int n) {
        int c;
        if (m < 0) {
            m = 0;
        }
        if (n > this.size()) {
            n = this.size();
        }
        if ((c = n - m) <= 0) {
            return new PathNode[0];
        }
        PathNode[] result = new PathNode[c];
        while (n > m) {
            result[--c] = (PathNode)this.pathlist.remove(--n);
        }
        return result;
    }

    public final PathNode[] removeAll() {
        return this.remove(0, this.size());
    }

    public final void setSlot(int index, int slot, double x, double y) {
        PathNode internal = this.get(index);
        if (internal != null) {
            internal.setSlot(slot, x, y);
        }
    }

    public final void setSlot(int index, int slot, float[] pair) {
        if (pair == null || pair.length != 2) {
            return;
        }
        this.setSlot(index, slot, pair[0], pair[1]);
    }

    public final void setSlot(int index, int slot, double[] pair) {
        if (pair == null || pair.length != 2) {
            return;
        }
        this.setSlot(index, slot, pair[0], pair[1]);
    }

    public final void setSlot(int[] indices, double x, double y) {
        if (indices == null || indices.length != 2) {
            return;
        }
        this.setSlot(indices[0], indices[1], x, y);
    }

    public final void setSlot(int[] indices, float[] pair) {
        if (indices == null || indices.length != 2) {
            return;
        }
        if (pair == null || pair.length != 2) {
            return;
        }
        this.setSlot(indices[0], indices[1], pair[0], pair[1]);
    }

    public final void setSlot(int[] indices, double[] pair) {
        if (indices == null || indices.length != 2) {
            return;
        }
        if (pair == null || pair.length != 2) {
            return;
        }
        this.setSlot(indices[0], indices[1], pair[0], pair[1]);
    }

    public final float[] getSlot(int index, int slot) {
        PathNode internal = this.get(index);
        if (internal == null) {
            return null;
        }
        return internal.getSlot(slot);
    }

    public final float[] getSlot(int[] indices) {
        if (indices == null || indices.length != 2) {
            return null;
        }
        return this.getSlot(indices[0], indices[1]);
    }

    public final int[] nearSlot(double x, double y, double epsilon) {
        return this.nearSlot(x, y, epsilon, Metric.MAX);
    }

    public final int[] nearSlot(double x, double y, double epsilon, Metric metric) {
        if (metric == null) {
            metric = Metric.MAX;
        }
        int N = this.size();
        int index = 0;
        while (index < N) {
            PathNode internal = (PathNode)this.pathlist.get(index);
            int slot = internal.nearSlot(x, y, epsilon, metric);
            if (slot > 0) {
                return new int[]{index, slot};
            }
            ++index;
        }
        return null;
    }

    public final void transform(AffineTransform T) {
        if (T == null) {
            return;
        }
        int N = this.size();
        int i = 0;
        while (i < N) {
            this.get(i).transform(T);
            ++i;
        }
    }

    public final boolean isValid() {
        return this.size() == 0 || this.get(0).getNodeType() == 0;
    }

    public final boolean isPolygon() {
        int N = this.size();
        if (N < 2) {
            return false;
        }
        if (this.get(0).getNodeType() != 0) {
            return false;
        }
        int i = 1;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            if (type == 2 || type == 3) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean isStrictPolygon() {
        int N = this.size();
        if (N < 2) {
            return false;
        }
        if (this.get(0).getNodeType() != 0) {
            return false;
        }
        int M = N - 1;
        int i = 1;
        while (i < M) {
            if (this.get(i).getNodeType() != 1) {
                return false;
            }
            ++i;
        }
        boolean hasLINE = M > 1;
        PathNode node = this.get(M);
        int type = node.getNodeType();
        if (type == 1) {
            hasLINE = true;
        } else if (type != 4) {
            return false;
        }
        return hasLINE;
    }

    public final PathList makeVertexPathList() {
        PathList list = new PathList(this.getWindingRule());
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: 
                case 4: {
                    list.append(new PathNode(node));
                    break;
                }
                case 2: 
                case 3: {
                    float x = node.getEndX();
                    float y = node.getEndY();
                    list.append(PathNode.line(x, y));
                    break;
                }
            }
            ++i;
        }
        return list;
    }

    public final PathList makeBezierPathList() {
        PathList list = new PathList(this.getWindingRule());
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: 
                case 4: {
                    list.append(new PathNode(node));
                    break;
                }
                case 2: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    list.append(PathNode.line(x1, y1));
                    list.append(PathNode.line(x2, y2));
                    break;
                }
                case 3: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    float x3 = node.getX3();
                    float y3 = node.getY3();
                    list.append(PathNode.line(x1, y1));
                    list.append(PathNode.line(x2, y2));
                    list.append(PathNode.line(x3, y3));
                    break;
                }
            }
            ++i;
        }
        return list;
    }

    public final PathList makeVertexDotsPathList() {
        PathList list = new PathList(this.getWindingRule());
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    float x = node.getEndX();
                    float y = node.getEndY();
                    list.append(PathNode.move(x, y));
                    list.append(PathNode.line(x, y));
                    break;
                }
            }
            ++i;
        }
        return list;
    }

    public final PathList makeBezierDotsPathList() {
        PathList list = new PathList(this.getWindingRule());
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    list.append(PathNode.move(x1, y1));
                    list.append(PathNode.line(x1, y1));
                    break;
                }
                case 2: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    list.append(PathNode.move(x1, y1));
                    list.append(PathNode.line(x1, y1));
                    list.append(PathNode.move(x2, y2));
                    list.append(PathNode.line(x2, y2));
                    break;
                }
                case 3: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    float x3 = node.getX3();
                    float y3 = node.getY3();
                    list.append(PathNode.move(x1, y1));
                    list.append(PathNode.line(x1, y1));
                    list.append(PathNode.move(x2, y2));
                    list.append(PathNode.line(x2, y2));
                    list.append(PathNode.move(x3, y3));
                    list.append(PathNode.line(x3, y3));
                    break;
                }
            }
            ++i;
        }
        return list;
    }

    public final PathList makeControlDotsPathList() {
        PathList list = new PathList(this.getWindingRule());
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 2: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    list.append(PathNode.move(x1, y1));
                    list.append(PathNode.line(x1, y1));
                    break;
                }
                case 3: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    list.append(PathNode.move(x1, y1));
                    list.append(PathNode.line(x1, y1));
                    list.append(PathNode.move(x2, y2));
                    list.append(PathNode.line(x2, y2));
                    break;
                }
            }
            ++i;
        }
        return list;
    }

    public final PathListIterator makeVertexPathListIterator() {
        return this.makeVertexPathList().makePathListIterator();
    }

    public final PathListIterator makeBezierPathListIterator() {
        return this.makeBezierPathList().makePathListIterator();
    }

    public final PathListIterator makeVertexDotsPathListIterator() {
        return this.makeVertexDotsPathList().makePathListIterator();
    }

    public final PathListIterator makeBezierDotsPathListIterator() {
        return this.makeBezierDotsPathList().makePathListIterator();
    }

    public final PathListIterator makeControlDotsPathListIterator() {
        return this.makeControlDotsPathList().makePathListIterator();
    }

    public final Point2D[] makeVertexPoints() {
        Vector<XPoint2D> list = new Vector<XPoint2D>();
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    float x = node.getEndX();
                    float y = node.getEndY();
                    list.add(new XPoint2D(x, y));
                    break;
                }
            }
            ++i;
        }
        return list.toArray(new Point2D[0]);
    }

    public final Point2D[] makeBezierPoints() {
        Vector<XPoint2D> list = new Vector<XPoint2D>();
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    list.add(new XPoint2D(x1, y1));
                    break;
                }
                case 2: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    list.add(new XPoint2D(x1, y1));
                    list.add(new XPoint2D(x2, y2));
                    break;
                }
                case 3: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    float x3 = node.getX3();
                    float y3 = node.getY3();
                    list.add(new XPoint2D(x1, y1));
                    list.add(new XPoint2D(x2, y2));
                    list.add(new XPoint2D(x3, y3));
                    break;
                }
            }
            ++i;
        }
        return list.toArray(new Point2D[0]);
    }

    public final Point2D[] makeControlPoints() {
        Vector<XPoint2D> list = new Vector<XPoint2D>();
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 2: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    list.add(new XPoint2D(x1, y1));
                    break;
                }
                case 3: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    list.add(new XPoint2D(x1, y1));
                    list.add(new XPoint2D(x2, y2));
                    break;
                }
            }
            ++i;
        }
        return list.toArray(new Point2D[0]);
    }

    public static Shape makeVertexShape(Shape shape) {
        return new PathList(shape).makeVertexShape();
    }

    public static Shape makeBezierShape(Shape shape) {
        return new PathList(shape).makeBezierShape();
    }

    public static Shape makeVertexDotsShape(Shape shape) {
        return new PathList(shape).makeVertexDotsShape();
    }

    public static Shape makeBezierDotsShape(Shape shape) {
        return new PathList(shape).makeBezierDotsShape();
    }

    public static Shape makeControlDotsShape(Shape shape) {
        return new PathList(shape).makeControlDotsShape();
    }

    public static Point2D[] makeVertexPoints(Shape shape) {
        return new PathList(shape).makeVertexPoints();
    }

    public static Point2D[] makeBezierPoints(Shape shape) {
        return new PathList(shape).makeBezierPoints();
    }

    public static Point2D[] makeControlPoints(Shape shape) {
        return new PathList(shape).makeControlPoints();
    }

    public final double getX(double t) {
        return new PathListFunction(this).getX(t);
    }

    public final double getY(double t) {
        return new PathListFunction(this).getY(t);
    }

    public final XPoint2D getShapePoint2D(double t) {
        return new PathListFunction(this).getShapePoint2D(t);
    }

    public final float[] getShapePoint(float t) {
        return new PathListFunction(this).getShapePoint(t);
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getWindingRuleString());
        buffer.append("\n");
        int N = this.size();
        int i = 0;
        while (i < N) {
            buffer.append(this.get(i).toString());
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    public final String toStringData() {
        return this.toString();
    }

    public final void fromStringData(String data) throws ParseException {
        if (data == null) {
            String message = "PathList error: null data\n";
            throw new ParseException(message, -1);
        }
        String[] item = Strings.tokenize(data = data.trim(), "\n", true);
        int L = item.length;
        if (L < 1) {
            String message = "PathList error: Too few lines of data " + L + "\n" + data + "\n\n" + standardMessage;
            throw new ParseException(message, -1);
        }
        WindingRule rule = this.getWindingRuleFromStringData(item[0]);
        int N = L - 1;
        PathNode[] nodes = new PathNode[N];
        int i = 0;
        while (i < N) {
            String info = item[i + 1];
            if (info.length() == 0) {
                nodes[i] = null;
            } else {
                try {
                    nodes[i] = new PathNode(info);
                }
                catch (ParseException ex) {
                    String message = "PathList error in PathNode data item: " + i + "\n" + info + "\n\n" + ex.getMessage() + "\n" + standardMessage;
                    throw new ParseException(message, -1);
                }
            }
            ++i;
        }
        this.setWindingRule(rule);
        this.setPathNodes(nodes);
    }

    public final String getWindingRuleString() {
        if (this.windingrule == WindingRule.WIND_NON_ZERO) {
            return String_WIND_NON_ZERO;
        }
        return String_WIND_EVEN_ODD;
    }

    public final WindingRule getWindingRuleFromStringData(String data) throws ParseException {
        if (data == null) {
            String message = "PathList winding rule error: null data\n";
            throw new ParseException(message, -1);
        }
        String testdata = (data = data.trim()).toUpperCase();
        if (testdata.equals(String_WIND_NON_ZERO)) {
            return WindingRule.WIND_NON_ZERO;
        }
        if (testdata.equals(String_WIND_EVEN_ODD)) {
            return WindingRule.WIND_EVEN_ODD;
        }
        if (testdata.equals(Alternate_WIND_NON_ZERO)) {
            return WindingRule.WIND_NON_ZERO;
        }
        if (testdata.equals(Alternate_WIND_EVEN_ODD)) {
            return WindingRule.WIND_EVEN_ODD;
        }
        String message = "PathList winding rule error:\n" + data + "\n\n" + standardMessage;
        throw new ParseException(message, -1);
    }

    public final String[] getPathNodeStateArray() {
        int N = this.size();
        String[] state = new String[N];
        int i = 0;
        while (i < N) {
            state[i] = this.get(i).toStringData();
            ++i;
        }
        return state;
    }

    public final String JavaCode() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new PathList(WindingRule.");
        buffer.append(this.getWindingRuleString());
        buffer.append(")\n");
        int n = this.pathlist.size();
        int i = 0;
        while (i < n) {
            buffer.append(".");
            buffer.append(this.get(i).toString());
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }
}

