/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.BaseShape;
import edu.neu.ccs.gui.ClosureMode;
import edu.neu.ccs.gui.PaintableSequence;
import edu.neu.ccs.gui.PathList;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.FloatArray;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class Path {
    public static final int SIZE = 6;
    public static final int HALF = 3;
    public static final Rectangle2D.Double DOT = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);
    public static final int THICK = 2;
    public static final BasicStroke STROKE = new BasicStroke(2.0f);
    public static final Strategy POLYGON = new Strategy(){

        public GeneralPath makePath(float[][] vertex, float[][] tangent, ClosureMode closuremode, WindingRule windingrule) {
            int N;
            if (closuremode == null) {
                closuremode = ClosureMode.CLOSED;
            }
            if (windingrule == null) {
                windingrule = WindingRule.WIND_NON_ZERO;
            }
            GeneralPath path = new GeneralPath(windingrule.rule());
            if (FloatArray.checkArray(vertex, 2) && (N = vertex.length) > 0) {
                path.moveTo(vertex[0][0], vertex[0][1]);
                int i = 1;
                while (i < N) {
                    path.lineTo(vertex[i][0], vertex[i][1]);
                    ++i;
                }
                if (closuremode == ClosureMode.CLOSED) {
                    path.closePath();
                }
            }
            return path;
        }
    };
    public static final Strategy POLYGON_DOTS = new Strategy(){

        public GeneralPath makePath(float[][] vertex, float[][] tangent, ClosureMode closuremode, WindingRule windingrule) {
            if (windingrule == null) {
                windingrule = WindingRule.WIND_NON_ZERO;
            }
            GeneralPath path = new GeneralPath(windingrule.rule());
            if (FloatArray.checkArray(vertex, 2)) {
                int N = vertex.length;
                int i = 0;
                while (i < N) {
                    path.moveTo(vertex[i][0], vertex[i][1]);
                    path.lineTo(vertex[i][0], vertex[i][1]);
                    ++i;
                }
            }
            return path;
        }
    };
    public static final Strategy BEZIER_CUBIC = new Strategy(){

        public GeneralPath makePath(float[][] vertex, float[][] tangent, ClosureMode closuremode, WindingRule windingrule) {
            int N;
            if (closuremode == null) {
                closuremode = ClosureMode.CLOSED;
            }
            if (windingrule == null) {
                windingrule = WindingRule.WIND_NON_ZERO;
            }
            if (tangent == null) {
                return POLYGON.makePath(vertex, null, closuremode, windingrule);
            }
            GeneralPath path = new GeneralPath(windingrule.rule());
            if (FloatArray.checkArrayPair(vertex, tangent, 2) && (N = vertex.length) > 0) {
                path.moveTo(vertex[0][0], vertex[0][1]);
                int limit = closuremode.limit(N);
                int i = 1;
                while (i <= limit) {
                    int j = i - 1;
                    int k = i < N ? i : 0;
                    float x1 = vertex[j][0] + tangent[j][0];
                    float y1 = vertex[j][1] + tangent[j][1];
                    float x2 = vertex[k][0] - tangent[k][0];
                    float y2 = vertex[k][1] - tangent[k][1];
                    float x3 = vertex[k][0];
                    float y3 = vertex[k][1];
                    path.curveTo(x1, y1, x2, y2, x3, y3);
                    ++i;
                }
                if (closuremode == ClosureMode.CLOSED) {
                    path.closePath();
                }
            }
            return path;
        }
    };
    public static final Strategy BEZIER_FRAME = new Strategy(){

        public GeneralPath makePath(float[][] vertex, float[][] tangent, ClosureMode closuremode, WindingRule windingrule) {
            if (closuremode == null) {
                closuremode = ClosureMode.CLOSED;
            }
            if (windingrule == null) {
                windingrule = WindingRule.WIND_NON_ZERO;
            }
            if (tangent == null) {
                return POLYGON.makePath(vertex, null, closuremode, windingrule);
            }
            if (closuremode == ClosureMode.CLOSED) {
                return POLYGON.makePath(BaseShape.closedBezierFramePoints(vertex, tangent), null, closuremode, windingrule);
            }
            return POLYGON.makePath(BaseShape.openBezierFramePoints(vertex, tangent), null, closuremode, windingrule);
        }
    };
    public static final Strategy BEZIER_TANGENT_SEGMENTS = new Strategy(){

        public GeneralPath makePath(float[][] vertex, float[][] tangent, ClosureMode closuremode, WindingRule windingrule) {
            int N;
            if (windingrule == null) {
                windingrule = WindingRule.WIND_NON_ZERO;
            }
            if (tangent == null) {
                return POLYGON_DOTS.makePath(vertex, null, closuremode, windingrule);
            }
            GeneralPath path = new GeneralPath(windingrule.rule());
            if (FloatArray.checkArrayPair(vertex, tangent, 2) && (N = vertex.length) > 0) {
                float[][] segments = BaseShape.bezierTangentSegmentPoints(vertex, tangent);
                int i = 0;
                while (i < N) {
                    int r = 2 * i;
                    int s = r + 1;
                    path.moveTo(segments[r][0], segments[r][1]);
                    path.lineTo(segments[s][0], segments[s][1]);
                    ++i;
                }
            }
            return path;
        }
    };

    private Path() {
    }

    public static GeneralPath append(GeneralPath path, Shape[] shape, boolean[] connect) {
        if (path == null) {
            path = new GeneralPath();
        }
        if (shape == null) {
            return path;
        }
        int N = shape.length;
        if (connect == null) {
            connect = new boolean[N + 1];
        } else if (connect.length != N + 1) {
            return path;
        }
        int i = 0;
        while (i < N) {
            if (shape[i] != null) {
                path.append(shape[i], connect[i]);
            }
            ++i;
        }
        if (connect[N]) {
            path.closePath();
        }
        return path;
    }

    public static GeneralPath append(GeneralPath path, Shape[] shape, boolean connect) {
        if (shape == null) {
            return path;
        }
        int N = shape.length;
        boolean[] array = new boolean[N + 1];
        int i = 0;
        while (i <= N) {
            array[i] = connect;
            ++i;
        }
        return Path.append(path, shape, array);
    }

    public static void showShapeStructure(Graphics g, Shape shape, Color fillColor, Color drawColor, Color vertexDotsColor, Color controlDotsColor, Color vertexFrameColor, Color bezierFrameColor, Color pathPointsColor, int thickness, int divisions) {
        if (g == null || shape == null) {
            return;
        }
        PathList pathlist = new PathList(shape);
        PaintableSequence paintable = pathlist.makeStructurePaintable(fillColor, drawColor, vertexDotsColor, controlDotsColor, vertexFrameColor, bezierFrameColor, pathPointsColor, thickness, divisions);
        paintable.paint(g);
    }

    public static void showShapeStructure(Graphics g, Shape shape, Color fillColor, Color drawColor, Color vertexDotsColor, Color controlDotsColor, Color vertexFrameColor, Color bezierFrameColor, int thickness) {
        if (g == null || shape == null) {
            return;
        }
        PathList pathlist = new PathList(shape);
        PaintableSequence paintable = pathlist.makeStructurePaintable(fillColor, drawColor, vertexDotsColor, controlDotsColor, vertexFrameColor, bezierFrameColor, thickness);
        paintable.paint(g);
    }

    public static void showShapeStructure(Graphics g, Shape shape, Color fillColor, Color drawColor, int thickness) {
        if (g == null || shape == null) {
            return;
        }
        PathList pathlist = new PathList(shape);
        PaintableSequence paintable = pathlist.makeStructurePaintable(fillColor, drawColor, thickness);
        paintable.paint(g);
    }

    public static void showShapeStructure(Graphics g, Shape shape, int thickness) {
        if (g == null || shape == null) {
            return;
        }
        PathList pathlist = new PathList(shape);
        PaintableSequence paintable = pathlist.makeStructurePaintable(thickness);
        paintable.paint(g);
    }

    public static void showShapeStructure(Graphics g, Shape shape) {
        if (g == null || shape == null) {
            return;
        }
        PathList pathlist = new PathList(shape);
        PaintableSequence paintable = pathlist.makeStructurePaintable();
        paintable.paint(g);
    }

    public static String shapeToString(Shape shape) {
        if (shape == null) {
            return "Null shape\n";
        }
        return new PathList(shape).toString();
    }

    public static interface Strategy {
        public GeneralPath makePath(float[][] var1, float[][] var2, ClosureMode var3, WindingRule var4);
    }
}

